/* Example how to send query for online and fix status */

#include <stdio.h>
#include <stdlib.h>
#include <dbus/dbus.h>

#define GPSD_SERVICE        "org.gpsd"
#define GPSD_INTERFACE      GPSD_SERVICE
#define GPSD_PATH           "/org/gpsd"
#define GPSD_GET_STATUS_REQ "get_status"

int main(int argc, char **argv)
{
	DBusMessage *msg, *reply;
	DBusConnection *connection = NULL;
	DBusError error;
	char *str;
	int st = -1, i;
	dbus_uint32_t serial;
	DBusMessageIter	iter;

	if (argc<2) {
		printf("%s <gpsd status query>\n", argv[0]);
		printf("Example: %s ONLINE_SET STATUS_SET\n", argv[0]);
		printf("         %s STATUS_SET\n", argv[0]);
		exit(-1);
	}

	dbus_error_init(&error);
	connection = dbus_bus_get(DBUS_BUS_SYSTEM, &error);
	if (connection == NULL) {
		return -1;
	}

	msg = dbus_message_new_method_call(GPSD_SERVICE,
					   GPSD_PATH,
					   GPSD_INTERFACE,
					   GPSD_GET_STATUS_REQ);
	if (msg == NULL)
		return -1;

#if 1
	dbus_message_iter_init_append(msg, &iter);
	for (i=1; i<argc; i++)
		dbus_message_iter_append_basic(&iter, DBUS_TYPE_STRING,	&argv[i]);

	dbus_message_set_no_reply(msg, TRUE);
#else
	if (!dbus_message_append_args(msg,
				      DBUS_TYPE_STRING, &str,
				      DBUS_TYPE_INVALID)) {
		st = -1;
		goto out;
	}
#endif

#if 1
	/* do not wait any reply */
	dbus_connection_send(connection, msg, &serial);
	dbus_connection_flush(connection);
#else
	/* or wait it */
	reply = dbus_connection_send_with_reply_and_block(
		connection, msg, 5*1000, &error);
	if (reply != NULL) {
		st = 0;
	} else {
		printf("ERROR: %s\n", error.message);
		st = -1;
	}
#endif

out:
	dbus_message_unref(msg);
	return st;
}

