#!/bin/sh
# X server startup/shutdown script

. /etc/osso-af-init/x-server.defs

case "$1" in
  start)

  panel=`cat /sys/devices/platform/omapfb/panel/name`
  curlink=`readlink /etc/pointercal`
  #curlink=`ls -l   /etc/pointercal |  awk  '{print  $11}'`

  if [  x$curlink != x"pointercal-$panel" ]; then
      ln -sf pointercal-${panel} /etc/pointercal
      ln -sf pointercal-${panel}.default /etc/pointercal.default
  fi    

  if [ ! -r /etc/pointercal -o ! -r /etc/pointercal.default  ]; then
      cp /etc/pointercal-${panel}.default /etc/pointercal-${panel}
  fi
  
  [ -c /dev/input/mouse0 ] && EXTRAOPT='-mouse /dev/input/mouse0'

  if [ -x /usr/sbin/dsmetool ]
  then
  
	  dsmetool --nice=-1 -r "/usr/bin/Xomap \
         $EXTRAOPT -mouse /dev/input/event2 \
         -dpi $DISPLAY_DPI " &
  else
      /usr/bin/Xomap \
	     $EXTRAOPT -mouse /dev/input/event2 \
         -dpi $DISPLAY_DPI  >/dev/null 2>&1 & 
  fi
		 
	;; 
  stop)
  	[ -c /dev/input/mouse0 ] && EXTRAOPT='-mouse /dev/input/mouse0'
  
  	 dsmetool -k "/usr/bin/Xomap \
         $EXTRAOPT -mouse /dev/input/event2 \
         -dpi $DISPLAY_DPI "
		 
    ;;
  *)      
    echo "Usage: $0 {start|stop}"
	exit 1
    ;;
esac

