
#include "lids.h"
#include "mat_struct.h"
#include <GL/gl.h>
#include <GL/glu.h>


#define NUM_LIDS 9

GLint lidLists[NUM_LIDS];

/*
typedef struct sample_MATERIAL{
 GLfloat ambient[3];
 GLfloat diffuse[3];
 GLfloat specular[3];
 GLfloat emission[3];
 GLfloat alpha;
 GLfloat phExp;
 int   texture;
}sample_MATERIAL;*/

static sample_MATERIAL materials [1] = {
 {{0.215686f,0.117647f,0.0627451f},	{0.847059f,0.713726f,0.639216f},	{0.044902f,0.044902f,0.044902f},	{0.0f,0.0f,0.0f},	1.0f,11.3137f,-1} //Material #519
};

static short face_indicies[NUM_LIDS][448][9] = {

//lid 10
{
// Object #-1
	{0,1,2 ,0,1,2 ,0,1,2 }, {0,2,3 ,3,2,4 ,3,2,4 }, {0,3,4 ,5,4,6 ,5,4,6 },
	{0,4,5 ,7,6,8 ,7,6,8 }, {0,5,6 ,9,8,10 ,9,8,10 }, {0,6,7 ,11,10,12 ,11,10,12 },
	{0,7,8 ,13,12,14 ,13,12,14 }, {0,8,9 ,15,14,16 ,15,14,16 }, {0,9,10 ,17,16,18 ,17,16,18 },
	{0,10,11 ,19,18,20 ,19,18,20 }, {0,11,12 ,21,20,22 ,21,20,22 },
	{0,12,13 ,23,22,24 ,23,22,24 }, {0,13,14 ,25,24,26 ,25,24,26 },
	{0,14,15 ,27,26,28 ,27,26,28 }, {0,15,16 ,29,28,30 ,29,28,30 },
	{0,16,1 ,31,30,31 ,31,30,32 }, {1,17,18 ,1,32,33 ,1,33,34 },
	{1,18,2 ,1,33,2 ,1,34,2 }, {2,18,19 ,2,33,34 ,2,34,35 }, {2,19,3 ,2,34,4 ,2,35,4 },
	{3,19,20 ,4,34,35 ,4,35,36 }, {3,20,4 ,4,35,6 ,4,36,6 }, {4,20,21 ,6,35,36 ,6,36,37 },
	{4,21,5 ,6,36,8 ,6,37,8 }, {5,21,22 ,8,36,37 ,8,37,38 }, {5,22,6 ,8,37,10 ,8,38,10 },
	{6,22,23 ,10,37,38 ,10,38,39 }, {6,23,7 ,10,38,12 ,10,39,12 },
	{7,23,24 ,12,38,39 ,12,39,40 }, {7,24,8 ,12,39,14 ,12,40,14 },
	{8,24,25 ,14,39,40 ,14,40,41 }, {8,25,9 ,14,40,16 ,14,41,16 },
	{9,25,26 ,16,40,41 ,16,41,42 }, {9,26,10 ,16,41,18 ,16,42,18 },
	{10,26,27 ,18,41,42 ,18,42,43 }, {10,27,11 ,18,42,20 ,18,43,20 },
	{11,27,28 ,20,42,43 ,20,43,44 }, {11,28,12 ,20,43,22 ,20,44,22 },
	{12,28,29 ,22,43,44 ,22,44,45 }, {12,29,13 ,22,44,24 ,22,45,24 },
	{13,29,30 ,24,44,45 ,24,45,46 }, {13,30,14 ,24,45,26 ,24,46,26 },
	{14,30,31 ,26,45,46 ,26,46,47 }, {14,31,15 ,26,46,28 ,26,47,28 },
	{15,31,32 ,28,46,47 ,28,47,48 }, {15,32,16 ,28,47,30 ,28,48,30 },
	{16,32,17 ,30,47,48 ,30,48,49 }, {16,17,1 ,30,49,49 ,30,49,32 },
	{17,33,34 ,32,50,51 ,33,50,51 }, {17,34,18 ,32,51,33 ,33,51,34 },
	{18,34,35 ,33,51,52 ,34,51,52 }, {18,35,19 ,33,52,34 ,34,52,35 },
	{19,35,36 ,34,52,53 ,35,52,53 }, {19,36,20 ,34,53,35 ,35,53,36 },
	{20,36,37 ,35,53,54 ,36,53,54 }, {20,37,21 ,35,54,36 ,36,54,37 },
	{21,37,38 ,36,54,55 ,37,54,55 }, {21,38,22 ,36,55,37 ,37,55,38 },
	{22,38,39 ,37,55,56 ,38,55,56 }, {22,39,23 ,37,56,38 ,38,56,39 },
	{23,39,40 ,38,56,57 ,39,56,57 }, {23,40,24 ,38,57,39 ,39,57,40 },
	{24,40,41 ,39,57,58 ,40,57,58 }, {24,41,25 ,39,58,40 ,40,58,41 },
	{25,41,42 ,40,58,59 ,41,58,59 }, {25,42,26 ,40,59,41 ,41,59,42 },
	{26,42,43 ,41,59,60 ,42,59,60 }, {26,43,27 ,41,60,42 ,42,60,43 },
	{27,43,44 ,42,60,61 ,43,60,61 }, {27,44,28 ,42,61,43 ,43,61,44 },
	{28,44,45 ,43,61,62 ,44,61,62 }, {28,45,29 ,43,62,44 ,44,62,45 },
	{29,45,46 ,44,62,63 ,45,62,63 }, {29,46,30 ,44,63,45 ,45,63,46 },
	{30,46,47 ,45,63,64 ,46,63,64 }, {30,47,31 ,45,64,46 ,46,64,47 },
	{31,47,48 ,46,64,65 ,47,64,65 }, {31,48,32 ,46,65,47 ,47,65,48 },
	{32,48,33 ,47,65,66 ,48,65,66 }, {32,33,17 ,47,67,67 ,48,66,49 },
	{33,49,50 ,50,68,69 ,50,67,68 }, {33,50,34 ,50,69,51 ,50,68,51 },
	{34,50,51 ,51,69,70 ,51,68,69 }, {34,51,35 ,51,70,52 ,51,69,52 },
	{35,51,52 ,52,70,71 ,52,69,70 }, {35,52,36 ,52,71,53 ,52,70,53 },
	{36,52,53 ,53,71,72 ,53,70,71 }, {36,53,37 ,53,72,54 ,53,71,54 },
	{37,53,54 ,54,72,73 ,54,71,72 }, {37,54,38 ,54,73,55 ,54,72,55 },
	{38,54,55 ,55,73,74 ,55,72,73 }, {38,55,39 ,55,74,56 ,55,73,56 },
	{39,55,56 ,56,74,75 ,56,73,74 }, {39,56,40 ,56,75,57 ,56,74,57 },
	{40,56,57 ,57,75,76 ,57,74,75 }, {40,57,41 ,57,76,58 ,57,75,58 },
	{41,57,58 ,58,76,77 ,58,75,76 }, {41,58,42 ,58,77,59 ,58,76,59 },
	{42,58,59 ,59,77,78 ,59,76,77 }, {42,59,43 ,59,78,60 ,59,77,60 },
	{43,59,60 ,60,78,79 ,60,77,78 }, {43,60,44 ,60,79,61 ,60,78,61 },
	{44,60,61 ,61,79,80 ,61,78,79 }, {44,61,45 ,61,80,62 ,61,79,62 },
	{45,61,62 ,62,80,81 ,62,79,80 }, {45,62,46 ,62,81,63 ,62,80,63 },
	{46,62,63 ,63,81,82 ,63,80,81 }, {46,63,47 ,63,82,64 ,63,81,64 },
	{47,63,64 ,64,82,83 ,64,81,82 }, {47,64,48 ,64,83,65 ,64,82,65 },
	{48,64,49 ,65,83,84 ,65,82,83 }, {48,49,33 ,65,85,85 ,65,83,66 },
	{66,65,67 ,86,87,88 ,1,0,2 }, {67,65,68 ,88,89,90 ,2,3,4 }, {68,65,69 ,90,91,92 ,4,5,6 },
	{69,65,70 ,92,93,94 ,6,7,8 }, {70,65,71 ,94,95,96 ,8,9,10 },
	{71,65,72 ,96,97,98 ,10,11,12 }, {72,65,73 ,98,99,100 ,12,13,14 },
	{73,65,74 ,100,101,102 ,14,15,16 }, {74,65,75 ,102,103,104 ,16,17,18 },
	{75,65,76 ,104,105,106 ,18,19,20 }, {76,65,77 ,106,107,108 ,20,21,22 },
	{77,65,78 ,108,109,110 ,22,23,24 }, {78,65,79 ,110,111,112 ,24,25,26 },
	{79,65,80 ,112,113,114 ,26,27,28 }, {80,65,81 ,114,115,116 ,28,29,30 },
	{81,65,66 ,116,117,117 ,30,31,32 }, {82,66,83 ,118,86,119 ,33,1,34 },
	{83,66,67 ,119,86,88 ,34,1,2 }, {83,67,84 ,119,88,120 ,34,2,35 },
	{84,67,68 ,120,88,90 ,35,2,4 }, {84,68,85 ,120,90,121 ,35,4,36 },
	{85,68,69 ,121,90,92 ,36,4,6 }, {85,69,86 ,121,92,122 ,36,6,37 },
	{86,69,70 ,122,92,94 ,37,6,8 }, {86,70,87 ,122,94,123 ,37,8,38 },
	{87,70,71 ,123,94,96 ,38,8,10 }, {87,71,88 ,123,96,124 ,38,10,39 },
	{88,71,72 ,124,96,98 ,39,10,12 }, {88,72,89 ,124,98,125 ,39,12,40 },
	{89,72,73 ,125,98,100 ,40,12,14 }, {89,73,90 ,125,100,126 ,40,14,41 },
	{90,73,74 ,126,100,102 ,41,14,16 }, {90,74,91 ,126,102,127 ,41,16,42 },
	{91,74,75 ,127,102,104 ,42,16,18 }, {91,75,92 ,127,104,128 ,42,18,43 },
	{92,75,76 ,128,104,106 ,43,18,20 }, {92,76,93 ,128,106,129 ,43,20,44 },
	{93,76,77 ,129,106,108 ,44,20,22 }, {93,77,94 ,129,108,130 ,44,22,45 },
	{94,77,78 ,130,108,110 ,45,22,24 }, {94,78,95 ,130,110,131 ,45,24,46 },
	{95,78,79 ,131,110,112 ,46,24,26 }, {95,79,96 ,131,112,132 ,46,26,47 },
	{96,79,80 ,132,112,114 ,47,26,28 }, {96,80,97 ,132,114,133 ,47,28,48 },
	{97,80,81 ,133,114,116 ,48,28,30 }, {97,81,82 ,133,116,134 ,48,30,49 },
	{82,81,66 ,135,116,135 ,49,30,32 }, {98,82,99 ,136,118,137 ,50,33,51 },
	{99,82,83 ,137,118,119 ,51,33,34 }, {99,83,100 ,137,119,138 ,51,34,52 },
	{100,83,84 ,138,119,120 ,52,34,35 }, {100,84,101 ,138,120,139 ,52,35,53 },
	{101,84,85 ,139,120,121 ,53,35,36 }, {101,85,102 ,139,121,140 ,53,36,54 },
	{102,85,86 ,140,121,122 ,54,36,37 }, {102,86,103 ,140,122,141 ,54,37,55 },
	{103,86,87 ,141,122,123 ,55,37,38 }, {103,87,104 ,141,123,142 ,55,38,56 },
	{104,87,88 ,142,123,124 ,56,38,39 }, {104,88,105 ,142,124,143 ,56,39,57 },
	{105,88,89 ,143,124,125 ,57,39,40 }, {105,89,106 ,143,125,144 ,57,40,58 },
	{106,89,90 ,144,125,126 ,58,40,41 }, {106,90,107 ,144,126,145 ,58,41,59 },
	{107,90,91 ,145,126,127 ,59,41,42 }, {107,91,108 ,145,127,146 ,59,42,60 },
	{108,91,92 ,146,127,128 ,60,42,43 }, {108,92,109 ,146,128,147 ,60,43,61 },
	{109,92,93 ,147,128,129 ,61,43,44 }, {109,93,110 ,147,129,148 ,61,44,62 },
	{110,93,94 ,148,129,130 ,62,44,45 }, {110,94,111 ,148,130,149 ,62,45,63 },
	{111,94,95 ,149,130,131 ,63,45,46 }, {111,95,112 ,149,131,150 ,63,46,64 },
	{112,95,96 ,150,131,132 ,64,46,47 }, {112,96,113 ,150,132,151 ,64,47,65 },
	{113,96,97 ,151,132,133 ,65,47,48 }, {113,97,98 ,151,133,152 ,65,48,66 },
	{98,97,82 ,153,133,153 ,66,48,49 }, {114,98,115 ,154,136,155 ,67,50,68 },
	{115,98,99 ,155,136,137 ,68,50,51 }, {115,99,116 ,155,137,156 ,68,51,69 },
	{116,99,100 ,156,137,138 ,69,51,52 }, {116,100,117 ,156,138,157 ,69,52,70 },
	{117,100,101 ,157,138,139 ,70,52,53 }, {117,101,118 ,157,139,158 ,70,53,71 },
	{118,101,102 ,158,139,140 ,71,53,54 }, {118,102,119 ,158,140,159 ,71,54,72 },
	{119,102,103 ,159,140,141 ,72,54,55 }, {119,103,120 ,159,141,160 ,72,55,73 },
	{120,103,104 ,160,141,142 ,73,55,56 }, {120,104,121 ,160,142,161 ,73,56,74 },
	{121,104,105 ,161,142,143 ,74,56,57 }, {121,105,122 ,161,143,162 ,74,57,75 },
	{122,105,106 ,162,143,144 ,75,57,58 }, {122,106,123 ,162,144,163 ,75,58,76 },
	{123,106,107 ,163,144,145 ,76,58,59 }, {123,107,124 ,163,145,164 ,76,59,77 },
	{124,107,108 ,164,145,146 ,77,59,60 }, {124,108,125 ,164,146,165 ,77,60,78 },
	{125,108,109 ,165,146,147 ,78,60,61 }, {125,109,126 ,165,147,166 ,78,61,79 },
	{126,109,110 ,166,147,148 ,79,61,62 }, {126,110,127 ,166,148,167 ,79,62,80 },
	{127,110,111 ,167,148,149 ,80,62,63 }, {127,111,128 ,167,149,168 ,80,63,81 },
	{128,111,112 ,168,149,150 ,81,63,64 }, {128,112,129 ,168,150,169 ,81,64,82 },
	{129,112,113 ,169,150,151 ,82,64,65 }, {129,113,114 ,169,151,170 ,82,65,83 },
	{114,113,98 ,171,151,171 ,83,65,66 }
// Object #-1
	, {130,131,132 ,172,173,174 ,0,1,2 }, {130,132,133 ,175,174,176 ,3,2,4 },
	{130,133,134 ,177,176,178 ,5,4,6 }, {130,134,135 ,179,178,180 ,7,6,8 },
	{130,135,136 ,181,180,182 ,9,8,10 }, {130,136,137 ,183,182,184 ,11,10,12 },
	{130,137,138 ,185,184,186 ,13,12,14 }, {130,138,139 ,187,186,188 ,15,14,16 },
	{130,139,140 ,189,188,190 ,17,16,18 }, {130,140,141 ,191,190,192 ,19,18,20 },
	{130,141,142 ,193,192,194 ,21,20,22 }, {130,142,143 ,195,194,196 ,23,22,24 },
	{130,143,144 ,197,196,198 ,25,24,26 }, {130,144,145 ,199,198,200 ,27,26,28 },
	{130,145,146 ,201,200,202 ,29,28,30 }, {130,146,131 ,203,202,203 ,31,30,32 },
	{131,147,148 ,173,204,205 ,1,33,34 }, {131,148,132 ,173,205,174 ,1,34,2 },
	{132,148,149 ,174,205,206 ,2,34,35 }, {132,149,133 ,174,206,176 ,2,35,4 },
	{133,149,150 ,176,206,207 ,4,35,36 }, {133,150,134 ,176,207,178 ,4,36,6 },
	{134,150,151 ,178,207,208 ,6,36,37 }, {134,151,135 ,178,208,180 ,6,37,8 },
	{135,151,152 ,180,208,209 ,8,37,38 }, {135,152,136 ,180,209,182 ,8,38,10 },
	{136,152,153 ,182,209,210 ,10,38,39 }, {136,153,137 ,182,210,184 ,10,39,12 },
	{137,153,154 ,184,210,211 ,12,39,40 }, {137,154,138 ,184,211,186 ,12,40,14 },
	{138,154,155 ,186,211,212 ,14,40,41 }, {138,155,139 ,186,212,188 ,14,41,16 },
	{139,155,156 ,188,212,213 ,16,41,42 }, {139,156,140 ,188,213,190 ,16,42,18 },
	{140,156,157 ,190,213,214 ,18,42,43 }, {140,157,141 ,190,214,192 ,18,43,20 },
	{141,157,158 ,192,214,215 ,20,43,44 }, {141,158,142 ,192,215,194 ,20,44,22 },
	{142,158,159 ,194,215,216 ,22,44,45 }, {142,159,143 ,194,216,196 ,22,45,24 },
	{143,159,160 ,196,216,217 ,24,45,46 }, {143,160,144 ,196,217,198 ,24,46,26 },
	{144,160,161 ,198,217,218 ,26,46,47 }, {144,161,145 ,198,218,200 ,26,47,28 },
	{145,161,162 ,200,218,219 ,28,47,48 }, {145,162,146 ,200,219,202 ,28,48,30 },
	{146,162,147 ,202,219,220 ,30,48,49 }, {146,147,131 ,202,221,221 ,30,49,32 },
	{147,163,164 ,204,222,223 ,33,50,51 }, {147,164,148 ,204,223,205 ,33,51,34 },
	{148,164,165 ,205,223,224 ,34,51,52 }, {148,165,149 ,205,224,206 ,34,52,35 },
	{149,165,166 ,206,224,225 ,35,52,53 }, {149,166,150 ,206,225,207 ,35,53,36 },
	{150,166,167 ,207,225,226 ,36,53,54 }, {150,167,151 ,207,226,208 ,36,54,37 },
	{151,167,168 ,208,226,227 ,37,54,55 }, {151,168,152 ,208,227,209 ,37,55,38 },
	{152,168,169 ,209,227,228 ,38,55,56 }, {152,169,153 ,209,228,210 ,38,56,39 },
	{153,169,170 ,210,228,229 ,39,56,57 }, {153,170,154 ,210,229,211 ,39,57,40 },
	{154,170,171 ,211,229,230 ,40,57,58 }, {154,171,155 ,211,230,212 ,40,58,41 },
	{155,171,172 ,212,230,231 ,41,58,59 }, {155,172,156 ,212,231,213 ,41,59,42 },
	{156,172,173 ,213,231,232 ,42,59,60 }, {156,173,157 ,213,232,214 ,42,60,43 },
	{157,173,174 ,214,232,233 ,43,60,61 }, {157,174,158 ,214,233,215 ,43,61,44 },
	{158,174,175 ,215,233,234 ,44,61,62 }, {158,175,159 ,215,234,216 ,44,62,45 },
	{159,175,176 ,216,234,235 ,45,62,63 }, {159,176,160 ,216,235,217 ,45,63,46 },
	{160,176,177 ,217,235,236 ,46,63,64 }, {160,177,161 ,217,236,218 ,46,64,47 },
	{161,177,178 ,218,236,237 ,47,64,65 }, {161,178,162 ,218,237,219 ,47,65,48 },
	{162,178,163 ,219,237,238 ,48,65,66 }, {162,163,147 ,219,239,239 ,48,66,49 },
	{163,179,180 ,222,240,241 ,50,67,68 }, {163,180,164 ,222,241,223 ,50,68,51 },
	{164,180,181 ,223,241,242 ,51,68,69 }, {164,181,165 ,223,242,224 ,51,69,52 },
	{165,181,182 ,224,242,243 ,52,69,70 }, {165,182,166 ,224,243,225 ,52,70,53 },
	{166,182,183 ,225,243,244 ,53,70,71 }, {166,183,167 ,225,244,226 ,53,71,54 },
	{167,183,184 ,226,244,245 ,54,71,72 }, {167,184,168 ,226,245,227 ,54,72,55 },
	{168,184,185 ,227,245,246 ,55,72,73 }, {168,185,169 ,227,246,228 ,55,73,56 },
	{169,185,186 ,228,246,247 ,56,73,74 }, {169,186,170 ,228,247,229 ,56,74,57 },
	{170,186,187 ,229,247,248 ,57,74,75 }, {170,187,171 ,229,248,230 ,57,75,58 },
	{171,187,188 ,230,248,249 ,58,75,76 }, {171,188,172 ,230,249,231 ,58,76,59 },
	{172,188,189 ,231,249,250 ,59,76,77 }, {172,189,173 ,231,250,232 ,59,77,60 },
	{173,189,190 ,232,250,251 ,60,77,78 }, {173,190,174 ,232,251,233 ,60,78,61 },
	{174,190,191 ,233,251,252 ,61,78,79 }, {174,191,175 ,233,252,234 ,61,79,62 },
	{175,191,192 ,234,252,253 ,62,79,80 }, {175,192,176 ,234,253,235 ,62,80,63 },
	{176,192,193 ,235,253,254 ,63,80,81 }, {176,193,177 ,235,254,236 ,63,81,64 },
	{177,193,194 ,236,254,255 ,64,81,82 }, {177,194,178 ,236,255,237 ,64,82,65 },
	{178,194,179 ,237,255,256 ,65,82,83 }, {178,179,163 ,237,257,257 ,65,83,66 },
	{196,195,197 ,258,259,260 ,1,0,2 }, {197,195,198 ,260,261,262 ,2,3,4 },
	{198,195,199 ,262,263,264 ,4,5,6 }, {199,195,200 ,264,265,266 ,6,7,8 },
	{200,195,201 ,266,267,268 ,8,9,10 }, {201,195,202 ,268,269,270 ,10,11,12 },
	{202,195,203 ,270,271,272 ,12,13,14 }, {203,195,204 ,272,273,274 ,14,15,16 },
	{204,195,205 ,274,275,276 ,16,17,18 }, {205,195,206 ,276,277,278 ,18,19,20 },
	{206,195,207 ,278,279,280 ,20,21,22 }, {207,195,208 ,280,281,282 ,22,23,24 },
	{208,195,209 ,282,283,284 ,24,25,26 }, {209,195,210 ,284,285,286 ,26,27,28 },
	{210,195,211 ,286,287,288 ,28,29,30 }, {211,195,196 ,288,289,289 ,30,31,32 },
	{212,196,213 ,290,258,291 ,33,1,34 }, {213,196,197 ,291,258,260 ,34,1,2 },
	{213,197,214 ,291,260,292 ,34,2,35 }, {214,197,198 ,292,260,262 ,35,2,4 },
	{214,198,215 ,292,262,293 ,35,4,36 }, {215,198,199 ,293,262,264 ,36,4,6 },
	{215,199,216 ,293,264,294 ,36,6,37 }, {216,199,200 ,294,264,266 ,37,6,8 },
	{216,200,217 ,294,266,295 ,37,8,38 }, {217,200,201 ,295,266,268 ,38,8,10 },
	{217,201,218 ,295,268,296 ,38,10,39 }, {218,201,202 ,296,268,270 ,39,10,12 },
	{218,202,219 ,296,270,297 ,39,12,40 }, {219,202,203 ,297,270,272 ,40,12,14 },
	{219,203,220 ,297,272,298 ,40,14,41 }, {220,203,204 ,298,272,274 ,41,14,16 },
	{220,204,221 ,298,274,299 ,41,16,42 }, {221,204,205 ,299,274,276 ,42,16,18 },
	{221,205,222 ,299,276,300 ,42,18,43 }, {222,205,206 ,300,276,278 ,43,18,20 },
	{222,206,223 ,300,278,301 ,43,20,44 }, {223,206,207 ,301,278,280 ,44,20,22 },
	{223,207,224 ,301,280,302 ,44,22,45 }, {224,207,208 ,302,280,282 ,45,22,24 },
	{224,208,225 ,302,282,303 ,45,24,46 }, {225,208,209 ,303,282,284 ,46,24,26 },
	{225,209,226 ,303,284,304 ,46,26,47 }, {226,209,210 ,304,284,286 ,47,26,28 },
	{226,210,227 ,304,286,305 ,47,28,48 }, {227,210,211 ,305,286,288 ,48,28,30 },
	{227,211,212 ,305,288,306 ,48,30,49 }, {212,211,196 ,307,288,307 ,49,30,32 },
	{228,212,229 ,308,290,309 ,50,33,51 }, {229,212,213 ,309,290,291 ,51,33,34 },
	{229,213,230 ,309,291,310 ,51,34,52 }, {230,213,214 ,310,291,292 ,52,34,35 },
	{230,214,231 ,310,292,311 ,52,35,53 }, {231,214,215 ,311,292,293 ,53,35,36 },
	{231,215,232 ,311,293,312 ,53,36,54 }, {232,215,216 ,312,293,294 ,54,36,37 },
	{232,216,233 ,312,294,313 ,54,37,55 }, {233,216,217 ,313,294,295 ,55,37,38 },
	{233,217,234 ,313,295,314 ,55,38,56 }, {234,217,218 ,314,295,296 ,56,38,39 },
	{234,218,235 ,314,296,315 ,56,39,57 }, {235,218,219 ,315,296,297 ,57,39,40 },
	{235,219,236 ,315,297,316 ,57,40,58 }, {236,219,220 ,316,297,298 ,58,40,41 },
	{236,220,237 ,316,298,317 ,58,41,59 }, {237,220,221 ,317,298,299 ,59,41,42 },
	{237,221,238 ,317,299,318 ,59,42,60 }, {238,221,222 ,318,299,300 ,60,42,43 },
	{238,222,239 ,318,300,319 ,60,43,61 }, {239,222,223 ,319,300,301 ,61,43,44 },
	{239,223,240 ,319,301,320 ,61,44,62 }, {240,223,224 ,320,301,302 ,62,44,45 },
	{240,224,241 ,320,302,321 ,62,45,63 }, {241,224,225 ,321,302,303 ,63,45,46 },
	{241,225,242 ,321,303,322 ,63,46,64 }, {242,225,226 ,322,303,304 ,64,46,47 },
	{242,226,243 ,322,304,323 ,64,47,65 }, {243,226,227 ,323,304,305 ,65,47,48 },
	{243,227,228 ,323,305,324 ,65,48,66 }, {228,227,212 ,325,305,325 ,66,48,49 },
	{244,228,245 ,326,308,327 ,67,50,68 }, {245,228,229 ,327,308,309 ,68,50,51 },
	{245,229,246 ,327,309,328 ,68,51,69 }, {246,229,230 ,328,309,310 ,69,51,52 },
	{246,230,247 ,328,310,329 ,69,52,70 }, {247,230,231 ,329,310,311 ,70,52,53 },
	{247,231,248 ,329,311,330 ,70,53,71 }, {248,231,232 ,330,311,312 ,71,53,54 },
	{248,232,249 ,330,312,331 ,71,54,72 }, {249,232,233 ,331,312,313 ,72,54,55 },
	{249,233,250 ,331,313,332 ,72,55,73 }, {250,233,234 ,332,313,314 ,73,55,56 },
	{250,234,251 ,332,314,333 ,73,56,74 }, {251,234,235 ,333,314,315 ,74,56,57 },
	{251,235,252 ,333,315,334 ,74,57,75 }, {252,235,236 ,334,315,316 ,75,57,58 },
	{252,236,253 ,334,316,335 ,75,58,76 }, {253,236,237 ,335,316,317 ,76,58,59 },
	{253,237,254 ,335,317,336 ,76,59,77 }, {254,237,238 ,336,317,318 ,77,59,60 },
	{254,238,255 ,336,318,337 ,77,60,78 }, {255,238,239 ,337,318,319 ,78,60,61 },
	{255,239,256 ,337,319,338 ,78,61,79 }, {256,239,240 ,338,319,320 ,79,61,62 },
	{256,240,257 ,338,320,339 ,79,62,80 }, {257,240,241 ,339,320,321 ,80,62,63 },
	{257,241,258 ,339,321,340 ,80,63,81 }, {258,241,242 ,340,321,322 ,81,63,64 },
	{258,242,259 ,340,322,341 ,81,64,82 }, {259,242,243 ,341,322,323 ,82,64,65 },
	{259,243,244 ,341,323,342 ,82,65,83 }, {244,243,228 ,343,323,343 ,83,65,66 }
},

//lid 9
{
// Object #-1
	{0,1,2 ,0,1,2 ,0,1,2 }, {0,2,3 ,3,2,4 ,3,2,4 }, {0,3,4 ,5,4,6 ,5,4,6 },
	{0,4,5 ,7,6,8 ,7,6,8 }, {0,5,6 ,9,8,10 ,9,8,10 }, {0,6,7 ,11,10,12 ,11,10,12 },
	{0,7,8 ,13,12,14 ,13,12,14 }, {0,8,9 ,15,14,16 ,15,14,16 }, {0,9,10 ,17,16,18 ,17,16,18 },
	{0,10,11 ,19,18,20 ,19,18,20 }, {0,11,12 ,21,20,22 ,21,20,22 },
	{0,12,13 ,23,22,24 ,23,22,24 }, {0,13,14 ,25,24,26 ,25,24,26 },
	{0,14,15 ,27,26,28 ,27,26,28 }, {0,15,16 ,29,28,30 ,29,28,30 },
	{0,16,1 ,31,30,31 ,31,30,32 }, {1,17,18 ,1,32,33 ,1,33,34 },
	{1,18,2 ,1,33,2 ,1,34,2 }, {2,18,19 ,2,33,34 ,2,34,35 }, {2,19,3 ,2,34,4 ,2,35,4 },
	{3,19,20 ,4,34,35 ,4,35,36 }, {3,20,4 ,4,35,6 ,4,36,6 }, {4,20,21 ,6,35,36 ,6,36,37 },
	{4,21,5 ,6,36,8 ,6,37,8 }, {5,21,22 ,8,36,37 ,8,37,38 }, {5,22,6 ,8,37,10 ,8,38,10 },
	{6,22,23 ,10,37,38 ,10,38,39 }, {6,23,7 ,10,38,12 ,10,39,12 },
	{7,23,24 ,12,38,39 ,12,39,40 }, {7,24,8 ,12,39,14 ,12,40,14 },
	{8,24,25 ,14,39,40 ,14,40,41 }, {8,25,9 ,14,40,16 ,14,41,16 },
	{9,25,26 ,16,40,41 ,16,41,42 }, {9,26,10 ,16,41,18 ,16,42,18 },
	{10,26,27 ,18,41,42 ,18,42,43 }, {10,27,11 ,18,42,20 ,18,43,20 },
	{11,27,28 ,20,42,43 ,20,43,44 }, {11,28,12 ,20,43,22 ,20,44,22 },
	{12,28,29 ,22,43,44 ,22,44,45 }, {12,29,13 ,22,44,24 ,22,45,24 },
	{13,29,30 ,24,44,45 ,24,45,46 }, {13,30,14 ,24,45,26 ,24,46,26 },
	{14,30,31 ,26,45,46 ,26,46,47 }, {14,31,15 ,26,46,28 ,26,47,28 },
	{15,31,32 ,28,46,47 ,28,47,48 }, {15,32,16 ,28,47,30 ,28,48,30 },
	{16,32,17 ,30,47,48 ,30,48,49 }, {16,17,1 ,30,49,49 ,30,49,32 },
	{17,33,34 ,32,50,51 ,33,50,51 }, {17,34,18 ,32,51,33 ,33,51,34 },
	{18,34,35 ,33,51,52 ,34,51,52 }, {18,35,19 ,33,52,34 ,34,52,35 },
	{19,35,36 ,34,52,53 ,35,52,53 }, {19,36,20 ,34,53,35 ,35,53,36 },
	{20,36,37 ,35,53,54 ,36,53,54 }, {20,37,21 ,35,54,36 ,36,54,37 },
	{21,37,38 ,36,54,55 ,37,54,55 }, {21,38,22 ,36,55,37 ,37,55,38 },
	{22,38,39 ,37,55,56 ,38,55,56 }, {22,39,23 ,37,56,38 ,38,56,39 },
	{23,39,40 ,38,56,57 ,39,56,57 }, {23,40,24 ,38,57,39 ,39,57,40 },
	{24,40,41 ,39,57,58 ,40,57,58 }, {24,41,25 ,39,58,40 ,40,58,41 },
	{25,41,42 ,40,58,59 ,41,58,59 }, {25,42,26 ,40,59,41 ,41,59,42 },
	{26,42,43 ,41,59,60 ,42,59,60 }, {26,43,27 ,41,60,42 ,42,60,43 },
	{27,43,44 ,42,60,61 ,43,60,61 }, {27,44,28 ,42,61,43 ,43,61,44 },
	{28,44,45 ,43,61,62 ,44,61,62 }, {28,45,29 ,43,62,44 ,44,62,45 },
	{29,45,46 ,44,62,63 ,45,62,63 }, {29,46,30 ,44,63,45 ,45,63,46 },
	{30,46,47 ,45,63,64 ,46,63,64 }, {30,47,31 ,45,64,46 ,46,64,47 },
	{31,47,48 ,46,64,65 ,47,64,65 }, {31,48,32 ,46,65,47 ,47,65,48 },
	{32,48,33 ,47,65,66 ,48,65,66 }, {32,33,17 ,47,67,67 ,48,66,49 },
	{33,49,50 ,50,68,69 ,50,67,68 }, {33,50,34 ,50,69,51 ,50,68,51 },
	{34,50,51 ,51,69,70 ,51,68,69 }, {34,51,35 ,51,70,52 ,51,69,52 },
	{35,51,52 ,52,70,71 ,52,69,70 }, {35,52,36 ,52,71,53 ,52,70,53 },
	{36,52,53 ,53,71,72 ,53,70,71 }, {36,53,37 ,53,72,54 ,53,71,54 },
	{37,53,54 ,54,72,73 ,54,71,72 }, {37,54,38 ,54,73,55 ,54,72,55 },
	{38,54,55 ,55,73,74 ,55,72,73 }, {38,55,39 ,55,74,56 ,55,73,56 },
	{39,55,56 ,56,74,75 ,56,73,74 }, {39,56,40 ,56,75,57 ,56,74,57 },
	{40,56,57 ,57,75,76 ,57,74,75 }, {40,57,41 ,57,76,58 ,57,75,58 },
	{41,57,58 ,58,76,77 ,58,75,76 }, {41,58,42 ,58,77,59 ,58,76,59 },
	{42,58,59 ,59,77,78 ,59,76,77 }, {42,59,43 ,59,78,60 ,59,77,60 },
	{43,59,60 ,60,78,79 ,60,77,78 }, {43,60,44 ,60,79,61 ,60,78,61 },
	{44,60,61 ,61,79,80 ,61,78,79 }, {44,61,45 ,61,80,62 ,61,79,62 },
	{45,61,62 ,62,80,81 ,62,79,80 }, {45,62,46 ,62,81,63 ,62,80,63 },
	{46,62,63 ,63,81,82 ,63,80,81 }, {46,63,47 ,63,82,64 ,63,81,64 },
	{47,63,64 ,64,82,83 ,64,81,82 }, {47,64,48 ,64,83,65 ,64,82,65 },
	{48,64,49 ,65,83,84 ,65,82,83 }, {48,49,33 ,65,85,85 ,65,83,66 },
	{66,65,67 ,86,87,88 ,1,0,2 }, {67,65,68 ,88,89,90 ,2,3,4 }, {68,65,69 ,90,91,92 ,4,5,6 },
	{69,65,70 ,92,93,94 ,6,7,8 }, {70,65,71 ,94,95,96 ,8,9,10 },
	{71,65,72 ,96,97,98 ,10,11,12 }, {72,65,73 ,98,99,100 ,12,13,14 },
	{73,65,74 ,100,101,102 ,14,15,16 }, {74,65,75 ,102,103,104 ,16,17,18 },
	{75,65,76 ,104,105,106 ,18,19,20 }, {76,65,77 ,106,107,108 ,20,21,22 },
	{77,65,78 ,108,109,110 ,22,23,24 }, {78,65,79 ,110,111,112 ,24,25,26 },
	{79,65,80 ,112,113,114 ,26,27,28 }, {80,65,81 ,114,115,116 ,28,29,30 },
	{81,65,66 ,116,117,117 ,30,31,32 }, {82,66,83 ,118,86,119 ,33,1,34 },
	{83,66,67 ,119,86,88 ,34,1,2 }, {83,67,84 ,119,88,120 ,34,2,35 },
	{84,67,68 ,120,88,90 ,35,2,4 }, {84,68,85 ,120,90,121 ,35,4,36 },
	{85,68,69 ,121,90,92 ,36,4,6 }, {85,69,86 ,121,92,122 ,36,6,37 },
	{86,69,70 ,122,92,94 ,37,6,8 }, {86,70,87 ,122,94,123 ,37,8,38 },
	{87,70,71 ,123,94,96 ,38,8,10 }, {87,71,88 ,123,96,124 ,38,10,39 },
	{88,71,72 ,124,96,98 ,39,10,12 }, {88,72,89 ,124,98,125 ,39,12,40 },
	{89,72,73 ,125,98,100 ,40,12,14 }, {89,73,90 ,125,100,126 ,40,14,41 },
	{90,73,74 ,126,100,102 ,41,14,16 }, {90,74,91 ,126,102,127 ,41,16,42 },
	{91,74,75 ,127,102,104 ,42,16,18 }, {91,75,92 ,127,104,128 ,42,18,43 },
	{92,75,76 ,128,104,106 ,43,18,20 }, {92,76,93 ,128,106,129 ,43,20,44 },
	{93,76,77 ,129,106,108 ,44,20,22 }, {93,77,94 ,129,108,130 ,44,22,45 },
	{94,77,78 ,130,108,110 ,45,22,24 }, {94,78,95 ,130,110,131 ,45,24,46 },
	{95,78,79 ,131,110,112 ,46,24,26 }, {95,79,96 ,131,112,132 ,46,26,47 },
	{96,79,80 ,132,112,114 ,47,26,28 }, {96,80,97 ,132,114,133 ,47,28,48 },
	{97,80,81 ,133,114,116 ,48,28,30 }, {97,81,82 ,133,116,134 ,48,30,49 },
	{82,81,66 ,135,116,135 ,49,30,32 }, {98,82,99 ,136,118,137 ,50,33,51 },
	{99,82,83 ,137,118,119 ,51,33,34 }, {99,83,100 ,137,119,138 ,51,34,52 },
	{100,83,84 ,138,119,120 ,52,34,35 }, {100,84,101 ,138,120,139 ,52,35,53 },
	{101,84,85 ,139,120,121 ,53,35,36 }, {101,85,102 ,139,121,140 ,53,36,54 },
	{102,85,86 ,140,121,122 ,54,36,37 }, {102,86,103 ,140,122,141 ,54,37,55 },
	{103,86,87 ,141,122,123 ,55,37,38 }, {103,87,104 ,141,123,142 ,55,38,56 },
	{104,87,88 ,142,123,124 ,56,38,39 }, {104,88,105 ,142,124,143 ,56,39,57 },
	{105,88,89 ,143,124,125 ,57,39,40 }, {105,89,106 ,143,125,144 ,57,40,58 },
	{106,89,90 ,144,125,126 ,58,40,41 }, {106,90,107 ,144,126,145 ,58,41,59 },
	{107,90,91 ,145,126,127 ,59,41,42 }, {107,91,108 ,145,127,146 ,59,42,60 },
	{108,91,92 ,146,127,128 ,60,42,43 }, {108,92,109 ,146,128,147 ,60,43,61 },
	{109,92,93 ,147,128,129 ,61,43,44 }, {109,93,110 ,147,129,148 ,61,44,62 },
	{110,93,94 ,148,129,130 ,62,44,45 }, {110,94,111 ,148,130,149 ,62,45,63 },
	{111,94,95 ,149,130,131 ,63,45,46 }, {111,95,112 ,149,131,150 ,63,46,64 },
	{112,95,96 ,150,131,132 ,64,46,47 }, {112,96,113 ,150,132,151 ,64,47,65 },
	{113,96,97 ,151,132,133 ,65,47,48 }, {113,97,98 ,151,133,152 ,65,48,66 },
	{98,97,82 ,153,133,153 ,66,48,49 }, {114,98,115 ,154,136,155 ,67,50,68 },
	{115,98,99 ,155,136,137 ,68,50,51 }, {115,99,116 ,155,137,156 ,68,51,69 },
	{116,99,100 ,156,137,138 ,69,51,52 }, {116,100,117 ,156,138,157 ,69,52,70 },
	{117,100,101 ,157,138,139 ,70,52,53 }, {117,101,118 ,157,139,158 ,70,53,71 },
	{118,101,102 ,158,139,140 ,71,53,54 }, {118,102,119 ,158,140,159 ,71,54,72 },
	{119,102,103 ,159,140,141 ,72,54,55 }, {119,103,120 ,159,141,160 ,72,55,73 },
	{120,103,104 ,160,141,142 ,73,55,56 }, {120,104,121 ,160,142,161 ,73,56,74 },
	{121,104,105 ,161,142,143 ,74,56,57 }, {121,105,122 ,161,143,162 ,74,57,75 },
	{122,105,106 ,162,143,144 ,75,57,58 }, {122,106,123 ,162,144,163 ,75,58,76 },
	{123,106,107 ,163,144,145 ,76,58,59 }, {123,107,124 ,163,145,164 ,76,59,77 },
	{124,107,108 ,164,145,146 ,77,59,60 }, {124,108,125 ,164,146,165 ,77,60,78 },
	{125,108,109 ,165,146,147 ,78,60,61 }, {125,109,126 ,165,147,166 ,78,61,79 },
	{126,109,110 ,166,147,148 ,79,61,62 }, {126,110,127 ,166,148,167 ,79,62,80 },
	{127,110,111 ,167,148,149 ,80,62,63 }, {127,111,128 ,167,149,168 ,80,63,81 },
	{128,111,112 ,168,149,150 ,81,63,64 }, {128,112,129 ,168,150,169 ,81,64,82 },
	{129,112,113 ,169,150,151 ,82,64,65 }, {129,113,114 ,169,151,170 ,82,65,83 },
	{114,113,98 ,171,151,171 ,83,65,66 }
// Object #-1
	, {130,131,132 ,172,173,174 ,0,1,2 }, {130,132,133 ,175,174,176 ,3,2,4 },
	{130,133,134 ,177,176,178 ,5,4,6 }, {130,134,135 ,179,178,180 ,7,6,8 },
	{130,135,136 ,181,180,182 ,9,8,10 }, {130,136,137 ,183,182,184 ,11,10,12 },
	{130,137,138 ,185,184,186 ,13,12,14 }, {130,138,139 ,187,186,188 ,15,14,16 },
	{130,139,140 ,189,188,190 ,17,16,18 }, {130,140,141 ,191,190,192 ,19,18,20 },
	{130,141,142 ,193,192,194 ,21,20,22 }, {130,142,143 ,195,194,196 ,23,22,24 },
	{130,143,144 ,197,196,198 ,25,24,26 }, {130,144,145 ,199,198,200 ,27,26,28 },
	{130,145,146 ,201,200,202 ,29,28,30 }, {130,146,131 ,203,202,203 ,31,30,32 },
	{131,147,148 ,173,204,205 ,1,33,34 }, {131,148,132 ,173,205,174 ,1,34,2 },
	{132,148,149 ,174,205,206 ,2,34,35 }, {132,149,133 ,174,206,176 ,2,35,4 },
	{133,149,150 ,176,206,207 ,4,35,36 }, {133,150,134 ,176,207,178 ,4,36,6 },
	{134,150,151 ,178,207,208 ,6,36,37 }, {134,151,135 ,178,208,180 ,6,37,8 },
	{135,151,152 ,180,208,209 ,8,37,38 }, {135,152,136 ,180,209,182 ,8,38,10 },
	{136,152,153 ,182,209,210 ,10,38,39 }, {136,153,137 ,182,210,184 ,10,39,12 },
	{137,153,154 ,184,210,211 ,12,39,40 }, {137,154,138 ,184,211,186 ,12,40,14 },
	{138,154,155 ,186,211,212 ,14,40,41 }, {138,155,139 ,186,212,188 ,14,41,16 },
	{139,155,156 ,188,212,213 ,16,41,42 }, {139,156,140 ,188,213,190 ,16,42,18 },
	{140,156,157 ,190,213,214 ,18,42,43 }, {140,157,141 ,190,214,192 ,18,43,20 },
	{141,157,158 ,192,214,215 ,20,43,44 }, {141,158,142 ,192,215,194 ,20,44,22 },
	{142,158,159 ,194,215,216 ,22,44,45 }, {142,159,143 ,194,216,196 ,22,45,24 },
	{143,159,160 ,196,216,217 ,24,45,46 }, {143,160,144 ,196,217,198 ,24,46,26 },
	{144,160,161 ,198,217,218 ,26,46,47 }, {144,161,145 ,198,218,200 ,26,47,28 },
	{145,161,162 ,200,218,219 ,28,47,48 }, {145,162,146 ,200,219,202 ,28,48,30 },
	{146,162,147 ,202,219,220 ,30,48,49 }, {146,147,131 ,202,221,221 ,30,49,32 },
	{147,163,164 ,204,222,223 ,33,50,51 }, {147,164,148 ,204,223,205 ,33,51,34 },
	{148,164,165 ,205,223,224 ,34,51,52 }, {148,165,149 ,205,224,206 ,34,52,35 },
	{149,165,166 ,206,224,225 ,35,52,53 }, {149,166,150 ,206,225,207 ,35,53,36 },
	{150,166,167 ,207,225,226 ,36,53,54 }, {150,167,151 ,207,226,208 ,36,54,37 },
	{151,167,168 ,208,226,227 ,37,54,55 }, {151,168,152 ,208,227,209 ,37,55,38 },
	{152,168,169 ,209,227,228 ,38,55,56 }, {152,169,153 ,209,228,210 ,38,56,39 },
	{153,169,170 ,210,228,229 ,39,56,57 }, {153,170,154 ,210,229,211 ,39,57,40 },
	{154,170,171 ,211,229,230 ,40,57,58 }, {154,171,155 ,211,230,212 ,40,58,41 },
	{155,171,172 ,212,230,231 ,41,58,59 }, {155,172,156 ,212,231,213 ,41,59,42 },
	{156,172,173 ,213,231,232 ,42,59,60 }, {156,173,157 ,213,232,214 ,42,60,43 },
	{157,173,174 ,214,232,233 ,43,60,61 }, {157,174,158 ,214,233,215 ,43,61,44 },
	{158,174,175 ,215,233,234 ,44,61,62 }, {158,175,159 ,215,234,216 ,44,62,45 },
	{159,175,176 ,216,234,235 ,45,62,63 }, {159,176,160 ,216,235,217 ,45,63,46 },
	{160,176,177 ,217,235,236 ,46,63,64 }, {160,177,161 ,217,236,218 ,46,64,47 },
	{161,177,178 ,218,236,237 ,47,64,65 }, {161,178,162 ,218,237,219 ,47,65,48 },
	{162,178,163 ,219,237,238 ,48,65,66 }, {162,163,147 ,219,239,239 ,48,66,49 },
	{163,179,180 ,222,240,241 ,50,67,68 }, {163,180,164 ,222,241,223 ,50,68,51 },
	{164,180,181 ,223,241,242 ,51,68,69 }, {164,181,165 ,223,242,224 ,51,69,52 },
	{165,181,182 ,224,242,243 ,52,69,70 }, {165,182,166 ,224,243,225 ,52,70,53 },
	{166,182,183 ,225,243,244 ,53,70,71 }, {166,183,167 ,225,244,226 ,53,71,54 },
	{167,183,184 ,226,244,245 ,54,71,72 }, {167,184,168 ,226,245,227 ,54,72,55 },
	{168,184,185 ,227,245,246 ,55,72,73 }, {168,185,169 ,227,246,228 ,55,73,56 },
	{169,185,186 ,228,246,247 ,56,73,74 }, {169,186,170 ,228,247,229 ,56,74,57 },
	{170,186,187 ,229,247,248 ,57,74,75 }, {170,187,171 ,229,248,230 ,57,75,58 },
	{171,187,188 ,230,248,249 ,58,75,76 }, {171,188,172 ,230,249,231 ,58,76,59 },
	{172,188,189 ,231,249,250 ,59,76,77 }, {172,189,173 ,231,250,232 ,59,77,60 },
	{173,189,190 ,232,250,251 ,60,77,78 }, {173,190,174 ,232,251,233 ,60,78,61 },
	{174,190,61 ,233,251,252 ,61,78,79 }, {174,61,175 ,233,252,234 ,61,79,62 },
	{175,61,191 ,234,252,253 ,62,79,80 }, {175,191,176 ,234,253,235 ,62,80,63 },
	{176,191,192 ,235,253,254 ,63,80,81 }, {176,192,177 ,235,254,236 ,63,81,64 },
	{177,192,193 ,236,254,255 ,64,81,82 }, {177,193,178 ,236,255,237 ,64,82,65 },
	{178,193,179 ,237,255,256 ,65,82,83 }, {178,179,163 ,237,257,257 ,65,83,66 },
	{195,194,196 ,258,259,260 ,1,0,2 }, {196,194,197 ,260,261,262 ,2,3,4 },
	{197,194,198 ,262,263,264 ,4,5,6 }, {198,194,199 ,264,265,266 ,6,7,8 },
	{199,194,200 ,266,267,268 ,8,9,10 }, {200,194,201 ,268,269,270 ,10,11,12 },
	{201,194,202 ,270,271,272 ,12,13,14 }, {202,194,203 ,272,273,274 ,14,15,16 },
	{203,194,204 ,274,275,276 ,16,17,18 }, {204,194,205 ,276,277,278 ,18,19,20 },
	{205,194,206 ,278,279,280 ,20,21,22 }, {206,194,207 ,280,281,282 ,22,23,24 },
	{207,194,208 ,282,283,284 ,24,25,26 }, {208,194,209 ,284,285,286 ,26,27,28 },
	{209,194,210 ,286,287,288 ,28,29,30 }, {210,194,195 ,288,289,289 ,30,31,32 },
	{211,195,212 ,290,258,291 ,33,1,34 }, {212,195,196 ,291,258,260 ,34,1,2 },
	{212,196,213 ,291,260,292 ,34,2,35 }, {213,196,197 ,292,260,262 ,35,2,4 },
	{213,197,214 ,292,262,293 ,35,4,36 }, {214,197,198 ,293,262,264 ,36,4,6 },
	{214,198,215 ,293,264,294 ,36,6,37 }, {215,198,199 ,294,264,266 ,37,6,8 },
	{215,199,216 ,294,266,295 ,37,8,38 }, {216,199,200 ,295,266,268 ,38,8,10 },
	{216,200,217 ,295,268,296 ,38,10,39 }, {217,200,201 ,296,268,270 ,39,10,12 },
	{217,201,218 ,296,270,297 ,39,12,40 }, {218,201,202 ,297,270,272 ,40,12,14 },
	{218,202,219 ,297,272,298 ,40,14,41 }, {219,202,203 ,298,272,274 ,41,14,16 },
	{219,203,220 ,298,274,299 ,41,16,42 }, {220,203,204 ,299,274,276 ,42,16,18 },
	{220,204,221 ,299,276,300 ,42,18,43 }, {221,204,205 ,300,276,278 ,43,18,20 },
	{221,205,222 ,300,278,301 ,43,20,44 }, {222,205,206 ,301,278,280 ,44,20,22 },
	{222,206,223 ,301,280,302 ,44,22,45 }, {223,206,207 ,302,280,282 ,45,22,24 },
	{223,207,224 ,302,282,303 ,45,24,46 }, {224,207,208 ,303,282,284 ,46,24,26 },
	{224,208,225 ,303,284,304 ,46,26,47 }, {225,208,209 ,304,284,286 ,47,26,28 },
	{225,209,226 ,304,286,305 ,47,28,48 }, {226,209,210 ,305,286,288 ,48,28,30 },
	{226,210,211 ,305,288,306 ,48,30,49 }, {211,210,195 ,307,288,307 ,49,30,32 },
	{227,211,228 ,308,290,309 ,50,33,51 }, {228,211,212 ,309,290,291 ,51,33,34 },
	{228,212,229 ,309,291,310 ,51,34,52 }, {229,212,213 ,310,291,292 ,52,34,35 },
	{229,213,230 ,310,292,311 ,52,35,53 }, {230,213,214 ,311,292,293 ,53,35,36 },
	{230,214,231 ,311,293,312 ,53,36,54 }, {231,214,215 ,312,293,294 ,54,36,37 },
	{231,215,232 ,312,294,313 ,54,37,55 }, {232,215,216 ,313,294,295 ,55,37,38 },
	{232,216,233 ,313,295,314 ,55,38,56 }, {233,216,217 ,314,295,296 ,56,38,39 },
	{233,217,234 ,314,296,315 ,56,39,57 }, {234,217,218 ,315,296,297 ,57,39,40 },
	{234,218,235 ,315,297,316 ,57,40,58 }, {235,218,219 ,316,297,298 ,58,40,41 },
	{235,219,236 ,316,298,317 ,58,41,59 }, {236,219,220 ,317,298,299 ,59,41,42 },
	{236,220,237 ,317,299,318 ,59,42,60 }, {237,220,221 ,318,299,300 ,60,42,43 },
	{237,221,238 ,318,300,319 ,60,43,61 }, {238,221,222 ,319,300,301 ,61,43,44 },
	{238,222,239 ,319,301,320 ,61,44,62 }, {239,222,223 ,320,301,302 ,62,44,45 },
	{239,223,240 ,320,302,321 ,62,45,63 }, {240,223,224 ,321,302,303 ,63,45,46 },
	{240,224,241 ,321,303,322 ,63,46,64 }, {241,224,225 ,322,303,304 ,64,46,47 },
	{241,225,242 ,322,304,323 ,64,47,65 }, {242,225,226 ,323,304,305 ,65,47,48 },
	{242,226,227 ,323,305,324 ,65,48,66 }, {227,226,211 ,325,305,325 ,66,48,49 },
	{243,227,244 ,326,308,327 ,67,50,68 }, {244,227,228 ,327,308,309 ,68,50,51 },
	{244,228,245 ,327,309,328 ,68,51,69 }, {245,228,229 ,328,309,310 ,69,51,52 },
	{245,229,246 ,328,310,329 ,69,52,70 }, {246,229,230 ,329,310,311 ,70,52,53 },
	{246,230,247 ,329,311,330 ,70,53,71 }, {247,230,231 ,330,311,312 ,71,53,54 },
	{247,231,248 ,330,312,331 ,71,54,72 }, {248,231,232 ,331,312,313 ,72,54,55 },
	{248,232,249 ,331,313,332 ,72,55,73 }, {249,232,233 ,332,313,314 ,73,55,56 },
	{249,233,250 ,332,314,333 ,73,56,74 }, {250,233,234 ,333,314,315 ,74,56,57 },
	{250,234,251 ,333,315,334 ,74,57,75 }, {251,234,235 ,334,315,316 ,75,57,58 },
	{251,235,252 ,334,316,335 ,75,58,76 }, {252,235,236 ,335,316,317 ,76,58,59 },
	{252,236,253 ,335,317,336 ,76,59,77 }, {253,236,237 ,336,317,318 ,77,59,60 },
	{253,237,254 ,336,318,337 ,77,60,78 }, {254,237,238 ,337,318,319 ,78,60,61 },
	{254,238,126 ,337,319,338 ,78,61,79 }, {126,238,239 ,338,319,320 ,79,61,62 },
	{126,239,255 ,338,320,339 ,79,62,80 }, {255,239,240 ,339,320,321 ,80,62,63 },
	{255,240,256 ,339,321,340 ,80,63,81 }, {256,240,241 ,340,321,322 ,81,63,64 },
	{256,241,257 ,340,322,341 ,81,64,82 }, {257,241,242 ,341,322,323 ,82,64,65 },
	{257,242,243 ,341,323,342 ,82,65,83 }, {243,242,227 ,343,323,343 ,83,65,66 }
},

//lid 8
{
// Object #-1
	{0,1,2 ,0,1,2 ,0,1,2 }, {0,2,3 ,3,2,4 ,3,2,4 }, {0,3,4 ,5,4,6 ,5,4,6 },
	{0,4,5 ,7,6,8 ,7,6,8 }, {0,5,6 ,9,8,10 ,9,8,10 }, {0,6,7 ,11,10,12 ,11,10,12 },
	{0,7,8 ,13,12,14 ,13,12,14 }, {0,8,9 ,15,14,16 ,15,14,16 }, {0,9,10 ,17,16,18 ,17,16,18 },
	{0,10,11 ,19,18,20 ,19,18,20 }, {0,11,12 ,21,20,22 ,21,20,22 },
	{0,12,13 ,23,22,24 ,23,22,24 }, {0,13,14 ,25,24,26 ,25,24,26 },
	{0,14,15 ,27,26,28 ,27,26,28 }, {0,15,16 ,29,28,30 ,29,28,30 },
	{0,16,1 ,31,30,31 ,31,30,32 }, {1,17,18 ,1,32,33 ,1,33,34 },
	{1,18,2 ,1,33,2 ,1,34,2 }, {2,18,19 ,2,33,34 ,2,34,35 }, {2,19,3 ,2,34,4 ,2,35,4 },
	{3,19,20 ,4,34,35 ,4,35,36 }, {3,20,4 ,4,35,6 ,4,36,6 }, {4,20,21 ,6,35,36 ,6,36,37 },
	{4,21,5 ,6,36,8 ,6,37,8 }, {5,21,22 ,8,36,37 ,8,37,38 }, {5,22,6 ,8,37,10 ,8,38,10 },
	{6,22,23 ,10,37,38 ,10,38,39 }, {6,23,7 ,10,38,12 ,10,39,12 },
	{7,23,24 ,12,38,39 ,12,39,40 }, {7,24,8 ,12,39,14 ,12,40,14 },
	{8,24,25 ,14,39,40 ,14,40,41 }, {8,25,9 ,14,40,16 ,14,41,16 },
	{9,25,26 ,16,40,41 ,16,41,42 }, {9,26,10 ,16,41,18 ,16,42,18 },
	{10,26,27 ,18,41,42 ,18,42,43 }, {10,27,11 ,18,42,20 ,18,43,20 },
	{11,27,28 ,20,42,43 ,20,43,44 }, {11,28,12 ,20,43,22 ,20,44,22 },
	{12,28,29 ,22,43,44 ,22,44,45 }, {12,29,13 ,22,44,24 ,22,45,24 },
	{13,29,30 ,24,44,45 ,24,45,46 }, {13,30,14 ,24,45,26 ,24,46,26 },
	{14,30,31 ,26,45,46 ,26,46,47 }, {14,31,15 ,26,46,28 ,26,47,28 },
	{15,31,32 ,28,46,47 ,28,47,48 }, {15,32,16 ,28,47,30 ,28,48,30 },
	{16,32,17 ,30,47,48 ,30,48,49 }, {16,17,1 ,30,49,49 ,30,49,32 },
	{17,33,34 ,32,50,51 ,33,50,51 }, {17,34,18 ,32,51,33 ,33,51,34 },
	{18,34,35 ,33,51,52 ,34,51,52 }, {18,35,19 ,33,52,34 ,34,52,35 },
	{19,35,36 ,34,52,53 ,35,52,53 }, {19,36,20 ,34,53,35 ,35,53,36 },
	{20,36,37 ,35,53,54 ,36,53,54 }, {20,37,21 ,35,54,36 ,36,54,37 },
	{21,37,38 ,36,54,55 ,37,54,55 }, {21,38,22 ,36,55,37 ,37,55,38 },
	{22,38,39 ,37,55,56 ,38,55,56 }, {22,39,23 ,37,56,38 ,38,56,39 },
	{23,39,40 ,38,56,57 ,39,56,57 }, {23,40,24 ,38,57,39 ,39,57,40 },
	{24,40,41 ,39,57,58 ,40,57,58 }, {24,41,25 ,39,58,40 ,40,58,41 },
	{25,41,42 ,40,58,59 ,41,58,59 }, {25,42,26 ,40,59,41 ,41,59,42 },
	{26,42,43 ,41,59,60 ,42,59,60 }, {26,43,27 ,41,60,42 ,42,60,43 },
	{27,43,44 ,42,60,61 ,43,60,61 }, {27,44,28 ,42,61,43 ,43,61,44 },
	{28,44,45 ,43,61,62 ,44,61,62 }, {28,45,29 ,43,62,44 ,44,62,45 },
	{29,45,46 ,44,62,63 ,45,62,63 }, {29,46,30 ,44,63,45 ,45,63,46 },
	{30,46,47 ,45,63,64 ,46,63,64 }, {30,47,31 ,45,64,46 ,46,64,47 },
	{31,47,48 ,46,64,65 ,47,64,65 }, {31,48,32 ,46,65,47 ,47,65,48 },
	{32,48,33 ,47,65,66 ,48,65,66 }, {32,33,17 ,47,67,67 ,48,66,49 },
	{33,49,50 ,50,68,69 ,50,67,68 }, {33,50,34 ,50,69,51 ,50,68,51 },
	{34,50,51 ,51,69,70 ,51,68,69 }, {34,51,35 ,51,70,52 ,51,69,52 },
	{35,51,52 ,52,70,71 ,52,69,70 }, {35,52,36 ,52,71,53 ,52,70,53 },
	{36,52,53 ,53,71,72 ,53,70,71 }, {36,53,37 ,53,72,54 ,53,71,54 },
	{37,53,54 ,54,72,73 ,54,71,72 }, {37,54,38 ,54,73,55 ,54,72,55 },
	{38,54,55 ,55,73,74 ,55,72,73 }, {38,55,39 ,55,74,56 ,55,73,56 },
	{39,55,56 ,56,74,75 ,56,73,74 }, {39,56,40 ,56,75,57 ,56,74,57 },
	{40,56,57 ,57,75,76 ,57,74,75 }, {40,57,41 ,57,76,58 ,57,75,58 },
	{41,57,58 ,58,76,77 ,58,75,76 }, {41,58,42 ,58,77,59 ,58,76,59 },
	{42,58,59 ,59,77,78 ,59,76,77 }, {42,59,43 ,59,78,60 ,59,77,60 },
	{43,59,60 ,60,78,79 ,60,77,78 }, {43,60,44 ,60,79,61 ,60,78,61 },
	{44,60,61 ,61,79,80 ,61,78,79 }, {44,61,45 ,61,80,62 ,61,79,62 },
	{45,61,62 ,62,80,81 ,62,79,80 }, {45,62,46 ,62,81,63 ,62,80,63 },
	{46,62,63 ,63,81,82 ,63,80,81 }, {46,63,47 ,63,82,64 ,63,81,64 },
	{47,63,64 ,64,82,83 ,64,81,82 }, {47,64,48 ,64,83,65 ,64,82,65 },
	{48,64,49 ,65,83,84 ,65,82,83 }, {48,49,33 ,65,85,85 ,65,83,66 },
	{66,65,67 ,86,87,88 ,1,0,2 }, {67,65,68 ,88,89,90 ,2,3,4 }, {68,65,69 ,90,91,92 ,4,5,6 },
	{69,65,70 ,92,93,94 ,6,7,8 }, {70,65,71 ,94,95,96 ,8,9,10 },
	{71,65,72 ,96,97,98 ,10,11,12 }, {72,65,73 ,98,99,100 ,12,13,14 },
	{73,65,74 ,100,101,102 ,14,15,16 }, {74,65,75 ,102,103,104 ,16,17,18 },
	{75,65,76 ,104,105,106 ,18,19,20 }, {76,65,77 ,106,107,108 ,20,21,22 },
	{77,65,78 ,108,109,110 ,22,23,24 }, {78,65,79 ,110,111,112 ,24,25,26 },
	{79,65,80 ,112,113,114 ,26,27,28 }, {80,65,81 ,114,115,116 ,28,29,30 },
	{81,65,66 ,116,117,117 ,30,31,32 }, {82,66,83 ,118,86,119 ,33,1,34 },
	{83,66,67 ,119,86,88 ,34,1,2 }, {83,67,84 ,119,88,120 ,34,2,35 },
	{84,67,68 ,120,88,90 ,35,2,4 }, {84,68,85 ,120,90,121 ,35,4,36 },
	{85,68,69 ,121,90,92 ,36,4,6 }, {85,69,86 ,121,92,122 ,36,6,37 },
	{86,69,70 ,122,92,94 ,37,6,8 }, {86,70,87 ,122,94,123 ,37,8,38 },
	{87,70,71 ,123,94,96 ,38,8,10 }, {87,71,88 ,123,96,124 ,38,10,39 },
	{88,71,72 ,124,96,98 ,39,10,12 }, {88,72,89 ,124,98,125 ,39,12,40 },
	{89,72,73 ,125,98,100 ,40,12,14 }, {89,73,90 ,125,100,126 ,40,14,41 },
	{90,73,74 ,126,100,102 ,41,14,16 }, {90,74,91 ,126,102,127 ,41,16,42 },
	{91,74,75 ,127,102,104 ,42,16,18 }, {91,75,92 ,127,104,128 ,42,18,43 },
	{92,75,76 ,128,104,106 ,43,18,20 }, {92,76,93 ,128,106,129 ,43,20,44 },
	{93,76,77 ,129,106,108 ,44,20,22 }, {93,77,94 ,129,108,130 ,44,22,45 },
	{94,77,78 ,130,108,110 ,45,22,24 }, {94,78,95 ,130,110,131 ,45,24,46 },
	{95,78,79 ,131,110,112 ,46,24,26 }, {95,79,96 ,131,112,132 ,46,26,47 },
	{96,79,80 ,132,112,114 ,47,26,28 }, {96,80,97 ,132,114,133 ,47,28,48 },
	{97,80,81 ,133,114,116 ,48,28,30 }, {97,81,82 ,133,116,134 ,48,30,49 },
	{82,81,66 ,135,116,135 ,49,30,32 }, {98,82,99 ,136,118,137 ,50,33,51 },
	{99,82,83 ,137,118,119 ,51,33,34 }, {99,83,100 ,137,119,138 ,51,34,52 },
	{100,83,84 ,138,119,120 ,52,34,35 }, {100,84,101 ,138,120,139 ,52,35,53 },
	{101,84,85 ,139,120,121 ,53,35,36 }, {101,85,102 ,139,121,140 ,53,36,54 },
	{102,85,86 ,140,121,122 ,54,36,37 }, {102,86,103 ,140,122,141 ,54,37,55 },
	{103,86,87 ,141,122,123 ,55,37,38 }, {103,87,104 ,141,123,142 ,55,38,56 },
	{104,87,88 ,142,123,124 ,56,38,39 }, {104,88,105 ,142,124,143 ,56,39,57 },
	{105,88,89 ,143,124,125 ,57,39,40 }, {105,89,106 ,143,125,144 ,57,40,58 },
	{106,89,90 ,144,125,126 ,58,40,41 }, {106,90,107 ,144,126,145 ,58,41,59 },
	{107,90,91 ,145,126,127 ,59,41,42 }, {107,91,108 ,145,127,146 ,59,42,60 },
	{108,91,92 ,146,127,128 ,60,42,43 }, {108,92,109 ,146,128,147 ,60,43,61 },
	{109,92,93 ,147,128,129 ,61,43,44 }, {109,93,110 ,147,129,148 ,61,44,62 },
	{110,93,94 ,148,129,130 ,62,44,45 }, {110,94,111 ,148,130,149 ,62,45,63 },
	{111,94,95 ,149,130,131 ,63,45,46 }, {111,95,112 ,149,131,150 ,63,46,64 },
	{112,95,96 ,150,131,132 ,64,46,47 }, {112,96,113 ,150,132,151 ,64,47,65 },
	{113,96,97 ,151,132,133 ,65,47,48 }, {113,97,98 ,151,133,152 ,65,48,66 },
	{98,97,82 ,153,133,153 ,66,48,49 }, {114,98,115 ,154,136,155 ,67,50,68 },
	{115,98,99 ,155,136,137 ,68,50,51 }, {115,99,116 ,155,137,156 ,68,51,69 },
	{116,99,100 ,156,137,138 ,69,51,52 }, {116,100,117 ,156,138,157 ,69,52,70 },
	{117,100,101 ,157,138,139 ,70,52,53 }, {117,101,118 ,157,139,158 ,70,53,71 },
	{118,101,102 ,158,139,140 ,71,53,54 }, {118,102,119 ,158,140,159 ,71,54,72 },
	{119,102,103 ,159,140,141 ,72,54,55 }, {119,103,120 ,159,141,160 ,72,55,73 },
	{120,103,104 ,160,141,142 ,73,55,56 }, {120,104,121 ,160,142,161 ,73,56,74 },
	{121,104,105 ,161,142,143 ,74,56,57 }, {121,105,122 ,161,143,162 ,74,57,75 },
	{122,105,106 ,162,143,144 ,75,57,58 }, {122,106,123 ,162,144,163 ,75,58,76 },
	{123,106,107 ,163,144,145 ,76,58,59 }, {123,107,124 ,163,145,164 ,76,59,77 },
	{124,107,108 ,164,145,146 ,77,59,60 }, {124,108,125 ,164,146,165 ,77,60,78 },
	{125,108,109 ,165,146,147 ,78,60,61 }, {125,109,126 ,165,147,166 ,78,61,79 },
	{126,109,110 ,166,147,148 ,79,61,62 }, {126,110,127 ,166,148,167 ,79,62,80 },
	{127,110,111 ,167,148,149 ,80,62,63 }, {127,111,128 ,167,149,168 ,80,63,81 },
	{128,111,112 ,168,149,150 ,81,63,64 }, {128,112,129 ,168,150,169 ,81,64,82 },
	{129,112,113 ,169,150,151 ,82,64,65 }, {129,113,114 ,169,151,170 ,82,65,83 },
	{114,113,98 ,171,151,171 ,83,65,66 }
// Object #-1
	, {130,131,132 ,172,173,174 ,0,1,2 }, {130,132,133 ,175,174,176 ,3,2,4 },
	{130,133,134 ,177,176,178 ,5,4,6 }, {130,134,135 ,179,178,180 ,7,6,8 },
	{130,135,136 ,181,180,182 ,9,8,10 }, {130,136,137 ,183,182,184 ,11,10,12 },
	{130,137,138 ,185,184,186 ,13,12,14 }, {130,138,139 ,187,186,188 ,15,14,16 },
	{130,139,140 ,189,188,190 ,17,16,18 }, {130,140,141 ,191,190,192 ,19,18,20 },
	{130,141,142 ,193,192,194 ,21,20,22 }, {130,142,143 ,195,194,196 ,23,22,24 },
	{130,143,144 ,197,196,198 ,25,24,26 }, {130,144,145 ,199,198,200 ,27,26,28 },
	{130,145,146 ,201,200,202 ,29,28,30 }, {130,146,131 ,203,202,203 ,31,30,32 },
	{131,147,148 ,173,204,205 ,1,33,34 }, {131,148,132 ,173,205,174 ,1,34,2 },
	{132,148,149 ,174,205,206 ,2,34,35 }, {132,149,133 ,174,206,176 ,2,35,4 },
	{133,149,150 ,176,206,207 ,4,35,36 }, {133,150,134 ,176,207,178 ,4,36,6 },
	{134,150,151 ,178,207,208 ,6,36,37 }, {134,151,135 ,178,208,180 ,6,37,8 },
	{135,151,152 ,180,208,209 ,8,37,38 }, {135,152,136 ,180,209,182 ,8,38,10 },
	{136,152,153 ,182,209,210 ,10,38,39 }, {136,153,137 ,182,210,184 ,10,39,12 },
	{137,153,154 ,184,210,211 ,12,39,40 }, {137,154,138 ,184,211,186 ,12,40,14 },
	{138,154,155 ,186,211,212 ,14,40,41 }, {138,155,139 ,186,212,188 ,14,41,16 },
	{139,155,156 ,188,212,213 ,16,41,42 }, {139,156,140 ,188,213,190 ,16,42,18 },
	{140,156,157 ,190,213,214 ,18,42,43 }, {140,157,141 ,190,214,192 ,18,43,20 },
	{141,157,158 ,192,214,215 ,20,43,44 }, {141,158,142 ,192,215,194 ,20,44,22 },
	{142,158,159 ,194,215,216 ,22,44,45 }, {142,159,143 ,194,216,196 ,22,45,24 },
	{143,159,160 ,196,216,217 ,24,45,46 }, {143,160,144 ,196,217,198 ,24,46,26 },
	{144,160,161 ,198,217,218 ,26,46,47 }, {144,161,145 ,198,218,200 ,26,47,28 },
	{145,161,162 ,200,218,219 ,28,47,48 }, {145,162,146 ,200,219,202 ,28,48,30 },
	{146,162,147 ,202,219,220 ,30,48,49 }, {146,147,131 ,202,221,221 ,30,49,32 },
	{147,163,164 ,204,222,223 ,33,50,51 }, {147,164,148 ,204,223,205 ,33,51,34 },
	{148,164,165 ,205,223,224 ,34,51,52 }, {148,165,149 ,205,224,206 ,34,52,35 },
	{149,165,166 ,206,224,225 ,35,52,53 }, {149,166,150 ,206,225,207 ,35,53,36 },
	{150,166,167 ,207,225,226 ,36,53,54 }, {150,167,151 ,207,226,208 ,36,54,37 },
	{151,167,168 ,208,226,227 ,37,54,55 }, {151,168,152 ,208,227,209 ,37,55,38 },
	{152,168,169 ,209,227,228 ,38,55,56 }, {152,169,153 ,209,228,210 ,38,56,39 },
	{153,169,170 ,210,228,229 ,39,56,57 }, {153,170,154 ,210,229,211 ,39,57,40 },
	{154,170,171 ,211,229,230 ,40,57,58 }, {154,171,155 ,211,230,212 ,40,58,41 },
	{155,171,172 ,212,230,231 ,41,58,59 }, {155,172,156 ,212,231,213 ,41,59,42 },
	{156,172,173 ,213,231,232 ,42,59,60 }, {156,173,157 ,213,232,214 ,42,60,43 },
	{157,173,174 ,214,232,233 ,43,60,61 }, {157,174,158 ,214,233,215 ,43,61,44 },
	{158,174,175 ,215,233,234 ,44,61,62 }, {158,175,159 ,215,234,216 ,44,62,45 },
	{159,175,176 ,216,234,235 ,45,62,63 }, {159,176,160 ,216,235,217 ,45,63,46 },
	{160,176,177 ,217,235,236 ,46,63,64 }, {160,177,161 ,217,236,218 ,46,64,47 },
	{161,177,178 ,218,236,237 ,47,64,65 }, {161,178,162 ,218,237,219 ,47,65,48 },
	{162,178,163 ,219,237,238 ,48,65,66 }, {162,163,147 ,219,239,239 ,48,66,49 },
	{163,179,180 ,222,240,241 ,50,67,68 }, {163,180,164 ,222,241,223 ,50,68,51 },
	{164,180,181 ,223,241,242 ,51,68,69 }, {164,181,165 ,223,242,224 ,51,69,52 },
	{165,181,182 ,224,242,243 ,52,69,70 }, {165,182,166 ,224,243,225 ,52,70,53 },
	{166,182,183 ,225,243,244 ,53,70,71 }, {166,183,167 ,225,244,226 ,53,71,54 },
	{167,183,184 ,226,244,245 ,54,71,72 }, {167,184,168 ,226,245,227 ,54,72,55 },
	{168,184,185 ,227,245,246 ,55,72,73 }, {168,185,169 ,227,246,228 ,55,73,56 },
	{169,185,186 ,228,246,247 ,56,73,74 }, {169,186,170 ,228,247,229 ,56,74,57 },
	{170,186,187 ,229,247,248 ,57,74,75 }, {170,187,171 ,229,248,230 ,57,75,58 },
	{171,187,188 ,230,248,249 ,58,75,76 }, {171,188,172 ,230,249,231 ,58,76,59 },
	{172,188,189 ,231,249,250 ,59,76,77 }, {172,189,173 ,231,250,232 ,59,77,60 },
	{173,189,190 ,232,250,251 ,60,77,78 }, {173,190,174 ,232,251,233 ,60,78,61 },
	{174,190,191 ,233,251,252 ,61,78,79 }, {174,191,175 ,233,252,234 ,61,79,62 },
	{175,191,192 ,234,252,253 ,62,79,80 }, {175,192,176 ,234,253,235 ,62,80,63 },
	{176,192,193 ,235,253,254 ,63,80,81 }, {176,193,177 ,235,254,236 ,63,81,64 },
	{177,193,194 ,236,254,255 ,64,81,82 }, {177,194,178 ,236,255,237 ,64,82,65 },
	{178,194,179 ,237,255,256 ,65,82,83 }, {178,179,163 ,237,257,257 ,65,83,66 },
	{196,195,197 ,258,259,260 ,1,0,2 }, {197,195,198 ,260,261,262 ,2,3,4 },
	{198,195,199 ,262,263,264 ,4,5,6 }, {199,195,200 ,264,265,266 ,6,7,8 },
	{200,195,201 ,266,267,268 ,8,9,10 }, {201,195,202 ,268,269,270 ,10,11,12 },
	{202,195,203 ,270,271,272 ,12,13,14 }, {203,195,204 ,272,273,274 ,14,15,16 },
	{204,195,205 ,274,275,276 ,16,17,18 }, {205,195,206 ,276,277,278 ,18,19,20 },
	{206,195,207 ,278,279,280 ,20,21,22 }, {207,195,208 ,280,281,282 ,22,23,24 },
	{208,195,209 ,282,283,284 ,24,25,26 }, {209,195,210 ,284,285,286 ,26,27,28 },
	{210,195,211 ,286,287,288 ,28,29,30 }, {211,195,196 ,288,289,289 ,30,31,32 },
	{212,196,213 ,290,258,291 ,33,1,34 }, {213,196,197 ,291,258,260 ,34,1,2 },
	{213,197,214 ,291,260,292 ,34,2,35 }, {214,197,198 ,292,260,262 ,35,2,4 },
	{214,198,215 ,292,262,293 ,35,4,36 }, {215,198,199 ,293,262,264 ,36,4,6 },
	{215,199,216 ,293,264,294 ,36,6,37 }, {216,199,200 ,294,264,266 ,37,6,8 },
	{216,200,217 ,294,266,295 ,37,8,38 }, {217,200,201 ,295,266,268 ,38,8,10 },
	{217,201,218 ,295,268,296 ,38,10,39 }, {218,201,202 ,296,268,270 ,39,10,12 },
	{218,202,219 ,296,270,297 ,39,12,40 }, {219,202,203 ,297,270,272 ,40,12,14 },
	{219,203,220 ,297,272,298 ,40,14,41 }, {220,203,204 ,298,272,274 ,41,14,16 },
	{220,204,221 ,298,274,299 ,41,16,42 }, {221,204,205 ,299,274,276 ,42,16,18 },
	{221,205,222 ,299,276,300 ,42,18,43 }, {222,205,206 ,300,276,278 ,43,18,20 },
	{222,206,223 ,300,278,301 ,43,20,44 }, {223,206,207 ,301,278,280 ,44,20,22 },
	{223,207,224 ,301,280,302 ,44,22,45 }, {224,207,208 ,302,280,282 ,45,22,24 },
	{224,208,225 ,302,282,303 ,45,24,46 }, {225,208,209 ,303,282,284 ,46,24,26 },
	{225,209,226 ,303,284,304 ,46,26,47 }, {226,209,210 ,304,284,286 ,47,26,28 },
	{226,210,227 ,304,286,305 ,47,28,48 }, {227,210,211 ,305,286,288 ,48,28,30 },
	{227,211,212 ,305,288,306 ,48,30,49 }, {212,211,196 ,307,288,307 ,49,30,32 },
	{228,212,229 ,308,290,309 ,50,33,51 }, {229,212,213 ,309,290,291 ,51,33,34 },
	{229,213,230 ,309,291,310 ,51,34,52 }, {230,213,214 ,310,291,292 ,52,34,35 },
	{230,214,231 ,310,292,311 ,52,35,53 }, {231,214,215 ,311,292,293 ,53,35,36 },
	{231,215,232 ,311,293,312 ,53,36,54 }, {232,215,216 ,312,293,294 ,54,36,37 },
	{232,216,233 ,312,294,313 ,54,37,55 }, {233,216,217 ,313,294,295 ,55,37,38 },
	{233,217,234 ,313,295,314 ,55,38,56 }, {234,217,218 ,314,295,296 ,56,38,39 },
	{234,218,235 ,314,296,315 ,56,39,57 }, {235,218,219 ,315,296,297 ,57,39,40 },
	{235,219,236 ,315,297,316 ,57,40,58 }, {236,219,220 ,316,297,298 ,58,40,41 },
	{236,220,237 ,316,298,317 ,58,41,59 }, {237,220,221 ,317,298,299 ,59,41,42 },
	{237,221,238 ,317,299,318 ,59,42,60 }, {238,221,222 ,318,299,300 ,60,42,43 },
	{238,222,239 ,318,300,319 ,60,43,61 }, {239,222,223 ,319,300,301 ,61,43,44 },
	{239,223,240 ,319,301,320 ,61,44,62 }, {240,223,224 ,320,301,302 ,62,44,45 },
	{240,224,241 ,320,302,321 ,62,45,63 }, {241,224,225 ,321,302,303 ,63,45,46 },
	{241,225,242 ,321,303,322 ,63,46,64 }, {242,225,226 ,322,303,304 ,64,46,47 },
	{242,226,243 ,322,304,323 ,64,47,65 }, {243,226,227 ,323,304,305 ,65,47,48 },
	{243,227,228 ,323,305,324 ,65,48,66 }, {228,227,212 ,325,305,325 ,66,48,49 },
	{244,228,245 ,326,308,327 ,67,50,68 }, {245,228,229 ,327,308,309 ,68,50,51 },
	{245,229,246 ,327,309,328 ,68,51,69 }, {246,229,230 ,328,309,310 ,69,51,52 },
	{246,230,247 ,328,310,329 ,69,52,70 }, {247,230,231 ,329,310,311 ,70,52,53 },
	{247,231,248 ,329,311,330 ,70,53,71 }, {248,231,232 ,330,311,312 ,71,53,54 },
	{248,232,249 ,330,312,331 ,71,54,72 }, {249,232,233 ,331,312,313 ,72,54,55 },
	{249,233,250 ,331,313,332 ,72,55,73 }, {250,233,234 ,332,313,314 ,73,55,56 },
	{250,234,251 ,332,314,333 ,73,56,74 }, {251,234,235 ,333,314,315 ,74,56,57 },
	{251,235,252 ,333,315,334 ,74,57,75 }, {252,235,236 ,334,315,316 ,75,57,58 },
	{252,236,253 ,334,316,335 ,75,58,76 }, {253,236,237 ,335,316,317 ,76,58,59 },
	{253,237,254 ,335,317,336 ,76,59,77 }, {254,237,238 ,336,317,318 ,77,59,60 },
	{254,238,255 ,336,318,337 ,77,60,78 }, {255,238,239 ,337,318,319 ,78,60,61 },
	{255,239,256 ,337,319,338 ,78,61,79 }, {256,239,240 ,338,319,320 ,79,61,62 },
	{256,240,257 ,338,320,339 ,79,62,80 }, {257,240,241 ,339,320,321 ,80,62,63 },
	{257,241,258 ,339,321,340 ,80,63,81 }, {258,241,242 ,340,321,322 ,81,63,64 },
	{258,242,259 ,340,322,341 ,81,64,82 }, {259,242,243 ,341,322,323 ,82,64,65 },
	{259,243,244 ,341,323,342 ,82,65,83 }, {244,243,228 ,343,323,343 ,83,65,66 }
},

//lid 6
{
// Object #-1
	{0,1,2 ,0,1,2 ,0,1,2 }, {0,2,3 ,3,2,4 ,3,2,4 }, {0,3,4 ,5,4,6 ,5,4,6 },
	{0,4,5 ,7,6,8 ,7,6,8 }, {0,5,6 ,9,8,10 ,9,8,10 }, {0,6,7 ,11,10,12 ,11,10,12 },
	{0,7,8 ,13,12,14 ,13,12,14 }, {0,8,9 ,15,14,16 ,15,14,16 }, {0,9,10 ,17,16,18 ,17,16,18 },
	{0,10,11 ,19,18,20 ,19,18,20 }, {0,11,12 ,21,20,22 ,21,20,22 },
	{0,12,13 ,23,22,24 ,23,22,24 }, {0,13,14 ,25,24,26 ,25,24,26 },
	{0,14,15 ,27,26,28 ,27,26,28 }, {0,15,16 ,29,28,30 ,29,28,30 },
	{0,16,1 ,31,30,31 ,31,30,32 }, {1,17,18 ,1,32,33 ,1,33,34 },
	{1,18,2 ,1,33,2 ,1,34,2 }, {2,18,19 ,2,33,34 ,2,34,35 }, {2,19,3 ,2,34,4 ,2,35,4 },
	{3,19,20 ,4,34,35 ,4,35,36 }, {3,20,4 ,4,35,6 ,4,36,6 }, {4,20,21 ,6,35,36 ,6,36,37 },
	{4,21,5 ,6,36,8 ,6,37,8 }, {5,21,22 ,8,36,37 ,8,37,38 }, {5,22,6 ,8,37,10 ,8,38,10 },
	{6,22,23 ,10,37,38 ,10,38,39 }, {6,23,7 ,10,38,12 ,10,39,12 },
	{7,23,24 ,12,38,39 ,12,39,40 }, {7,24,8 ,12,39,14 ,12,40,14 },
	{8,24,25 ,14,39,40 ,14,40,41 }, {8,25,9 ,14,40,16 ,14,41,16 },
	{9,25,26 ,16,40,41 ,16,41,42 }, {9,26,10 ,16,41,18 ,16,42,18 },
	{10,26,27 ,18,41,42 ,18,42,43 }, {10,27,11 ,18,42,20 ,18,43,20 },
	{11,27,28 ,20,42,43 ,20,43,44 }, {11,28,12 ,20,43,22 ,20,44,22 },
	{12,28,29 ,22,43,44 ,22,44,45 }, {12,29,13 ,22,44,24 ,22,45,24 },
	{13,29,30 ,24,44,45 ,24,45,46 }, {13,30,14 ,24,45,26 ,24,46,26 },
	{14,30,31 ,26,45,46 ,26,46,47 }, {14,31,15 ,26,46,28 ,26,47,28 },
	{15,31,32 ,28,46,47 ,28,47,48 }, {15,32,16 ,28,47,30 ,28,48,30 },
	{16,32,17 ,30,47,48 ,30,48,49 }, {16,17,1 ,30,49,49 ,30,49,32 },
	{17,33,34 ,32,50,51 ,33,50,51 }, {17,34,18 ,32,51,33 ,33,51,34 },
	{18,34,35 ,33,51,52 ,34,51,52 }, {18,35,19 ,33,52,34 ,34,52,35 },
	{19,35,36 ,34,52,53 ,35,52,53 }, {19,36,20 ,34,53,35 ,35,53,36 },
	{20,36,37 ,35,53,54 ,36,53,54 }, {20,37,21 ,35,54,36 ,36,54,37 },
	{21,37,38 ,36,54,55 ,37,54,55 }, {21,38,22 ,36,55,37 ,37,55,38 },
	{22,38,39 ,37,55,56 ,38,55,56 }, {22,39,23 ,37,56,38 ,38,56,39 },
	{23,39,40 ,38,56,57 ,39,56,57 }, {23,40,24 ,38,57,39 ,39,57,40 },
	{24,40,41 ,39,57,58 ,40,57,58 }, {24,41,25 ,39,58,40 ,40,58,41 },
	{25,41,42 ,40,58,59 ,41,58,59 }, {25,42,26 ,40,59,41 ,41,59,42 },
	{26,42,43 ,41,59,60 ,42,59,60 }, {26,43,27 ,41,60,42 ,42,60,43 },
	{27,43,44 ,42,60,61 ,43,60,61 }, {27,44,28 ,42,61,43 ,43,61,44 },
	{28,44,45 ,43,61,62 ,44,61,62 }, {28,45,29 ,43,62,44 ,44,62,45 },
	{29,45,46 ,44,62,63 ,45,62,63 }, {29,46,30 ,44,63,45 ,45,63,46 },
	{30,46,47 ,45,63,64 ,46,63,64 }, {30,47,31 ,45,64,46 ,46,64,47 },
	{31,47,48 ,46,64,65 ,47,64,65 }, {31,48,32 ,46,65,47 ,47,65,48 },
	{32,48,33 ,47,65,66 ,48,65,66 }, {32,33,17 ,47,67,67 ,48,66,49 },
	{33,49,50 ,50,68,69 ,50,67,68 }, {33,50,34 ,50,69,51 ,50,68,51 },
	{34,50,51 ,51,69,70 ,51,68,69 }, {34,51,35 ,51,70,52 ,51,69,52 },
	{35,51,52 ,52,70,71 ,52,69,70 }, {35,52,36 ,52,71,53 ,52,70,53 },
	{36,52,53 ,53,71,72 ,53,70,71 }, {36,53,37 ,53,72,54 ,53,71,54 },
	{37,53,54 ,54,72,73 ,54,71,72 }, {37,54,38 ,54,73,55 ,54,72,55 },
	{38,54,55 ,55,73,74 ,55,72,73 }, {38,55,39 ,55,74,56 ,55,73,56 },
	{39,55,56 ,56,74,75 ,56,73,74 }, {39,56,40 ,56,75,57 ,56,74,57 },
	{40,56,57 ,57,75,76 ,57,74,75 }, {40,57,41 ,57,76,58 ,57,75,58 },
	{41,57,58 ,58,76,77 ,58,75,76 }, {41,58,42 ,58,77,59 ,58,76,59 },
	{42,58,59 ,59,77,78 ,59,76,77 }, {42,59,43 ,59,78,60 ,59,77,60 },
	{43,59,60 ,60,78,79 ,60,77,78 }, {43,60,44 ,60,79,61 ,60,78,61 },
	{44,60,61 ,61,79,80 ,61,78,79 }, {44,61,45 ,61,80,62 ,61,79,62 },
	{45,61,62 ,62,80,81 ,62,79,80 }, {45,62,46 ,62,81,63 ,62,80,63 },
	{46,62,63 ,63,81,82 ,63,80,81 }, {46,63,47 ,63,82,64 ,63,81,64 },
	{47,63,64 ,64,82,83 ,64,81,82 }, {47,64,48 ,64,83,65 ,64,82,65 },
	{48,64,49 ,65,83,84 ,65,82,83 }, {48,49,33 ,65,85,85 ,65,83,66 },
	{66,65,67 ,86,87,88 ,1,0,2 }, {67,65,68 ,88,89,90 ,2,3,4 }, {68,65,69 ,90,91,92 ,4,5,6 },
	{69,65,70 ,92,93,94 ,6,7,8 }, {70,65,71 ,94,95,96 ,8,9,10 },
	{71,65,72 ,96,97,98 ,10,11,12 }, {72,65,73 ,98,99,100 ,12,13,14 },
	{73,65,74 ,100,101,102 ,14,15,16 }, {74,65,75 ,102,103,104 ,16,17,18 },
	{75,65,76 ,104,105,106 ,18,19,20 }, {76,65,77 ,106,107,108 ,20,21,22 },
	{77,65,78 ,108,109,110 ,22,23,24 }, {78,65,79 ,110,111,112 ,24,25,26 },
	{79,65,80 ,112,113,114 ,26,27,28 }, {80,65,81 ,114,115,116 ,28,29,30 },
	{81,65,66 ,116,117,117 ,30,31,32 }, {82,66,83 ,118,86,119 ,33,1,34 },
	{83,66,67 ,119,86,88 ,34,1,2 }, {83,67,84 ,119,88,120 ,34,2,35 },
	{84,67,68 ,120,88,90 ,35,2,4 }, {84,68,85 ,120,90,121 ,35,4,36 },
	{85,68,69 ,121,90,92 ,36,4,6 }, {85,69,86 ,121,92,122 ,36,6,37 },
	{86,69,70 ,122,92,94 ,37,6,8 }, {86,70,87 ,122,94,123 ,37,8,38 },
	{87,70,71 ,123,94,96 ,38,8,10 }, {87,71,88 ,123,96,124 ,38,10,39 },
	{88,71,72 ,124,96,98 ,39,10,12 }, {88,72,89 ,124,98,125 ,39,12,40 },
	{89,72,73 ,125,98,100 ,40,12,14 }, {89,73,90 ,125,100,126 ,40,14,41 },
	{90,73,74 ,126,100,102 ,41,14,16 }, {90,74,91 ,126,102,127 ,41,16,42 },
	{91,74,75 ,127,102,104 ,42,16,18 }, {91,75,92 ,127,104,128 ,42,18,43 },
	{92,75,76 ,128,104,106 ,43,18,20 }, {92,76,93 ,128,106,129 ,43,20,44 },
	{93,76,77 ,129,106,108 ,44,20,22 }, {93,77,94 ,129,108,130 ,44,22,45 },
	{94,77,78 ,130,108,110 ,45,22,24 }, {94,78,95 ,130,110,131 ,45,24,46 },
	{95,78,79 ,131,110,112 ,46,24,26 }, {95,79,96 ,131,112,132 ,46,26,47 },
	{96,79,80 ,132,112,114 ,47,26,28 }, {96,80,97 ,132,114,133 ,47,28,48 },
	{97,80,81 ,133,114,116 ,48,28,30 }, {97,81,82 ,133,116,134 ,48,30,49 },
	{82,81,66 ,135,116,135 ,49,30,32 }, {98,82,99 ,136,118,137 ,50,33,51 },
	{99,82,83 ,137,118,119 ,51,33,34 }, {99,83,100 ,137,119,138 ,51,34,52 },
	{100,83,84 ,138,119,120 ,52,34,35 }, {100,84,101 ,138,120,139 ,52,35,53 },
	{101,84,85 ,139,120,121 ,53,35,36 }, {101,85,102 ,139,121,140 ,53,36,54 },
	{102,85,86 ,140,121,122 ,54,36,37 }, {102,86,103 ,140,122,141 ,54,37,55 },
	{103,86,87 ,141,122,123 ,55,37,38 }, {103,87,104 ,141,123,142 ,55,38,56 },
	{104,87,88 ,142,123,124 ,56,38,39 }, {104,88,105 ,142,124,143 ,56,39,57 },
	{105,88,89 ,143,124,125 ,57,39,40 }, {105,89,106 ,143,125,144 ,57,40,58 },
	{106,89,90 ,144,125,126 ,58,40,41 }, {106,90,107 ,144,126,145 ,58,41,59 },
	{107,90,91 ,145,126,127 ,59,41,42 }, {107,91,108 ,145,127,146 ,59,42,60 },
	{108,91,92 ,146,127,128 ,60,42,43 }, {108,92,109 ,146,128,147 ,60,43,61 },
	{109,92,93 ,147,128,129 ,61,43,44 }, {109,93,110 ,147,129,148 ,61,44,62 },
	{110,93,94 ,148,129,130 ,62,44,45 }, {110,94,111 ,148,130,149 ,62,45,63 },
	{111,94,95 ,149,130,131 ,63,45,46 }, {111,95,112 ,149,131,150 ,63,46,64 },
	{112,95,96 ,150,131,132 ,64,46,47 }, {112,96,113 ,150,132,151 ,64,47,65 },
	{113,96,97 ,151,132,133 ,65,47,48 }, {113,97,98 ,151,133,152 ,65,48,66 },
	{98,97,82 ,153,133,153 ,66,48,49 }, {114,98,115 ,154,136,155 ,67,50,68 },
	{115,98,99 ,155,136,137 ,68,50,51 }, {115,99,116 ,155,137,156 ,68,51,69 },
	{116,99,100 ,156,137,138 ,69,51,52 }, {116,100,117 ,156,138,157 ,69,52,70 },
	{117,100,101 ,157,138,139 ,70,52,53 }, {117,101,118 ,157,139,158 ,70,53,71 },
	{118,101,102 ,158,139,140 ,71,53,54 }, {118,102,119 ,158,140,159 ,71,54,72 },
	{119,102,103 ,159,140,141 ,72,54,55 }, {119,103,120 ,159,141,160 ,72,55,73 },
	{120,103,104 ,160,141,142 ,73,55,56 }, {120,104,121 ,160,142,161 ,73,56,74 },
	{121,104,105 ,161,142,143 ,74,56,57 }, {121,105,122 ,161,143,162 ,74,57,75 },
	{122,105,106 ,162,143,144 ,75,57,58 }, {122,106,123 ,162,144,163 ,75,58,76 },
	{123,106,107 ,163,144,145 ,76,58,59 }, {123,107,124 ,163,145,164 ,76,59,77 },
	{124,107,108 ,164,145,146 ,77,59,60 }, {124,108,125 ,164,146,165 ,77,60,78 },
	{125,108,109 ,165,146,147 ,78,60,61 }, {125,109,126 ,165,147,166 ,78,61,79 },
	{126,109,110 ,166,147,148 ,79,61,62 }, {126,110,127 ,166,148,167 ,79,62,80 },
	{127,110,111 ,167,148,149 ,80,62,63 }, {127,111,128 ,167,149,168 ,80,63,81 },
	{128,111,112 ,168,149,150 ,81,63,64 }, {128,112,129 ,168,150,169 ,81,64,82 },
	{129,112,113 ,169,150,151 ,82,64,65 }, {129,113,114 ,169,151,170 ,82,65,83 },
	{114,113,98 ,171,151,171 ,83,65,66 }
// Object #-1
	, {130,131,132 ,172,173,174 ,0,1,2 }, {130,132,133 ,175,174,176 ,3,2,4 },
	{130,133,134 ,177,176,178 ,5,4,6 }, {130,134,135 ,179,178,180 ,7,6,8 },
	{130,135,136 ,181,180,182 ,9,8,10 }, {130,136,137 ,183,182,184 ,11,10,12 },
	{130,137,138 ,185,184,186 ,13,12,14 }, {130,138,139 ,187,186,188 ,15,14,16 },
	{130,139,140 ,189,188,190 ,17,16,18 }, {130,140,141 ,191,190,192 ,19,18,20 },
	{130,141,142 ,193,192,194 ,21,20,22 }, {130,142,143 ,195,194,196 ,23,22,24 },
	{130,143,144 ,197,196,198 ,25,24,26 }, {130,144,145 ,199,198,200 ,27,26,28 },
	{130,145,146 ,201,200,202 ,29,28,30 }, {130,146,131 ,203,202,203 ,31,30,32 },
	{131,147,148 ,173,204,205 ,1,33,34 }, {131,148,132 ,173,205,174 ,1,34,2 },
	{132,148,149 ,174,205,206 ,2,34,35 }, {132,149,133 ,174,206,176 ,2,35,4 },
	{133,149,150 ,176,206,207 ,4,35,36 }, {133,150,134 ,176,207,178 ,4,36,6 },
	{134,150,151 ,178,207,208 ,6,36,37 }, {134,151,135 ,178,208,180 ,6,37,8 },
	{135,151,152 ,180,208,209 ,8,37,38 }, {135,152,136 ,180,209,182 ,8,38,10 },
	{136,152,153 ,182,209,210 ,10,38,39 }, {136,153,137 ,182,210,184 ,10,39,12 },
	{137,153,154 ,184,210,211 ,12,39,40 }, {137,154,138 ,184,211,186 ,12,40,14 },
	{138,154,155 ,186,211,212 ,14,40,41 }, {138,155,139 ,186,212,188 ,14,41,16 },
	{139,155,156 ,188,212,213 ,16,41,42 }, {139,156,140 ,188,213,190 ,16,42,18 },
	{140,156,157 ,190,213,214 ,18,42,43 }, {140,157,141 ,190,214,192 ,18,43,20 },
	{141,157,158 ,192,214,215 ,20,43,44 }, {141,158,142 ,192,215,194 ,20,44,22 },
	{142,158,159 ,194,215,216 ,22,44,45 }, {142,159,143 ,194,216,196 ,22,45,24 },
	{143,159,160 ,196,216,217 ,24,45,46 }, {143,160,144 ,196,217,198 ,24,46,26 },
	{144,160,161 ,198,217,218 ,26,46,47 }, {144,161,145 ,198,218,200 ,26,47,28 },
	{145,161,162 ,200,218,219 ,28,47,48 }, {145,162,146 ,200,219,202 ,28,48,30 },
	{146,162,147 ,202,219,220 ,30,48,49 }, {146,147,131 ,202,221,221 ,30,49,32 },
	{147,163,164 ,204,222,223 ,33,50,51 }, {147,164,148 ,204,223,205 ,33,51,34 },
	{148,164,165 ,205,223,224 ,34,51,52 }, {148,165,149 ,205,224,206 ,34,52,35 },
	{149,165,166 ,206,224,225 ,35,52,53 }, {149,166,150 ,206,225,207 ,35,53,36 },
	{150,166,167 ,207,225,226 ,36,53,54 }, {150,167,151 ,207,226,208 ,36,54,37 },
	{151,167,168 ,208,226,227 ,37,54,55 }, {151,168,152 ,208,227,209 ,37,55,38 },
	{152,168,169 ,209,227,228 ,38,55,56 }, {152,169,153 ,209,228,210 ,38,56,39 },
	{153,169,170 ,210,228,229 ,39,56,57 }, {153,170,154 ,210,229,211 ,39,57,40 },
	{154,170,171 ,211,229,230 ,40,57,58 }, {154,171,155 ,211,230,212 ,40,58,41 },
	{155,171,172 ,212,230,231 ,41,58,59 }, {155,172,156 ,212,231,213 ,41,59,42 },
	{156,172,173 ,213,231,232 ,42,59,60 }, {156,173,157 ,213,232,214 ,42,60,43 },
	{157,173,174 ,214,232,233 ,43,60,61 }, {157,174,158 ,214,233,215 ,43,61,44 },
	{158,174,175 ,215,233,234 ,44,61,62 }, {158,175,159 ,215,234,216 ,44,62,45 },
	{159,175,176 ,216,234,235 ,45,62,63 }, {159,176,160 ,216,235,217 ,45,63,46 },
	{160,176,177 ,217,235,236 ,46,63,64 }, {160,177,161 ,217,236,218 ,46,64,47 },
	{161,177,178 ,218,236,237 ,47,64,65 }, {161,178,162 ,218,237,219 ,47,65,48 },
	{162,178,163 ,219,237,238 ,48,65,66 }, {162,163,147 ,219,239,239 ,48,66,49 },
	{163,179,180 ,222,240,241 ,50,67,68 }, {163,180,164 ,222,241,223 ,50,68,51 },
	{164,180,181 ,223,241,242 ,51,68,69 }, {164,181,165 ,223,242,224 ,51,69,52 },
	{165,181,182 ,224,242,243 ,52,69,70 }, {165,182,166 ,224,243,225 ,52,70,53 },
	{166,182,183 ,225,243,244 ,53,70,71 }, {166,183,167 ,225,244,226 ,53,71,54 },
	{167,183,184 ,226,244,245 ,54,71,72 }, {167,184,168 ,226,245,227 ,54,72,55 },
	{168,184,185 ,227,245,246 ,55,72,73 }, {168,185,169 ,227,246,228 ,55,73,56 },
	{169,185,186 ,228,246,247 ,56,73,74 }, {169,186,170 ,228,247,229 ,56,74,57 },
	{170,186,187 ,229,247,248 ,57,74,75 }, {170,187,171 ,229,248,230 ,57,75,58 },
	{171,187,188 ,230,248,249 ,58,75,76 }, {171,188,172 ,230,249,231 ,58,76,59 },
	{172,188,189 ,231,249,250 ,59,76,77 }, {172,189,173 ,231,250,232 ,59,77,60 },
	{173,189,190 ,232,250,251 ,60,77,78 }, {173,190,174 ,232,251,233 ,60,78,61 },
	{174,190,191 ,233,251,252 ,61,78,79 }, {174,191,175 ,233,252,234 ,61,79,62 },
	{175,191,192 ,234,252,253 ,62,79,80 }, {175,192,176 ,234,253,235 ,62,80,63 },
	{176,192,193 ,235,253,254 ,63,80,81 }, {176,193,177 ,235,254,236 ,63,81,64 },
	{177,193,194 ,236,254,255 ,64,81,82 }, {177,194,178 ,236,255,237 ,64,82,65 },
	{178,194,179 ,237,255,256 ,65,82,83 }, {178,179,163 ,237,257,257 ,65,83,66 },
	{196,195,197 ,258,259,260 ,1,0,2 }, {197,195,198 ,260,261,262 ,2,3,4 },
	{198,195,199 ,262,263,264 ,4,5,6 }, {199,195,200 ,264,265,266 ,6,7,8 },
	{200,195,201 ,266,267,268 ,8,9,10 }, {201,195,202 ,268,269,270 ,10,11,12 },
	{202,195,203 ,270,271,272 ,12,13,14 }, {203,195,204 ,272,273,274 ,14,15,16 },
	{204,195,205 ,274,275,276 ,16,17,18 }, {205,195,206 ,276,277,278 ,18,19,20 },
	{206,195,207 ,278,279,280 ,20,21,22 }, {207,195,208 ,280,281,282 ,22,23,24 },
	{208,195,209 ,282,283,284 ,24,25,26 }, {209,195,210 ,284,285,286 ,26,27,28 },
	{210,195,211 ,286,287,288 ,28,29,30 }, {211,195,196 ,288,289,289 ,30,31,32 },
	{212,196,213 ,290,258,291 ,33,1,34 }, {213,196,197 ,291,258,260 ,34,1,2 },
	{213,197,214 ,291,260,292 ,34,2,35 }, {214,197,198 ,292,260,262 ,35,2,4 },
	{214,198,215 ,292,262,293 ,35,4,36 }, {215,198,199 ,293,262,264 ,36,4,6 },
	{215,199,216 ,293,264,294 ,36,6,37 }, {216,199,200 ,294,264,266 ,37,6,8 },
	{216,200,217 ,294,266,295 ,37,8,38 }, {217,200,201 ,295,266,268 ,38,8,10 },
	{217,201,218 ,295,268,296 ,38,10,39 }, {218,201,202 ,296,268,270 ,39,10,12 },
	{218,202,219 ,296,270,297 ,39,12,40 }, {219,202,203 ,297,270,272 ,40,12,14 },
	{219,203,220 ,297,272,298 ,40,14,41 }, {220,203,204 ,298,272,274 ,41,14,16 },
	{220,204,221 ,298,274,299 ,41,16,42 }, {221,204,205 ,299,274,276 ,42,16,18 },
	{221,205,222 ,299,276,300 ,42,18,43 }, {222,205,206 ,300,276,278 ,43,18,20 },
	{222,206,223 ,300,278,301 ,43,20,44 }, {223,206,207 ,301,278,280 ,44,20,22 },
	{223,207,224 ,301,280,302 ,44,22,45 }, {224,207,208 ,302,280,282 ,45,22,24 },
	{224,208,225 ,302,282,303 ,45,24,46 }, {225,208,209 ,303,282,284 ,46,24,26 },
	{225,209,226 ,303,284,304 ,46,26,47 }, {226,209,210 ,304,284,286 ,47,26,28 },
	{226,210,227 ,304,286,305 ,47,28,48 }, {227,210,211 ,305,286,288 ,48,28,30 },
	{227,211,212 ,305,288,306 ,48,30,49 }, {212,211,196 ,307,288,307 ,49,30,32 },
	{228,212,229 ,308,290,309 ,50,33,51 }, {229,212,213 ,309,290,291 ,51,33,34 },
	{229,213,230 ,309,291,310 ,51,34,52 }, {230,213,214 ,310,291,292 ,52,34,35 },
	{230,214,231 ,310,292,311 ,52,35,53 }, {231,214,215 ,311,292,293 ,53,35,36 },
	{231,215,232 ,311,293,312 ,53,36,54 }, {232,215,216 ,312,293,294 ,54,36,37 },
	{232,216,233 ,312,294,313 ,54,37,55 }, {233,216,217 ,313,294,295 ,55,37,38 },
	{233,217,234 ,313,295,314 ,55,38,56 }, {234,217,218 ,314,295,296 ,56,38,39 },
	{234,218,235 ,314,296,315 ,56,39,57 }, {235,218,219 ,315,296,297 ,57,39,40 },
	{235,219,236 ,315,297,316 ,57,40,58 }, {236,219,220 ,316,297,298 ,58,40,41 },
	{236,220,237 ,316,298,317 ,58,41,59 }, {237,220,221 ,317,298,299 ,59,41,42 },
	{237,221,238 ,317,299,318 ,59,42,60 }, {238,221,222 ,318,299,300 ,60,42,43 },
	{238,222,239 ,318,300,319 ,60,43,61 }, {239,222,223 ,319,300,301 ,61,43,44 },
	{239,223,240 ,319,301,320 ,61,44,62 }, {240,223,224 ,320,301,302 ,62,44,45 },
	{240,224,241 ,320,302,321 ,62,45,63 }, {241,224,225 ,321,302,303 ,63,45,46 },
	{241,225,242 ,321,303,322 ,63,46,64 }, {242,225,226 ,322,303,304 ,64,46,47 },
	{242,226,243 ,322,304,323 ,64,47,65 }, {243,226,227 ,323,304,305 ,65,47,48 },
	{243,227,228 ,323,305,324 ,65,48,66 }, {228,227,212 ,325,305,325 ,66,48,49 },
	{244,228,245 ,326,308,327 ,67,50,68 }, {245,228,229 ,327,308,309 ,68,50,51 },
	{245,229,246 ,327,309,328 ,68,51,69 }, {246,229,230 ,328,309,310 ,69,51,52 },
	{246,230,247 ,328,310,329 ,69,52,70 }, {247,230,231 ,329,310,311 ,70,52,53 },
	{247,231,248 ,329,311,330 ,70,53,71 }, {248,231,232 ,330,311,312 ,71,53,54 },
	{248,232,249 ,330,312,331 ,71,54,72 }, {249,232,233 ,331,312,313 ,72,54,55 },
	{249,233,250 ,331,313,332 ,72,55,73 }, {250,233,234 ,332,313,314 ,73,55,56 },
	{250,234,251 ,332,314,333 ,73,56,74 }, {251,234,235 ,333,314,315 ,74,56,57 },
	{251,235,252 ,333,315,334 ,74,57,75 }, {252,235,236 ,334,315,316 ,75,57,58 },
	{252,236,253 ,334,316,335 ,75,58,76 }, {253,236,237 ,335,316,317 ,76,58,59 },
	{253,237,254 ,335,317,336 ,76,59,77 }, {254,237,238 ,336,317,318 ,77,59,60 },
	{254,238,255 ,336,318,337 ,77,60,78 }, {255,238,239 ,337,318,319 ,78,60,61 },
	{255,239,256 ,337,319,338 ,78,61,79 }, {256,239,240 ,338,319,320 ,79,61,62 },
	{256,240,257 ,338,320,339 ,79,62,80 }, {257,240,241 ,339,320,321 ,80,62,63 },
	{257,241,258 ,339,321,340 ,80,63,81 }, {258,241,242 ,340,321,322 ,81,63,64 },
	{258,242,259 ,340,322,341 ,81,64,82 }, {259,242,243 ,341,322,323 ,82,64,65 },
	{259,243,244 ,341,323,342 ,82,65,83 }, {244,243,228 ,343,323,343 ,83,65,66 }
},

//lid 5
{
// Object #-1
	{0,1,2 ,0,1,2 ,0,1,2 }, {0,2,3 ,3,2,4 ,3,2,4 }, {0,3,4 ,5,4,6 ,5,4,6 },
	{0,4,5 ,7,6,8 ,7,6,8 }, {0,5,6 ,9,8,10 ,9,8,10 }, {0,6,7 ,11,10,12 ,11,10,12 },
	{0,7,8 ,13,12,14 ,13,12,14 }, {0,8,9 ,15,14,16 ,15,14,16 }, {0,9,10 ,17,16,18 ,17,16,18 },
	{0,10,11 ,19,18,20 ,19,18,20 }, {0,11,12 ,21,20,22 ,21,20,22 },
	{0,12,13 ,23,22,24 ,23,22,24 }, {0,13,14 ,25,24,26 ,25,24,26 },
	{0,14,15 ,27,26,28 ,27,26,28 }, {0,15,16 ,29,28,30 ,29,28,30 },
	{0,16,1 ,31,30,31 ,31,30,32 }, {1,17,18 ,1,32,33 ,1,33,34 },
	{1,18,2 ,1,33,2 ,1,34,2 }, {2,18,19 ,2,33,34 ,2,34,35 }, {2,19,3 ,2,34,4 ,2,35,4 },
	{3,19,20 ,4,34,35 ,4,35,36 }, {3,20,4 ,4,35,6 ,4,36,6 }, {4,20,21 ,6,35,36 ,6,36,37 },
	{4,21,5 ,6,36,8 ,6,37,8 }, {5,21,22 ,8,36,37 ,8,37,38 }, {5,22,6 ,8,37,10 ,8,38,10 },
	{6,22,23 ,10,37,38 ,10,38,39 }, {6,23,7 ,10,38,12 ,10,39,12 },
	{7,23,24 ,12,38,39 ,12,39,40 }, {7,24,8 ,12,39,14 ,12,40,14 },
	{8,24,25 ,14,39,40 ,14,40,41 }, {8,25,9 ,14,40,16 ,14,41,16 },
	{9,25,26 ,16,40,41 ,16,41,42 }, {9,26,10 ,16,41,18 ,16,42,18 },
	{10,26,27 ,18,41,42 ,18,42,43 }, {10,27,11 ,18,42,20 ,18,43,20 },
	{11,27,28 ,20,42,43 ,20,43,44 }, {11,28,12 ,20,43,22 ,20,44,22 },
	{12,28,29 ,22,43,44 ,22,44,45 }, {12,29,13 ,22,44,24 ,22,45,24 },
	{13,29,30 ,24,44,45 ,24,45,46 }, {13,30,14 ,24,45,26 ,24,46,26 },
	{14,30,31 ,26,45,46 ,26,46,47 }, {14,31,15 ,26,46,28 ,26,47,28 },
	{15,31,32 ,28,46,47 ,28,47,48 }, {15,32,16 ,28,47,30 ,28,48,30 },
	{16,32,17 ,30,47,48 ,30,48,49 }, {16,17,1 ,30,49,49 ,30,49,32 },
	{17,33,34 ,32,50,51 ,33,50,51 }, {17,34,18 ,32,51,33 ,33,51,34 },
	{18,34,35 ,33,51,52 ,34,51,52 }, {18,35,19 ,33,52,34 ,34,52,35 },
	{19,35,36 ,34,52,53 ,35,52,53 }, {19,36,20 ,34,53,35 ,35,53,36 },
	{20,36,37 ,35,53,54 ,36,53,54 }, {20,37,21 ,35,54,36 ,36,54,37 },
	{21,37,38 ,36,54,55 ,37,54,55 }, {21,38,22 ,36,55,37 ,37,55,38 },
	{22,38,39 ,37,55,56 ,38,55,56 }, {22,39,23 ,37,56,38 ,38,56,39 },
	{23,39,40 ,38,56,57 ,39,56,57 }, {23,40,24 ,38,57,39 ,39,57,40 },
	{24,40,41 ,39,57,58 ,40,57,58 }, {24,41,25 ,39,58,40 ,40,58,41 },
	{25,41,42 ,40,58,59 ,41,58,59 }, {25,42,26 ,40,59,41 ,41,59,42 },
	{26,42,43 ,41,59,60 ,42,59,60 }, {26,43,27 ,41,60,42 ,42,60,43 },
	{27,43,44 ,42,60,61 ,43,60,61 }, {27,44,28 ,42,61,43 ,43,61,44 },
	{28,44,45 ,43,61,62 ,44,61,62 }, {28,45,29 ,43,62,44 ,44,62,45 },
	{29,45,46 ,44,62,63 ,45,62,63 }, {29,46,30 ,44,63,45 ,45,63,46 },
	{30,46,47 ,45,63,64 ,46,63,64 }, {30,47,31 ,45,64,46 ,46,64,47 },
	{31,47,48 ,46,64,65 ,47,64,65 }, {31,48,32 ,46,65,47 ,47,65,48 },
	{32,48,33 ,47,65,66 ,48,65,66 }, {32,33,17 ,47,67,67 ,48,66,49 },
	{33,49,50 ,50,68,69 ,50,67,68 }, {33,50,34 ,50,69,51 ,50,68,51 },
	{34,50,51 ,51,69,70 ,51,68,69 }, {34,51,35 ,51,70,52 ,51,69,52 },
	{35,51,52 ,52,70,71 ,52,69,70 }, {35,52,36 ,52,71,53 ,52,70,53 },
	{36,52,53 ,53,71,72 ,53,70,71 }, {36,53,37 ,53,72,54 ,53,71,54 },
	{37,53,54 ,54,72,73 ,54,71,72 }, {37,54,38 ,54,73,55 ,54,72,55 },
	{38,54,55 ,55,73,74 ,55,72,73 }, {38,55,39 ,55,74,56 ,55,73,56 },
	{39,55,56 ,56,74,75 ,56,73,74 }, {39,56,40 ,56,75,57 ,56,74,57 },
	{40,56,57 ,57,75,76 ,57,74,75 }, {40,57,41 ,57,76,58 ,57,75,58 },
	{41,57,58 ,58,76,77 ,58,75,76 }, {41,58,42 ,58,77,59 ,58,76,59 },
	{42,58,59 ,59,77,78 ,59,76,77 }, {42,59,43 ,59,78,60 ,59,77,60 },
	{43,59,60 ,60,78,79 ,60,77,78 }, {43,60,44 ,60,79,61 ,60,78,61 },
	{44,60,61 ,61,79,80 ,61,78,79 }, {44,61,45 ,61,80,62 ,61,79,62 },
	{45,61,62 ,62,80,81 ,62,79,80 }, {45,62,46 ,62,81,63 ,62,80,63 },
	{46,62,63 ,63,81,82 ,63,80,81 }, {46,63,47 ,63,82,64 ,63,81,64 },
	{47,63,64 ,64,82,83 ,64,81,82 }, {47,64,48 ,64,83,65 ,64,82,65 },
	{48,64,49 ,65,83,84 ,65,82,83 }, {48,49,33 ,65,85,85 ,65,83,66 },
	{66,65,67 ,86,87,88 ,1,0,2 }, {67,65,68 ,88,89,90 ,2,3,4 }, {68,65,69 ,90,91,92 ,4,5,6 },
	{69,65,70 ,92,93,94 ,6,7,8 }, {70,65,71 ,94,95,96 ,8,9,10 },
	{71,65,72 ,96,97,98 ,10,11,12 }, {72,65,73 ,98,99,100 ,12,13,14 },
	{73,65,74 ,100,101,102 ,14,15,16 }, {74,65,75 ,102,103,104 ,16,17,18 },
	{75,65,76 ,104,105,106 ,18,19,20 }, {76,65,77 ,106,107,108 ,20,21,22 },
	{77,65,78 ,108,109,110 ,22,23,24 }, {78,65,79 ,110,111,112 ,24,25,26 },
	{79,65,80 ,112,113,114 ,26,27,28 }, {80,65,81 ,114,115,116 ,28,29,30 },
	{81,65,66 ,116,117,117 ,30,31,32 }, {82,66,83 ,118,86,119 ,33,1,34 },
	{83,66,67 ,119,86,88 ,34,1,2 }, {83,67,84 ,119,88,120 ,34,2,35 },
	{84,67,68 ,120,88,90 ,35,2,4 }, {84,68,85 ,120,90,121 ,35,4,36 },
	{85,68,69 ,121,90,92 ,36,4,6 }, {85,69,86 ,121,92,122 ,36,6,37 },
	{86,69,70 ,122,92,94 ,37,6,8 }, {86,70,87 ,122,94,123 ,37,8,38 },
	{87,70,71 ,123,94,96 ,38,8,10 }, {87,71,88 ,123,96,124 ,38,10,39 },
	{88,71,72 ,124,96,98 ,39,10,12 }, {88,72,89 ,124,98,125 ,39,12,40 },
	{89,72,73 ,125,98,100 ,40,12,14 }, {89,73,90 ,125,100,126 ,40,14,41 },
	{90,73,74 ,126,100,102 ,41,14,16 }, {90,74,91 ,126,102,127 ,41,16,42 },
	{91,74,75 ,127,102,104 ,42,16,18 }, {91,75,92 ,127,104,128 ,42,18,43 },
	{92,75,76 ,128,104,106 ,43,18,20 }, {92,76,93 ,128,106,129 ,43,20,44 },
	{93,76,77 ,129,106,108 ,44,20,22 }, {93,77,94 ,129,108,130 ,44,22,45 },
	{94,77,78 ,130,108,110 ,45,22,24 }, {94,78,95 ,130,110,131 ,45,24,46 },
	{95,78,79 ,131,110,112 ,46,24,26 }, {95,79,96 ,131,112,132 ,46,26,47 },
	{96,79,80 ,132,112,114 ,47,26,28 }, {96,80,97 ,132,114,133 ,47,28,48 },
	{97,80,81 ,133,114,116 ,48,28,30 }, {97,81,82 ,133,116,134 ,48,30,49 },
	{82,81,66 ,135,116,135 ,49,30,32 }, {98,82,99 ,136,118,137 ,50,33,51 },
	{99,82,83 ,137,118,119 ,51,33,34 }, {99,83,100 ,137,119,138 ,51,34,52 },
	{100,83,84 ,138,119,120 ,52,34,35 }, {100,84,101 ,138,120,139 ,52,35,53 },
	{101,84,85 ,139,120,121 ,53,35,36 }, {101,85,102 ,139,121,140 ,53,36,54 },
	{102,85,86 ,140,121,122 ,54,36,37 }, {102,86,103 ,140,122,141 ,54,37,55 },
	{103,86,87 ,141,122,123 ,55,37,38 }, {103,87,104 ,141,123,142 ,55,38,56 },
	{104,87,88 ,142,123,124 ,56,38,39 }, {104,88,105 ,142,124,143 ,56,39,57 },
	{105,88,89 ,143,124,125 ,57,39,40 }, {105,89,106 ,143,125,144 ,57,40,58 },
	{106,89,90 ,144,125,126 ,58,40,41 }, {106,90,107 ,144,126,145 ,58,41,59 },
	{107,90,91 ,145,126,127 ,59,41,42 }, {107,91,108 ,145,127,146 ,59,42,60 },
	{108,91,92 ,146,127,128 ,60,42,43 }, {108,92,109 ,146,128,147 ,60,43,61 },
	{109,92,93 ,147,128,129 ,61,43,44 }, {109,93,110 ,147,129,148 ,61,44,62 },
	{110,93,94 ,148,129,130 ,62,44,45 }, {110,94,111 ,148,130,149 ,62,45,63 },
	{111,94,95 ,149,130,131 ,63,45,46 }, {111,95,112 ,149,131,150 ,63,46,64 },
	{112,95,96 ,150,131,132 ,64,46,47 }, {112,96,113 ,150,132,151 ,64,47,65 },
	{113,96,97 ,151,132,133 ,65,47,48 }, {113,97,98 ,151,133,152 ,65,48,66 },
	{98,97,82 ,153,133,153 ,66,48,49 }, {114,98,115 ,154,136,155 ,67,50,68 },
	{115,98,99 ,155,136,137 ,68,50,51 }, {115,99,116 ,155,137,156 ,68,51,69 },
	{116,99,100 ,156,137,138 ,69,51,52 }, {116,100,117 ,156,138,157 ,69,52,70 },
	{117,100,101 ,157,138,139 ,70,52,53 }, {117,101,118 ,157,139,158 ,70,53,71 },
	{118,101,102 ,158,139,140 ,71,53,54 }, {118,102,119 ,158,140,159 ,71,54,72 },
	{119,102,103 ,159,140,141 ,72,54,55 }, {119,103,120 ,159,141,160 ,72,55,73 },
	{120,103,104 ,160,141,142 ,73,55,56 }, {120,104,121 ,160,142,161 ,73,56,74 },
	{121,104,105 ,161,142,143 ,74,56,57 }, {121,105,122 ,161,143,162 ,74,57,75 },
	{122,105,106 ,162,143,144 ,75,57,58 }, {122,106,123 ,162,144,163 ,75,58,76 },
	{123,106,107 ,163,144,145 ,76,58,59 }, {123,107,124 ,163,145,164 ,76,59,77 },
	{124,107,108 ,164,145,146 ,77,59,60 }, {124,108,125 ,164,146,165 ,77,60,78 },
	{125,108,109 ,165,146,147 ,78,60,61 }, {125,109,126 ,165,147,166 ,78,61,79 },
	{126,109,110 ,166,147,148 ,79,61,62 }, {126,110,127 ,166,148,167 ,79,62,80 },
	{127,110,111 ,167,148,149 ,80,62,63 }, {127,111,128 ,167,149,168 ,80,63,81 },
	{128,111,112 ,168,149,150 ,81,63,64 }, {128,112,129 ,168,150,169 ,81,64,82 },
	{129,112,113 ,169,150,151 ,82,64,65 }, {129,113,114 ,169,151,170 ,82,65,83 },
	{114,113,98 ,171,151,171 ,83,65,66 }
// Object #-1
	, {130,131,132 ,172,173,174 ,0,1,2 }, {130,132,133 ,175,174,176 ,3,2,4 },
	{130,133,134 ,177,176,178 ,5,4,6 }, {130,134,135 ,179,178,180 ,7,6,8 },
	{130,135,136 ,181,180,182 ,9,8,10 }, {130,136,137 ,183,182,184 ,11,10,12 },
	{130,137,138 ,185,184,186 ,13,12,14 }, {130,138,139 ,187,186,188 ,15,14,16 },
	{130,139,140 ,189,188,190 ,17,16,18 }, {130,140,141 ,191,190,192 ,19,18,20 },
	{130,141,142 ,193,192,194 ,21,20,22 }, {130,142,143 ,195,194,196 ,23,22,24 },
	{130,143,144 ,197,196,198 ,25,24,26 }, {130,144,145 ,199,198,200 ,27,26,28 },
	{130,145,146 ,201,200,202 ,29,28,30 }, {130,146,131 ,203,202,203 ,31,30,32 },
	{131,147,148 ,173,204,205 ,1,33,34 }, {131,148,132 ,173,205,174 ,1,34,2 },
	{132,148,149 ,174,205,206 ,2,34,35 }, {132,149,133 ,174,206,176 ,2,35,4 },
	{133,149,150 ,176,206,207 ,4,35,36 }, {133,150,134 ,176,207,178 ,4,36,6 },
	{134,150,151 ,178,207,208 ,6,36,37 }, {134,151,135 ,178,208,180 ,6,37,8 },
	{135,151,152 ,180,208,209 ,8,37,38 }, {135,152,136 ,180,209,182 ,8,38,10 },
	{136,152,153 ,182,209,210 ,10,38,39 }, {136,153,137 ,182,210,184 ,10,39,12 },
	{137,153,154 ,184,210,211 ,12,39,40 }, {137,154,138 ,184,211,186 ,12,40,14 },
	{138,154,155 ,186,211,212 ,14,40,41 }, {138,155,139 ,186,212,188 ,14,41,16 },
	{139,155,156 ,188,212,213 ,16,41,42 }, {139,156,140 ,188,213,190 ,16,42,18 },
	{140,156,157 ,190,213,214 ,18,42,43 }, {140,157,141 ,190,214,192 ,18,43,20 },
	{141,157,158 ,192,214,215 ,20,43,44 }, {141,158,142 ,192,215,194 ,20,44,22 },
	{142,158,159 ,194,215,216 ,22,44,45 }, {142,159,143 ,194,216,196 ,22,45,24 },
	{143,159,160 ,196,216,217 ,24,45,46 }, {143,160,144 ,196,217,198 ,24,46,26 },
	{144,160,161 ,198,217,218 ,26,46,47 }, {144,161,145 ,198,218,200 ,26,47,28 },
	{145,161,162 ,200,218,219 ,28,47,48 }, {145,162,146 ,200,219,202 ,28,48,30 },
	{146,162,147 ,202,219,220 ,30,48,49 }, {146,147,131 ,202,221,221 ,30,49,32 },
	{147,163,164 ,204,222,223 ,33,50,51 }, {147,164,148 ,204,223,205 ,33,51,34 },
	{148,164,165 ,205,223,224 ,34,51,52 }, {148,165,149 ,205,224,206 ,34,52,35 },
	{149,165,166 ,206,224,225 ,35,52,53 }, {149,166,150 ,206,225,207 ,35,53,36 },
	{150,166,167 ,207,225,226 ,36,53,54 }, {150,167,151 ,207,226,208 ,36,54,37 },
	{151,167,168 ,208,226,227 ,37,54,55 }, {151,168,152 ,208,227,209 ,37,55,38 },
	{152,168,169 ,209,227,228 ,38,55,56 }, {152,169,153 ,209,228,210 ,38,56,39 },
	{153,169,170 ,210,228,229 ,39,56,57 }, {153,170,154 ,210,229,211 ,39,57,40 },
	{154,170,171 ,211,229,230 ,40,57,58 }, {154,171,155 ,211,230,212 ,40,58,41 },
	{155,171,172 ,212,230,231 ,41,58,59 }, {155,172,156 ,212,231,213 ,41,59,42 },
	{156,172,173 ,213,231,232 ,42,59,60 }, {156,173,157 ,213,232,214 ,42,60,43 },
	{157,173,174 ,214,232,233 ,43,60,61 }, {157,174,158 ,214,233,215 ,43,61,44 },
	{158,174,175 ,215,233,234 ,44,61,62 }, {158,175,159 ,215,234,216 ,44,62,45 },
	{159,175,176 ,216,234,235 ,45,62,63 }, {159,176,160 ,216,235,217 ,45,63,46 },
	{160,176,177 ,217,235,236 ,46,63,64 }, {160,177,161 ,217,236,218 ,46,64,47 },
	{161,177,178 ,218,236,237 ,47,64,65 }, {161,178,162 ,218,237,219 ,47,65,48 },
	{162,178,163 ,219,237,238 ,48,65,66 }, {162,163,147 ,219,239,239 ,48,66,49 },
	{163,179,180 ,222,240,241 ,50,67,68 }, {163,180,164 ,222,241,223 ,50,68,51 },
	{164,180,181 ,223,241,242 ,51,68,69 }, {164,181,165 ,223,242,224 ,51,69,52 },
	{165,181,182 ,224,242,243 ,52,69,70 }, {165,182,166 ,224,243,225 ,52,70,53 },
	{166,182,183 ,225,243,244 ,53,70,71 }, {166,183,167 ,225,244,226 ,53,71,54 },
	{167,183,184 ,226,244,245 ,54,71,72 }, {167,184,168 ,226,245,227 ,54,72,55 },
	{168,184,185 ,227,245,246 ,55,72,73 }, {168,185,169 ,227,246,228 ,55,73,56 },
	{169,185,186 ,228,246,247 ,56,73,74 }, {169,186,170 ,228,247,229 ,56,74,57 },
	{170,186,187 ,229,247,248 ,57,74,75 }, {170,187,171 ,229,248,230 ,57,75,58 },
	{171,187,188 ,230,248,249 ,58,75,76 }, {171,188,172 ,230,249,231 ,58,76,59 },
	{172,188,189 ,231,249,250 ,59,76,77 }, {172,189,173 ,231,250,232 ,59,77,60 },
	{173,189,190 ,232,250,251 ,60,77,78 }, {173,190,174 ,232,251,233 ,60,78,61 },
	{174,190,191 ,233,251,252 ,61,78,79 }, {174,191,175 ,233,252,234 ,61,79,62 },
	{175,191,192 ,234,252,253 ,62,79,80 }, {175,192,176 ,234,253,235 ,62,80,63 },
	{176,192,193 ,235,253,254 ,63,80,81 }, {176,193,177 ,235,254,236 ,63,81,64 },
	{177,193,194 ,236,254,255 ,64,81,82 }, {177,194,178 ,236,255,237 ,64,82,65 },
	{178,194,179 ,237,255,256 ,65,82,83 }, {178,179,163 ,237,257,257 ,65,83,66 },
	{196,195,197 ,258,259,260 ,1,0,2 }, {197,195,198 ,260,261,262 ,2,3,4 },
	{198,195,199 ,262,263,264 ,4,5,6 }, {199,195,200 ,264,265,266 ,6,7,8 },
	{200,195,201 ,266,267,268 ,8,9,10 }, {201,195,202 ,268,269,270 ,10,11,12 },
	{202,195,203 ,270,271,272 ,12,13,14 }, {203,195,204 ,272,273,274 ,14,15,16 },
	{204,195,205 ,274,275,276 ,16,17,18 }, {205,195,206 ,276,277,278 ,18,19,20 },
	{206,195,207 ,278,279,280 ,20,21,22 }, {207,195,208 ,280,281,282 ,22,23,24 },
	{208,195,209 ,282,283,284 ,24,25,26 }, {209,195,210 ,284,285,286 ,26,27,28 },
	{210,195,211 ,286,287,288 ,28,29,30 }, {211,195,196 ,288,289,289 ,30,31,32 },
	{212,196,213 ,290,258,291 ,33,1,34 }, {213,196,197 ,291,258,260 ,34,1,2 },
	{213,197,214 ,291,260,292 ,34,2,35 }, {214,197,198 ,292,260,262 ,35,2,4 },
	{214,198,215 ,292,262,293 ,35,4,36 }, {215,198,199 ,293,262,264 ,36,4,6 },
	{215,199,216 ,293,264,294 ,36,6,37 }, {216,199,200 ,294,264,266 ,37,6,8 },
	{216,200,217 ,294,266,295 ,37,8,38 }, {217,200,201 ,295,266,268 ,38,8,10 },
	{217,201,218 ,295,268,296 ,38,10,39 }, {218,201,202 ,296,268,270 ,39,10,12 },
	{218,202,219 ,296,270,297 ,39,12,40 }, {219,202,203 ,297,270,272 ,40,12,14 },
	{219,203,220 ,297,272,298 ,40,14,41 }, {220,203,204 ,298,272,274 ,41,14,16 },
	{220,204,221 ,298,274,299 ,41,16,42 }, {221,204,205 ,299,274,276 ,42,16,18 },
	{221,205,222 ,299,276,300 ,42,18,43 }, {222,205,206 ,300,276,278 ,43,18,20 },
	{222,206,223 ,300,278,301 ,43,20,44 }, {223,206,207 ,301,278,280 ,44,20,22 },
	{223,207,224 ,301,280,302 ,44,22,45 }, {224,207,208 ,302,280,282 ,45,22,24 },
	{224,208,225 ,302,282,303 ,45,24,46 }, {225,208,209 ,303,282,284 ,46,24,26 },
	{225,209,226 ,303,284,304 ,46,26,47 }, {226,209,210 ,304,284,286 ,47,26,28 },
	{226,210,227 ,304,286,305 ,47,28,48 }, {227,210,211 ,305,286,288 ,48,28,30 },
	{227,211,212 ,305,288,306 ,48,30,49 }, {212,211,196 ,307,288,307 ,49,30,32 },
	{228,212,229 ,308,290,309 ,50,33,51 }, {229,212,213 ,309,290,291 ,51,33,34 },
	{229,213,230 ,309,291,310 ,51,34,52 }, {230,213,214 ,310,291,292 ,52,34,35 },
	{230,214,231 ,310,292,311 ,52,35,53 }, {231,214,215 ,311,292,293 ,53,35,36 },
	{231,215,232 ,311,293,312 ,53,36,54 }, {232,215,216 ,312,293,294 ,54,36,37 },
	{232,216,233 ,312,294,313 ,54,37,55 }, {233,216,217 ,313,294,295 ,55,37,38 },
	{233,217,234 ,313,295,314 ,55,38,56 }, {234,217,218 ,314,295,296 ,56,38,39 },
	{234,218,235 ,314,296,315 ,56,39,57 }, {235,218,219 ,315,296,297 ,57,39,40 },
	{235,219,236 ,315,297,316 ,57,40,58 }, {236,219,220 ,316,297,298 ,58,40,41 },
	{236,220,237 ,316,298,317 ,58,41,59 }, {237,220,221 ,317,298,299 ,59,41,42 },
	{237,221,238 ,317,299,318 ,59,42,60 }, {238,221,222 ,318,299,300 ,60,42,43 },
	{238,222,239 ,318,300,319 ,60,43,61 }, {239,222,223 ,319,300,301 ,61,43,44 },
	{239,223,240 ,319,301,320 ,61,44,62 }, {240,223,224 ,320,301,302 ,62,44,45 },
	{240,224,241 ,320,302,321 ,62,45,63 }, {241,224,225 ,321,302,303 ,63,45,46 },
	{241,225,242 ,321,303,322 ,63,46,64 }, {242,225,226 ,322,303,304 ,64,46,47 },
	{242,226,243 ,322,304,323 ,64,47,65 }, {243,226,227 ,323,304,305 ,65,47,48 },
	{243,227,228 ,323,305,324 ,65,48,66 }, {228,227,212 ,325,305,325 ,66,48,49 },
	{244,228,245 ,326,308,327 ,67,50,68 }, {245,228,229 ,327,308,309 ,68,50,51 },
	{245,229,246 ,327,309,328 ,68,51,69 }, {246,229,230 ,328,309,310 ,69,51,52 },
	{246,230,247 ,328,310,329 ,69,52,70 }, {247,230,231 ,329,310,311 ,70,52,53 },
	{247,231,248 ,329,311,330 ,70,53,71 }, {248,231,232 ,330,311,312 ,71,53,54 },
	{248,232,249 ,330,312,331 ,71,54,72 }, {249,232,233 ,331,312,313 ,72,54,55 },
	{249,233,250 ,331,313,332 ,72,55,73 }, {250,233,234 ,332,313,314 ,73,55,56 },
	{250,234,251 ,332,314,333 ,73,56,74 }, {251,234,235 ,333,314,315 ,74,56,57 },
	{251,235,252 ,333,315,334 ,74,57,75 }, {252,235,236 ,334,315,316 ,75,57,58 },
	{252,236,253 ,334,316,335 ,75,58,76 }, {253,236,237 ,335,316,317 ,76,58,59 },
	{253,237,254 ,335,317,336 ,76,59,77 }, {254,237,238 ,336,317,318 ,77,59,60 },
	{254,238,255 ,336,318,337 ,77,60,78 }, {255,238,239 ,337,318,319 ,78,60,61 },
	{255,239,256 ,337,319,338 ,78,61,79 }, {256,239,240 ,338,319,320 ,79,61,62 },
	{256,240,257 ,338,320,339 ,79,62,80 }, {257,240,241 ,339,320,321 ,80,62,63 },
	{257,241,258 ,339,321,340 ,80,63,81 }, {258,241,242 ,340,321,322 ,81,63,64 },
	{258,242,259 ,340,322,341 ,81,64,82 }, {259,242,243 ,341,322,323 ,82,64,65 },
	{259,243,244 ,341,323,342 ,82,65,83 }, {244,243,228 ,343,323,343 ,83,65,66 }
},

//lid 4
{
// Object #-1
	{0,1,2 ,0,1,2 ,0,1,2 }, {0,2,3 ,3,2,4 ,3,2,4 }, {0,3,4 ,5,4,6 ,5,4,6 },
	{0,4,5 ,7,6,8 ,7,6,8 }, {0,5,6 ,9,8,10 ,9,8,10 }, {0,6,7 ,11,10,12 ,11,10,12 },
	{0,7,8 ,13,12,14 ,13,12,14 }, {0,8,9 ,15,14,16 ,15,14,16 }, {0,9,10 ,17,16,18 ,17,16,18 },
	{0,10,11 ,19,18,20 ,19,18,20 }, {0,11,12 ,21,20,22 ,21,20,22 },
	{0,12,13 ,23,22,24 ,23,22,24 }, {0,13,14 ,25,24,26 ,25,24,26 },
	{0,14,15 ,27,26,28 ,27,26,28 }, {0,15,16 ,29,28,30 ,29,28,30 },
	{0,16,1 ,31,30,31 ,31,30,32 }, {1,17,18 ,1,32,33 ,1,33,34 },
	{1,18,2 ,1,33,2 ,1,34,2 }, {2,18,19 ,2,33,34 ,2,34,35 }, {2,19,3 ,2,34,4 ,2,35,4 },
	{3,19,20 ,4,34,35 ,4,35,36 }, {3,20,4 ,4,35,6 ,4,36,6 }, {4,20,21 ,6,35,36 ,6,36,37 },
	{4,21,5 ,6,36,8 ,6,37,8 }, {5,21,22 ,8,36,37 ,8,37,38 }, {5,22,6 ,8,37,10 ,8,38,10 },
	{6,22,23 ,10,37,38 ,10,38,39 }, {6,23,7 ,10,38,12 ,10,39,12 },
	{7,23,24 ,12,38,39 ,12,39,40 }, {7,24,8 ,12,39,14 ,12,40,14 },
	{8,24,25 ,14,39,40 ,14,40,41 }, {8,25,9 ,14,40,16 ,14,41,16 },
	{9,25,26 ,16,40,41 ,16,41,42 }, {9,26,10 ,16,41,18 ,16,42,18 },
	{10,26,27 ,18,41,42 ,18,42,43 }, {10,27,11 ,18,42,20 ,18,43,20 },
	{11,27,28 ,20,42,43 ,20,43,44 }, {11,28,12 ,20,43,22 ,20,44,22 },
	{12,28,29 ,22,43,44 ,22,44,45 }, {12,29,13 ,22,44,24 ,22,45,24 },
	{13,29,30 ,24,44,45 ,24,45,46 }, {13,30,14 ,24,45,26 ,24,46,26 },
	{14,30,31 ,26,45,46 ,26,46,47 }, {14,31,15 ,26,46,28 ,26,47,28 },
	{15,31,32 ,28,46,47 ,28,47,48 }, {15,32,16 ,28,47,30 ,28,48,30 },
	{16,32,17 ,30,47,48 ,30,48,49 }, {16,17,1 ,30,49,49 ,30,49,32 },
	{17,33,34 ,32,50,51 ,33,50,51 }, {17,34,18 ,32,51,33 ,33,51,34 },
	{18,34,35 ,33,51,52 ,34,51,52 }, {18,35,19 ,33,52,34 ,34,52,35 },
	{19,35,36 ,34,52,53 ,35,52,53 }, {19,36,20 ,34,53,35 ,35,53,36 },
	{20,36,37 ,35,53,54 ,36,53,54 }, {20,37,21 ,35,54,36 ,36,54,37 },
	{21,37,38 ,36,54,55 ,37,54,55 }, {21,38,22 ,36,55,37 ,37,55,38 },
	{22,38,39 ,37,55,56 ,38,55,56 }, {22,39,23 ,37,56,38 ,38,56,39 },
	{23,39,40 ,38,56,57 ,39,56,57 }, {23,40,24 ,38,57,39 ,39,57,40 },
	{24,40,41 ,39,57,58 ,40,57,58 }, {24,41,25 ,39,58,40 ,40,58,41 },
	{25,41,42 ,40,58,59 ,41,58,59 }, {25,42,26 ,40,59,41 ,41,59,42 },
	{26,42,43 ,41,59,60 ,42,59,60 }, {26,43,27 ,41,60,42 ,42,60,43 },
	{27,43,44 ,42,60,61 ,43,60,61 }, {27,44,28 ,42,61,43 ,43,61,44 },
	{28,44,45 ,43,61,62 ,44,61,62 }, {28,45,29 ,43,62,44 ,44,62,45 },
	{29,45,46 ,44,62,63 ,45,62,63 }, {29,46,30 ,44,63,45 ,45,63,46 },
	{30,46,47 ,45,63,64 ,46,63,64 }, {30,47,31 ,45,64,46 ,46,64,47 },
	{31,47,48 ,46,64,65 ,47,64,65 }, {31,48,32 ,46,65,47 ,47,65,48 },
	{32,48,33 ,47,65,66 ,48,65,66 }, {32,33,17 ,47,67,67 ,48,66,49 },
	{33,49,50 ,50,68,69 ,50,67,68 }, {33,50,34 ,50,69,51 ,50,68,51 },
	{34,50,51 ,51,69,70 ,51,68,69 }, {34,51,35 ,51,70,52 ,51,69,52 },
	{35,51,52 ,52,70,71 ,52,69,70 }, {35,52,36 ,52,71,53 ,52,70,53 },
	{36,52,53 ,53,71,72 ,53,70,71 }, {36,53,37 ,53,72,54 ,53,71,54 },
	{37,53,54 ,54,72,73 ,54,71,72 }, {37,54,38 ,54,73,55 ,54,72,55 },
	{38,54,55 ,55,73,74 ,55,72,73 }, {38,55,39 ,55,74,56 ,55,73,56 },
	{39,55,56 ,56,74,75 ,56,73,74 }, {39,56,40 ,56,75,57 ,56,74,57 },
	{40,56,57 ,57,75,76 ,57,74,75 }, {40,57,41 ,57,76,58 ,57,75,58 },
	{41,57,58 ,58,76,77 ,58,75,76 }, {41,58,42 ,58,77,59 ,58,76,59 },
	{42,58,59 ,59,77,78 ,59,76,77 }, {42,59,43 ,59,78,60 ,59,77,60 },
	{43,59,60 ,60,78,79 ,60,77,78 }, {43,60,44 ,60,79,61 ,60,78,61 },
	{44,60,61 ,61,79,80 ,61,78,79 }, {44,61,45 ,61,80,62 ,61,79,62 },
	{45,61,62 ,62,80,81 ,62,79,80 }, {45,62,46 ,62,81,63 ,62,80,63 },
	{46,62,63 ,63,81,82 ,63,80,81 }, {46,63,47 ,63,82,64 ,63,81,64 },
	{47,63,64 ,64,82,83 ,64,81,82 }, {47,64,48 ,64,83,65 ,64,82,65 },
	{48,64,49 ,65,83,84 ,65,82,83 }, {48,49,33 ,65,85,85 ,65,83,66 },
	{66,65,67 ,86,87,88 ,1,0,2 }, {67,65,68 ,88,89,90 ,2,3,4 }, {68,65,69 ,90,91,92 ,4,5,6 },
	{69,65,70 ,92,93,94 ,6,7,8 }, {70,65,71 ,94,95,96 ,8,9,10 },
	{71,65,72 ,96,97,98 ,10,11,12 }, {72,65,73 ,98,99,100 ,12,13,14 },
	{73,65,74 ,100,101,102 ,14,15,16 }, {74,65,75 ,102,103,104 ,16,17,18 },
	{75,65,76 ,104,105,106 ,18,19,20 }, {76,65,77 ,106,107,108 ,20,21,22 },
	{77,65,78 ,108,109,110 ,22,23,24 }, {78,65,79 ,110,111,112 ,24,25,26 },
	{79,65,80 ,112,113,114 ,26,27,28 }, {80,65,81 ,114,115,116 ,28,29,30 },
	{81,65,66 ,116,117,117 ,30,31,32 }, {82,66,83 ,118,86,119 ,33,1,34 },
	{83,66,67 ,119,86,88 ,34,1,2 }, {83,67,84 ,119,88,120 ,34,2,35 },
	{84,67,68 ,120,88,90 ,35,2,4 }, {84,68,85 ,120,90,121 ,35,4,36 },
	{85,68,69 ,121,90,92 ,36,4,6 }, {85,69,86 ,121,92,122 ,36,6,37 },
	{86,69,70 ,122,92,94 ,37,6,8 }, {86,70,87 ,122,94,123 ,37,8,38 },
	{87,70,71 ,123,94,96 ,38,8,10 }, {87,71,88 ,123,96,124 ,38,10,39 },
	{88,71,72 ,124,96,98 ,39,10,12 }, {88,72,89 ,124,98,125 ,39,12,40 },
	{89,72,73 ,125,98,100 ,40,12,14 }, {89,73,90 ,125,100,126 ,40,14,41 },
	{90,73,74 ,126,100,102 ,41,14,16 }, {90,74,91 ,126,102,127 ,41,16,42 },
	{91,74,75 ,127,102,104 ,42,16,18 }, {91,75,92 ,127,104,128 ,42,18,43 },
	{92,75,76 ,128,104,106 ,43,18,20 }, {92,76,93 ,128,106,129 ,43,20,44 },
	{93,76,77 ,129,106,108 ,44,20,22 }, {93,77,94 ,129,108,130 ,44,22,45 },
	{94,77,78 ,130,108,110 ,45,22,24 }, {94,78,95 ,130,110,131 ,45,24,46 },
	{95,78,79 ,131,110,112 ,46,24,26 }, {95,79,96 ,131,112,132 ,46,26,47 },
	{96,79,80 ,132,112,114 ,47,26,28 }, {96,80,97 ,132,114,133 ,47,28,48 },
	{97,80,81 ,133,114,116 ,48,28,30 }, {97,81,82 ,133,116,134 ,48,30,49 },
	{82,81,66 ,135,116,135 ,49,30,32 }, {98,82,99 ,136,118,137 ,50,33,51 },
	{99,82,83 ,137,118,119 ,51,33,34 }, {99,83,100 ,137,119,138 ,51,34,52 },
	{100,83,84 ,138,119,120 ,52,34,35 }, {100,84,101 ,138,120,139 ,52,35,53 },
	{101,84,85 ,139,120,121 ,53,35,36 }, {101,85,102 ,139,121,140 ,53,36,54 },
	{102,85,86 ,140,121,122 ,54,36,37 }, {102,86,103 ,140,122,141 ,54,37,55 },
	{103,86,87 ,141,122,123 ,55,37,38 }, {103,87,104 ,141,123,142 ,55,38,56 },
	{104,87,88 ,142,123,124 ,56,38,39 }, {104,88,105 ,142,124,143 ,56,39,57 },
	{105,88,89 ,143,124,125 ,57,39,40 }, {105,89,106 ,143,125,144 ,57,40,58 },
	{106,89,90 ,144,125,126 ,58,40,41 }, {106,90,107 ,144,126,145 ,58,41,59 },
	{107,90,91 ,145,126,127 ,59,41,42 }, {107,91,108 ,145,127,146 ,59,42,60 },
	{108,91,92 ,146,127,128 ,60,42,43 }, {108,92,109 ,146,128,147 ,60,43,61 },
	{109,92,93 ,147,128,129 ,61,43,44 }, {109,93,110 ,147,129,148 ,61,44,62 },
	{110,93,94 ,148,129,130 ,62,44,45 }, {110,94,111 ,148,130,149 ,62,45,63 },
	{111,94,95 ,149,130,131 ,63,45,46 }, {111,95,112 ,149,131,150 ,63,46,64 },
	{112,95,96 ,150,131,132 ,64,46,47 }, {112,96,113 ,150,132,151 ,64,47,65 },
	{113,96,97 ,151,132,133 ,65,47,48 }, {113,97,98 ,151,133,152 ,65,48,66 },
	{98,97,82 ,153,133,153 ,66,48,49 }, {114,98,115 ,154,136,155 ,67,50,68 },
	{115,98,99 ,155,136,137 ,68,50,51 }, {115,99,116 ,155,137,156 ,68,51,69 },
	{116,99,100 ,156,137,138 ,69,51,52 }, {116,100,117 ,156,138,157 ,69,52,70 },
	{117,100,101 ,157,138,139 ,70,52,53 }, {117,101,118 ,157,139,158 ,70,53,71 },
	{118,101,102 ,158,139,140 ,71,53,54 }, {118,102,119 ,158,140,159 ,71,54,72 },
	{119,102,103 ,159,140,141 ,72,54,55 }, {119,103,120 ,159,141,160 ,72,55,73 },
	{120,103,104 ,160,141,142 ,73,55,56 }, {120,104,121 ,160,142,161 ,73,56,74 },
	{121,104,105 ,161,142,143 ,74,56,57 }, {121,105,122 ,161,143,162 ,74,57,75 },
	{122,105,106 ,162,143,144 ,75,57,58 }, {122,106,123 ,162,144,163 ,75,58,76 },
	{123,106,107 ,163,144,145 ,76,58,59 }, {123,107,124 ,163,145,164 ,76,59,77 },
	{124,107,108 ,164,145,146 ,77,59,60 }, {124,108,125 ,164,146,165 ,77,60,78 },
	{125,108,109 ,165,146,147 ,78,60,61 }, {125,109,126 ,165,147,166 ,78,61,79 },
	{126,109,110 ,166,147,148 ,79,61,62 }, {126,110,127 ,166,148,167 ,79,62,80 },
	{127,110,111 ,167,148,149 ,80,62,63 }, {127,111,128 ,167,149,168 ,80,63,81 },
	{128,111,112 ,168,149,150 ,81,63,64 }, {128,112,129 ,168,150,169 ,81,64,82 },
	{129,112,113 ,169,150,151 ,82,64,65 }, {129,113,114 ,169,151,170 ,82,65,83 },
	{114,113,98 ,171,151,171 ,83,65,66 }
// Object #-1
	, {130,131,132 ,172,173,174 ,0,1,2 }, {130,132,133 ,175,174,176 ,3,2,4 },
	{130,133,134 ,177,176,178 ,5,4,6 }, {130,134,135 ,179,178,180 ,7,6,8 },
	{130,135,136 ,181,180,182 ,9,8,10 }, {130,136,137 ,183,182,184 ,11,10,12 },
	{130,137,138 ,185,184,186 ,13,12,14 }, {130,138,139 ,187,186,188 ,15,14,16 },
	{130,139,140 ,189,188,190 ,17,16,18 }, {130,140,141 ,191,190,192 ,19,18,20 },
	{130,141,142 ,193,192,194 ,21,20,22 }, {130,142,143 ,195,194,196 ,23,22,24 },
	{130,143,144 ,197,196,198 ,25,24,26 }, {130,144,145 ,199,198,200 ,27,26,28 },
	{130,145,146 ,201,200,202 ,29,28,30 }, {130,146,131 ,203,202,203 ,31,30,32 },
	{131,147,148 ,173,204,205 ,1,33,34 }, {131,148,132 ,173,205,174 ,1,34,2 },
	{132,148,149 ,174,205,206 ,2,34,35 }, {132,149,133 ,174,206,176 ,2,35,4 },
	{133,149,150 ,176,206,207 ,4,35,36 }, {133,150,134 ,176,207,178 ,4,36,6 },
	{134,150,151 ,178,207,208 ,6,36,37 }, {134,151,135 ,178,208,180 ,6,37,8 },
	{135,151,152 ,180,208,209 ,8,37,38 }, {135,152,136 ,180,209,182 ,8,38,10 },
	{136,152,153 ,182,209,210 ,10,38,39 }, {136,153,137 ,182,210,184 ,10,39,12 },
	{137,153,154 ,184,210,211 ,12,39,40 }, {137,154,138 ,184,211,186 ,12,40,14 },
	{138,154,155 ,186,211,212 ,14,40,41 }, {138,155,139 ,186,212,188 ,14,41,16 },
	{139,155,156 ,188,212,213 ,16,41,42 }, {139,156,140 ,188,213,190 ,16,42,18 },
	{140,156,157 ,190,213,214 ,18,42,43 }, {140,157,141 ,190,214,192 ,18,43,20 },
	{141,157,158 ,192,214,215 ,20,43,44 }, {141,158,142 ,192,215,194 ,20,44,22 },
	{142,158,159 ,194,215,216 ,22,44,45 }, {142,159,143 ,194,216,196 ,22,45,24 },
	{143,159,160 ,196,216,217 ,24,45,46 }, {143,160,144 ,196,217,198 ,24,46,26 },
	{144,160,161 ,198,217,218 ,26,46,47 }, {144,161,145 ,198,218,200 ,26,47,28 },
	{145,161,162 ,200,218,219 ,28,47,48 }, {145,162,146 ,200,219,202 ,28,48,30 },
	{146,162,147 ,202,219,220 ,30,48,49 }, {146,147,131 ,202,221,221 ,30,49,32 },
	{147,163,164 ,204,222,223 ,33,50,51 }, {147,164,148 ,204,223,205 ,33,51,34 },
	{148,164,165 ,205,223,224 ,34,51,52 }, {148,165,149 ,205,224,206 ,34,52,35 },
	{149,165,166 ,206,224,225 ,35,52,53 }, {149,166,150 ,206,225,207 ,35,53,36 },
	{150,166,167 ,207,225,226 ,36,53,54 }, {150,167,151 ,207,226,208 ,36,54,37 },
	{151,167,168 ,208,226,227 ,37,54,55 }, {151,168,152 ,208,227,209 ,37,55,38 },
	{152,168,169 ,209,227,228 ,38,55,56 }, {152,169,153 ,209,228,210 ,38,56,39 },
	{153,169,170 ,210,228,229 ,39,56,57 }, {153,170,154 ,210,229,211 ,39,57,40 },
	{154,170,171 ,211,229,230 ,40,57,58 }, {154,171,155 ,211,230,212 ,40,58,41 },
	{155,171,172 ,212,230,231 ,41,58,59 }, {155,172,156 ,212,231,213 ,41,59,42 },
	{156,172,173 ,213,231,232 ,42,59,60 }, {156,173,157 ,213,232,214 ,42,60,43 },
	{157,173,174 ,214,232,233 ,43,60,61 }, {157,174,158 ,214,233,215 ,43,61,44 },
	{158,174,175 ,215,233,234 ,44,61,62 }, {158,175,159 ,215,234,216 ,44,62,45 },
	{159,175,176 ,216,234,235 ,45,62,63 }, {159,176,160 ,216,235,217 ,45,63,46 },
	{160,176,177 ,217,235,236 ,46,63,64 }, {160,177,161 ,217,236,218 ,46,64,47 },
	{161,177,178 ,218,236,237 ,47,64,65 }, {161,178,162 ,218,237,219 ,47,65,48 },
	{162,178,163 ,219,237,238 ,48,65,66 }, {162,163,147 ,219,239,239 ,48,66,49 },
	{163,179,180 ,222,240,241 ,50,67,68 }, {163,180,164 ,222,241,223 ,50,68,51 },
	{164,180,181 ,223,241,242 ,51,68,69 }, {164,181,165 ,223,242,224 ,51,69,52 },
	{165,181,182 ,224,242,243 ,52,69,70 }, {165,182,166 ,224,243,225 ,52,70,53 },
	{166,182,183 ,225,243,244 ,53,70,71 }, {166,183,167 ,225,244,226 ,53,71,54 },
	{167,183,184 ,226,244,245 ,54,71,72 }, {167,184,168 ,226,245,227 ,54,72,55 },
	{168,184,185 ,227,245,246 ,55,72,73 }, {168,185,169 ,227,246,228 ,55,73,56 },
	{169,185,186 ,228,246,247 ,56,73,74 }, {169,186,170 ,228,247,229 ,56,74,57 },
	{170,186,187 ,229,247,248 ,57,74,75 }, {170,187,171 ,229,248,230 ,57,75,58 },
	{171,187,188 ,230,248,249 ,58,75,76 }, {171,188,172 ,230,249,231 ,58,76,59 },
	{172,188,189 ,231,249,250 ,59,76,77 }, {172,189,173 ,231,250,232 ,59,77,60 },
	{173,189,190 ,232,250,251 ,60,77,78 }, {173,190,174 ,232,251,233 ,60,78,61 },
	{174,190,191 ,233,251,252 ,61,78,79 }, {174,191,175 ,233,252,234 ,61,79,62 },
	{175,191,192 ,234,252,253 ,62,79,80 }, {175,192,176 ,234,253,235 ,62,80,63 },
	{176,192,193 ,235,253,254 ,63,80,81 }, {176,193,177 ,235,254,236 ,63,81,64 },
	{177,193,194 ,236,254,255 ,64,81,82 }, {177,194,178 ,236,255,237 ,64,82,65 },
	{178,194,179 ,237,255,256 ,65,82,83 }, {178,179,163 ,237,257,257 ,65,83,66 },
	{196,195,197 ,258,259,260 ,1,0,2 }, {197,195,198 ,260,261,262 ,2,3,4 },
	{198,195,199 ,262,263,264 ,4,5,6 }, {199,195,200 ,264,265,266 ,6,7,8 },
	{200,195,201 ,266,267,268 ,8,9,10 }, {201,195,202 ,268,269,270 ,10,11,12 },
	{202,195,203 ,270,271,272 ,12,13,14 }, {203,195,204 ,272,273,274 ,14,15,16 },
	{204,195,205 ,274,275,276 ,16,17,18 }, {205,195,206 ,276,277,278 ,18,19,20 },
	{206,195,207 ,278,279,280 ,20,21,22 }, {207,195,208 ,280,281,282 ,22,23,24 },
	{208,195,209 ,282,283,284 ,24,25,26 }, {209,195,210 ,284,285,286 ,26,27,28 },
	{210,195,211 ,286,287,288 ,28,29,30 }, {211,195,196 ,288,289,289 ,30,31,32 },
	{212,196,213 ,290,258,291 ,33,1,34 }, {213,196,197 ,291,258,260 ,34,1,2 },
	{213,197,214 ,291,260,292 ,34,2,35 }, {214,197,198 ,292,260,262 ,35,2,4 },
	{214,198,215 ,292,262,293 ,35,4,36 }, {215,198,199 ,293,262,264 ,36,4,6 },
	{215,199,216 ,293,264,294 ,36,6,37 }, {216,199,200 ,294,264,266 ,37,6,8 },
	{216,200,217 ,294,266,295 ,37,8,38 }, {217,200,201 ,295,266,268 ,38,8,10 },
	{217,201,218 ,295,268,296 ,38,10,39 }, {218,201,202 ,296,268,270 ,39,10,12 },
	{218,202,219 ,296,270,297 ,39,12,40 }, {219,202,203 ,297,270,272 ,40,12,14 },
	{219,203,220 ,297,272,298 ,40,14,41 }, {220,203,204 ,298,272,274 ,41,14,16 },
	{220,204,221 ,298,274,299 ,41,16,42 }, {221,204,205 ,299,274,276 ,42,16,18 },
	{221,205,222 ,299,276,300 ,42,18,43 }, {222,205,206 ,300,276,278 ,43,18,20 },
	{222,206,223 ,300,278,301 ,43,20,44 }, {223,206,207 ,301,278,280 ,44,20,22 },
	{223,207,224 ,301,280,302 ,44,22,45 }, {224,207,208 ,302,280,282 ,45,22,24 },
	{224,208,225 ,302,282,303 ,45,24,46 }, {225,208,209 ,303,282,284 ,46,24,26 },
	{225,209,226 ,303,284,304 ,46,26,47 }, {226,209,210 ,304,284,286 ,47,26,28 },
	{226,210,227 ,304,286,305 ,47,28,48 }, {227,210,211 ,305,286,288 ,48,28,30 },
	{227,211,212 ,305,288,306 ,48,30,49 }, {212,211,196 ,307,288,307 ,49,30,32 },
	{228,212,229 ,308,290,309 ,50,33,51 }, {229,212,213 ,309,290,291 ,51,33,34 },
	{229,213,230 ,309,291,310 ,51,34,52 }, {230,213,214 ,310,291,292 ,52,34,35 },
	{230,214,231 ,310,292,311 ,52,35,53 }, {231,214,215 ,311,292,293 ,53,35,36 },
	{231,215,232 ,311,293,312 ,53,36,54 }, {232,215,216 ,312,293,294 ,54,36,37 },
	{232,216,233 ,312,294,313 ,54,37,55 }, {233,216,217 ,313,294,295 ,55,37,38 },
	{233,217,234 ,313,295,314 ,55,38,56 }, {234,217,218 ,314,295,296 ,56,38,39 },
	{234,218,235 ,314,296,315 ,56,39,57 }, {235,218,219 ,315,296,297 ,57,39,40 },
	{235,219,236 ,315,297,316 ,57,40,58 }, {236,219,220 ,316,297,298 ,58,40,41 },
	{236,220,237 ,316,298,317 ,58,41,59 }, {237,220,221 ,317,298,299 ,59,41,42 },
	{237,221,238 ,317,299,318 ,59,42,60 }, {238,221,222 ,318,299,300 ,60,42,43 },
	{238,222,239 ,318,300,319 ,60,43,61 }, {239,222,223 ,319,300,301 ,61,43,44 },
	{239,223,240 ,319,301,320 ,61,44,62 }, {240,223,224 ,320,301,302 ,62,44,45 },
	{240,224,241 ,320,302,321 ,62,45,63 }, {241,224,225 ,321,302,303 ,63,45,46 },
	{241,225,242 ,321,303,322 ,63,46,64 }, {242,225,226 ,322,303,304 ,64,46,47 },
	{242,226,243 ,322,304,323 ,64,47,65 }, {243,226,227 ,323,304,305 ,65,47,48 },
	{243,227,228 ,323,305,324 ,65,48,66 }, {228,227,212 ,325,305,325 ,66,48,49 },
	{244,228,245 ,326,308,327 ,67,50,68 }, {245,228,229 ,327,308,309 ,68,50,51 },
	{245,229,246 ,327,309,328 ,68,51,69 }, {246,229,230 ,328,309,310 ,69,51,52 },
	{246,230,247 ,328,310,329 ,69,52,70 }, {247,230,231 ,329,310,311 ,70,52,53 },
	{247,231,248 ,329,311,330 ,70,53,71 }, {248,231,232 ,330,311,312 ,71,53,54 },
	{248,232,249 ,330,312,331 ,71,54,72 }, {249,232,233 ,331,312,313 ,72,54,55 },
	{249,233,250 ,331,313,332 ,72,55,73 }, {250,233,234 ,332,313,314 ,73,55,56 },
	{250,234,251 ,332,314,333 ,73,56,74 }, {251,234,235 ,333,314,315 ,74,56,57 },
	{251,235,252 ,333,315,334 ,74,57,75 }, {252,235,236 ,334,315,316 ,75,57,58 },
	{252,236,253 ,334,316,335 ,75,58,76 }, {253,236,237 ,335,316,317 ,76,58,59 },
	{253,237,254 ,335,317,336 ,76,59,77 }, {254,237,238 ,336,317,318 ,77,59,60 },
	{254,238,255 ,336,318,337 ,77,60,78 }, {255,238,239 ,337,318,319 ,78,60,61 },
	{255,239,256 ,337,319,338 ,78,61,79 }, {256,239,240 ,338,319,320 ,79,61,62 },
	{256,240,257 ,338,320,339 ,79,62,80 }, {257,240,241 ,339,320,321 ,80,62,63 },
	{257,241,258 ,339,321,340 ,80,63,81 }, {258,241,242 ,340,321,322 ,81,63,64 },
	{258,242,259 ,340,322,341 ,81,64,82 }, {259,242,243 ,341,322,323 ,82,64,65 },
	{259,243,244 ,341,323,342 ,82,65,83 }, {244,243,228 ,343,323,343 ,83,65,66 }
},
//lid 3
{
// Object #-1
	{0,1,2 ,0,1,2 ,0,1,2 }, {0,2,3 ,3,2,4 ,3,2,4 }, {0,3,4 ,5,4,6 ,5,4,6 },
	{0,4,5 ,7,6,8 ,7,6,8 }, {0,5,6 ,9,8,10 ,9,8,10 }, {0,6,7 ,11,10,12 ,11,10,12 },
	{0,7,8 ,13,12,14 ,13,12,14 }, {0,8,9 ,15,14,16 ,15,14,16 }, {0,9,10 ,17,16,18 ,17,16,18 },
	{0,10,11 ,19,18,20 ,19,18,20 }, {0,11,12 ,21,20,22 ,21,20,22 },
	{0,12,13 ,23,22,24 ,23,22,24 }, {0,13,14 ,25,24,26 ,25,24,26 },
	{0,14,15 ,27,26,28 ,27,26,28 }, {0,15,16 ,29,28,30 ,29,28,30 },
	{0,16,1 ,31,30,31 ,31,30,32 }, {1,17,18 ,1,32,33 ,1,33,34 },
	{1,18,2 ,1,33,2 ,1,34,2 }, {2,18,19 ,2,33,34 ,2,34,35 }, {2,19,3 ,2,34,4 ,2,35,4 },
	{3,19,20 ,4,34,35 ,4,35,36 }, {3,20,4 ,4,35,6 ,4,36,6 }, {4,20,21 ,6,35,36 ,6,36,37 },
	{4,21,5 ,6,36,8 ,6,37,8 }, {5,21,22 ,8,36,37 ,8,37,38 }, {5,22,6 ,8,37,10 ,8,38,10 },
	{6,22,23 ,10,37,38 ,10,38,39 }, {6,23,7 ,10,38,12 ,10,39,12 },
	{7,23,24 ,12,38,39 ,12,39,40 }, {7,24,8 ,12,39,14 ,12,40,14 },
	{8,24,25 ,14,39,40 ,14,40,41 }, {8,25,9 ,14,40,16 ,14,41,16 },
	{9,25,26 ,16,40,41 ,16,41,42 }, {9,26,10 ,16,41,18 ,16,42,18 },
	{10,26,27 ,18,41,42 ,18,42,43 }, {10,27,11 ,18,42,20 ,18,43,20 },
	{11,27,28 ,20,42,43 ,20,43,44 }, {11,28,12 ,20,43,22 ,20,44,22 },
	{12,28,29 ,22,43,44 ,22,44,45 }, {12,29,13 ,22,44,24 ,22,45,24 },
	{13,29,30 ,24,44,45 ,24,45,46 }, {13,30,14 ,24,45,26 ,24,46,26 },
	{14,30,31 ,26,45,46 ,26,46,47 }, {14,31,15 ,26,46,28 ,26,47,28 },
	{15,31,32 ,28,46,47 ,28,47,48 }, {15,32,16 ,28,47,30 ,28,48,30 },
	{16,32,17 ,30,47,48 ,30,48,49 }, {16,17,1 ,30,49,49 ,30,49,32 },
	{17,33,34 ,32,50,51 ,33,50,51 }, {17,34,18 ,32,51,33 ,33,51,34 },
	{18,34,35 ,33,51,52 ,34,51,52 }, {18,35,19 ,33,52,34 ,34,52,35 },
	{19,35,36 ,34,52,53 ,35,52,53 }, {19,36,20 ,34,53,35 ,35,53,36 },
	{20,36,37 ,35,53,54 ,36,53,54 }, {20,37,21 ,35,54,36 ,36,54,37 },
	{21,37,38 ,36,54,55 ,37,54,55 }, {21,38,22 ,36,55,37 ,37,55,38 },
	{22,38,39 ,37,55,56 ,38,55,56 }, {22,39,23 ,37,56,38 ,38,56,39 },
	{23,39,40 ,38,56,57 ,39,56,57 }, {23,40,24 ,38,57,39 ,39,57,40 },
	{24,40,41 ,39,57,58 ,40,57,58 }, {24,41,25 ,39,58,40 ,40,58,41 },
	{25,41,42 ,40,58,59 ,41,58,59 }, {25,42,26 ,40,59,41 ,41,59,42 },
	{26,42,43 ,41,59,60 ,42,59,60 }, {26,43,27 ,41,60,42 ,42,60,43 },
	{27,43,44 ,42,60,61 ,43,60,61 }, {27,44,28 ,42,61,43 ,43,61,44 },
	{28,44,45 ,43,61,62 ,44,61,62 }, {28,45,29 ,43,62,44 ,44,62,45 },
	{29,45,46 ,44,62,63 ,45,62,63 }, {29,46,30 ,44,63,45 ,45,63,46 },
	{30,46,47 ,45,63,64 ,46,63,64 }, {30,47,31 ,45,64,46 ,46,64,47 },
	{31,47,48 ,46,64,65 ,47,64,65 }, {31,48,32 ,46,65,47 ,47,65,48 },
	{32,48,33 ,47,65,66 ,48,65,66 }, {32,33,17 ,47,67,67 ,48,66,49 },
	{33,49,50 ,50,68,69 ,50,67,68 }, {33,50,34 ,50,69,51 ,50,68,51 },
	{34,50,51 ,51,69,70 ,51,68,69 }, {34,51,35 ,51,70,52 ,51,69,52 },
	{35,51,52 ,52,70,71 ,52,69,70 }, {35,52,36 ,52,71,53 ,52,70,53 },
	{36,52,53 ,53,71,72 ,53,70,71 }, {36,53,37 ,53,72,54 ,53,71,54 },
	{37,53,54 ,54,72,73 ,54,71,72 }, {37,54,38 ,54,73,55 ,54,72,55 },
	{38,54,55 ,55,73,74 ,55,72,73 }, {38,55,39 ,55,74,56 ,55,73,56 },
	{39,55,56 ,56,74,75 ,56,73,74 }, {39,56,40 ,56,75,57 ,56,74,57 },
	{40,56,57 ,57,75,76 ,57,74,75 }, {40,57,41 ,57,76,58 ,57,75,58 },
	{41,57,58 ,58,76,77 ,58,75,76 }, {41,58,42 ,58,77,59 ,58,76,59 },
	{42,58,59 ,59,77,78 ,59,76,77 }, {42,59,43 ,59,78,60 ,59,77,60 },
	{43,59,60 ,60,78,79 ,60,77,78 }, {43,60,44 ,60,79,61 ,60,78,61 },
	{44,60,61 ,61,79,80 ,61,78,79 }, {44,61,45 ,61,80,62 ,61,79,62 },
	{45,61,62 ,62,80,81 ,62,79,80 }, {45,62,46 ,62,81,63 ,62,80,63 },
	{46,62,63 ,63,81,82 ,63,80,81 }, {46,63,47 ,63,82,64 ,63,81,64 },
	{47,63,64 ,64,82,83 ,64,81,82 }, {47,64,48 ,64,83,65 ,64,82,65 },
	{48,64,49 ,65,83,84 ,65,82,83 }, {48,49,33 ,65,85,85 ,65,83,66 },
	{66,65,67 ,86,87,88 ,1,0,2 }, {67,65,68 ,88,89,90 ,2,3,4 }, {68,65,69 ,90,91,92 ,4,5,6 },
	{69,65,70 ,92,93,94 ,6,7,8 }, {70,65,71 ,94,95,96 ,8,9,10 },
	{71,65,72 ,96,97,98 ,10,11,12 }, {72,65,73 ,98,99,100 ,12,13,14 },
	{73,65,74 ,100,101,102 ,14,15,16 }, {74,65,75 ,102,103,104 ,16,17,18 },
	{75,65,76 ,104,105,106 ,18,19,20 }, {76,65,77 ,106,107,108 ,20,21,22 },
	{77,65,78 ,108,109,110 ,22,23,24 }, {78,65,79 ,110,111,112 ,24,25,26 },
	{79,65,80 ,112,113,114 ,26,27,28 }, {80,65,81 ,114,115,116 ,28,29,30 },
	{81,65,66 ,116,117,117 ,30,31,32 }, {82,66,83 ,118,86,119 ,33,1,34 },
	{83,66,67 ,119,86,88 ,34,1,2 }, {83,67,84 ,119,88,120 ,34,2,35 },
	{84,67,68 ,120,88,90 ,35,2,4 }, {84,68,85 ,120,90,121 ,35,4,36 },
	{85,68,69 ,121,90,92 ,36,4,6 }, {85,69,86 ,121,92,122 ,36,6,37 },
	{86,69,70 ,122,92,94 ,37,6,8 }, {86,70,87 ,122,94,123 ,37,8,38 },
	{87,70,71 ,123,94,96 ,38,8,10 }, {87,71,88 ,123,96,124 ,38,10,39 },
	{88,71,72 ,124,96,98 ,39,10,12 }, {88,72,89 ,124,98,125 ,39,12,40 },
	{89,72,73 ,125,98,100 ,40,12,14 }, {89,73,90 ,125,100,126 ,40,14,41 },
	{90,73,74 ,126,100,102 ,41,14,16 }, {90,74,91 ,126,102,127 ,41,16,42 },
	{91,74,75 ,127,102,104 ,42,16,18 }, {91,75,92 ,127,104,128 ,42,18,43 },
	{92,75,76 ,128,104,106 ,43,18,20 }, {92,76,93 ,128,106,129 ,43,20,44 },
	{93,76,77 ,129,106,108 ,44,20,22 }, {93,77,94 ,129,108,130 ,44,22,45 },
	{94,77,78 ,130,108,110 ,45,22,24 }, {94,78,95 ,130,110,131 ,45,24,46 },
	{95,78,79 ,131,110,112 ,46,24,26 }, {95,79,96 ,131,112,132 ,46,26,47 },
	{96,79,80 ,132,112,114 ,47,26,28 }, {96,80,97 ,132,114,133 ,47,28,48 },
	{97,80,81 ,133,114,116 ,48,28,30 }, {97,81,82 ,133,116,134 ,48,30,49 },
	{82,81,66 ,135,116,135 ,49,30,32 }, {98,82,99 ,136,118,137 ,50,33,51 },
	{99,82,83 ,137,118,119 ,51,33,34 }, {99,83,100 ,137,119,138 ,51,34,52 },
	{100,83,84 ,138,119,120 ,52,34,35 }, {100,84,101 ,138,120,139 ,52,35,53 },
	{101,84,85 ,139,120,121 ,53,35,36 }, {101,85,102 ,139,121,140 ,53,36,54 },
	{102,85,86 ,140,121,122 ,54,36,37 }, {102,86,103 ,140,122,141 ,54,37,55 },
	{103,86,87 ,141,122,123 ,55,37,38 }, {103,87,104 ,141,123,142 ,55,38,56 },
	{104,87,88 ,142,123,124 ,56,38,39 }, {104,88,105 ,142,124,143 ,56,39,57 },
	{105,88,89 ,143,124,125 ,57,39,40 }, {105,89,106 ,143,125,144 ,57,40,58 },
	{106,89,90 ,144,125,126 ,58,40,41 }, {106,90,107 ,144,126,145 ,58,41,59 },
	{107,90,91 ,145,126,127 ,59,41,42 }, {107,91,108 ,145,127,146 ,59,42,60 },
	{108,91,92 ,146,127,128 ,60,42,43 }, {108,92,109 ,146,128,147 ,60,43,61 },
	{109,92,93 ,147,128,129 ,61,43,44 }, {109,93,110 ,147,129,148 ,61,44,62 },
	{110,93,94 ,148,129,130 ,62,44,45 }, {110,94,111 ,148,130,149 ,62,45,63 },
	{111,94,95 ,149,130,131 ,63,45,46 }, {111,95,112 ,149,131,150 ,63,46,64 },
	{112,95,96 ,150,131,132 ,64,46,47 }, {112,96,113 ,150,132,151 ,64,47,65 },
	{113,96,97 ,151,132,133 ,65,47,48 }, {113,97,98 ,151,133,152 ,65,48,66 },
	{98,97,82 ,153,133,153 ,66,48,49 }, {114,98,115 ,154,136,155 ,67,50,68 },
	{115,98,99 ,155,136,137 ,68,50,51 }, {115,99,116 ,155,137,156 ,68,51,69 },
	{116,99,100 ,156,137,138 ,69,51,52 }, {116,100,117 ,156,138,157 ,69,52,70 },
	{117,100,101 ,157,138,139 ,70,52,53 }, {117,101,118 ,157,139,158 ,70,53,71 },
	{118,101,102 ,158,139,140 ,71,53,54 }, {118,102,119 ,158,140,159 ,71,54,72 },
	{119,102,103 ,159,140,141 ,72,54,55 }, {119,103,120 ,159,141,160 ,72,55,73 },
	{120,103,104 ,160,141,142 ,73,55,56 }, {120,104,121 ,160,142,161 ,73,56,74 },
	{121,104,105 ,161,142,143 ,74,56,57 }, {121,105,122 ,161,143,162 ,74,57,75 },
	{122,105,106 ,162,143,144 ,75,57,58 }, {122,106,123 ,162,144,163 ,75,58,76 },
	{123,106,107 ,163,144,145 ,76,58,59 }, {123,107,124 ,163,145,164 ,76,59,77 },
	{124,107,108 ,164,145,146 ,77,59,60 }, {124,108,125 ,164,146,165 ,77,60,78 },
	{125,108,109 ,165,146,147 ,78,60,61 }, {125,109,126 ,165,147,166 ,78,61,79 },
	{126,109,110 ,166,147,148 ,79,61,62 }, {126,110,127 ,166,148,167 ,79,62,80 },
	{127,110,111 ,167,148,149 ,80,62,63 }, {127,111,128 ,167,149,168 ,80,63,81 },
	{128,111,112 ,168,149,150 ,81,63,64 }, {128,112,129 ,168,150,169 ,81,64,82 },
	{129,112,113 ,169,150,151 ,82,64,65 }, {129,113,114 ,169,151,170 ,82,65,83 },
	{114,113,98 ,171,151,171 ,83,65,66 }
// Object #-1
	, {130,131,132 ,172,173,174 ,0,1,2 }, {130,132,133 ,175,174,176 ,3,2,4 },
	{130,133,134 ,177,176,178 ,5,4,6 }, {130,134,135 ,179,178,180 ,7,6,8 },
	{130,135,136 ,181,180,182 ,9,8,10 }, {130,136,137 ,183,182,184 ,11,10,12 },
	{130,137,138 ,185,184,186 ,13,12,14 }, {130,138,139 ,187,186,188 ,15,14,16 },
	{130,139,140 ,189,188,190 ,17,16,18 }, {130,140,141 ,191,190,192 ,19,18,20 },
	{130,141,142 ,193,192,194 ,21,20,22 }, {130,142,143 ,195,194,196 ,23,22,24 },
	{130,143,144 ,197,196,198 ,25,24,26 }, {130,144,145 ,199,198,200 ,27,26,28 },
	{130,145,146 ,201,200,202 ,29,28,30 }, {130,146,131 ,203,202,203 ,31,30,32 },
	{131,147,148 ,173,204,205 ,1,33,34 }, {131,148,132 ,173,205,174 ,1,34,2 },
	{132,148,149 ,174,205,206 ,2,34,35 }, {132,149,133 ,174,206,176 ,2,35,4 },
	{133,149,150 ,176,206,207 ,4,35,36 }, {133,150,134 ,176,207,178 ,4,36,6 },
	{134,150,151 ,178,207,208 ,6,36,37 }, {134,151,135 ,178,208,180 ,6,37,8 },
	{135,151,152 ,180,208,209 ,8,37,38 }, {135,152,136 ,180,209,182 ,8,38,10 },
	{136,152,153 ,182,209,210 ,10,38,39 }, {136,153,137 ,182,210,184 ,10,39,12 },
	{137,153,154 ,184,210,211 ,12,39,40 }, {137,154,138 ,184,211,186 ,12,40,14 },
	{138,154,155 ,186,211,212 ,14,40,41 }, {138,155,139 ,186,212,188 ,14,41,16 },
	{139,155,156 ,188,212,213 ,16,41,42 }, {139,156,140 ,188,213,190 ,16,42,18 },
	{140,156,157 ,190,213,214 ,18,42,43 }, {140,157,141 ,190,214,192 ,18,43,20 },
	{141,157,158 ,192,214,215 ,20,43,44 }, {141,158,142 ,192,215,194 ,20,44,22 },
	{142,158,159 ,194,215,216 ,22,44,45 }, {142,159,143 ,194,216,196 ,22,45,24 },
	{143,159,160 ,196,216,217 ,24,45,46 }, {143,160,144 ,196,217,198 ,24,46,26 },
	{144,160,161 ,198,217,218 ,26,46,47 }, {144,161,145 ,198,218,200 ,26,47,28 },
	{145,161,162 ,200,218,219 ,28,47,48 }, {145,162,146 ,200,219,202 ,28,48,30 },
	{146,162,147 ,202,219,220 ,30,48,49 }, {146,147,131 ,202,221,221 ,30,49,32 },
	{147,163,164 ,204,222,223 ,33,50,51 }, {147,164,148 ,204,223,205 ,33,51,34 },
	{148,164,165 ,205,223,224 ,34,51,52 }, {148,165,149 ,205,224,206 ,34,52,35 },
	{149,165,166 ,206,224,225 ,35,52,53 }, {149,166,150 ,206,225,207 ,35,53,36 },
	{150,166,167 ,207,225,226 ,36,53,54 }, {150,167,151 ,207,226,208 ,36,54,37 },
	{151,167,168 ,208,226,227 ,37,54,55 }, {151,168,152 ,208,227,209 ,37,55,38 },
	{152,168,169 ,209,227,228 ,38,55,56 }, {152,169,153 ,209,228,210 ,38,56,39 },
	{153,169,170 ,210,228,229 ,39,56,57 }, {153,170,154 ,210,229,211 ,39,57,40 },
	{154,170,171 ,211,229,230 ,40,57,58 }, {154,171,155 ,211,230,212 ,40,58,41 },
	{155,171,172 ,212,230,231 ,41,58,59 }, {155,172,156 ,212,231,213 ,41,59,42 },
	{156,172,173 ,213,231,232 ,42,59,60 }, {156,173,157 ,213,232,214 ,42,60,43 },
	{157,173,174 ,214,232,233 ,43,60,61 }, {157,174,158 ,214,233,215 ,43,61,44 },
	{158,174,175 ,215,233,234 ,44,61,62 }, {158,175,159 ,215,234,216 ,44,62,45 },
	{159,175,176 ,216,234,235 ,45,62,63 }, {159,176,160 ,216,235,217 ,45,63,46 },
	{160,176,177 ,217,235,236 ,46,63,64 }, {160,177,161 ,217,236,218 ,46,64,47 },
	{161,177,178 ,218,236,237 ,47,64,65 }, {161,178,162 ,218,237,219 ,47,65,48 },
	{162,178,163 ,219,237,238 ,48,65,66 }, {162,163,147 ,219,239,239 ,48,66,49 },
	{163,179,180 ,222,240,241 ,50,67,68 }, {163,180,164 ,222,241,223 ,50,68,51 },
	{164,180,181 ,223,241,242 ,51,68,69 }, {164,181,165 ,223,242,224 ,51,69,52 },
	{165,181,182 ,224,242,243 ,52,69,70 }, {165,182,166 ,224,243,225 ,52,70,53 },
	{166,182,183 ,225,243,244 ,53,70,71 }, {166,183,167 ,225,244,226 ,53,71,54 },
	{167,183,184 ,226,244,245 ,54,71,72 }, {167,184,168 ,226,245,227 ,54,72,55 },
	{168,184,185 ,227,245,246 ,55,72,73 }, {168,185,169 ,227,246,228 ,55,73,56 },
	{169,185,186 ,228,246,247 ,56,73,74 }, {169,186,170 ,228,247,229 ,56,74,57 },
	{170,186,187 ,229,247,248 ,57,74,75 }, {170,187,171 ,229,248,230 ,57,75,58 },
	{171,187,188 ,230,248,249 ,58,75,76 }, {171,188,172 ,230,249,231 ,58,76,59 },
	{172,188,189 ,231,249,250 ,59,76,77 }, {172,189,173 ,231,250,232 ,59,77,60 },
	{173,189,190 ,232,250,251 ,60,77,78 }, {173,190,174 ,232,251,233 ,60,78,61 },
	{174,190,191 ,233,251,252 ,61,78,79 }, {174,191,175 ,233,252,234 ,61,79,62 },
	{175,191,192 ,234,252,253 ,62,79,80 }, {175,192,176 ,234,253,235 ,62,80,63 },
	{176,192,193 ,235,253,254 ,63,80,81 }, {176,193,177 ,235,254,236 ,63,81,64 },
	{177,193,194 ,236,254,255 ,64,81,82 }, {177,194,178 ,236,255,237 ,64,82,65 },
	{178,194,179 ,237,255,256 ,65,82,83 }, {178,179,163 ,237,257,257 ,65,83,66 },
	{196,195,197 ,258,259,260 ,1,0,2 }, {197,195,198 ,260,261,262 ,2,3,4 },
	{198,195,199 ,262,263,264 ,4,5,6 }, {199,195,200 ,264,265,266 ,6,7,8 },
	{200,195,201 ,266,267,268 ,8,9,10 }, {201,195,202 ,268,269,270 ,10,11,12 },
	{202,195,203 ,270,271,272 ,12,13,14 }, {203,195,204 ,272,273,274 ,14,15,16 },
	{204,195,205 ,274,275,276 ,16,17,18 }, {205,195,206 ,276,277,278 ,18,19,20 },
	{206,195,207 ,278,279,280 ,20,21,22 }, {207,195,208 ,280,281,282 ,22,23,24 },
	{208,195,209 ,282,283,284 ,24,25,26 }, {209,195,210 ,284,285,286 ,26,27,28 },
	{210,195,211 ,286,287,288 ,28,29,30 }, {211,195,196 ,288,289,289 ,30,31,32 },
	{212,196,213 ,290,258,291 ,33,1,34 }, {213,196,197 ,291,258,260 ,34,1,2 },
	{213,197,214 ,291,260,292 ,34,2,35 }, {214,197,198 ,292,260,262 ,35,2,4 },
	{214,198,215 ,292,262,293 ,35,4,36 }, {215,198,199 ,293,262,264 ,36,4,6 },
	{215,199,216 ,293,264,294 ,36,6,37 }, {216,199,200 ,294,264,266 ,37,6,8 },
	{216,200,217 ,294,266,295 ,37,8,38 }, {217,200,201 ,295,266,268 ,38,8,10 },
	{217,201,218 ,295,268,296 ,38,10,39 }, {218,201,202 ,296,268,270 ,39,10,12 },
	{218,202,219 ,296,270,297 ,39,12,40 }, {219,202,203 ,297,270,272 ,40,12,14 },
	{219,203,220 ,297,272,298 ,40,14,41 }, {220,203,204 ,298,272,274 ,41,14,16 },
	{220,204,221 ,298,274,299 ,41,16,42 }, {221,204,205 ,299,274,276 ,42,16,18 },
	{221,205,222 ,299,276,300 ,42,18,43 }, {222,205,206 ,300,276,278 ,43,18,20 },
	{222,206,223 ,300,278,301 ,43,20,44 }, {223,206,207 ,301,278,280 ,44,20,22 },
	{223,207,224 ,301,280,302 ,44,22,45 }, {224,207,208 ,302,280,282 ,45,22,24 },
	{224,208,225 ,302,282,303 ,45,24,46 }, {225,208,209 ,303,282,284 ,46,24,26 },
	{225,209,226 ,303,284,304 ,46,26,47 }, {226,209,210 ,304,284,286 ,47,26,28 },
	{226,210,227 ,304,286,305 ,47,28,48 }, {227,210,211 ,305,286,288 ,48,28,30 },
	{227,211,212 ,305,288,306 ,48,30,49 }, {212,211,196 ,307,288,307 ,49,30,32 },
	{228,212,229 ,308,290,309 ,50,33,51 }, {229,212,213 ,309,290,291 ,51,33,34 },
	{229,213,230 ,309,291,310 ,51,34,52 }, {230,213,214 ,310,291,292 ,52,34,35 },
	{230,214,231 ,310,292,311 ,52,35,53 }, {231,214,215 ,311,292,293 ,53,35,36 },
	{231,215,232 ,311,293,312 ,53,36,54 }, {232,215,216 ,312,293,294 ,54,36,37 },
	{232,216,233 ,312,294,313 ,54,37,55 }, {233,216,217 ,313,294,295 ,55,37,38 },
	{233,217,234 ,313,295,314 ,55,38,56 }, {234,217,218 ,314,295,296 ,56,38,39 },
	{234,218,235 ,314,296,315 ,56,39,57 }, {235,218,219 ,315,296,297 ,57,39,40 },
	{235,219,236 ,315,297,316 ,57,40,58 }, {236,219,220 ,316,297,298 ,58,40,41 },
	{236,220,237 ,316,298,317 ,58,41,59 }, {237,220,221 ,317,298,299 ,59,41,42 },
	{237,221,238 ,317,299,318 ,59,42,60 }, {238,221,222 ,318,299,300 ,60,42,43 },
	{238,222,239 ,318,300,319 ,60,43,61 }, {239,222,223 ,319,300,301 ,61,43,44 },
	{239,223,240 ,319,301,320 ,61,44,62 }, {240,223,224 ,320,301,302 ,62,44,45 },
	{240,224,241 ,320,302,321 ,62,45,63 }, {241,224,225 ,321,302,303 ,63,45,46 },
	{241,225,242 ,321,303,322 ,63,46,64 }, {242,225,226 ,322,303,304 ,64,46,47 },
	{242,226,243 ,322,304,323 ,64,47,65 }, {243,226,227 ,323,304,305 ,65,47,48 },
	{243,227,228 ,323,305,324 ,65,48,66 }, {228,227,212 ,325,305,325 ,66,48,49 },
	{244,228,245 ,326,308,327 ,67,50,68 }, {245,228,229 ,327,308,309 ,68,50,51 },
	{245,229,246 ,327,309,328 ,68,51,69 }, {246,229,230 ,328,309,310 ,69,51,52 },
	{246,230,247 ,328,310,329 ,69,52,70 }, {247,230,231 ,329,310,311 ,70,52,53 },
	{247,231,248 ,329,311,330 ,70,53,71 }, {248,231,232 ,330,311,312 ,71,53,54 },
	{248,232,249 ,330,312,331 ,71,54,72 }, {249,232,233 ,331,312,313 ,72,54,55 },
	{249,233,250 ,331,313,332 ,72,55,73 }, {250,233,234 ,332,313,314 ,73,55,56 },
	{250,234,251 ,332,314,333 ,73,56,74 }, {251,234,235 ,333,314,315 ,74,56,57 },
	{251,235,252 ,333,315,334 ,74,57,75 }, {252,235,236 ,334,315,316 ,75,57,58 },
	{252,236,253 ,334,316,335 ,75,58,76 }, {253,236,237 ,335,316,317 ,76,58,59 },
	{253,237,254 ,335,317,336 ,76,59,77 }, {254,237,238 ,336,317,318 ,77,59,60 },
	{254,238,255 ,336,318,337 ,77,60,78 }, {255,238,239 ,337,318,319 ,78,60,61 },
	{255,239,256 ,337,319,338 ,78,61,79 }, {256,239,240 ,338,319,320 ,79,61,62 },
	{256,240,257 ,338,320,339 ,79,62,80 }, {257,240,241 ,339,320,321 ,80,62,63 },
	{257,241,258 ,339,321,340 ,80,63,81 }, {258,241,242 ,340,321,322 ,81,63,64 },
	{258,242,259 ,340,322,341 ,81,64,82 }, {259,242,243 ,341,322,323 ,82,64,65 },
	{259,243,244 ,341,323,342 ,82,65,83 }, {244,243,228 ,343,323,343 ,83,65,66 }
},

//lid 2
{
// Object #-1
	{0,1,2 ,0,1,2 ,0,1,2 }, {0,2,3 ,3,2,4 ,3,2,4 }, {0,3,4 ,5,4,6 ,5,4,6 },
	{0,4,5 ,7,6,8 ,7,6,8 }, {0,5,6 ,9,8,10 ,9,8,10 }, {0,6,7 ,11,10,12 ,11,10,12 },
	{0,7,8 ,13,12,14 ,13,12,14 }, {0,8,9 ,15,14,16 ,15,14,16 }, {0,9,10 ,17,16,18 ,17,16,18 },
	{0,10,11 ,19,18,20 ,19,18,20 }, {0,11,12 ,21,20,22 ,21,20,22 },
	{0,12,13 ,23,22,24 ,23,22,24 }, {0,13,14 ,25,24,26 ,25,24,26 },
	{0,14,15 ,27,26,28 ,27,26,28 }, {0,15,16 ,29,28,30 ,29,28,30 },
	{0,16,1 ,31,30,31 ,31,30,32 }, {1,17,18 ,1,32,33 ,1,33,34 },
	{1,18,2 ,1,33,2 ,1,34,2 }, {2,18,19 ,2,33,34 ,2,34,35 }, {2,19,3 ,2,34,4 ,2,35,4 },
	{3,19,20 ,4,34,35 ,4,35,36 }, {3,20,4 ,4,35,6 ,4,36,6 }, {4,20,21 ,6,35,36 ,6,36,37 },
	{4,21,5 ,6,36,8 ,6,37,8 }, {5,21,22 ,8,36,37 ,8,37,38 }, {5,22,6 ,8,37,10 ,8,38,10 },
	{6,22,23 ,10,37,38 ,10,38,39 }, {6,23,7 ,10,38,12 ,10,39,12 },
	{7,23,24 ,12,38,39 ,12,39,40 }, {7,24,8 ,12,39,14 ,12,40,14 },
	{8,24,25 ,14,39,40 ,14,40,41 }, {8,25,9 ,14,40,16 ,14,41,16 },
	{9,25,26 ,16,40,41 ,16,41,42 }, {9,26,10 ,16,41,18 ,16,42,18 },
	{10,26,27 ,18,41,42 ,18,42,43 }, {10,27,11 ,18,42,20 ,18,43,20 },
	{11,27,28 ,20,42,43 ,20,43,44 }, {11,28,12 ,20,43,22 ,20,44,22 },
	{12,28,29 ,22,43,44 ,22,44,45 }, {12,29,13 ,22,44,24 ,22,45,24 },
	{13,29,30 ,24,44,45 ,24,45,46 }, {13,30,14 ,24,45,26 ,24,46,26 },
	{14,30,31 ,26,45,46 ,26,46,47 }, {14,31,15 ,26,46,28 ,26,47,28 },
	{15,31,32 ,28,46,47 ,28,47,48 }, {15,32,16 ,28,47,30 ,28,48,30 },
	{16,32,17 ,30,47,48 ,30,48,49 }, {16,17,1 ,30,49,49 ,30,49,32 },
	{17,33,34 ,32,50,51 ,33,50,51 }, {17,34,18 ,32,51,33 ,33,51,34 },
	{18,34,35 ,33,51,52 ,34,51,52 }, {18,35,19 ,33,52,34 ,34,52,35 },
	{19,35,36 ,34,52,53 ,35,52,53 }, {19,36,20 ,34,53,35 ,35,53,36 },
	{20,36,37 ,35,53,54 ,36,53,54 }, {20,37,21 ,35,54,36 ,36,54,37 },
	{21,37,38 ,36,54,55 ,37,54,55 }, {21,38,22 ,36,55,37 ,37,55,38 },
	{22,38,39 ,37,55,56 ,38,55,56 }, {22,39,23 ,37,56,38 ,38,56,39 },
	{23,39,40 ,38,56,57 ,39,56,57 }, {23,40,24 ,38,57,39 ,39,57,40 },
	{24,40,41 ,39,57,58 ,40,57,58 }, {24,41,25 ,39,58,40 ,40,58,41 },
	{25,41,42 ,40,58,59 ,41,58,59 }, {25,42,26 ,40,59,41 ,41,59,42 },
	{26,42,43 ,41,59,60 ,42,59,60 }, {26,43,27 ,41,60,42 ,42,60,43 },
	{27,43,44 ,42,60,61 ,43,60,61 }, {27,44,28 ,42,61,43 ,43,61,44 },
	{28,44,45 ,43,61,62 ,44,61,62 }, {28,45,29 ,43,62,44 ,44,62,45 },
	{29,45,46 ,44,62,63 ,45,62,63 }, {29,46,30 ,44,63,45 ,45,63,46 },
	{30,46,47 ,45,63,64 ,46,63,64 }, {30,47,31 ,45,64,46 ,46,64,47 },
	{31,47,48 ,46,64,65 ,47,64,65 }, {31,48,32 ,46,65,47 ,47,65,48 },
	{32,48,33 ,47,65,66 ,48,65,66 }, {32,33,17 ,47,67,67 ,48,66,49 },
	{33,49,50 ,50,68,69 ,50,67,68 }, {33,50,34 ,50,69,51 ,50,68,51 },
	{34,50,51 ,51,69,70 ,51,68,69 }, {34,51,35 ,51,70,52 ,51,69,52 },
	{35,51,52 ,52,70,71 ,52,69,70 }, {35,52,36 ,52,71,53 ,52,70,53 },
	{36,52,53 ,53,71,72 ,53,70,71 }, {36,53,37 ,53,72,54 ,53,71,54 },
	{37,53,54 ,54,72,73 ,54,71,72 }, {37,54,38 ,54,73,55 ,54,72,55 },
	{38,54,55 ,55,73,74 ,55,72,73 }, {38,55,39 ,55,74,56 ,55,73,56 },
	{39,55,56 ,56,74,75 ,56,73,74 }, {39,56,40 ,56,75,57 ,56,74,57 },
	{40,56,57 ,57,75,76 ,57,74,75 }, {40,57,41 ,57,76,58 ,57,75,58 },
	{41,57,58 ,58,76,77 ,58,75,76 }, {41,58,42 ,58,77,59 ,58,76,59 },
	{42,58,59 ,59,77,78 ,59,76,77 }, {42,59,43 ,59,78,60 ,59,77,60 },
	{43,59,60 ,60,78,79 ,60,77,78 }, {43,60,44 ,60,79,61 ,60,78,61 },
	{44,60,61 ,61,79,80 ,61,78,79 }, {44,61,45 ,61,80,62 ,61,79,62 },
	{45,61,62 ,62,80,81 ,62,79,80 }, {45,62,46 ,62,81,63 ,62,80,63 },
	{46,62,63 ,63,81,82 ,63,80,81 }, {46,63,47 ,63,82,64 ,63,81,64 },
	{47,63,64 ,64,82,83 ,64,81,82 }, {47,64,48 ,64,83,65 ,64,82,65 },
	{48,64,49 ,65,83,84 ,65,82,83 }, {48,49,33 ,65,85,85 ,65,83,66 },
	{66,65,67 ,86,87,88 ,1,0,2 }, {67,65,68 ,88,89,90 ,2,3,4 }, {68,65,69 ,90,91,92 ,4,5,6 },
	{69,65,70 ,92,93,94 ,6,7,8 }, {70,65,71 ,94,95,96 ,8,9,10 },
	{71,65,72 ,96,97,98 ,10,11,12 }, {72,65,73 ,98,99,100 ,12,13,14 },
	{73,65,74 ,100,101,102 ,14,15,16 }, {74,65,75 ,102,103,104 ,16,17,18 },
	{75,65,76 ,104,105,106 ,18,19,20 }, {76,65,77 ,106,107,108 ,20,21,22 },
	{77,65,78 ,108,109,110 ,22,23,24 }, {78,65,79 ,110,111,112 ,24,25,26 },
	{79,65,80 ,112,113,114 ,26,27,28 }, {80,65,81 ,114,115,116 ,28,29,30 },
	{81,65,66 ,116,117,117 ,30,31,32 }, {82,66,83 ,118,86,119 ,33,1,34 },
	{83,66,67 ,119,86,88 ,34,1,2 }, {83,67,84 ,119,88,120 ,34,2,35 },
	{84,67,68 ,120,88,90 ,35,2,4 }, {84,68,85 ,120,90,121 ,35,4,36 },
	{85,68,69 ,121,90,92 ,36,4,6 }, {85,69,86 ,121,92,122 ,36,6,37 },
	{86,69,70 ,122,92,94 ,37,6,8 }, {86,70,87 ,122,94,123 ,37,8,38 },
	{87,70,71 ,123,94,96 ,38,8,10 }, {87,71,88 ,123,96,124 ,38,10,39 },
	{88,71,72 ,124,96,98 ,39,10,12 }, {88,72,89 ,124,98,125 ,39,12,40 },
	{89,72,73 ,125,98,100 ,40,12,14 }, {89,73,90 ,125,100,126 ,40,14,41 },
	{90,73,74 ,126,100,102 ,41,14,16 }, {90,74,91 ,126,102,127 ,41,16,42 },
	{91,74,75 ,127,102,104 ,42,16,18 }, {91,75,92 ,127,104,128 ,42,18,43 },
	{92,75,76 ,128,104,106 ,43,18,20 }, {92,76,93 ,128,106,129 ,43,20,44 },
	{93,76,77 ,129,106,108 ,44,20,22 }, {93,77,94 ,129,108,130 ,44,22,45 },
	{94,77,78 ,130,108,110 ,45,22,24 }, {94,78,95 ,130,110,131 ,45,24,46 },
	{95,78,79 ,131,110,112 ,46,24,26 }, {95,79,96 ,131,112,132 ,46,26,47 },
	{96,79,80 ,132,112,114 ,47,26,28 }, {96,80,97 ,132,114,133 ,47,28,48 },
	{97,80,81 ,133,114,116 ,48,28,30 }, {97,81,82 ,133,116,134 ,48,30,49 },
	{82,81,66 ,135,116,135 ,49,30,32 }, {98,82,99 ,136,118,137 ,50,33,51 },
	{99,82,83 ,137,118,119 ,51,33,34 }, {99,83,100 ,137,119,138 ,51,34,52 },
	{100,83,84 ,138,119,120 ,52,34,35 }, {100,84,101 ,138,120,139 ,52,35,53 },
	{101,84,85 ,139,120,121 ,53,35,36 }, {101,85,102 ,139,121,140 ,53,36,54 },
	{102,85,86 ,140,121,122 ,54,36,37 }, {102,86,103 ,140,122,141 ,54,37,55 },
	{103,86,87 ,141,122,123 ,55,37,38 }, {103,87,104 ,141,123,142 ,55,38,56 },
	{104,87,88 ,142,123,124 ,56,38,39 }, {104,88,105 ,142,124,143 ,56,39,57 },
	{105,88,89 ,143,124,125 ,57,39,40 }, {105,89,106 ,143,125,144 ,57,40,58 },
	{106,89,90 ,144,125,126 ,58,40,41 }, {106,90,107 ,144,126,145 ,58,41,59 },
	{107,90,91 ,145,126,127 ,59,41,42 }, {107,91,108 ,145,127,146 ,59,42,60 },
	{108,91,92 ,146,127,128 ,60,42,43 }, {108,92,109 ,146,128,147 ,60,43,61 },
	{109,92,93 ,147,128,129 ,61,43,44 }, {109,93,110 ,147,129,148 ,61,44,62 },
	{110,93,94 ,148,129,130 ,62,44,45 }, {110,94,111 ,148,130,149 ,62,45,63 },
	{111,94,95 ,149,130,131 ,63,45,46 }, {111,95,112 ,149,131,150 ,63,46,64 },
	{112,95,96 ,150,131,132 ,64,46,47 }, {112,96,113 ,150,132,151 ,64,47,65 },
	{113,96,97 ,151,132,133 ,65,47,48 }, {113,97,98 ,151,133,152 ,65,48,66 },
	{98,97,82 ,153,133,153 ,66,48,49 }, {114,98,115 ,154,136,155 ,67,50,68 },
	{115,98,99 ,155,136,137 ,68,50,51 }, {115,99,116 ,155,137,156 ,68,51,69 },
	{116,99,100 ,156,137,138 ,69,51,52 }, {116,100,117 ,156,138,157 ,69,52,70 },
	{117,100,101 ,157,138,139 ,70,52,53 }, {117,101,118 ,157,139,158 ,70,53,71 },
	{118,101,102 ,158,139,140 ,71,53,54 }, {118,102,119 ,158,140,159 ,71,54,72 },
	{119,102,103 ,159,140,141 ,72,54,55 }, {119,103,120 ,159,141,160 ,72,55,73 },
	{120,103,104 ,160,141,142 ,73,55,56 }, {120,104,121 ,160,142,161 ,73,56,74 },
	{121,104,105 ,161,142,143 ,74,56,57 }, {121,105,122 ,161,143,162 ,74,57,75 },
	{122,105,106 ,162,143,144 ,75,57,58 }, {122,106,123 ,162,144,163 ,75,58,76 },
	{123,106,107 ,163,144,145 ,76,58,59 }, {123,107,124 ,163,145,164 ,76,59,77 },
	{124,107,108 ,164,145,146 ,77,59,60 }, {124,108,125 ,164,146,165 ,77,60,78 },
	{125,108,109 ,165,146,147 ,78,60,61 }, {125,109,126 ,165,147,166 ,78,61,79 },
	{126,109,110 ,166,147,148 ,79,61,62 }, {126,110,127 ,166,148,167 ,79,62,80 },
	{127,110,111 ,167,148,149 ,80,62,63 }, {127,111,128 ,167,149,168 ,80,63,81 },
	{128,111,112 ,168,149,150 ,81,63,64 }, {128,112,129 ,168,150,169 ,81,64,82 },
	{129,112,113 ,169,150,151 ,82,64,65 }, {129,113,114 ,169,151,170 ,82,65,83 },
	{114,113,98 ,171,151,171 ,83,65,66 }
// Object #-1
	, {130,131,132 ,172,173,174 ,0,1,2 }, {130,132,133 ,175,174,176 ,3,2,4 },
	{130,133,134 ,177,176,178 ,5,4,6 }, {130,134,135 ,179,178,180 ,7,6,8 },
	{130,135,136 ,181,180,182 ,9,8,10 }, {130,136,137 ,183,182,184 ,11,10,12 },
	{130,137,138 ,185,184,186 ,13,12,14 }, {130,138,139 ,187,186,188 ,15,14,16 },
	{130,139,140 ,189,188,190 ,17,16,18 }, {130,140,141 ,191,190,192 ,19,18,20 },
	{130,141,142 ,193,192,194 ,21,20,22 }, {130,142,143 ,195,194,196 ,23,22,24 },
	{130,143,144 ,197,196,198 ,25,24,26 }, {130,144,145 ,199,198,200 ,27,26,28 },
	{130,145,146 ,201,200,202 ,29,28,30 }, {130,146,131 ,203,202,203 ,31,30,32 },
	{131,147,148 ,173,204,205 ,1,33,34 }, {131,148,132 ,173,205,174 ,1,34,2 },
	{132,148,149 ,174,205,206 ,2,34,35 }, {132,149,133 ,174,206,176 ,2,35,4 },
	{133,149,150 ,176,206,207 ,4,35,36 }, {133,150,134 ,176,207,178 ,4,36,6 },
	{134,150,151 ,178,207,208 ,6,36,37 }, {134,151,135 ,178,208,180 ,6,37,8 },
	{135,151,152 ,180,208,209 ,8,37,38 }, {135,152,136 ,180,209,182 ,8,38,10 },
	{136,152,153 ,182,209,210 ,10,38,39 }, {136,153,137 ,182,210,184 ,10,39,12 },
	{137,153,154 ,184,210,211 ,12,39,40 }, {137,154,138 ,184,211,186 ,12,40,14 },
	{138,154,155 ,186,211,212 ,14,40,41 }, {138,155,139 ,186,212,188 ,14,41,16 },
	{139,155,156 ,188,212,213 ,16,41,42 }, {139,156,140 ,188,213,190 ,16,42,18 },
	{140,156,157 ,190,213,214 ,18,42,43 }, {140,157,141 ,190,214,192 ,18,43,20 },
	{141,157,158 ,192,214,215 ,20,43,44 }, {141,158,142 ,192,215,194 ,20,44,22 },
	{142,158,159 ,194,215,216 ,22,44,45 }, {142,159,143 ,194,216,196 ,22,45,24 },
	{143,159,160 ,196,216,217 ,24,45,46 }, {143,160,144 ,196,217,198 ,24,46,26 },
	{144,160,161 ,198,217,218 ,26,46,47 }, {144,161,145 ,198,218,200 ,26,47,28 },
	{145,161,162 ,200,218,219 ,28,47,48 }, {145,162,146 ,200,219,202 ,28,48,30 },
	{146,162,147 ,202,219,220 ,30,48,49 }, {146,147,131 ,202,221,221 ,30,49,32 },
	{147,163,164 ,204,222,223 ,33,50,51 }, {147,164,148 ,204,223,205 ,33,51,34 },
	{148,164,165 ,205,223,224 ,34,51,52 }, {148,165,149 ,205,224,206 ,34,52,35 },
	{149,165,166 ,206,224,225 ,35,52,53 }, {149,166,150 ,206,225,207 ,35,53,36 },
	{150,166,167 ,207,225,226 ,36,53,54 }, {150,167,151 ,207,226,208 ,36,54,37 },
	{151,167,168 ,208,226,227 ,37,54,55 }, {151,168,152 ,208,227,209 ,37,55,38 },
	{152,168,169 ,209,227,228 ,38,55,56 }, {152,169,153 ,209,228,210 ,38,56,39 },
	{153,169,170 ,210,228,229 ,39,56,57 }, {153,170,154 ,210,229,211 ,39,57,40 },
	{154,170,171 ,211,229,230 ,40,57,58 }, {154,171,155 ,211,230,212 ,40,58,41 },
	{155,171,172 ,212,230,231 ,41,58,59 }, {155,172,156 ,212,231,213 ,41,59,42 },
	{156,172,173 ,213,231,232 ,42,59,60 }, {156,173,157 ,213,232,214 ,42,60,43 },
	{157,173,174 ,214,232,233 ,43,60,61 }, {157,174,158 ,214,233,215 ,43,61,44 },
	{158,174,175 ,215,233,234 ,44,61,62 }, {158,175,159 ,215,234,216 ,44,62,45 },
	{159,175,176 ,216,234,235 ,45,62,63 }, {159,176,160 ,216,235,217 ,45,63,46 },
	{160,176,177 ,217,235,236 ,46,63,64 }, {160,177,161 ,217,236,218 ,46,64,47 },
	{161,177,178 ,218,236,237 ,47,64,65 }, {161,178,162 ,218,237,219 ,47,65,48 },
	{162,178,163 ,219,237,238 ,48,65,66 }, {162,163,147 ,219,239,239 ,48,66,49 },
	{163,179,180 ,222,240,241 ,50,67,68 }, {163,180,164 ,222,241,223 ,50,68,51 },
	{164,180,181 ,223,241,242 ,51,68,69 }, {164,181,165 ,223,242,224 ,51,69,52 },
	{165,181,182 ,224,242,243 ,52,69,70 }, {165,182,166 ,224,243,225 ,52,70,53 },
	{166,182,183 ,225,243,244 ,53,70,71 }, {166,183,167 ,225,244,226 ,53,71,54 },
	{167,183,184 ,226,244,245 ,54,71,72 }, {167,184,168 ,226,245,227 ,54,72,55 },
	{168,184,185 ,227,245,246 ,55,72,73 }, {168,185,169 ,227,246,228 ,55,73,56 },
	{169,185,186 ,228,246,247 ,56,73,74 }, {169,186,170 ,228,247,229 ,56,74,57 },
	{170,186,187 ,229,247,248 ,57,74,75 }, {170,187,171 ,229,248,230 ,57,75,58 },
	{171,187,188 ,230,248,249 ,58,75,76 }, {171,188,172 ,230,249,231 ,58,76,59 },
	{172,188,189 ,231,249,250 ,59,76,77 }, {172,189,173 ,231,250,232 ,59,77,60 },
	{173,189,190 ,232,250,251 ,60,77,78 }, {173,190,174 ,232,251,233 ,60,78,61 },
	{174,190,191 ,233,251,252 ,61,78,79 }, {174,191,175 ,233,252,234 ,61,79,62 },
	{175,191,192 ,234,252,253 ,62,79,80 }, {175,192,176 ,234,253,235 ,62,80,63 },
	{176,192,193 ,235,253,254 ,63,80,81 }, {176,193,177 ,235,254,236 ,63,81,64 },
	{177,193,194 ,236,254,255 ,64,81,82 }, {177,194,178 ,236,255,237 ,64,82,65 },
	{178,194,179 ,237,255,256 ,65,82,83 }, {178,179,163 ,237,257,257 ,65,83,66 },
	{196,195,197 ,258,259,260 ,1,0,2 }, {197,195,198 ,260,261,262 ,2,3,4 },
	{198,195,199 ,262,263,264 ,4,5,6 }, {199,195,200 ,264,265,266 ,6,7,8 },
	{200,195,201 ,266,267,268 ,8,9,10 }, {201,195,202 ,268,269,270 ,10,11,12 },
	{202,195,203 ,270,271,272 ,12,13,14 }, {203,195,204 ,272,273,274 ,14,15,16 },
	{204,195,205 ,274,275,276 ,16,17,18 }, {205,195,206 ,276,277,278 ,18,19,20 },
	{206,195,207 ,278,279,280 ,20,21,22 }, {207,195,208 ,280,281,282 ,22,23,24 },
	{208,195,209 ,282,283,284 ,24,25,26 }, {209,195,210 ,284,285,286 ,26,27,28 },
	{210,195,211 ,286,287,288 ,28,29,30 }, {211,195,196 ,288,289,289 ,30,31,32 },
	{212,196,213 ,290,258,291 ,33,1,34 }, {213,196,197 ,291,258,260 ,34,1,2 },
	{213,197,214 ,291,260,292 ,34,2,35 }, {214,197,198 ,292,260,262 ,35,2,4 },
	{214,198,215 ,292,262,293 ,35,4,36 }, {215,198,199 ,293,262,264 ,36,4,6 },
	{215,199,216 ,293,264,294 ,36,6,37 }, {216,199,200 ,294,264,266 ,37,6,8 },
	{216,200,217 ,294,266,295 ,37,8,38 }, {217,200,201 ,295,266,268 ,38,8,10 },
	{217,201,218 ,295,268,296 ,38,10,39 }, {218,201,202 ,296,268,270 ,39,10,12 },
	{218,202,219 ,296,270,297 ,39,12,40 }, {219,202,203 ,297,270,272 ,40,12,14 },
	{219,203,220 ,297,272,298 ,40,14,41 }, {220,203,204 ,298,272,274 ,41,14,16 },
	{220,204,221 ,298,274,299 ,41,16,42 }, {221,204,205 ,299,274,276 ,42,16,18 },
	{221,205,222 ,299,276,300 ,42,18,43 }, {222,205,206 ,300,276,278 ,43,18,20 },
	{222,206,223 ,300,278,301 ,43,20,44 }, {223,206,207 ,301,278,280 ,44,20,22 },
	{223,207,224 ,301,280,302 ,44,22,45 }, {224,207,208 ,302,280,282 ,45,22,24 },
	{224,208,225 ,302,282,303 ,45,24,46 }, {225,208,209 ,303,282,284 ,46,24,26 },
	{225,209,226 ,303,284,304 ,46,26,47 }, {226,209,210 ,304,284,286 ,47,26,28 },
	{226,210,227 ,304,286,305 ,47,28,48 }, {227,210,211 ,305,286,288 ,48,28,30 },
	{227,211,212 ,305,288,306 ,48,30,49 }, {212,211,196 ,307,288,307 ,49,30,32 },
	{228,212,229 ,308,290,309 ,50,33,51 }, {229,212,213 ,309,290,291 ,51,33,34 },
	{229,213,230 ,309,291,310 ,51,34,52 }, {230,213,214 ,310,291,292 ,52,34,35 },
	{230,214,231 ,310,292,311 ,52,35,53 }, {231,214,215 ,311,292,293 ,53,35,36 },
	{231,215,232 ,311,293,312 ,53,36,54 }, {232,215,216 ,312,293,294 ,54,36,37 },
	{232,216,233 ,312,294,313 ,54,37,55 }, {233,216,217 ,313,294,295 ,55,37,38 },
	{233,217,234 ,313,295,314 ,55,38,56 }, {234,217,218 ,314,295,296 ,56,38,39 },
	{234,218,235 ,314,296,315 ,56,39,57 }, {235,218,219 ,315,296,297 ,57,39,40 },
	{235,219,236 ,315,297,316 ,57,40,58 }, {236,219,220 ,316,297,298 ,58,40,41 },
	{236,220,237 ,316,298,317 ,58,41,59 }, {237,220,221 ,317,298,299 ,59,41,42 },
	{237,221,238 ,317,299,318 ,59,42,60 }, {238,221,222 ,318,299,300 ,60,42,43 },
	{238,222,239 ,318,300,319 ,60,43,61 }, {239,222,223 ,319,300,301 ,61,43,44 },
	{239,223,240 ,319,301,320 ,61,44,62 }, {240,223,224 ,320,301,302 ,62,44,45 },
	{240,224,241 ,320,302,321 ,62,45,63 }, {241,224,225 ,321,302,303 ,63,45,46 },
	{241,225,242 ,321,303,322 ,63,46,64 }, {242,225,226 ,322,303,304 ,64,46,47 },
	{242,226,243 ,322,304,323 ,64,47,65 }, {243,226,227 ,323,304,305 ,65,47,48 },
	{243,227,228 ,323,305,324 ,65,48,66 }, {228,227,212 ,325,305,325 ,66,48,49 },
	{244,228,245 ,326,308,327 ,67,50,68 }, {245,228,229 ,327,308,309 ,68,50,51 },
	{245,229,246 ,327,309,328 ,68,51,69 }, {246,229,230 ,328,309,310 ,69,51,52 },
	{246,230,247 ,328,310,329 ,69,52,70 }, {247,230,231 ,329,310,311 ,70,52,53 },
	{247,231,118 ,329,311,330 ,70,53,71 }, {118,231,232 ,330,311,312 ,71,53,54 },
	{118,232,248 ,330,312,331 ,71,54,72 }, {248,232,233 ,331,312,313 ,72,54,55 },
	{248,233,249 ,331,313,332 ,72,55,73 }, {249,233,234 ,332,313,314 ,73,55,56 },
	{249,234,250 ,332,314,333 ,73,56,74 }, {250,234,235 ,333,314,315 ,74,56,57 },
	{250,235,251 ,333,315,334 ,74,57,75 }, {251,235,236 ,334,315,316 ,75,57,58 },
	{251,236,252 ,334,316,335 ,75,58,76 }, {252,236,237 ,335,316,317 ,76,58,59 },
	{252,237,253 ,335,317,336 ,76,59,77 }, {253,237,238 ,336,317,318 ,77,59,60 },
	{253,238,254 ,336,318,337 ,77,60,78 }, {254,238,239 ,337,318,319 ,78,60,61 },
	{254,239,126 ,337,319,338 ,78,61,79 }, {126,239,240 ,338,319,320 ,79,61,62 },
	{126,240,255 ,338,320,339 ,79,62,80 }, {255,240,241 ,339,320,321 ,80,62,63 },
	{255,241,256 ,339,321,340 ,80,63,81 }, {256,241,242 ,340,321,322 ,81,63,64 },
	{256,242,257 ,340,322,341 ,81,64,82 }, {257,242,243 ,341,322,323 ,82,64,65 },
	{257,243,244 ,341,323,342 ,82,65,83 }, {244,243,228 ,343,323,343 ,83,65,66 }
},

//lid 1

{
// Object #-1
	{0,1,2 ,0,1,2 ,0,1,2 }, {0,2,3 ,3,2,4 ,3,2,4 }, {0,3,4 ,5,4,6 ,5,4,6 },
	{0,4,5 ,7,6,8 ,7,6,8 }, {0,5,6 ,9,8,10 ,9,8,10 }, {0,6,7 ,11,10,12 ,11,10,12 },
	{0,7,8 ,13,12,14 ,13,12,14 }, {0,8,9 ,15,14,16 ,15,14,16 }, {0,9,10 ,17,16,18 ,17,16,18 },
	{0,10,11 ,19,18,20 ,19,18,20 }, {0,11,12 ,21,20,22 ,21,20,22 },
	{0,12,13 ,23,22,24 ,23,22,24 }, {0,13,14 ,25,24,26 ,25,24,26 },
	{0,14,15 ,27,26,28 ,27,26,28 }, {0,15,16 ,29,28,30 ,29,28,30 },
	{0,16,1 ,31,30,31 ,31,30,32 }, {1,17,18 ,1,32,33 ,1,33,34 },
	{1,18,2 ,1,33,2 ,1,34,2 }, {2,18,19 ,2,33,34 ,2,34,35 }, {2,19,3 ,2,34,4 ,2,35,4 },
	{3,19,20 ,4,34,35 ,4,35,36 }, {3,20,4 ,4,35,6 ,4,36,6 }, {4,20,21 ,6,35,36 ,6,36,37 },
	{4,21,5 ,6,36,8 ,6,37,8 }, {5,21,22 ,8,36,37 ,8,37,38 }, {5,22,6 ,8,37,10 ,8,38,10 },
	{6,22,23 ,10,37,38 ,10,38,39 }, {6,23,7 ,10,38,12 ,10,39,12 },
	{7,23,24 ,12,38,39 ,12,39,40 }, {7,24,8 ,12,39,14 ,12,40,14 },
	{8,24,25 ,14,39,40 ,14,40,41 }, {8,25,9 ,14,40,16 ,14,41,16 },
	{9,25,26 ,16,40,41 ,16,41,42 }, {9,26,10 ,16,41,18 ,16,42,18 },
	{10,26,27 ,18,41,42 ,18,42,43 }, {10,27,11 ,18,42,20 ,18,43,20 },
	{11,27,28 ,20,42,43 ,20,43,44 }, {11,28,12 ,20,43,22 ,20,44,22 },
	{12,28,29 ,22,43,44 ,22,44,45 }, {12,29,13 ,22,44,24 ,22,45,24 },
	{13,29,30 ,24,44,45 ,24,45,46 }, {13,30,14 ,24,45,26 ,24,46,26 },
	{14,30,31 ,26,45,46 ,26,46,47 }, {14,31,15 ,26,46,28 ,26,47,28 },
	{15,31,32 ,28,46,47 ,28,47,48 }, {15,32,16 ,28,47,30 ,28,48,30 },
	{16,32,17 ,30,47,48 ,30,48,49 }, {16,17,1 ,30,49,49 ,30,49,32 },
	{17,33,34 ,32,50,51 ,33,50,51 }, {17,34,18 ,32,51,33 ,33,51,34 },
	{18,34,35 ,33,51,52 ,34,51,52 }, {18,35,19 ,33,52,34 ,34,52,35 },
	{19,35,36 ,34,52,53 ,35,52,53 }, {19,36,20 ,34,53,35 ,35,53,36 },
	{20,36,37 ,35,53,54 ,36,53,54 }, {20,37,21 ,35,54,36 ,36,54,37 },
	{21,37,38 ,36,54,55 ,37,54,55 }, {21,38,22 ,36,55,37 ,37,55,38 },
	{22,38,39 ,37,55,56 ,38,55,56 }, {22,39,23 ,37,56,38 ,38,56,39 },
	{23,39,40 ,38,56,57 ,39,56,57 }, {23,40,24 ,38,57,39 ,39,57,40 },
	{24,40,41 ,39,57,58 ,40,57,58 }, {24,41,25 ,39,58,40 ,40,58,41 },
	{25,41,42 ,40,58,59 ,41,58,59 }, {25,42,26 ,40,59,41 ,41,59,42 },
	{26,42,43 ,41,59,60 ,42,59,60 }, {26,43,27 ,41,60,42 ,42,60,43 },
	{27,43,44 ,42,60,61 ,43,60,61 }, {27,44,28 ,42,61,43 ,43,61,44 },
	{28,44,45 ,43,61,62 ,44,61,62 }, {28,45,29 ,43,62,44 ,44,62,45 },
	{29,45,46 ,44,62,63 ,45,62,63 }, {29,46,30 ,44,63,45 ,45,63,46 },
	{30,46,47 ,45,63,64 ,46,63,64 }, {30,47,31 ,45,64,46 ,46,64,47 },
	{31,47,48 ,46,64,65 ,47,64,65 }, {31,48,32 ,46,65,47 ,47,65,48 },
	{32,48,33 ,47,65,66 ,48,65,66 }, {32,33,17 ,47,67,67 ,48,66,49 },
	{33,49,50 ,50,68,69 ,50,67,68 }, {33,50,34 ,50,69,51 ,50,68,51 },
	{34,50,51 ,51,69,70 ,51,68,69 }, {34,51,35 ,51,70,52 ,51,69,52 },
	{35,51,52 ,52,70,71 ,52,69,70 }, {35,52,36 ,52,71,53 ,52,70,53 },
	{36,52,53 ,53,71,72 ,53,70,71 }, {36,53,37 ,53,72,54 ,53,71,54 },
	{37,53,54 ,54,72,73 ,54,71,72 }, {37,54,38 ,54,73,55 ,54,72,55 },
	{38,54,55 ,55,73,74 ,55,72,73 }, {38,55,39 ,55,74,56 ,55,73,56 },
	{39,55,56 ,56,74,75 ,56,73,74 }, {39,56,40 ,56,75,57 ,56,74,57 },
	{40,56,57 ,57,75,76 ,57,74,75 }, {40,57,41 ,57,76,58 ,57,75,58 },
	{41,57,58 ,58,76,77 ,58,75,76 }, {41,58,42 ,58,77,59 ,58,76,59 },
	{42,58,59 ,59,77,78 ,59,76,77 }, {42,59,43 ,59,78,60 ,59,77,60 },
	{43,59,60 ,60,78,79 ,60,77,78 }, {43,60,44 ,60,79,61 ,60,78,61 },
	{44,60,61 ,61,79,80 ,61,78,79 }, {44,61,45 ,61,80,62 ,61,79,62 },
	{45,61,62 ,62,80,81 ,62,79,80 }, {45,62,46 ,62,81,63 ,62,80,63 },
	{46,62,63 ,63,81,82 ,63,80,81 }, {46,63,47 ,63,82,64 ,63,81,64 },
	{47,63,64 ,64,82,83 ,64,81,82 }, {47,64,48 ,64,83,65 ,64,82,65 },
	{48,64,49 ,65,83,84 ,65,82,83 }, {48,49,33 ,65,85,85 ,65,83,66 },
	{66,65,67 ,86,87,88 ,1,0,2 }, {67,65,68 ,88,89,90 ,2,3,4 }, {68,65,69 ,90,91,92 ,4,5,6 },
	{69,65,70 ,92,93,94 ,6,7,8 }, {70,65,71 ,94,95,96 ,8,9,10 },
	{71,65,72 ,96,97,98 ,10,11,12 }, {72,65,73 ,98,99,100 ,12,13,14 },
	{73,65,74 ,100,101,102 ,14,15,16 }, {74,65,75 ,102,103,104 ,16,17,18 },
	{75,65,76 ,104,105,106 ,18,19,20 }, {76,65,77 ,106,107,108 ,20,21,22 },
	{77,65,78 ,108,109,110 ,22,23,24 }, {78,65,79 ,110,111,112 ,24,25,26 },
	{79,65,80 ,112,113,114 ,26,27,28 }, {80,65,81 ,114,115,116 ,28,29,30 },
	{81,65,66 ,116,117,117 ,30,31,32 }, {82,66,83 ,118,86,119 ,33,1,34 },
	{83,66,67 ,119,86,88 ,34,1,2 }, {83,67,84 ,119,88,120 ,34,2,35 },
	{84,67,68 ,120,88,90 ,35,2,4 }, {84,68,85 ,120,90,121 ,35,4,36 },
	{85,68,69 ,121,90,92 ,36,4,6 }, {85,69,86 ,121,92,122 ,36,6,37 },
	{86,69,70 ,122,92,94 ,37,6,8 }, {86,70,87 ,122,94,123 ,37,8,38 },
	{87,70,71 ,123,94,96 ,38,8,10 }, {87,71,88 ,123,96,124 ,38,10,39 },
	{88,71,72 ,124,96,98 ,39,10,12 }, {88,72,89 ,124,98,125 ,39,12,40 },
	{89,72,73 ,125,98,100 ,40,12,14 }, {89,73,90 ,125,100,126 ,40,14,41 },
	{90,73,74 ,126,100,102 ,41,14,16 }, {90,74,91 ,126,102,127 ,41,16,42 },
	{91,74,75 ,127,102,104 ,42,16,18 }, {91,75,92 ,127,104,128 ,42,18,43 },
	{92,75,76 ,128,104,106 ,43,18,20 }, {92,76,93 ,128,106,129 ,43,20,44 },
	{93,76,77 ,129,106,108 ,44,20,22 }, {93,77,94 ,129,108,130 ,44,22,45 },
	{94,77,78 ,130,108,110 ,45,22,24 }, {94,78,95 ,130,110,131 ,45,24,46 },
	{95,78,79 ,131,110,112 ,46,24,26 }, {95,79,96 ,131,112,132 ,46,26,47 },
	{96,79,80 ,132,112,114 ,47,26,28 }, {96,80,97 ,132,114,133 ,47,28,48 },
	{97,80,81 ,133,114,116 ,48,28,30 }, {97,81,82 ,133,116,134 ,48,30,49 },
	{82,81,66 ,135,116,135 ,49,30,32 }, {98,82,99 ,136,118,137 ,50,33,51 },
	{99,82,83 ,137,118,119 ,51,33,34 }, {99,83,100 ,137,119,138 ,51,34,52 },
	{100,83,84 ,138,119,120 ,52,34,35 }, {100,84,101 ,138,120,139 ,52,35,53 },
	{101,84,85 ,139,120,121 ,53,35,36 }, {101,85,102 ,139,121,140 ,53,36,54 },
	{102,85,86 ,140,121,122 ,54,36,37 }, {102,86,103 ,140,122,141 ,54,37,55 },
	{103,86,87 ,141,122,123 ,55,37,38 }, {103,87,104 ,141,123,142 ,55,38,56 },
	{104,87,88 ,142,123,124 ,56,38,39 }, {104,88,105 ,142,124,143 ,56,39,57 },
	{105,88,89 ,143,124,125 ,57,39,40 }, {105,89,106 ,143,125,144 ,57,40,58 },
	{106,89,90 ,144,125,126 ,58,40,41 }, {106,90,107 ,144,126,145 ,58,41,59 },
	{107,90,91 ,145,126,127 ,59,41,42 }, {107,91,108 ,145,127,146 ,59,42,60 },
	{108,91,92 ,146,127,128 ,60,42,43 }, {108,92,109 ,146,128,147 ,60,43,61 },
	{109,92,93 ,147,128,129 ,61,43,44 }, {109,93,110 ,147,129,148 ,61,44,62 },
	{110,93,94 ,148,129,130 ,62,44,45 }, {110,94,111 ,148,130,149 ,62,45,63 },
	{111,94,95 ,149,130,131 ,63,45,46 }, {111,95,112 ,149,131,150 ,63,46,64 },
	{112,95,96 ,150,131,132 ,64,46,47 }, {112,96,113 ,150,132,151 ,64,47,65 },
	{113,96,97 ,151,132,133 ,65,47,48 }, {113,97,98 ,151,133,152 ,65,48,66 },
	{98,97,82 ,153,133,153 ,66,48,49 }, {114,98,115 ,154,136,155 ,67,50,68 },
	{115,98,99 ,155,136,137 ,68,50,51 }, {115,99,116 ,155,137,156 ,68,51,69 },
	{116,99,100 ,156,137,138 ,69,51,52 }, {116,100,117 ,156,138,157 ,69,52,70 },
	{117,100,101 ,157,138,139 ,70,52,53 }, {117,101,118 ,157,139,158 ,70,53,71 },
	{118,101,102 ,158,139,140 ,71,53,54 }, {118,102,119 ,158,140,159 ,71,54,72 },
	{119,102,103 ,159,140,141 ,72,54,55 }, {119,103,120 ,159,141,160 ,72,55,73 },
	{120,103,104 ,160,141,142 ,73,55,56 }, {120,104,121 ,160,142,161 ,73,56,74 },
	{121,104,105 ,161,142,143 ,74,56,57 }, {121,105,122 ,161,143,162 ,74,57,75 },
	{122,105,106 ,162,143,144 ,75,57,58 }, {122,106,123 ,162,144,163 ,75,58,76 },
	{123,106,107 ,163,144,145 ,76,58,59 }, {123,107,124 ,163,145,164 ,76,59,77 },
	{124,107,108 ,164,145,146 ,77,59,60 }, {124,108,125 ,164,146,165 ,77,60,78 },
	{125,108,109 ,165,146,147 ,78,60,61 }, {125,109,126 ,165,147,166 ,78,61,79 },
	{126,109,110 ,166,147,148 ,79,61,62 }, {126,110,127 ,166,148,167 ,79,62,80 },
	{127,110,111 ,167,148,149 ,80,62,63 }, {127,111,128 ,167,149,168 ,80,63,81 },
	{128,111,112 ,168,149,150 ,81,63,64 }, {128,112,129 ,168,150,169 ,81,64,82 },
	{129,112,113 ,169,150,151 ,82,64,65 }, {129,113,114 ,169,151,170 ,82,65,83 },
	{114,113,98 ,171,151,171 ,83,65,66 }
// Object #-1
	, {130,131,132 ,172,173,174 ,0,1,2 }, {130,132,133 ,175,174,176 ,3,2,4 },
	{130,133,134 ,177,176,178 ,5,4,6 }, {130,134,135 ,179,178,180 ,7,6,8 },
	{130,135,136 ,181,180,182 ,9,8,10 }, {130,136,137 ,183,182,184 ,11,10,12 },
	{130,137,138 ,185,184,186 ,13,12,14 }, {130,138,139 ,187,186,188 ,15,14,16 },
	{130,139,140 ,189,188,190 ,17,16,18 }, {130,140,141 ,191,190,192 ,19,18,20 },
	{130,141,142 ,193,192,194 ,21,20,22 }, {130,142,143 ,195,194,196 ,23,22,24 },
	{130,143,144 ,197,196,198 ,25,24,26 }, {130,144,145 ,199,198,200 ,27,26,28 },
	{130,145,146 ,201,200,202 ,29,28,30 }, {130,146,131 ,203,202,203 ,31,30,32 },
	{131,147,148 ,173,204,205 ,1,33,34 }, {131,148,132 ,173,205,174 ,1,34,2 },
	{132,148,149 ,174,205,206 ,2,34,35 }, {132,149,133 ,174,206,176 ,2,35,4 },
	{133,149,150 ,176,206,207 ,4,35,36 }, {133,150,134 ,176,207,178 ,4,36,6 },
	{134,150,151 ,178,207,208 ,6,36,37 }, {134,151,135 ,178,208,180 ,6,37,8 },
	{135,151,152 ,180,208,209 ,8,37,38 }, {135,152,136 ,180,209,182 ,8,38,10 },
	{136,152,153 ,182,209,210 ,10,38,39 }, {136,153,137 ,182,210,184 ,10,39,12 },
	{137,153,154 ,184,210,211 ,12,39,40 }, {137,154,138 ,184,211,186 ,12,40,14 },
	{138,154,155 ,186,211,212 ,14,40,41 }, {138,155,139 ,186,212,188 ,14,41,16 },
	{139,155,156 ,188,212,213 ,16,41,42 }, {139,156,140 ,188,213,190 ,16,42,18 },
	{140,156,157 ,190,213,214 ,18,42,43 }, {140,157,141 ,190,214,192 ,18,43,20 },
	{141,157,158 ,192,214,215 ,20,43,44 }, {141,158,142 ,192,215,194 ,20,44,22 },
	{142,158,159 ,194,215,216 ,22,44,45 }, {142,159,143 ,194,216,196 ,22,45,24 },
	{143,159,160 ,196,216,217 ,24,45,46 }, {143,160,144 ,196,217,198 ,24,46,26 },
	{144,160,161 ,198,217,218 ,26,46,47 }, {144,161,145 ,198,218,200 ,26,47,28 },
	{145,161,162 ,200,218,219 ,28,47,48 }, {145,162,146 ,200,219,202 ,28,48,30 },
	{146,162,147 ,202,219,220 ,30,48,49 }, {146,147,131 ,202,221,221 ,30,49,32 },
	{147,163,164 ,204,222,223 ,33,50,51 }, {147,164,148 ,204,223,205 ,33,51,34 },
	{148,164,165 ,205,223,224 ,34,51,52 }, {148,165,149 ,205,224,206 ,34,52,35 },
	{149,165,166 ,206,224,225 ,35,52,53 }, {149,166,150 ,206,225,207 ,35,53,36 },
	{150,166,167 ,207,225,226 ,36,53,54 }, {150,167,151 ,207,226,208 ,36,54,37 },
	{151,167,168 ,208,226,227 ,37,54,55 }, {151,168,152 ,208,227,209 ,37,55,38 },
	{152,168,169 ,209,227,228 ,38,55,56 }, {152,169,153 ,209,228,210 ,38,56,39 },
	{153,169,170 ,210,228,229 ,39,56,57 }, {153,170,154 ,210,229,211 ,39,57,40 },
	{154,170,171 ,211,229,230 ,40,57,58 }, {154,171,155 ,211,230,212 ,40,58,41 },
	{155,171,172 ,212,230,231 ,41,58,59 }, {155,172,156 ,212,231,213 ,41,59,42 },
	{156,172,173 ,213,231,232 ,42,59,60 }, {156,173,157 ,213,232,214 ,42,60,43 },
	{157,173,174 ,214,232,233 ,43,60,61 }, {157,174,158 ,214,233,215 ,43,61,44 },
	{158,174,175 ,215,233,234 ,44,61,62 }, {158,175,159 ,215,234,216 ,44,62,45 },
	{159,175,176 ,216,234,235 ,45,62,63 }, {159,176,160 ,216,235,217 ,45,63,46 },
	{160,176,177 ,217,235,236 ,46,63,64 }, {160,177,161 ,217,236,218 ,46,64,47 },
	{161,177,178 ,218,236,237 ,47,64,65 }, {161,178,162 ,218,237,219 ,47,65,48 },
	{162,178,163 ,219,237,238 ,48,65,66 }, {162,163,147 ,219,239,239 ,48,66,49 },
	{163,179,180 ,222,240,241 ,50,67,68 }, {163,180,164 ,222,241,223 ,50,68,51 },
	{164,180,181 ,223,241,242 ,51,68,69 }, {164,181,165 ,223,242,224 ,51,69,52 },
	{165,181,182 ,224,242,243 ,52,69,70 }, {165,182,166 ,224,243,225 ,52,70,53 },
	{166,182,183 ,225,243,244 ,53,70,71 }, {166,183,167 ,225,244,226 ,53,71,54 },
	{167,183,184 ,226,244,245 ,54,71,72 }, {167,184,168 ,226,245,227 ,54,72,55 },
	{168,184,185 ,227,245,246 ,55,72,73 }, {168,185,169 ,227,246,228 ,55,73,56 },
	{169,185,186 ,228,246,247 ,56,73,74 }, {169,186,170 ,228,247,229 ,56,74,57 },
	{170,186,187 ,229,247,248 ,57,74,75 }, {170,187,171 ,229,248,230 ,57,75,58 },
	{171,187,188 ,230,248,249 ,58,75,76 }, {171,188,172 ,230,249,231 ,58,76,59 },
	{172,188,189 ,231,249,250 ,59,76,77 }, {172,189,173 ,231,250,232 ,59,77,60 },
	{173,189,190 ,232,250,251 ,60,77,78 }, {173,190,174 ,232,251,233 ,60,78,61 },
	{174,190,191 ,233,251,252 ,61,78,79 }, {174,191,175 ,233,252,234 ,61,79,62 },
	{175,191,192 ,234,252,253 ,62,79,80 }, {175,192,176 ,234,253,235 ,62,80,63 },
	{176,192,193 ,235,253,254 ,63,80,81 }, {176,193,177 ,235,254,236 ,63,81,64 },
	{177,193,194 ,236,254,255 ,64,81,82 }, {177,194,178 ,236,255,237 ,64,82,65 },
	{178,194,179 ,237,255,256 ,65,82,83 }, {178,179,163 ,237,257,257 ,65,83,66 },
	{196,195,197 ,258,259,260 ,1,0,2 }, {197,195,198 ,260,261,262 ,2,3,4 },
	{198,195,199 ,262,263,264 ,4,5,6 }, {199,195,200 ,264,265,266 ,6,7,8 },
	{200,195,201 ,266,267,268 ,8,9,10 }, {201,195,202 ,268,269,270 ,10,11,12 },
	{202,195,203 ,270,271,272 ,12,13,14 }, {203,195,204 ,272,273,274 ,14,15,16 },
	{204,195,205 ,274,275,276 ,16,17,18 }, {205,195,206 ,276,277,278 ,18,19,20 },
	{206,195,207 ,278,279,280 ,20,21,22 }, {207,195,208 ,280,281,282 ,22,23,24 },
	{208,195,209 ,282,283,284 ,24,25,26 }, {209,195,210 ,284,285,286 ,26,27,28 },
	{210,195,211 ,286,287,288 ,28,29,30 }, {211,195,196 ,288,289,289 ,30,31,32 },
	{212,196,213 ,290,258,291 ,33,1,34 }, {213,196,197 ,291,258,260 ,34,1,2 },
	{213,197,214 ,291,260,292 ,34,2,35 }, {214,197,198 ,292,260,262 ,35,2,4 },
	{214,198,215 ,292,262,293 ,35,4,36 }, {215,198,199 ,293,262,264 ,36,4,6 },
	{215,199,216 ,293,264,294 ,36,6,37 }, {216,199,200 ,294,264,266 ,37,6,8 },
	{216,200,217 ,294,266,295 ,37,8,38 }, {217,200,201 ,295,266,268 ,38,8,10 },
	{217,201,218 ,295,268,296 ,38,10,39 }, {218,201,202 ,296,268,270 ,39,10,12 },
	{218,202,219 ,296,270,297 ,39,12,40 }, {219,202,203 ,297,270,272 ,40,12,14 },
	{219,203,220 ,297,272,298 ,40,14,41 }, {220,203,204 ,298,272,274 ,41,14,16 },
	{220,204,221 ,298,274,299 ,41,16,42 }, {221,204,205 ,299,274,276 ,42,16,18 },
	{221,205,222 ,299,276,300 ,42,18,43 }, {222,205,206 ,300,276,278 ,43,18,20 },
	{222,206,223 ,300,278,301 ,43,20,44 }, {223,206,207 ,301,278,280 ,44,20,22 },
	{223,207,224 ,301,280,302 ,44,22,45 }, {224,207,208 ,302,280,282 ,45,22,24 },
	{224,208,225 ,302,282,303 ,45,24,46 }, {225,208,209 ,303,282,284 ,46,24,26 },
	{225,209,226 ,303,284,304 ,46,26,47 }, {226,209,210 ,304,284,286 ,47,26,28 },
	{226,210,227 ,304,286,305 ,47,28,48 }, {227,210,211 ,305,286,288 ,48,28,30 },
	{227,211,212 ,305,288,306 ,48,30,49 }, {212,211,196 ,307,288,307 ,49,30,32 },
	{228,212,229 ,308,290,309 ,50,33,51 }, {229,212,213 ,309,290,291 ,51,33,34 },
	{229,213,230 ,309,291,310 ,51,34,52 }, {230,213,214 ,310,291,292 ,52,34,35 },
	{230,214,231 ,310,292,311 ,52,35,53 }, {231,214,215 ,311,292,293 ,53,35,36 },
	{231,215,232 ,311,293,312 ,53,36,54 }, {232,215,216 ,312,293,294 ,54,36,37 },
	{232,216,233 ,312,294,313 ,54,37,55 }, {233,216,217 ,313,294,295 ,55,37,38 },
	{233,217,234 ,313,295,314 ,55,38,56 }, {234,217,218 ,314,295,296 ,56,38,39 },
	{234,218,235 ,314,296,315 ,56,39,57 }, {235,218,219 ,315,296,297 ,57,39,40 },
	{235,219,236 ,315,297,316 ,57,40,58 }, {236,219,220 ,316,297,298 ,58,40,41 },
	{236,220,237 ,316,298,317 ,58,41,59 }, {237,220,221 ,317,298,299 ,59,41,42 },
	{237,221,238 ,317,299,318 ,59,42,60 }, {238,221,222 ,318,299,300 ,60,42,43 },
	{238,222,239 ,318,300,319 ,60,43,61 }, {239,222,223 ,319,300,301 ,61,43,44 },
	{239,223,240 ,319,301,320 ,61,44,62 }, {240,223,224 ,320,301,302 ,62,44,45 },
	{240,224,241 ,320,302,321 ,62,45,63 }, {241,224,225 ,321,302,303 ,63,45,46 },
	{241,225,242 ,321,303,322 ,63,46,64 }, {242,225,226 ,322,303,304 ,64,46,47 },
	{242,226,243 ,322,304,323 ,64,47,65 }, {243,226,227 ,323,304,305 ,65,47,48 },
	{243,227,228 ,323,305,324 ,65,48,66 }, {228,227,212 ,325,305,325 ,66,48,49 },
	{244,228,245 ,326,308,327 ,67,50,68 }, {245,228,229 ,327,308,309 ,68,50,51 },
	{245,229,246 ,327,309,328 ,68,51,69 }, {246,229,230 ,328,309,310 ,69,51,52 },
	{246,230,247 ,328,310,329 ,69,52,70 }, {247,230,231 ,329,310,311 ,70,52,53 },
	{247,231,248 ,329,311,330 ,70,53,71 }, {248,231,232 ,330,311,312 ,71,53,54 },
	{248,232,249 ,330,312,331 ,71,54,72 }, {249,232,233 ,331,312,313 ,72,54,55 },
	{249,233,250 ,331,313,332 ,72,55,73 }, {250,233,234 ,332,313,314 ,73,55,56 },
	{250,234,251 ,332,314,333 ,73,56,74 }, {251,234,235 ,333,314,315 ,74,56,57 },
	{251,235,252 ,333,315,334 ,74,57,75 }, {252,235,236 ,334,315,316 ,75,57,58 },
	{252,236,253 ,334,316,335 ,75,58,76 }, {253,236,237 ,335,316,317 ,76,58,59 },
	{253,237,254 ,335,317,336 ,76,59,77 }, {254,237,238 ,336,317,318 ,77,59,60 },
	{254,238,255 ,336,318,337 ,77,60,78 }, {255,238,239 ,337,318,319 ,78,60,61 },
	{255,239,256 ,337,319,338 ,78,61,79 }, {256,239,240 ,338,319,320 ,79,61,62 },
	{256,240,257 ,338,320,339 ,79,62,80 }, {257,240,241 ,339,320,321 ,80,62,63 },
	{257,241,258 ,339,321,340 ,80,63,81 }, {258,241,242 ,340,321,322 ,81,63,64 },
	{258,242,259 ,340,322,341 ,81,64,82 }, {259,242,243 ,341,322,323 ,82,64,65 },
	{259,243,244 ,341,323,342 ,82,65,83 }, {244,243,228 ,343,323,343 ,83,65,66 }
}

};


static GLfloat vertices [NUM_LIDS][260][3] = {

//lid 10
{
{-0.343683f,0.0932276f,-0.0808442f},{-0.352388f,0.0509511f,-0.122382f},{-0.380222f,0.053445f,-0.125489f},
{-0.402561f,0.0605469f,-0.120347f},{-0.41485f,0.0711757f,-0.107383f},{-0.414844f,0.0837132f,-0.0888708f},
{-0.403224f,0.0962507f,-0.0683421f},{-0.382806f,0.10688f,-0.0494748f},{-0.357221f,0.113981f,-0.0351177f},
{-0.330137f,0.116475f,-0.0269877f},{-0.305195f,0.113981f,-0.0259064f},{-0.285916f,0.10688f,-0.0319369f},
{-0.27509f,0.0962508f,-0.0441779f},{-0.274086f,0.0837133f,-0.0607215f},{-0.282788f,0.0711757f,-0.0791407f},
{-0.300108f,0.0605469f,-0.0970521f},{-0.324256f,0.053445f,-0.112215f},{-0.353956f,-0.00391801f,-0.143495f},
{-0.406556f,0.000690078f,-0.149706f},{-0.44962f,0.0138127f,-0.140053f},{-0.472019f,0.0334522f,-0.114869f},
{-0.469142f,0.0566185f,-0.0792073f},{-0.444738f,0.0797848f,-0.0411625f},{-0.406781f,0.0994242f,-0.0083254f},
{-0.361986f,0.112547f,0.0151765f},{-0.314714f,0.117155f,0.0283778f},{-0.269974f,0.112547f,0.0305063f},
{-0.235063f,0.0994242f,0.0199389f},{-0.216662f,0.0797847f,-0.00294113f},{-0.2168f,0.0566185f,-0.0337662f},
{-0.233011f,0.0334521f,-0.0667812f},{-0.262346f,0.0138127f,-0.0980229f},{-0.303477f,0.000690076f,-0.124775f},
{-0.349115f,-0.0630264f,-0.141198f},{-0.416647f,-0.0570057f,-0.146593f},{-0.471994f,-0.0398601f,-0.131983f},
{-0.499332f,-0.0142f,-0.098174f},{-0.492887f,0.0160683f,-0.0523413f},{-0.459889f,0.0463366f,-0.00548934f},
{-0.412508f,0.0719967f,0.0330037f},{-0.358013f,0.0891423f,0.0598819f},{-0.298752f,0.095163f,0.0764664f},
{-0.239999f,0.0891423f,0.0816282f},{-0.193576f,0.0719967f,0.0698183f},{-0.171052f,0.0463365f,0.0391026f},
{-0.174628f,0.0160682f,-0.00326448f},{-0.197804f,-0.0142f,-0.0471786f},{-0.234863f,-0.0398601f,-0.0869477f},
{-0.285586f,-0.0570057f,-0.119624f},{-0.340812f,-0.117375f,-0.116494f},{-0.410435f,-0.110859f,-0.117365f},
{-0.466555f,-0.0923004f,-0.0986838f},{-0.493515f,-0.064526f,-0.0625363f},{-0.486108f,-0.0317639f,-0.0165297f},
{-0.452382f,0.000998166f,0.0289768f},{-0.404425f,0.0287725f,0.0661753f},{-0.348021f,0.0473308f,0.0935464f},
{-0.284297f,0.0538476f,0.113032f},{-0.219522f,0.0473308f,0.121693f},{-0.16847f,0.0287725f,0.110644f},
{-0.145166f,0.000998132f,0.0764654f},{-0.151592f,-0.031764f,0.0281869f},{-0.178972f,-0.0645261f,-0.0214156f},
{-0.219936f,-0.0923004f,-0.0648312f},{-0.274181f,-0.110859f,-0.0978641f},{0.343683f,0.0932276f,-0.0808442f},
{0.352388f,0.0509511f,-0.122382f},{0.380222f,0.053445f,-0.125489f},{0.402561f,0.0605469f,-0.120347f},
{0.41485f,0.0711757f,-0.107383f},{0.414844f,0.0837132f,-0.0888707f},{0.403224f,0.0962508f,-0.0683421f},
{0.382806f,0.10688f,-0.0494748f},{0.357221f,0.113981f,-0.0351177f},{0.330137f,0.116475f,-0.0269877f},
{0.305195f,0.113981f,-0.0259064f},{0.285916f,0.10688f,-0.0319369f},{0.27509f,0.0962508f,-0.0441779f},
{0.274086f,0.0837133f,-0.0607215f},{0.282788f,0.0711757f,-0.0791407f},{0.300108f,0.0605469f,-0.0970521f},
{0.324257f,0.053445f,-0.112215f},{0.353956f,-0.003918f,-0.143495f},{0.406556f,0.000690089f,-0.149706f},
{0.44962f,0.0138127f,-0.140053f},{0.472019f,0.0334522f,-0.114869f},{0.469142f,0.0566185f,-0.0792073f},
{0.444738f,0.0797848f,-0.0411625f},{0.406781f,0.0994242f,-0.0083254f},{0.361986f,0.112547f,0.0151765f},
{0.314714f,0.117155f,0.0283778f},{0.269974f,0.112547f,0.0305063f},{0.235063f,0.0994242f,0.0199389f},
{0.216662f,0.0797848f,-0.00294113f},{0.2168f,0.0566185f,-0.0337662f},{0.233011f,0.0334521f,-0.0667812f},
{0.262346f,0.0138127f,-0.0980229f},{0.303477f,0.000690081f,-0.124775f},{0.349115f,-0.0630264f,-0.141198f},
{0.416647f,-0.0570057f,-0.146593f},{0.471994f,-0.0398601f,-0.131983f},{0.499332f,-0.0142f,-0.098174f},
{0.492887f,0.0160683f,-0.0523413f},{0.45989f,0.0463366f,-0.00548934f},{0.412508f,0.0719967f,0.0330037f},
{0.358013f,0.0891423f,0.0598819f},{0.298752f,0.095163f,0.0764664f},{0.239999f,0.0891423f,0.0816282f},
{0.193576f,0.0719967f,0.0698183f},{0.171052f,0.0463365f,0.0391026f},{0.174629f,0.0160683f,-0.00326448f},
{0.197804f,-0.0141999f,-0.0471786f},{0.234863f,-0.0398601f,-0.0869477f},{0.285586f,-0.0570057f,-0.119624f},
{0.340812f,-0.117375f,-0.116494f},{0.410435f,-0.110859f,-0.117365f},{0.466555f,-0.0923004f,-0.0986838f},
{0.493515f,-0.064526f,-0.0625363f},{0.486108f,-0.0317639f,-0.0165297f},{0.452382f,0.000998165f,0.0289768f},
{0.404425f,0.0287725f,0.0661753f},{0.348021f,0.0473308f,0.0935464f},{0.284297f,0.0538476f,0.113032f},
{0.219522f,0.0473308f,0.121693f},{0.16847f,0.0287725f,0.110644f},{0.145166f,0.000998129f,0.0764654f},
{0.151592f,-0.031764f,0.0281869f},{0.178973f,-0.0645261f,-0.0214156f},{0.219936f,-0.0923004f,-0.0648312f},
{0.274181f,-0.110859f,-0.0978641f},{-0.299079f,0.0958282f,0.075584f},{-0.31504f,0.117375f,0.0272876f},
{-0.338602f,0.114996f,0.0266701f},{-0.355762f,0.10822f,0.0331344f},{-0.363792f,0.0980784f,0.0452518f},
{-0.361929f,0.0861159f,0.0605897f},{-0.351081f,0.0741534f,0.0766588f},{-0.333006f,0.0640121f,0.0915983f},
{-0.309891f,0.0572358f,0.104011f},{-0.284547f,0.0548563f,0.112407f},{-0.260658f,0.0572358f,0.115136f},
{-0.24234f,0.064012f,0.111029f},{-0.232993f,0.0741534f,0.100179f},{-0.234196f,0.0861159f,0.0842273f},
{-0.245435f,0.0980784f,0.0659791f},{-0.264676f,0.10822f,0.0486193f},{-0.289045f,0.114996f,0.0350069f},
{-0.330443f,0.116217f,-0.0281498f},{-0.376622f,0.111821f,-0.0296334f},{-0.409825f,0.0992999f,-0.0162356f},
{-0.423182f,0.0805612f,0.00924655f},{-0.416791f,0.0584573f,0.0400915f},{-0.395343f,0.0363535f,0.0700464f},
{-0.363257f,0.0176148f,0.0966719f},{-0.322911f,0.00509398f,0.119456f},{-0.27691f,0.000697269f,0.136065f},
{-0.231205f,0.00509398f,0.142105f},{-0.19511f,0.0176148f,0.134121f},{-0.177144f,0.0363535f,0.112203f},
{-0.180418f,0.0584574f,0.0803985f},{-0.202116f,0.0805612f,0.0450649f},{-0.237155f,0.0992999f,0.0123635f},
{-0.281386f,0.111821f,-0.0131619f},{-0.343923f,0.0925307f,-0.0818601f},{-0.408753f,0.0867861f,-0.0862252f},
{-0.455729f,0.0704268f,-0.0684926f},{-0.472454f,0.0459435f,-0.0315206f},{-0.46048f,0.0170635f,0.0132626f},
{-0.429943f,-0.0118166f,0.0551654f},{-0.388862f,-0.0362999f,0.0913457f},{-0.339208f,-0.0526592f,0.122215f},
{-0.281228f,-0.0584037f,0.14396f},{-0.220778f,-0.0526591f,0.149706f},{-0.17139f,-0.0362999f,0.135578f},
{-0.146815f,-0.0118166f,0.103441f},{-0.151526f,0.0170635f,0.0600771f},{-0.179724f,0.0459436f,0.0142591f},
{-0.223279f,0.0704269f,-0.0271356f},{-0.278744f,0.0867861f,-0.0603045f},{-0.352496f,0.0499212f,-0.123042f},
{-0.425996f,0.0437033f,-0.130422f},{-0.480485f,0.0259961f,-0.111688f},{-0.5f,-0.000504367f,-0.0691896f},
{-0.486108f,-0.0317639f,-0.0165297f},{-0.451623f,-0.0630235f,0.0331431f},{-0.407178f,-0.0895241f,0.0757201f},
{-0.355434f,-0.107231f,0.110467f},{-0.295211f,-0.113449f,0.132021f},{-0.230886f,-0.107231f,0.133409f},
{-0.176698f,-0.089524f,0.11295f},{-0.148448f,-0.0630235f,0.0751234f},{-0.151592f,-0.0317639f,0.0281869f},
{-0.179627f,-0.000504385f,-0.0191356f},{-0.223715f,0.0259962f,-0.061618f},{-0.281467f,0.0437033f,-0.0973949f},
{0.299079f,0.0958282f,0.075584f},{0.31504f,0.117375f,0.0272877f},{0.338602f,0.114996f,0.0266701f},
{0.355762f,0.10822f,0.0331344f},{0.363792f,0.0980784f,0.0452518f},{0.361929f,0.0861159f,0.0605897f},
{0.351081f,0.0741534f,0.0766588f},{0.333006f,0.0640121f,0.0915983f},{0.309891f,0.0572358f,0.104011f},
{0.284547f,0.0548563f,0.112407f},{0.260658f,0.0572358f,0.115136f},{0.24234f,0.064012f,0.111029f},
{0.232993f,0.0741534f,0.100179f},{0.234196f,0.0861159f,0.0842273f},{0.245435f,0.0980784f,0.0659791f},
{0.264676f,0.10822f,0.0486193f},{0.289045f,0.114996f,0.0350069f},{0.330443f,0.116217f,-0.0281497f},
{0.376622f,0.111821f,-0.0296334f},{0.409825f,0.0992999f,-0.0162356f},{0.423182f,0.0805612f,0.00924655f},
{0.416791f,0.0584573f,0.0400915f},{0.395343f,0.0363535f,0.0700464f},{0.363257f,0.0176148f,0.0966719f},
{0.322912f,0.00509398f,0.119456f},{0.27691f,0.000697269f,0.136065f},{0.231205f,0.00509397f,0.142105f},
{0.19511f,0.0176148f,0.134121f},{0.177144f,0.0363535f,0.112203f},{0.180418f,0.0584574f,0.0803985f},
{0.202116f,0.0805612f,0.0450649f},{0.237155f,0.0992999f,0.0123635f},{0.281386f,0.111821f,-0.0131619f},
{0.343923f,0.0925307f,-0.0818601f},{0.408753f,0.0867861f,-0.0862252f},{0.455729f,0.0704268f,-0.0684926f},
{0.472454f,0.0459435f,-0.0315206f},{0.46048f,0.0170635f,0.0132626f},{0.429943f,-0.0118166f,0.0551654f},
{0.388862f,-0.0362999f,0.0913457f},{0.339208f,-0.0526592f,0.122215f},{0.281228f,-0.0584037f,0.14396f},
{0.220778f,-0.0526591f,0.149706f},{0.17139f,-0.0362999f,0.135578f},{0.146815f,-0.0118166f,0.103441f},
{0.151526f,0.0170635f,0.0600771f},{0.179724f,0.0459436f,0.0142591f},{0.223279f,0.0704269f,-0.0271356f},
{0.278744f,0.0867861f,-0.0603045f},{0.352496f,0.0499212f,-0.123042f},{0.425996f,0.0437033f,-0.130422f},
{0.480485f,0.0259961f,-0.111688f},{0.5f,-0.000504367f,-0.0691896f},{0.486108f,-0.0317639f,-0.0165297f},
{0.451623f,-0.0630235f,0.0331431f},{0.407178f,-0.0895241f,0.0757201f},{0.355434f,-0.107231f,0.110467f},
{0.295211f,-0.113449f,0.132021f},{0.230887f,-0.107231f,0.133409f},{0.176698f,-0.089524f,0.11295f},
{0.148448f,-0.0630235f,0.0751234f},{0.151592f,-0.0317639f,0.0281869f},{0.179627f,-0.000504385f,-0.0191356f},
{0.223715f,0.0259962f,-0.061618f},{0.281467f,0.0437033f,-0.0973949f}
},

//lid 9
{
{-0.3488f,0.0865926f,-0.0971807f},{-0.355149f,0.0384448f,-0.131394f},{-0.383397f,0.0414699f,-0.135249f},
{-0.406599f,0.050085f,-0.131759f},{-0.420077f,0.0629783f,-0.121066f},{-0.421253f,0.078187f,-0.104942f},
{-0.410423f,0.0933956f,-0.0864117f},{-0.390209f,0.106289f,-0.0688549f},{-0.364329f,0.114904f,-0.0550734f},
{-0.336691f,0.117929f,-0.0468607f},{-0.311134f,0.114904f,-0.045088f},{-0.29125f,0.106289f,-0.0498234f},
{-0.279811f,0.0933956f,-0.0602377f},{-0.278177f,0.078187f,-0.0746586f},{-0.286279f,0.0629783f,-0.0910166f},
{-0.303118f,0.050085f,-0.107269f},{-0.326994f,0.04147f,-0.12142f},{-0.354272f,-0.0191842f,-0.143262f},
{-0.406923f,-0.0135943f,-0.150064f},{-0.45107f,0.00232414f,-0.143143f},{-0.475731f,0.0261478f,-0.122366f},
{-0.475481f,0.0542498f,-0.0914424f},{-0.452868f,0.0823518f,-0.0571111f},{-0.415338f,0.106175f,-0.0264407f},
{-0.370037f,0.122094f,-0.00389177f},{-0.322023f,0.127684f,0.00912666f},{-0.276588f,0.122094f,0.0118882f},
{-0.240895f,0.106175f,0.00314799f},{-0.22145f,0.0823517f,-0.0166116f},{-0.220325f,0.0542497f,-0.0435621f},
{-0.235311f,0.0261478f,-0.0728357f},{-0.26371f,0.00232414f,-0.101058f},{-0.304208f,-0.0135943f,-0.125642f},
{-0.347807f,-0.0775208f,-0.131687f},{-0.414577f,-0.0702173f,-0.13703f},{-0.470347f,-0.0494188f,-0.125525f},
{-0.5f,-0.0182916f,-0.0974381f},{-0.496833f,0.0184253f,-0.0578607f},{-0.466347f,0.0551422f,-0.0157821f},
{-0.420001f,0.0862694f,0.0198636f},{-0.365715f,0.107068f,0.0450127f},{-0.306476f,0.114371f,0.0605497f},
{-0.247349f,0.107068f,0.0659861f},{-0.19973f,0.0862694f,0.056531f},{-0.175301f,0.0551422f,0.0300508f},
{-0.176868f,0.0184253f,-0.00730101f},{-0.198555f,-0.0182916f,-0.0466047f},{-0.234831f,-0.0494188f,-0.0826403f},
{-0.28505f,-0.0702173f,-0.112264f},{-0.338949f,-0.127684f,-0.0988612f},{-0.407241f,-0.119779f,-0.0997776f},
{-0.462866f,-0.0972665f,-0.0844077f},{-0.491146f,-0.0635747f,-0.0543019f},{-0.486365f,-0.0238325f,-0.0148972f},
{-0.455136f,0.0159096f,0.0254358f},{-0.408856f,0.0496013f,0.059075f},{-0.353684f,0.0721135f,0.0836812f},
{-0.290783f,0.0800187f,0.101396f},{-0.22564f,0.0721136f,0.110631f},{-0.172661f,0.0496013f,0.10308f},
{-0.146696f,0.0159096f,0.0741784f},{-0.151058f,-0.0238325f,0.0313679f},{-0.177696f,-0.0635748f,-0.0133948f},
{-0.218854f,-0.0972665f,-0.0527407f},{-0.273153f,-0.119779f,-0.0824408f},{0.3488f,0.0865926f,-0.0971807f},
{0.355149f,0.0384448f,-0.131394f},{0.383397f,0.04147f,-0.135249f},{0.406599f,0.050085f,-0.131759f},
{0.420077f,0.0629783f,-0.121066f},{0.421253f,0.078187f,-0.104942f},{0.410423f,0.0933956f,-0.0864117f},
{0.390209f,0.106289f,-0.0688549f},{0.364329f,0.114904f,-0.0550734f},{0.336691f,0.117929f,-0.0468607f},
{0.311134f,0.114904f,-0.045088f},{0.29125f,0.106289f,-0.0498234f},{0.279811f,0.0933956f,-0.0602376f},
{0.278177f,0.078187f,-0.0746586f},{0.286279f,0.0629783f,-0.0910166f},{0.303118f,0.050085f,-0.107269f},
{0.326994f,0.04147f,-0.12142f},{0.354272f,-0.0191842f,-0.143262f},{0.406923f,-0.0135943f,-0.150064f},
{0.451071f,0.00232424f,-0.143143f},{0.475731f,0.0261478f,-0.122366f},{0.475482f,0.0542498f,-0.0914424f},
{0.452868f,0.0823518f,-0.0571111f},{0.415338f,0.106175f,-0.0264407f},{0.370037f,0.122094f,-0.00389177f},
{0.322023f,0.127684f,0.00912666f},{0.276589f,0.122094f,0.0118882f},{0.240895f,0.106175f,0.00314799f},
{0.22145f,0.0823517f,-0.0166116f},{0.220325f,0.0542497f,-0.0435621f},{0.235311f,0.0261478f,-0.0728357f},
{0.26371f,0.00232414f,-0.101058f},{0.304208f,-0.0135943f,-0.125642f},{0.347807f,-0.0775207f,-0.131687f},
{0.414577f,-0.0702173f,-0.13703f},{0.470347f,-0.0494188f,-0.125525f},{0.5f,-0.0182916f,-0.0974381f},
{0.496833f,0.0184253f,-0.0578607f},{0.466347f,0.0551422f,-0.0157821f},{0.420001f,0.0862695f,0.0198636f},
{0.365715f,0.107068f,0.0450127f},{0.306476f,0.114371f,0.0605497f},{0.247349f,0.107068f,0.0659861f},
{0.19973f,0.0862694f,0.056531f},{0.175301f,0.0551422f,0.0300508f},{0.176868f,0.0184253f,-0.00730098f},
{0.198555f,-0.0182916f,-0.0466047f},{0.234831f,-0.0494188f,-0.0826403f},{0.28505f,-0.0702173f,-0.112264f},
{0.338949f,-0.127684f,-0.0988612f},{0.407241f,-0.119779f,-0.0997776f},{0.462866f,-0.0972665f,-0.0844077f},
{0.491147f,-0.0635747f,-0.0543019f},{0.486365f,-0.0238325f,-0.0148972f},{0.455136f,0.0159096f,0.0254358f},
{0.408856f,0.0496013f,0.059075f},{0.353684f,0.0721135f,0.0836812f},{0.290783f,0.0800187f,0.101396f},
{0.22564f,0.0721136f,0.110631f},{0.172661f,0.0496013f,0.10308f},{0.146696f,0.0159096f,0.0741784f},
{0.151058f,-0.0238325f,0.0313679f},{0.177696f,-0.0635748f,-0.0133948f},{0.218854f,-0.0972665f,-0.0527407f},
{0.273153f,-0.119779f,-0.0824408f},{-0.297829f,0.0980529f,0.0842386f},{-0.313667f,0.123265f,0.038132f},
{-0.33705f,0.120639f,0.0372689f},{-0.354056f,0.113163f,0.0431301f},{-0.362066f,0.101974f,0.0543168f},
{-0.36034f,0.0887749f,0.0685476f},{-0.349711f,0.0755762f,0.0835722f},{-0.331827f,0.064387f,0.0977591f},
{-0.308798f,0.0569104f,0.109844f},{-0.283419f,0.0542851f,0.118356f},{-0.2594f,0.0569105f,0.121591f},
{-0.240924f,0.0643869f,0.11828f},{-0.231469f,0.0755762f,0.108374f},{-0.232666f,0.0887749f,0.0933521f},
{-0.243995f,0.101974f,0.0758818f},{-0.26335f,0.113163f,0.0590793f},{-0.28776f,0.120639f,0.0457874f},
{-0.328873f,0.126082f,-0.0164282f},{-0.374561f,0.121231f,-0.0180109f},{-0.407332f,0.107417f,-0.00547944f},
{-0.420692f,0.0867414f,0.0183273f},{-0.414793f,0.0623534f,0.0470197f},{-0.394038f,0.0379655f,0.0749315f},
{-0.362508f,0.0172904f,0.100144f},{-0.322425f,0.00347572f,0.122329f},{-0.276379f,-0.00137538f,0.139072f},
{-0.230358f,0.00347572f,0.145889f},{-0.193783f,0.0172904f,0.139267f},{-0.175374f,0.0379654f,0.119083f},
{-0.17845f,0.0623534f,0.0889719f},{-0.200266f,0.0867414f,0.05494f},{-0.235598f,0.107417f,0.0231068f},
{-0.280002f,0.121231f,-0.00181462f},{-0.342729f,0.106077f,-0.0712325f},{-0.40707f,0.0997385f,-0.0755093f},
{-0.453559f,0.0816888f,-0.0588285f},{-0.470324f,0.0546754f,-0.0239743f},{-0.459008f,0.022811f,0.0181521f},
{-0.42934f,-0.00905347f,0.0575822f},{-0.3889f,-0.0360667f,0.0920333f},{-0.339532f,-0.0541165f,0.122036f},
{-0.28154f,-0.0604547f,0.143658f},{-0.220773f,-0.0541165f,0.150064f},{-0.170787f,-0.0360668f,0.137505f},
{-0.14554f,-0.00905347f,0.107605f},{-0.149815f,0.022811f,0.0664637f},{-0.177993f,0.0546754f,0.0222531f},
{-0.221855f,0.0816888f,-0.0181252f},{-0.277621f,0.0997385f,-0.05043f},{-0.352579f,0.0662937f,-0.115311f},
{-0.426014f,0.0594332f,-0.122827f},{-0.480338f,0.0398963f,-0.10543f},{-0.499898f,0.0106573f,-0.065114f},
{-0.486365f,-0.0238325f,-0.0148973f},{-0.452313f,-0.0583224f,0.0325481f},{-0.408062f,-0.0875614f,0.0734018f},
{-0.356245f,-0.107098f,0.107029f},{-0.295864f,-0.113959f,0.128165f},{-0.231347f,-0.107098f,0.130078f},
{-0.176848f,-0.0875614f,0.111236f},{-0.148202f,-0.0583224f,0.0758284f},{-0.179053f,0.0106573f,-0.0141398f},
{-0.223329f,0.0398963f,-0.0555068f},{-0.281369f,0.0594333f,-0.0903756f},{0.297829f,0.0980529f,0.0842386f},
{0.313667f,0.123265f,0.038132f},{0.33705f,0.120639f,0.0372689f},{0.354056f,0.113163f,0.0431301f},
{0.362066f,0.101974f,0.0543168f},{0.36034f,0.0887749f,0.0685476f},{0.349711f,0.0755762f,0.0835722f},
{0.331827f,0.064387f,0.0977591f},{0.308798f,0.0569104f,0.109844f},{0.283419f,0.0542851f,0.118356f},
{0.2594f,0.0569105f,0.121591f},{0.240924f,0.0643869f,0.11828f},{0.231469f,0.0755762f,0.108374f},
{0.232666f,0.0887749f,0.0933521f},{0.243995f,0.101974f,0.0758818f},{0.26335f,0.113163f,0.0590793f},
{0.28776f,0.120639f,0.0457874f},{0.328873f,0.126082f,-0.0164282f},{0.374561f,0.121231f,-0.0180109f},
{0.407332f,0.107417f,-0.00547944f},{0.420692f,0.0867414f,0.0183273f},{0.414793f,0.0623534f,0.0470197f},
{0.394038f,0.0379655f,0.0749315f},{0.362508f,0.0172904f,0.100144f},{0.322425f,0.00347572f,0.122329f},
{0.276379f,-0.00137538f,0.139072f},{0.230358f,0.00347572f,0.145889f},{0.193783f,0.0172904f,0.139267f},
{0.175374f,0.0379654f,0.119083f},{0.17845f,0.0623534f,0.0889719f},{0.200266f,0.0867414f,0.05494f},
{0.235598f,0.107417f,0.0231068f},{0.280002f,0.121231f,-0.00181462f},{0.342729f,0.106077f,-0.0712325f},
{0.40707f,0.0997385f,-0.0755093f},{0.453559f,0.0816888f,-0.0588285f},{0.470324f,0.0546754f,-0.0239743f},
{0.459008f,0.022811f,0.0181521f},{0.42934f,-0.00905347f,0.0575822f},{0.3889f,-0.0360667f,0.0920333f},
{0.339532f,-0.0541165f,0.122036f},{0.28154f,-0.0604547f,0.143658f},{0.220773f,-0.0541165f,0.150064f},
{0.170787f,-0.0360668f,0.137505f},{0.14554f,-0.00905347f,0.107605f},{0.149815f,0.022811f,0.0664637f},
{0.177993f,0.0546754f,0.0222531f},{0.221855f,0.0816888f,-0.0181252f},{0.277621f,0.0997385f,-0.05043f},
{0.352579f,0.0662937f,-0.115311f},{0.426014f,0.0594332f,-0.122827f},{0.480338f,0.0398963f,-0.10543f},
{0.499898f,0.0106573f,-0.065114f},{0.486365f,-0.0238325f,-0.0148973f},{0.452313f,-0.0583224f,0.0325481f},
{0.408062f,-0.0875614f,0.0734018f},{0.356245f,-0.107098f,0.107029f},{0.295864f,-0.113959f,0.128165f},
{0.231347f,-0.107098f,0.130078f},{0.176848f,-0.0875614f,0.111236f},{0.148202f,-0.0583224f,0.0758284f},
{0.179053f,0.0106573f,-0.0141398f},{0.223329f,0.0398963f,-0.0555068f},{0.281369f,0.0594333f,-0.0903756f}
},

//lid 8
{
{-0.348964f,0.0841141f,-0.102844f},{-0.354155f,0.034321f,-0.134653f},{-0.382714f,0.0375006f,-0.138946f},
{-0.406454f,0.0465551f,-0.136169f},{-0.420594f,0.0601062f,-0.126341f},{-0.422361f,0.0760907f,-0.111045f},
{-0.411852f,0.0920752f,-0.0931276f},{-0.39161f,0.105626f,-0.0758779f},{-0.365443f,0.114681f,-0.0621226f},
{-0.337443f,0.11786f,-0.0537301f},{-0.311591f,0.114681f,-0.0516105f},{-0.291492f,0.105626f,-0.0558164f},
{-0.279841f,0.0920752f,-0.0655216f},{-0.277923f,0.0760906f,-0.0791518f},{-0.285685f,0.0601061f,-0.0948063f},
{-0.302221f,0.0465551f,-0.110585f},{-0.325939f,0.0375006f,-0.124552f},{-0.352121f,-0.0239383f,-0.143656f},
{-0.405164f,-0.0180633f,-0.150868f},{-0.450226f,-0.00133275f,-0.145058f},{-0.476253f,0.0237063f,-0.125898f},
{-0.477338f,0.0532419f,-0.0965964f},{-0.455389f,0.0827775f,-0.0633853f},{-0.417606f,0.107817f,-0.0331416f},
{-0.371497f,0.124547f,-0.0105503f},{-0.32275f,0.130422f,0.00261082f},{-0.277032f,0.124547f,0.0055299f},
{-0.241377f,0.107817f,-0.0027318f},{-0.221859f,0.0827775f,-0.0214042f},{-0.220238f,0.0532419f,-0.0468527f},
{-0.234397f,0.0237063f,-0.0747574f},{-0.262018f,-0.00133274f,-0.102078f},{-0.302085f,-0.0180633f,-0.12617f},
{-0.344948f,-0.0817945f,-0.129319f},{-0.412012f,-0.0741185f,-0.134705f},{-0.4687f,-0.0522589f,-0.124335f},
{-0.5f,-0.0195438f,-0.0982293f},{-0.498575f,0.0190463f,-0.0607126f},{-0.468954f,0.0576364f,-0.0200192f},
{-0.422252f,0.0903515f,0.0151393f},{-0.366996f,0.112211f,0.0402528f},{-0.307083f,0.119887f,0.0555925f},
{-0.247974f,0.112211f,0.0606335f},{-0.200709f,0.0903515f,0.0512665f},{-0.176262f,0.0576364f,0.0259707f},
{-0.177034f,0.0190463f,-0.00941388f},{-0.197421f,-0.0195438f,-0.0469124f},{-0.232576f,-0.052259f,-0.081761f},
{-0.282258f,-0.0741185f,-0.110534f},{-0.335953f,-0.130439f,-0.0940914f},{-0.404416f,-0.122131f,-0.0948819f},
{-0.460736f,-0.0984704f,-0.0805227f},{-0.49041f,-0.0630598f,-0.052294f},{-0.487177f,-0.0212901f,-0.0148493f},
{-0.456766f,0.0204795f,0.0241508f},{-0.410302f,0.05589f,0.0571937f},{-0.354541f,0.0795506f,0.0814215f},
{-0.291402f,0.0878591f,0.0984543f},{-0.226542f,0.0795506f,0.106885f},{-0.173908f,0.05589f,0.0992358f},
{-0.147736f,0.0204794f,0.0715326f},{-0.15111f,-0.0212902f,0.0308063f},{-0.176369f,-0.0630598f,-0.0119795f},
{-0.216431f,-0.0984704f,-0.0499184f},{-0.270239f,-0.122131f,-0.0785263f},{0.348964f,0.0841141f,-0.102844f},
{0.354155f,0.034321f,-0.134653f},{0.382714f,0.0375006f,-0.138946f},{0.406454f,0.0465551f,-0.136169f},
{0.420594f,0.0601062f,-0.126341f},{0.422361f,0.0760907f,-0.111045f},{0.411852f,0.0920752f,-0.0931276f},
{0.39161f,0.105626f,-0.075878f},{0.365443f,0.114681f,-0.0621226f},{0.337443f,0.11786f,-0.0537301f},
{0.311591f,0.114681f,-0.0516105f},{0.291492f,0.105626f,-0.0558164f},{0.279841f,0.0920752f,-0.0655216f},
{0.277923f,0.0760906f,-0.0791518f},{0.285685f,0.0601061f,-0.0948063f},{0.302221f,0.0465551f,-0.110585f},
{0.32594f,0.0375006f,-0.124552f},{0.352121f,-0.0239383f,-0.143656f},{0.405164f,-0.0180633f,-0.150868f},
{0.450226f,-0.00133275f,-0.145058f},{0.476253f,0.0237063f,-0.125898f},{0.477338f,0.0532419f,-0.0965964f},
{0.455389f,0.0827775f,-0.0633853f},{0.417606f,0.107817f,-0.0331416f},{0.371497f,0.124547f,-0.0105503f},
{0.32275f,0.130422f,0.00261082f},{0.277032f,0.124547f,0.0055299f},{0.241377f,0.107817f,-0.0027318f},
{0.221859f,0.0827775f,-0.0214042f},{0.220238f,0.0532419f,-0.0468527f},{0.234397f,0.0237063f,-0.0747574f},
{0.262018f,-0.00133274f,-0.102078f},{0.302085f,-0.0180633f,-0.12617f},{0.344948f,-0.0817945f,-0.129319f},
{0.412012f,-0.0741185f,-0.134705f},{0.4687f,-0.0522589f,-0.124335f},{0.5f,-0.0195438f,-0.0982293f},
{0.498575f,0.0190463f,-0.0607126f},{0.468954f,0.0576364f,-0.0200192f},{0.422252f,0.0903515f,0.0151393f},
{0.366996f,0.112211f,0.0402528f},{0.307083f,0.119887f,0.0555925f},{0.247974f,0.112211f,0.0606335f},
{0.200709f,0.0903515f,0.0512665f},{0.176262f,0.0576364f,0.0259707f},{0.177034f,0.0190463f,-0.00941388f},
{0.197421f,-0.0195438f,-0.0469124f},{0.232576f,-0.052259f,-0.081761f},{0.282258f,-0.0741185f,-0.110534f},
{0.335953f,-0.130439f,-0.0940914f},{0.404416f,-0.122131f,-0.0948819f},{0.460736f,-0.0984704f,-0.0805227f},
{0.49041f,-0.0630598f,-0.052294f},{0.487177f,-0.0212901f,-0.0148493f},{0.456766f,0.0204795f,0.0241508f},
{0.410302f,0.05589f,0.0571937f},{0.354541f,0.0795506f,0.0814215f},{0.291402f,0.0878591f,0.0984543f},
{0.226542f,0.0795506f,0.106885f},{0.173908f,0.05589f,0.0992358f},{0.147736f,0.0204794f,0.0715326f},
{0.15111f,-0.0212902f,0.0308063f},{0.176369f,-0.0630598f,-0.0119795f},{0.216431f,-0.0984704f,-0.0499184f},
{0.270239f,-0.122131f,-0.0785263f},{-0.291072f,0.0869352f,0.0992675f},{-0.306729f,0.119396f,0.0566704f},
{-0.330009f,0.116298f,0.0553776f},{-0.347061f,0.107476f,0.060103f},{-0.355392f,0.094272f,0.0696509f},
{-0.35423f,0.078697f,0.082139f},{-0.344255f,0.063122f,0.0957421f},{-0.326952f,0.0499182f,0.109044f},
{-0.304306f,0.0410956f,0.120722f},{-0.279013f,0.0379976f,0.129152f},{-0.254731f,0.0410956f,0.13261f},
{-0.235694f,0.0499182f,0.129947f},{-0.225567f,0.063122f,0.121192f},{-0.226215f,0.078697f,0.1077f},
{-0.237249f,0.094272f,0.0918433f},{-0.256524f,0.107476f,0.0764213f},{-0.280909f,0.116298f,0.0640395f},
{-0.322409f,0.130439f,0.00385885f},{-0.367471f,0.124715f,0.00184701f},{-0.400107f,0.108413f,0.0123315f},
{-0.414317f,0.0840155f,0.0327456f},{-0.410025f,0.0552367f,0.0577653f},{-0.391009f,0.0264579f,0.0829813f},
{-0.360978f,0.00206033f,0.106894f},{-0.322089f,-0.0142416f,0.128503f},{-0.276729f,-0.019966f,0.144602f},
{-0.230467f,-0.0142416f,0.150868f},{-0.192583f,0.00206035f,0.144734f},{-0.172269f,0.0264579f,0.126669f},
{-0.173642f,0.0552367f,0.0998949f},{-0.194526f,0.0840156f,0.0694042f},{-0.229637f,0.108413f,0.0404957f},
{-0.273962f,0.124715f,0.0175577f},{-0.337139f,0.118383f,-0.0525144f},{-0.400699f,0.110904f,-0.0571073f},
{-0.447192f,0.0896042f,-0.0430756f},{-0.465444f,0.0577272f,-0.01278f},{-0.456584f,0.0201259f,0.0244976f},
{-0.42927f,-0.0174755f,0.0605408f},{-0.390675f,-0.0493524f,0.093387f},{-0.342933f,-0.0706518f,0.122279f},
{-0.286261f,-0.0781312f,0.142185f},{-0.225698f,-0.0706519f,0.146978f},{-0.174201f,-0.0493524f,0.13474f},
{-0.146169f,-0.0174755f,0.107994f},{-0.147595f,0.0201259f,0.0718902f},{-0.17391f,0.0577273f,0.0327803f},
{-0.217068f,0.0896041f,-0.00361029f},{-0.272593f,0.110904f,-0.033185f},{-0.348767f,0.0850626f,-0.10191f},
{-0.422111f,0.076967f,-0.110121f},{-0.477084f,0.0539125f,-0.0958718f},{-0.498416f,0.0194093f,-0.0603363f},
{-0.487177f,-0.0212902f,-0.0148492f},{-0.454951f,-0.0619896f,0.0292421f},{-0.411793f,-0.0964929f,0.0680066f},
{-0.360878f,-0.119547f,0.0996509f},{-0.301511f,-0.127643f,0.118439f},{-0.237483f,-0.119547f,0.118782f},
{-0.182061f,-0.0964929f,0.100861f},{-0.151065f,-0.0619896f,0.0694335f},{-0.15111f,-0.0212902f,0.0308063f},
{-0.176925f,0.0194093f,-0.00906683f},{-0.220087f,0.0539126f,-0.0462431f},{-0.27776f,0.0769669f,-0.0783452f},
{0.291072f,0.0869352f,0.0992675f},{0.306729f,0.119396f,0.0566704f},{0.330009f,0.116298f,0.0553776f},
{0.347061f,0.107476f,0.060103f},{0.355392f,0.094272f,0.0696509f},{0.35423f,0.078697f,0.082139f},
{0.344255f,0.063122f,0.095742f},{0.326952f,0.0499182f,0.109044f},{0.304306f,0.0410956f,0.120722f},
{0.279013f,0.0379976f,0.129152f},{0.254731f,0.0410956f,0.13261f},{0.235694f,0.0499182f,0.129947f},
{0.225567f,0.063122f,0.121192f},{0.226215f,0.078697f,0.1077f},{0.237249f,0.094272f,0.0918432f},
{0.256524f,0.107476f,0.0764213f},{0.280909f,0.116298f,0.0640395f},{0.322409f,0.130439f,0.00385884f},
{0.367471f,0.124715f,0.001847f},{0.400107f,0.108413f,0.0123315f},{0.414317f,0.0840155f,0.0327456f},
{0.410025f,0.0552367f,0.0577653f},{0.391009f,0.0264579f,0.0829813f},{0.360978f,0.00206034f,0.106894f},
{0.322089f,-0.0142416f,0.128503f},{0.276729f,-0.019966f,0.144602f},{0.230467f,-0.0142416f,0.150868f},
{0.192583f,0.00206036f,0.144734f},{0.172269f,0.0264579f,0.126669f},{0.173642f,0.0552368f,0.0998949f},
{0.194526f,0.0840156f,0.0694042f},{0.229637f,0.108413f,0.0404957f},{0.273962f,0.124715f,0.0175577f},
{0.337139f,0.118383f,-0.0525144f},{0.400699f,0.110904f,-0.0571073f},{0.447192f,0.0896042f,-0.0430756f},
{0.465443f,0.0577272f,-0.01278f},{0.456584f,0.0201259f,0.0244975f},{0.42927f,-0.0174755f,0.0605408f},
{0.390675f,-0.0493524f,0.093387f},{0.342933f,-0.0706518f,0.122279f},{0.286261f,-0.0781312f,0.142185f},
{0.225698f,-0.0706519f,0.146978f},{0.174201f,-0.0493524f,0.13474f},{0.146169f,-0.0174755f,0.107994f},
{0.147595f,0.0201259f,0.0718902f},{0.17391f,0.0577273f,0.0327803f},{0.217068f,0.0896041f,-0.0036103f},
{0.272593f,0.110904f,-0.033185f},{0.348767f,0.0850626f,-0.10191f},{0.422111f,0.0769669f,-0.110121f},
{0.477084f,0.0539125f,-0.0958718f},{0.498416f,0.0194093f,-0.0603363f},{0.487177f,-0.0212902f,-0.0148492f},
{0.454951f,-0.0619896f,0.0292421f},{0.411793f,-0.0964929f,0.0680066f},{0.360878f,-0.119547f,0.0996509f},
{0.301511f,-0.127643f,0.118439f},{0.237483f,-0.119547f,0.118782f},{0.182061f,-0.0964929f,0.100861f},
{0.151065f,-0.0619896f,0.0694335f},{0.15111f,-0.0212902f,0.0308063f},{0.176925f,0.0194093f,-0.00906683f},
{0.220087f,0.0539126f,-0.0462431f},{0.27776f,0.0769669f,-0.0783453f}
},

//lid 6
{
{-0.351756f,0.0844025f,-0.109661f},{-0.355945f,0.0328842f,-0.138446f},{-0.384378f,0.0362308f,-0.142751f},
{-0.408193f,0.0457608f,-0.140451f},{-0.42265f,0.0600234f,-0.131521f},{-0.424904f,0.0768473f,-0.117353f},
{-0.414884f,0.0936713f,-0.100537f},{-0.394983f,0.107934f,-0.084143f},{-0.36896f,0.117464f,-0.070887f},
{-0.340955f,0.12081f,-0.0626191f},{-0.315021f,0.117464f,-0.0602733f},{-0.294794f,0.107934f,-0.0639409f},
{-0.282961f,0.0936712f,-0.0728692f},{-0.2808f,0.0768474f,-0.0856041f},{-0.288278f,0.0600233f,-0.100374f},
{-0.304522f,0.0457607f,-0.115367f},{-0.327964f,0.0362308f,-0.128713f},{-0.353096f,-0.0259013f,-0.144196f},
{-0.405674f,-0.0197177f,-0.151037f},{-0.450633f,-0.00210858f,-0.145914f},{-0.477229f,0.0242454f,-0.128485f},
{-0.479417f,0.0553321f,-0.10146f},{-0.458564f,0.0864186f,-0.0703846f},{-0.421405f,0.112773f,-0.0416503f},
{-0.375401f,0.130382f,-0.0198441f},{-0.326511f,0.136565f,-0.00688288f},{-0.280637f,0.130382f,-0.00366803f},
{-0.244819f,0.112772f,-0.0110978f},{-0.225012f,0.0864185f,-0.0284403f},{-0.222941f,0.055332f,-0.0523391f},
{-0.23661f,0.0242453f,-0.078796f},{-0.263825f,-0.00210858f,-0.104838f},{-0.30352f,-0.0197177f,-0.127723f},
{-0.34558f,-0.0830043f,-0.126825f},{-0.411879f,-0.0749251f,-0.131548f},{-0.468152f,-0.0519177f,-0.121991f},
{-0.5f,-0.0174846f,-0.0981684f},{-0.499979f,0.023132f,-0.0636476f},{-0.47182f,0.0637486f,-0.0256644f},
{-0.425949f,0.0981816f,0.00767143f},{-0.370867f,0.121189f,0.0318387f},{-0.310857f,0.129268f,0.0468414f},
{-0.251612f,0.121189f,0.0521057f},{-0.204087f,0.0981816f,0.0437074f},{-0.179119f,0.0637485f,0.0201095f},
{-0.179202f,0.0231319f,-0.013301f},{-0.19903f,-0.0174846f,-0.0490307f},{-0.233919f,-0.0519177f,-0.0823255f},
{-0.283398f,-0.0749251f,-0.109512f},{-0.336776f,-0.129732f,-0.0889855f},{-0.404391f,-0.120987f,-0.0893879f},
{-0.460079f,-0.0960837f,-0.0761018f},{-0.490006f,-0.0588136f,-0.0503488f},{-0.487934f,-0.0148505f,-0.0159837f},
{-0.458895f,0.0291126f,0.020314f},{-0.413359f,0.0663826f,0.0515159f},{-0.358011f,0.0912858f,0.0746728f},
{-0.294985f,0.100031f,0.0912395f},{-0.229974f,0.0912857f,0.0999435f},{-0.176824f,0.0663827f,0.0935117f},
{-0.149845f,0.0291126f,0.067785f},{-0.152477f,-0.0148506f,0.0292381f},{-0.177433f,-0.0588137f,-0.0115784f},
{-0.217614f,-0.0960837f,-0.0477599f},{-0.271491f,-0.120987f,-0.074726f},{0.351756f,0.0844025f,-0.109661f},
{0.355945f,0.0328842f,-0.138446f},{0.384378f,0.0362308f,-0.142751f},{0.408193f,0.0457608f,-0.140451f},
{0.42265f,0.0600234f,-0.131521f},{0.424904f,0.0768474f,-0.117353f},{0.414884f,0.0936713f,-0.100537f},
{0.394983f,0.107934f,-0.084143f},{0.36896f,0.117464f,-0.070887f},{0.340955f,0.12081f,-0.0626191f},
{0.315021f,0.117464f,-0.0602733f},{0.294794f,0.107934f,-0.0639409f},{0.282961f,0.0936712f,-0.0728692f},
{0.2808f,0.0768474f,-0.0856041f},{0.288278f,0.0600233f,-0.100374f},{0.304522f,0.0457607f,-0.115367f},
{0.327964f,0.0362308f,-0.128713f},{0.353096f,-0.0259012f,-0.144196f},{0.405674f,-0.0197177f,-0.151037f},
{0.450633f,-0.00210858f,-0.145914f},{0.477229f,0.0242454f,-0.128485f},{0.479417f,0.0553321f,-0.10146f},
{0.458564f,0.0864186f,-0.0703846f},{0.421405f,0.112773f,-0.0416503f},{0.375401f,0.130382f,-0.0198441f},
{0.326511f,0.136565f,-0.00688288f},{0.280637f,0.130382f,-0.00366802f},{0.244819f,0.112772f,-0.0110978f},
{0.225012f,0.0864185f,-0.0284403f},{0.222941f,0.055332f,-0.0523391f},{0.236611f,0.0242453f,-0.078796f},
{0.263825f,-0.00210858f,-0.104838f},{0.30352f,-0.0197177f,-0.127723f},{0.345581f,-0.0830043f,-0.126825f},
{0.411879f,-0.0749251f,-0.131548f},{0.468152f,-0.0519177f,-0.121991f},{0.5f,-0.0174846f,-0.0981684f},
{0.499979f,0.023132f,-0.0636476f},{0.47182f,0.0637486f,-0.0256644f},{0.425949f,0.0981816f,0.00767143f},
{0.370867f,0.121189f,0.0318387f},{0.310857f,0.129268f,0.0468414f},{0.251612f,0.121189f,0.0521057f},
{0.204087f,0.0981816f,0.0437074f},{0.179119f,0.0637485f,0.0201095f},{0.179202f,0.0231319f,-0.013301f},
{0.19903f,-0.0174846f,-0.0490307f},{0.233919f,-0.0519177f,-0.0823255f},{0.283398f,-0.0749251f,-0.109512f},
{0.336776f,-0.129732f,-0.0889855f},{0.404391f,-0.120987f,-0.0893879f},{0.460079f,-0.0960837f,-0.0761018f},
{0.490007f,-0.0588136f,-0.0503488f},{0.487934f,-0.0148505f,-0.0159837f},{0.458895f,0.0291126f,0.020314f},
{0.413359f,0.0663826f,0.0515159f},{0.358011f,0.0912858f,0.0746728f},{0.294985f,0.100031f,0.0912395f},
{0.229974f,0.0912857f,0.0999435f},{0.176824f,0.0663827f,0.0935117f},{0.149845f,0.0291126f,0.067785f},
{0.152477f,-0.0148506f,0.0292381f},{0.177433f,-0.0588137f,-0.0115784f},{0.217614f,-0.0960837f,-0.0477599f},
{0.271491f,-0.120987f,-0.074726f},{-0.287056f,0.0758929f,0.110646f},{-0.301988f,0.115564f,0.0728616f},
{-0.325153f,0.112018f,0.0708336f},{-0.342261f,0.101921f,0.0739892f},{-0.351035f,0.0868102f,0.0813745f},
{-0.350709f,0.0689855f,0.0915995f},{-0.341765f,0.0511608f,0.10337f},{-0.325429f,0.0360497f,0.115558f},
{-0.303445f,0.0259528f,0.126808f},{-0.278313f,0.0224073f,0.135353f},{-0.253592f,0.0259528f,0.139427f},
{-0.233614f,0.0360497f,0.137946f},{-0.22236f,0.0511608f,0.130911f},{-0.22208f,0.0689854f,0.119439f},
{-0.232625f,0.0868102f,0.105524f},{-0.2518f,0.101921f,0.0916217f},{-0.276219f,0.112018f,0.080118f},
{-0.317919f,0.13538f,0.0237192f},{-0.36191f,0.128829f,0.0210766f},{-0.394013f,0.110172f,0.0288914f},
{-0.409112f,0.0822505f,0.0448135f},{-0.40697f,0.0493148f,0.0648619f},{-0.390534f,0.016379f,0.08627f},
{-0.362855f,-0.0115425f,0.108162f},{-0.325769f,-0.0301992f,0.128919f},{-0.281276f,-0.0367505f,0.144595f},
{-0.234463f,-0.0301991f,0.151037f},{-0.194554f,-0.0115425f,0.146466f},{-0.171463f,0.016379f,0.131679f},
{-0.170486f,0.0493148f,0.109223f},{-0.190284f,0.0822505f,0.082936f},{-0.225447f,0.110172f,0.0573035f},
{-0.269985f,0.128829f,0.0364921f},{-0.333196f,0.132325f,-0.0320871f},{-0.39485f,0.123765f,-0.0366893f},
{-0.440427f,0.0993894f,-0.0258578f},{-0.460181f,0.0629081f,-0.00177522f},{-0.454693f,0.0198755f,0.0284132f},
{-0.431007f,-0.0231572f,0.0590285f},{-0.395363f,-0.0596384f,0.0888389f},{-0.34986f,-0.0840145f,0.115946f},
{-0.294567f,-0.0925742f,0.134374f},{-0.233834f,-0.0840145f,0.13864f},{-0.180142f,-0.0596384f,0.12824f},
{-0.148514f,-0.0231572f,0.106138f},{-0.146522f,0.0198755f,0.07627f},{-0.171003f,0.0629081f,0.0431261f},
{-0.213996f,0.0993894f,0.0113892f},{-0.269657f,0.123765f,-0.0148336f},{-0.346426f,0.106864f,-0.0853202f},
{-0.418148f,0.0975991f,-0.0933364f},{-0.472597f,0.0712147f,-0.0826396f},{-0.495756f,0.0317277f,-0.0538754f},
{-0.487934f,-0.0148505f,-0.0159838f},{-0.458964f,-0.0614287f,0.0220605f},{-0.417971f,-0.100916f,0.056811f},
{-0.36836f,-0.1273f,0.0855621f},{-0.309844f,-0.136565f,0.102268f},{-0.245932f,-0.1273f,0.102289f},
{-0.189196f,-0.100916f,0.0869168f},{-0.155469f,-0.0614287f,0.0609428f},{-0.152477f,-0.0148505f,0.0292381f},
{-0.176282f,0.0317276f,-0.00420161f},{-0.21885f,0.0712148f,-0.0363203f},{-0.276383f,0.0975992f,-0.0644713f},
{0.287056f,0.0758929f,0.110646f},{0.301988f,0.115564f,0.0728616f},{0.325153f,0.112018f,0.0708336f},
{0.342261f,0.101921f,0.0739892f},{0.351035f,0.0868102f,0.0813745f},{0.350709f,0.0689855f,0.0915995f},
{0.341765f,0.0511608f,0.10337f},{0.325429f,0.0360497f,0.115558f},{0.303445f,0.0259528f,0.126808f},
{0.278313f,0.0224073f,0.135353f},{0.253592f,0.0259528f,0.139427f},{0.233614f,0.0360497f,0.137946f},
{0.22236f,0.0511608f,0.130911f},{0.22208f,0.0689854f,0.119439f},{0.232625f,0.0868102f,0.105524f},
{0.2518f,0.101921f,0.0916217f},{0.276219f,0.112018f,0.080118f},{0.317919f,0.13538f,0.0237192f},
{0.36191f,0.128829f,0.0210766f},{0.394013f,0.110172f,0.0288914f},{0.409112f,0.0822505f,0.0448135f},
{0.40697f,0.0493148f,0.0648619f},{0.390534f,0.016379f,0.08627f},{0.362855f,-0.0115425f,0.108162f},
{0.325769f,-0.0301992f,0.128919f},{0.281276f,-0.0367505f,0.144595f},{0.234463f,-0.0301991f,0.151037f},
{0.194554f,-0.0115425f,0.146466f},{0.171463f,0.016379f,0.131679f},{0.170486f,0.0493148f,0.109223f},
{0.190285f,0.0822505f,0.082936f},{0.225447f,0.110172f,0.0573035f},{0.269985f,0.128829f,0.0364921f},
{0.333196f,0.132325f,-0.0320871f},{0.394851f,0.123765f,-0.0366893f},{0.440427f,0.0993894f,-0.0258578f},
{0.460181f,0.0629081f,-0.00177522f},{0.454693f,0.0198755f,0.0284132f},{0.431007f,-0.0231572f,0.0590285f},
{0.395363f,-0.0596384f,0.0888389f},{0.34986f,-0.0840145f,0.115946f},{0.294567f,-0.0925742f,0.134374f},
{0.233834f,-0.0840145f,0.13864f},{0.180142f,-0.0596384f,0.12824f},{0.148514f,-0.0231572f,0.106138f},
{0.146523f,0.0198755f,0.07627f},{0.171003f,0.0629081f,0.0431261f},{0.213996f,0.0993894f,0.0113892f},
{0.269657f,0.123765f,-0.0148336f},{0.346426f,0.106864f,-0.0853202f},{0.418148f,0.0975991f,-0.0933364f},
{0.472597f,0.0712147f,-0.0826396f},{0.495756f,0.0317277f,-0.0538754f},{0.487934f,-0.0148505f,-0.0159838f},
{0.458964f,-0.0614287f,0.0220605f},{0.417971f,-0.100916f,0.056811f},{0.36836f,-0.1273f,0.0855621f},
{0.309845f,-0.136565f,0.102268f},{0.245932f,-0.1273f,0.102289f},{0.189196f,-0.100916f,0.0869168f},
{0.155469f,-0.0614287f,0.0609428f},{0.152477f,-0.0148505f,0.0292381f},{0.176282f,0.0317276f,-0.00420161f},
{0.21885f,0.0712148f,-0.0363203f},{0.276383f,0.0975992f,-0.0644713f}
},

//lid 5
{
{-0.35222f,0.0807632f,-0.116269f},{-0.355112f,0.0275006f,-0.141217f},{-0.383561f,0.0310274f,-0.145773f},
{-0.407652f,0.0410709f,-0.144276f},{-0.422647f,0.056102f,-0.136598f},{-0.425567f,0.0738323f,-0.123872f},
{-0.416122f,0.0915627f,-0.108372f},{-0.396538f,0.106594f,-0.092926f},{-0.370553f,0.116637f,-0.0801451f},
{-0.342414f,0.120164f,-0.0718868f},{-0.316287f,0.116637f,-0.0691268f},{-0.295842f,0.106594f,-0.0720026f},
{-0.283736f,0.0915627f,-0.0798502f},{-0.281224f,0.0738323f,-0.0913764f},{-0.288303f,0.0561019f,-0.104997f},
{-0.304166f,0.0410709f,-0.119044f},{-0.327307f,0.0310274f,-0.131739f},{-0.351234f,-0.0315149f,-0.14288f},
{-0.40356f,-0.0249982f,-0.149751f},{-0.448778f,-0.00644035f,-0.14589f},{-0.476382f,0.0213335f,-0.130823f},
{-0.480046f,0.0540949f,-0.106621f},{-0.46045f,0.0868564f,-0.0780273f},{-0.423811f,0.11463f,-0.0509148f},
{-0.377654f,0.133188f,-0.0298383f},{-0.328398f,0.139705f,-0.0169541f},{-0.282288f,0.133188f,-0.0132744f},
{-0.246317f,0.11463f,-0.019573f},{-0.22617f,0.0868563f,-0.0350928f},{-0.223453f,0.0540949f,-0.0568338f},
{-0.236342f,0.0213334f,-0.0812907f},{-0.262887f,-0.00644041f,-0.105693f},{-0.302078f,-0.0249983f,-0.127263f},
{-0.34326f,-0.0872989f,-0.121779f},{-0.408985f,-0.0787845f,-0.126311f},{-0.465236f,-0.0545374f,-0.11824f},
{-0.498151f,-0.0182492f,-0.0974167f},{-0.5f,0.0245557f,-0.0664839f},{-0.473501f,0.0673606f,-0.0315635f},
{-0.428328f,0.103649f,-0.000164158f},{-0.373146f,0.127896f,0.0230542f},{-0.3129f,0.13641f,0.037678f},
{-0.25362f,0.127896f,0.0431086f},{-0.206011f,0.103649f,0.0358444f},{-0.1805f,0.0673606f,0.0145129f},
{-0.17957f,0.0245557f,-0.0160796f},{-0.198361f,-0.0182492f,-0.0492255f},{-0.232567f,-0.0545374f,-0.0804019f},
{-0.281607f,-0.0787845f,-0.105784f},{-0.334569f,-0.131359f,-0.0809148f},{-0.40145f,-0.122143f,-0.0813779f},
{-0.456808f,-0.0958979f,-0.069794f},{-0.487429f,-0.0566198f,-0.0471402f},{-0.486932f,-0.0102881f,-0.0163207f},
{-0.459465f,0.0360436f,0.0170134f},{-0.414816f,0.0753217f,0.0462327f},{-0.359802f,0.101566f,0.0681354f},
{-0.296993f,0.110782f,0.0839128f},{-0.232114f,0.101566f,0.0925683f},{-0.178659f,0.0753217f,0.0873822f},
{-0.150754f,0.0360435f,0.0642135f},{-0.152175f,-0.0102882f,0.0287899f},{-0.176247f,-0.0566198f,-0.00911687f},
{-0.216092f,-0.0958979f,-0.042849f},{-0.269784f,-0.122143f,-0.0678564f},{0.35222f,0.0807632f,-0.116269f},
{0.355112f,0.0275006f,-0.141217f},{0.383561f,0.0310274f,-0.145773f},{0.407652f,0.0410709f,-0.144276f},
{0.422647f,0.056102f,-0.136598f},{0.425567f,0.0738323f,-0.123872f},{0.416122f,0.0915627f,-0.108372f},
{0.396538f,0.106594f,-0.092926f},{0.370553f,0.116637f,-0.0801451f},{0.342414f,0.120164f,-0.0718868f},
{0.316287f,0.116637f,-0.0691268f},{0.295842f,0.106594f,-0.0720026f},{0.283736f,0.0915627f,-0.0798502f},
{0.281224f,0.0738323f,-0.0913764f},{0.288303f,0.0561019f,-0.104997f},{0.304166f,0.0410709f,-0.119044f},
{0.327307f,0.0310274f,-0.131739f},{0.351234f,-0.031515f,-0.14288f},{0.40356f,-0.0249982f,-0.149751f},
{0.448778f,-0.00644035f,-0.14589f},{0.476382f,0.0213335f,-0.130823f},{0.480046f,0.0540949f,-0.106621f},
{0.46045f,0.0868564f,-0.0780273f},{0.423811f,0.11463f,-0.0509149f},{0.377654f,0.133188f,-0.0298383f},
{0.328398f,0.139705f,-0.0169541f},{0.282288f,0.133188f,-0.0132744f},{0.246317f,0.11463f,-0.019573f},
{0.22617f,0.0868563f,-0.0350928f},{0.223453f,0.0540949f,-0.0568338f},{0.236342f,0.0213334f,-0.0812907f},
{0.262887f,-0.00644041f,-0.105693f},{0.302078f,-0.0249983f,-0.127263f},{0.34326f,-0.0872989f,-0.121779f},
{0.408985f,-0.0787845f,-0.126311f},{0.465236f,-0.0545374f,-0.11824f},{0.498151f,-0.0182492f,-0.0974167f},
{0.5f,0.0245557f,-0.0664839f},{0.473501f,0.0673606f,-0.0315635f},{0.428328f,0.103649f,-0.00016416f},
{0.373146f,0.127896f,0.0230542f},{0.3129f,0.13641f,0.037678f},{0.25362f,0.127896f,0.0431086f},
{0.206011f,0.103649f,0.0358444f},{0.1805f,0.0673606f,0.0145129f},{0.17957f,0.0245557f,-0.0160796f},
{0.198361f,-0.0182492f,-0.0492255f},{0.232567f,-0.0545375f,-0.0804019f},{0.281607f,-0.0787845f,-0.105784f},
{0.334569f,-0.131359f,-0.0809148f},{0.40145f,-0.122143f,-0.0813779f},{0.456808f,-0.0958979f,-0.069794f},
{0.487429f,-0.0566198f,-0.0471402f},{0.486932f,-0.0102881f,-0.0163207f},{0.459465f,0.0360436f,0.0170134f},
{0.414816f,0.0753217f,0.0462327f},{0.359802f,0.101566f,0.0681354f},{0.296993f,0.110782f,0.0839128f},
{0.232114f,0.101566f,0.0925683f},{0.178659f,0.0753217f,0.0873822f},{0.150754f,0.0360435f,0.0642135f},
{0.152175f,-0.0102882f,0.0287899f},{0.176247f,-0.0566198f,-0.00911686f},{0.216092f,-0.0958979f,-0.042849f},
{0.269784f,-0.122143f,-0.0678564f},{-0.283516f,0.0684505f,0.117249f},{-0.297523f,0.111982f,0.0825327f},
{-0.320672f,0.108213f,0.0800315f},{-0.337917f,0.0974768f,0.0822191f},{-0.347078f,0.0814095f,0.0883145f},
{-0.347375f,0.062457f,0.0972086f},{-0.33918f,0.0435043f,0.107872f},{-0.323569f,0.0274371f,0.119293f},
{-0.302141f,0.0167013f,0.1301f},{-0.277259f,0.0129314f,0.138501f},{-0.252381f,0.0167013f,0.142792f},
{-0.231847f,0.0274371f,0.14198f},{-0.219791f,0.0435043f,0.136064f},{-0.218713f,0.0624569f,0.125981f},
{-0.228674f,0.0814096f,0.113434f},{-0.247538f,0.0974768f,0.100606f},{-0.271824f,0.108213f,0.0897131f},
{-0.313436f,0.1369f,0.0359331f},{-0.35693f,0.129934f,0.0327261f},{-0.388907f,0.110097f,0.0387786f},
{-0.404696f,0.0804084f,0.0519694f},{-0.403928f,0.0453886f,0.0691129f},{-0.389077f,0.0103687f,0.0882565f},
{-0.36285f,-0.0193198f,0.108704f},{-0.326938f,-0.0391569f,0.12848f},{-0.28316f,-0.0461228f,0.14344f},
{-0.236305f,-0.0391569f,0.149751f},{-0.195408f,-0.0193197f,0.146165f},{-0.170624f,0.0103687f,0.133635f},
{-0.167907f,0.0453885f,0.114231f},{-0.18657f,0.0804084f,0.090957f},{-0.221347f,0.110097f,0.0676455f},
{-0.265804f,0.129934f,0.0482343f},{-0.328906f,0.139409f,-0.0188677f},{-0.389563f,0.130308f,-0.0237764f},
{-0.434822f,0.104389f,-0.0151712f},{-0.455683f,0.0655995f,0.00499309f},{-0.452287f,0.0198438f,0.0308808f},
{-0.430691f,-0.0259118f,0.0581252f},{-0.396613f,-0.0647016f,0.085662f},{-0.352229f,-0.0906201f,0.111006f},
{-0.29775f,-0.0997214f,0.128053f},{-0.237276f,-0.09062f,0.131966f},{-0.182806f,-0.0647016f,0.122977f},
{-0.149318f,-0.0259118f,0.104165f},{-0.145113f,0.0198439f,0.0786865f},{-0.168025f,0.0655996f,0.0497981f},
{-0.21047f,0.104389f,0.0213453f},{-0.265982f,0.130308f,-0.00271041f},{-0.342835f,0.119128f,-0.0736233f},
{-0.413662f,0.109277f,-0.0818217f},{-0.468026f,0.0812232f,-0.0736504f},{-0.492562f,0.0392375f,-0.0493431f},
{-0.486932f,-0.0102881f,-0.0163207f},{-0.459805f,-0.0598137f,0.0177488f},{-0.419752f,-0.101799f,0.0495111f},
{-0.37045f,-0.129853f,0.0758506f},{-0.312195f,-0.139705f,0.0909771f},{-0.248628f,-0.129853f,0.091013f},
{-0.191762f,-0.101799f,0.0777037f},{-0.156931f,-0.0598137f,0.0556475f},{-0.152175f,-0.0102881f,0.0287899f},
{-0.174436f,0.0392374f,-0.000122022f},{-0.216246f,0.0812232f,-0.0287078f},{-0.273448f,0.109277f,-0.0542936f},
{0.283516f,0.0684505f,0.117249f},{0.297523f,0.111982f,0.0825327f},{0.320672f,0.108213f,0.0800315f},
{0.337917f,0.0974768f,0.0822191f},{0.347078f,0.0814095f,0.0883145f},{0.347375f,0.062457f,0.0972086f},
{0.33918f,0.0435043f,0.107872f},{0.323569f,0.0274371f,0.119293f},{0.302141f,0.0167013f,0.1301f},
{0.277259f,0.0129314f,0.138501f},{0.252381f,0.0167013f,0.142792f},{0.231847f,0.0274371f,0.14198f},
{0.219791f,0.0435043f,0.136064f},{0.218713f,0.062457f,0.125981f},{0.228674f,0.0814096f,0.113434f},
{0.247538f,0.0974768f,0.100606f},{0.271824f,0.108213f,0.0897131f},{0.313436f,0.1369f,0.0359331f},
{0.35693f,0.129934f,0.0327261f},{0.388907f,0.110097f,0.0387786f},{0.404696f,0.0804084f,0.0519694f},
{0.403928f,0.0453886f,0.0691129f},{0.389077f,0.0103687f,0.0882565f},{0.36285f,-0.0193197f,0.108704f},
{0.326938f,-0.0391569f,0.12848f},{0.28316f,-0.0461228f,0.14344f},{0.236305f,-0.0391569f,0.149751f},
{0.195408f,-0.0193197f,0.146165f},{0.170624f,0.0103687f,0.133635f},{0.167907f,0.0453885f,0.114231f},
{0.18657f,0.0804084f,0.090957f},{0.221347f,0.110097f,0.0676455f},{0.265804f,0.129934f,0.0482343f},
{0.328906f,0.139409f,-0.0188677f},{0.389563f,0.130308f,-0.0237764f},{0.434822f,0.104389f,-0.0151712f},
{0.455683f,0.0655995f,0.00499309f},{0.452287f,0.0198438f,0.0308808f},{0.430691f,-0.0259118f,0.0581252f},
{0.396613f,-0.0647016f,0.085662f},{0.352229f,-0.0906201f,0.111006f},{0.29775f,-0.0997214f,0.128053f},
{0.237276f,-0.09062f,0.131966f},{0.182806f,-0.0647016f,0.122977f},{0.149318f,-0.0259118f,0.104165f},
{0.145113f,0.0198439f,0.0786865f},{0.168025f,0.0655996f,0.0497981f},{0.21047f,0.104389f,0.0213453f},
{0.265982f,0.130308f,-0.00271041f},{0.342835f,0.119128f,-0.0736233f},{0.413662f,0.109277f,-0.0818217f},
{0.468026f,0.0812232f,-0.0736504f},{0.492562f,0.0392375f,-0.0493431f},{0.486932f,-0.0102881f,-0.0163207f},
{0.459805f,-0.0598137f,0.0177488f},{0.419752f,-0.101799f,0.0495111f},{0.37045f,-0.129853f,0.0758506f},
{0.312195f,-0.139705f,0.0909771f},{0.248628f,-0.129853f,0.091013f},{0.191762f,-0.101799f,0.0777037f},
{0.156931f,-0.0598137f,0.0556475f},{0.152175f,-0.0102881f,0.0287899f},{0.174436f,0.0392374f,-0.000122023f},
{0.216246f,0.0812232f,-0.0287078f},{0.273448f,0.109277f,-0.0542936f}
},

//lid 4
{
{-0.353855f,0.0634518f,-0.127808f},{-0.353743f,0.00680746f,-0.14288f},{-0.382005f,0.0107183f,-0.14774f},
{-0.406503f,0.0218554f,-0.148074f},{-0.422603f,0.0385233f,-0.143562f},{-0.427103f,0.0581844f,-0.134712f},
{-0.419209f,0.0778456f,-0.12295f},{-0.400665f,0.0945135f,-0.110367f},{-0.37505f,0.105651f,-0.0991699f},
{-0.346773f,0.109561f,-0.0911444f},{-0.32025f,0.105651f,-0.0873742f},{-0.299264f,0.0945134f,-0.088188f},
{-0.286447f,0.0778455f,-0.0932286f},{-0.283047f,0.0581844f,-0.101633f},{-0.28916f,0.0385233f,-0.112242f},
{-0.304115f,0.0218554f,-0.123685f},{-0.32649f,0.0107183f,-0.134417f},{-0.347829f,-0.051748f,-0.134586f},
{-0.39918f,-0.0445217f,-0.141112f},{-0.444479f,-0.023943f,-0.140152f},{-0.474048f,0.00685527f,-0.131052f},
{-0.481203f,0.0431843f,-0.114419f},{-0.465041f,0.0795133f,-0.0929282f},{-0.430264f,0.110311f,-0.0708482f},
{-0.384188f,0.13089f,-0.0522717f},{-0.334187f,0.138117f,-0.0397563f},{-0.287418f,0.13089f,-0.0346676f},
{-0.250883f,0.110312f,-0.0377287f},{-0.229717f,0.0795133f,-0.0483917f},{-0.225358f,0.0431842f,-0.0646188f},
{-0.236481f,0.00685524f,-0.0839373f},{-0.261654f,-0.023943f,-0.103878f},{-0.299784f,-0.0445217f,-0.121626f},
{-0.339278f,-0.1033f,-0.104625f},{-0.40326f,-0.0938584f,-0.108657f},{-0.458827f,-0.066971f,-0.104285f},
{-0.493724f,-0.0267311f,-0.0911008f},{-0.5f,0.020735f,-0.0697199f},{-0.47804f,0.0682011f,-0.0435093f},
{-0.435242f,0.108441f,-0.0180731f},{-0.380135f,0.135328f,0.00212642f},{-0.319193f,0.14477f,0.0158355f},
{-0.259542f,0.135328f,0.0221782f},{-0.211448f,0.108441f,0.0183685f},{-0.184369f,0.0682011f,0.0031685f},
{-0.180904f,0.0207349f,-0.0201245f},{-0.197459f,-0.0267312f,-0.0464986f},{-0.230533f,-0.066971f,-0.0718127f},
{-0.278897f,-0.0938584f,-0.0921433f},{-0.331281f,-0.14f,-0.0568862f},{-0.396099f,-0.129781f,-0.0579084f},
{-0.450089f,-0.100678f,-0.050944f},{-0.481864f,-0.0571228f,-0.0363563f},{-0.48513f,-0.00574581f,-0.0149238f},
{-0.461947f,0.0456311f,0.0101581f},{-0.419991f,0.0891865f,0.0335696f},{-0.365921f,0.118289f,0.0519629f},
{-0.303382f,0.128509f,0.0659771f},{-0.238494f,0.118289f,0.0750094f},{-0.184008f,0.0891864f,0.0734764f},
{-0.153528f,0.0456311f,0.0572033f},{-0.151825f,-0.00574587f,0.0300291f},{-0.174023f,-0.0571228f,-9.32868e-005f},
{-0.213722f,-0.100678f,-0.027056f},{-0.267552f,-0.129781f,-0.0467337f},{0.353855f,0.0634518f,-0.127808f},
{0.353743f,0.00680746f,-0.14288f},{0.382005f,0.0107183f,-0.14774f},{0.406503f,0.0218554f,-0.148074f},
{0.422603f,0.0385233f,-0.143562f},{0.427103f,0.0581844f,-0.134712f},{0.419209f,0.0778455f,-0.12295f},
{0.400665f,0.0945135f,-0.110367f},{0.37505f,0.105651f,-0.0991699f},{0.346773f,0.109561f,-0.0911444f},
{0.32025f,0.105651f,-0.0873742f},{0.299264f,0.0945134f,-0.0881879f},{0.286447f,0.0778455f,-0.0932286f},
{0.283047f,0.0581844f,-0.101633f},{0.28916f,0.0385233f,-0.112242f},{0.304115f,0.0218554f,-0.123685f},
{0.32649f,0.0107183f,-0.134417f},{0.347829f,-0.051748f,-0.134586f},{0.39918f,-0.0445217f,-0.141112f},
{0.444479f,-0.023943f,-0.140152f},{0.474048f,0.00685527f,-0.131052f},{0.481203f,0.0431843f,-0.114419f},
{0.465041f,0.0795133f,-0.0929282f},{0.430264f,0.110311f,-0.0708482f},{0.384188f,0.13089f,-0.0522717f},
{0.334187f,0.138117f,-0.0397563f},{0.287418f,0.13089f,-0.0346676f},{0.250883f,0.110312f,-0.0377287f},
{0.229717f,0.0795133f,-0.0483917f},{0.225358f,0.0431842f,-0.0646188f},{0.236481f,0.00685524f,-0.0839372f},
{0.261654f,-0.023943f,-0.103878f},{0.299784f,-0.0445217f,-0.121626f},{0.339278f,-0.1033f,-0.104625f},
{0.40326f,-0.0938584f,-0.108657f},{0.458827f,-0.066971f,-0.104285f},{0.493724f,-0.0267311f,-0.0911008f},
{0.5f,0.020735f,-0.0697199f},{0.47804f,0.068201f,-0.0435093f},{0.435242f,0.108441f,-0.0180731f},
{0.380135f,0.135328f,0.00212642f},{0.319193f,0.14477f,0.0158355f},{0.259542f,0.135328f,0.0221782f},
{0.211448f,0.108441f,0.0183685f},{0.184369f,0.0682011f,0.0031685f},{0.180904f,0.0207349f,-0.0201245f},
{0.197459f,-0.0267312f,-0.0464986f},{0.230533f,-0.066971f,-0.0718127f},{0.278897f,-0.0938584f,-0.0921433f},
{0.331281f,-0.14f,-0.0568862f},{0.396099f,-0.129781f,-0.0579084f},{0.450089f,-0.100678f,-0.050944f},
{0.481864f,-0.0571228f,-0.0363563f},{0.48513f,-0.00574581f,-0.0149238f},{0.461947f,0.0456311f,0.0101581f},
{0.419991f,0.0891864f,0.0335696f},{0.365921f,0.118289f,0.0519629f},{0.303382f,0.128509f,0.0659771f},
{0.238494f,0.118289f,0.0750095f},{0.184008f,0.0891864f,0.0734764f},{0.153528f,0.0456311f,0.0572033f},
{0.151825f,-0.00574587f,0.0300291f},{0.174023f,-0.0571228f,-9.32874e-005f},{0.213722f,-0.100678f,-0.027056f},
{0.267552f,-0.129781f,-0.0467337f},{-0.279283f,0.0520408f,0.127571f},{-0.291091f,0.101044f,0.0980386f},
{-0.314344f,0.0969793f,0.0946093f},{-0.331977f,0.0854032f,0.0951078f},{-0.341951f,0.0680782f,0.0990535f},
{-0.343465f,0.0476421f,0.105775f},{-0.336696f,0.027206f,0.11463f},{-0.322456f,0.00988106f,0.12477f},
{-0.302072f,-0.0016951f,0.134807f},{-0.277652f,-0.00576013f,0.142958f},{-0.252472f,-0.00169512f,0.147658f},
{-0.230868f,0.00988104f,0.148074f},{-0.217233f,0.0272059f,0.144161f},{-0.214527f,0.0476421f,0.136514f},
{-0.223242f,0.0680783f,0.126309f},{-0.241414f,0.0854032f,0.115241f},{-0.265439f,0.0969793f,0.10525f},
{-0.306765f,0.13379f,0.0561555f},{-0.349583f,0.126279f,0.0517622f},{-0.381449f,0.104889f,0.0547534f},
{-0.398489f,0.0728766f,0.0633834f},{-0.400159f,0.0351155f,0.0757282f},{-0.388138f,-0.00264553f,0.0910661f},
{-0.364489f,-0.0346578f,0.108922f},{-0.330591f,-0.0560477f,0.126846f},{-0.287987f,-0.0635589f,0.140574f},
{-0.241024f,-0.0560477f,0.146878f},{-0.198397f,-0.0346578f,0.145269f},{-0.17056f,-0.00264554f,0.136838f},
{-0.164573f,0.0351155f,0.122803f},{-0.18101f,0.0728766f,0.104726f},{-0.215025f,0.104889f,0.0852658f},
{-0.259448f,0.126279f,0.067972f},{-0.322458f,0.145293f,0.00425289f},{-0.381335f,0.135479f,-0.00130134f},
{-0.4259f,0.107531f,0.00352389f},{-0.448605f,0.0657054f,0.0170174f},{-0.448895f,0.0163682f,0.0354859f},
{-0.431053f,-0.0329691f,0.0567292f},{-0.399729f,-0.0747951f,0.0799807f},{-0.35711f,-0.102742f,0.102015f},
{-0.303763f,-0.112556f,0.116832f},{-0.243626f,-0.102742f,0.120643f},{-0.18791f,-0.0747951f,0.114571f},
{-0.151294f,-0.032969f,0.101662f},{-0.143201f,0.0163682f,0.0838106f},{-0.163332f,0.0657054f,0.0622674f},
{-0.204947f,0.107531f,0.0393893f},{-0.260449f,0.135479f,0.018813f},{-0.337146f,0.133801f,-0.0513591f},
{-0.405991f,0.123178f,-0.0596923f},{-0.459809f,0.0929286f,-0.0556713f},{-0.486676f,0.0476564f,-0.039131f},
{-0.48513f,-0.00574584f,-0.0149238f},{-0.461581f,-0.0591481f,0.0117126f},{-0.423384f,-0.10442f,0.0378093f},
{-0.374549f,-0.13467f,0.059798f},{-0.316475f,-0.145293f,0.072463f},{-0.253313f,-0.13467f,0.0730645f},
{-0.196251f,-0.10442f,0.0637669f},{-0.159614f,-0.059148f,0.0486072f},{-0.151825f,-0.00574584f,0.0300291f},
{-0.171463f,0.0476564f,0.00889002f},{-0.212175f,0.0929286f,-0.0135302f},{-0.269009f,0.123178f,-0.0346653f},
{0.279283f,0.0520408f,0.127571f},{0.291091f,0.101044f,0.0980386f},{0.314344f,0.0969793f,0.0946093f},
{0.331977f,0.0854032f,0.0951078f},{0.341951f,0.0680782f,0.0990535f},{0.343465f,0.0476421f,0.105775f},
{0.336696f,0.027206f,0.11463f},{0.322456f,0.00988106f,0.12477f},{0.302072f,-0.0016951f,0.134807f},
{0.277652f,-0.00576013f,0.142958f},{0.252472f,-0.00169512f,0.147658f},{0.230868f,0.00988104f,0.148074f},
{0.217233f,0.0272059f,0.144161f},{0.214527f,0.0476421f,0.136514f},{0.223242f,0.0680782f,0.126309f},
{0.241414f,0.0854032f,0.115241f},{0.265439f,0.0969793f,0.10525f},{0.306765f,0.13379f,0.0561555f},
{0.349583f,0.126279f,0.0517622f},{0.381449f,0.104889f,0.0547534f},{0.398489f,0.0728766f,0.0633834f},
{0.400159f,0.0351155f,0.0757282f},{0.388138f,-0.00264554f,0.0910661f},{0.364489f,-0.0346578f,0.108922f},
{0.330591f,-0.0560477f,0.126846f},{0.287987f,-0.0635589f,0.140574f},{0.241024f,-0.0560477f,0.146878f},
{0.198397f,-0.0346578f,0.145269f},{0.17056f,-0.00264554f,0.136838f},{0.164573f,0.0351155f,0.122803f},
{0.18101f,0.0728766f,0.104726f},{0.215025f,0.104889f,0.0852658f},{0.259448f,0.126279f,0.067972f},
{0.322458f,0.145293f,0.00425289f},{0.381335f,0.135479f,-0.00130134f},{0.4259f,0.107531f,0.00352389f},
{0.448605f,0.0657054f,0.0170174f},{0.448896f,0.0163682f,0.0354859f},{0.431053f,-0.0329691f,0.0567292f},
{0.399729f,-0.0747951f,0.0799807f},{0.35711f,-0.102742f,0.102015f},{0.303763f,-0.112556f,0.116832f},
{0.243626f,-0.102742f,0.120643f},{0.187909f,-0.0747951f,0.114571f},{0.151294f,-0.032969f,0.101662f},
{0.143201f,0.0163682f,0.0838106f},{0.163332f,0.0657054f,0.0622674f},{0.204947f,0.107531f,0.0393893f},
{0.260449f,0.135479f,0.018813f},{0.337146f,0.133801f,-0.0513591f},{0.405991f,0.123178f,-0.0596923f},
{0.459809f,0.0929286f,-0.0556713f},{0.486676f,0.0476564f,-0.039131f},{0.48513f,-0.00574584f,-0.0149238f},
{0.461581f,-0.0591481f,0.0117126f},{0.423385f,-0.10442f,0.0378093f},{0.374549f,-0.13467f,0.059798f},
{0.316475f,-0.145293f,0.072463f},{0.253313f,-0.13467f,0.0730645f},{0.196251f,-0.10442f,0.0637669f},
{0.159614f,-0.059148f,0.0486072f},{0.151825f,-0.00574584f,0.0300291f},{0.171463f,0.0476564f,0.00889002f},
{0.212175f,0.0929286f,-0.0135302f},{0.269009f,0.123178f,-0.0346653f}
},

//lid3
{
{-0.354934f,0.0573656f,-0.132288f},{-0.35381f,-0.000170749f,-0.143506f},{-0.381882f,0.0038597f,-0.148337f},
{-0.406389f,0.0153374f,-0.149276f},{-0.422778f,0.032515f,-0.145954f},{-0.427813f,0.0527773f,-0.138659f},
{-0.420534f,0.0730396f,-0.128481f},{-0.402489f,0.0902173f,-0.117185f},{-0.377147f,0.101695f,-0.106769f},
{-0.348936f,0.105725f,-0.098952f},{-0.322337f,0.101695f,-0.0948513f},{-0.301181f,0.0902172f,-0.0948892f},
{-0.288106f,0.0730396f,-0.0988492f},{-0.28438f,0.0527773f,-0.106035f},{-0.290143f,0.032515f,-0.11543f},
{-0.304767f,0.0153374f,-0.125765f},{-0.326835f,0.00385966f,-0.135594f},{-0.34734f,-0.0581242f,-0.131498f},
{-0.398136f,-0.0506769f,-0.137744f},{-0.443184f,-0.0294689f,-0.13778f},{-0.473215f,0.00227113f,-0.130937f},
{-0.481555f,0.039711f,-0.117333f},{-0.466781f,0.077151f,-0.0988643f},{-0.432955f,0.108891f,-0.0790885f},
{-0.387165f,0.130099f,-0.0617732f},{-0.337041f,0.137546f,-0.0495308f},{-0.290066f,0.130099f,-0.0438717f},
{-0.253281f,0.108891f,-0.0455929f},{-0.231674f,0.0771509f,-0.0543229f},{-0.226688f,0.039711f,-0.0683984f},
{-0.237222f,0.00227109f,-0.0856564f},{-0.26199f,-0.0294689f,-0.103695f},{-0.299775f,-0.0506769f,-0.119748f},
{-0.338795f,-0.107672f,-0.0983158f},{-0.401925f,-0.0979416f,-0.102189f},{-0.456905f,-0.070232f,-0.0992443f},
{-0.492207f,-0.0287616f,-0.0890065f},{-0.5f,0.020156f,-0.0714432f},{-0.479892f,0.0690737f,-0.0489261f},
{-0.438293f,0.110544f,-0.0262122f},{-0.383453f,0.138254f,-0.00747452f},{-0.322322f,0.147984f,0.00582876f},
{-0.262487f,0.138254f,0.0126678f},{-0.214117f,0.110544f,0.0103978f},{-0.186347f,0.0690736f,-0.00228616f},
{-0.181908f,0.020156f,-0.0226702f},{-0.197763f,-0.0287616f,-0.0462757f},{-0.230646f,-0.070232f,-0.0690678f},
{-0.278912f,-0.0979416f,-0.0872364f},{-0.331209f,-0.141271f,-0.0482373f},{-0.395084f,-0.130739f,-0.0496675f},
{-0.44825f,-0.100746f,-0.0446528f},{-0.480164f,-0.0558588f,-0.0332809f},{-0.484745f,-0.00291071f,-0.0156133f},
{-0.463326f,0.0500373f,0.00600839f},{-0.422637f,0.0949245f,0.0268506f},{-0.369065f,0.124917f,0.0437058f},
{-0.30661f,0.135449f,0.0570844f},{-0.241634f,0.124917f,0.0664523f},{-0.186655f,0.0949245f,0.0665538f},
{-0.155078f,0.0500372f,0.053143f},{-0.152135f,-0.00291078f,0.0293266f},{-0.173756f,-0.0558588f,0.00241507f},
{-0.213691f,-0.100746f,-0.0216839f},{-0.267826f,-0.130739f,-0.0391481f},{0.354934f,0.0573656f,-0.132288f},
{0.35381f,-0.000170749f,-0.143506f},{0.381882f,0.00385971f,-0.148337f},{0.406389f,0.0153374f,-0.149276f},
{0.422778f,0.032515f,-0.145954f},{0.427813f,0.0527773f,-0.138659f},{0.420534f,0.0730396f,-0.128481f},
{0.402489f,0.0902173f,-0.117185f},{0.377147f,0.101695f,-0.106769f},{0.348936f,0.105725f,-0.098952f},
{0.322337f,0.101695f,-0.0948513f},{0.30118f,0.0902172f,-0.0948892f},{0.288106f,0.0730396f,-0.0988492f},
{0.28438f,0.0527773f,-0.106035f},{0.290143f,0.032515f,-0.11543f},{0.304766f,0.0153374f,-0.125765f},
{0.326835f,0.00385966f,-0.135594f},{0.34734f,-0.0581242f,-0.131498f},{0.398136f,-0.0506769f,-0.137744f},
{0.443184f,-0.0294689f,-0.13778f},{0.473215f,0.00227113f,-0.130937f},{0.481555f,0.039711f,-0.117333f},
{0.466781f,0.077151f,-0.0988643f},{0.432955f,0.108891f,-0.0790885f},{0.387165f,0.130099f,-0.0617732f},
{0.337041f,0.137546f,-0.0495308f},{0.290066f,0.130099f,-0.0438717f},{0.253281f,0.108891f,-0.0455929f},
{0.231674f,0.0771509f,-0.0543229f},{0.226688f,0.039711f,-0.0683984f},{0.237222f,0.00227109f,-0.0856564f},
{0.26199f,-0.0294689f,-0.103695f},{0.299775f,-0.0506769f,-0.119748f},{0.338795f,-0.107672f,-0.0983158f},
{0.401925f,-0.0979416f,-0.102189f},{0.456905f,-0.070232f,-0.0992443f},{0.492207f,-0.0287616f,-0.0890065f},
{0.5f,0.020156f,-0.0714432f},{0.479892f,0.0690737f,-0.0489261f},{0.438293f,0.110544f,-0.0262122f},
{0.383453f,0.138254f,-0.00747452f},{0.322321f,0.147984f,0.00582876f},{0.262487f,0.138254f,0.0126678f},
{0.214117f,0.110544f,0.0103978f},{0.186347f,0.0690736f,-0.00228616f},{0.181908f,0.020156f,-0.0226702f},
{0.197763f,-0.0287616f,-0.0462757f},{0.230646f,-0.070232f,-0.0690678f},{0.278912f,-0.0979416f,-0.0872364f},
{0.331209f,-0.141271f,-0.0482373f},{0.395083f,-0.130739f,-0.0496675f},{0.44825f,-0.100746f,-0.0446528f},
{0.480164f,-0.0558588f,-0.0332809f},{0.484745f,-0.00291071f,-0.0156133f},{0.463326f,0.0500373f,0.00600839f},
{0.422637f,0.0949245f,0.0268506f},{0.369065f,0.124917f,0.0437058f},{0.30661f,0.135449f,0.0570844f},
{0.241634f,0.124917f,0.0664523f},{0.186655f,0.0949245f,0.0665538f},{0.155078f,0.0500372f,0.053143f},
{0.152135f,-0.00291078f,0.0293266f},{0.173756f,-0.0558588f,0.00241507f},{0.213691f,-0.100746f,-0.0216839f},
{0.267826f,-0.130739f,-0.0391481f},{-0.277987f,0.0386883f,0.132131f},{-0.287513f,0.0910388f,0.106426f},
{-0.310982f,0.0868129f,0.102243f},{-0.32908f,0.0747783f,0.101479f},{-0.339832f,0.0567673f,0.103884f},
{-0.342399f,0.0355218f,0.10907f},{-0.336808f,0.0142763f,0.116615f},{-0.323672f,-0.00373473f,0.125754f},
{-0.304119f,-0.0157693f,0.135112f},{-0.280073f,-0.0199953f,0.142976f},{-0.254669f,-0.0157693f,0.147932f},
{-0.232214f,-0.00373472f,0.149276f},{-0.217264f,0.0142763f,0.146921f},{-0.21312f,0.0355218f,0.141185f},
{-0.22065f,0.0567673f,0.13281f},{-0.238105f,0.0747783f,0.123086f},{-0.261851f,0.0868129f,0.113735f},
{-0.302723f,0.129086f,0.0681242f},{-0.345325f,0.121278f,0.0626405f},{-0.37736f,0.0990408f,0.0633087f},
{-0.395498f,0.0657608f,0.068684f},{-0.399073f,0.0265043f,0.0776627f},{-0.389194f,-0.0127523f,0.0902372f},
{-0.367429f,-0.0460323f,0.105995f},{-0.33493f,-0.0682694f,0.122262f},{-0.293123f,-0.076078f,0.134908f},
{-0.246114f,-0.0682694f,0.141237f},{-0.202283f,-0.0460323f,0.141245f},{-0.172133f,-0.0127523f,0.136049f},
{-0.163456f,0.0265042f,0.126224f},{-0.177871f,0.0657607f,0.11221f},{-0.21106f,0.0990408f,0.0956785f},
{-0.255442f,0.121278f,0.0798278f},{-0.318575f,0.147039f,0.018955f},{-0.376353f,0.136836f,0.0126824f},
{-0.420545f,0.107782f,0.0146494f},{-0.444704f,0.0642997f,0.0232859f},{-0.447788f,0.0130085f,0.036352f},
{-0.432737f,-0.0382826f,0.0530567f},{-0.403325f,-0.0817651f,0.0727878f},{-0.361725f,-0.110819f,0.0920003f},
{-0.308949f,-0.121022f,0.105077f},{-0.249036f,-0.110819f,0.109041f},{-0.192594f,-0.0817651f,0.105453f},
{-0.153797f,-0.0382826f,0.0971894f},{-0.142695f,0.0130085f,0.0852546f},{-0.160501f,0.0642996f,0.0694309f},
{-0.201377f,0.107782f,0.0508067f},{-0.256994f,0.136836f,0.0326489f},{-0.333621f,0.142162f,-0.0362204f},
{-0.400982f,0.131119f,-0.0447669f},{-0.454372f,0.0996714f,-0.0438248f},{-0.483064f,0.0526063f,-0.0330922f},
{-0.484745f,-0.00291076f,-0.0156133f},{-0.464001f,-0.0584278f,0.00516931f},{-0.42714f,-0.105493f,0.0266546f},
{-0.378398f,-0.136941f,0.0451392f},{-0.320159f,-0.147984f,0.0560012f},{-0.257181f,-0.136941f,0.0573072f},
{-0.200088f,-0.105493f,0.0513338f},{-0.162235f,-0.0584278f,0.0415487f},{-0.152135f,-0.00291073f,0.0293265f},
{-0.169683f,0.0526063f,0.0142241f},{-0.209585f,0.0996715f,-0.00340899f},{-0.266299f,0.131119f,-0.0212809f},
{0.277987f,0.0386883f,0.132131f},{0.287513f,0.0910388f,0.106426f},{0.310982f,0.0868129f,0.102243f},
{0.32908f,0.0747783f,0.101479f},{0.339832f,0.0567673f,0.103884f},{0.342399f,0.0355218f,0.10907f},
{0.336808f,0.0142763f,0.116615f},{0.323672f,-0.00373473f,0.125754f},{0.304119f,-0.0157693f,0.135112f},
{0.280073f,-0.0199953f,0.142976f},{0.254669f,-0.0157693f,0.147932f},{0.232214f,-0.00373472f,0.149276f},
{0.217264f,0.0142763f,0.146921f},{0.21312f,0.0355218f,0.141185f},{0.22065f,0.0567673f,0.13281f},
{0.238105f,0.0747783f,0.123086f},{0.261851f,0.0868129f,0.113735f},{0.302723f,0.129086f,0.0681242f},
{0.345325f,0.121278f,0.0626405f},{0.37736f,0.0990408f,0.0633087f},{0.395498f,0.0657608f,0.068684f},
{0.399073f,0.0265043f,0.0776627f},{0.389194f,-0.0127523f,0.0902372f},{0.367429f,-0.0460323f,0.105995f},
{0.33493f,-0.0682694f,0.122262f},{0.293123f,-0.076078f,0.134908f},{0.246114f,-0.0682694f,0.141237f},
{0.202283f,-0.0460323f,0.141246f},{0.172133f,-0.0127523f,0.136049f},{0.163456f,0.0265042f,0.126224f},
{0.177871f,0.0657607f,0.11221f},{0.21106f,0.0990408f,0.0956785f},{0.255442f,0.121278f,0.0798278f},
{0.318575f,0.147039f,0.018955f},{0.376353f,0.136836f,0.0126824f},{0.420545f,0.107782f,0.0146494f},
{0.444704f,0.0642997f,0.0232859f},{0.447787f,0.0130085f,0.036352f},{0.432737f,-0.0382826f,0.0530567f},
{0.403325f,-0.0817651f,0.0727878f},{0.361725f,-0.110819f,0.0920003f},{0.308949f,-0.121022f,0.105077f},
{0.249036f,-0.110819f,0.109041f},{0.192594f,-0.0817651f,0.105453f},{0.153797f,-0.0382825f,0.0971894f},
{0.142695f,0.0130085f,0.0852546f},{0.160501f,0.0642996f,0.0694309f},{0.201377f,0.107782f,0.0508067f},
{0.256994f,0.136836f,0.0326489f},{0.333621f,0.142162f,-0.0362204f},{0.400982f,0.131119f,-0.0447669f},
{0.454372f,0.0996714f,-0.0438248f},{0.483064f,0.0526063f,-0.0330922f},{0.484745f,-0.00291076f,-0.0156133f},
{0.464001f,-0.0584278f,0.00516931f},{0.42714f,-0.105493f,0.0266546f},{0.378398f,-0.136941f,0.0451392f},
{0.320159f,-0.147984f,0.0560012f},{0.257181f,-0.136941f,0.0573072f},{0.200088f,-0.105493f,0.0513338f},
{0.162235f,-0.0584278f,0.0415487f},{0.152135f,-0.00291073f,0.0293265f},{0.169683f,0.0526063f,0.0142241f},
{0.209585f,0.0996715f,-0.00340899f},{0.266299f,0.131119f,-0.0212809f}
},

//lid2
{
{-0.35492f,0.0490122f,-0.136664f},{-0.352441f,-0.00933507f,-0.143152f},{-0.38041f,-0.00517772f,-0.148025f},
{-0.405069f,0.00666169f,-0.149782f},{-0.421938f,0.0243805f,-0.147992f},{-0.427713f,0.0452814f,-0.142654f},
{-0.421216f,0.0661823f,-0.134438f},{-0.403749f,0.0839011f,-0.124699f},{-0.378666f,0.0957405f,-0.115177f},
{-0.35044f,0.0998979f,-0.107521f},{-0.323665f,0.0957405f,-0.102911f},{-0.302226f,0.0839011f,-0.101906f},
{-0.288762f,0.0661823f,-0.104479f},{-0.284557f,0.0452814f,-0.110146f},{-0.289822f,0.0243805f,-0.118063f},
{-0.304004f,0.00666169f,-0.127075f},{-0.32572f,-0.00517772f,-0.13585f},{-0.345275f,-0.0662611f,-0.126649f},
{-0.395652f,-0.0585793f,-0.132679f},{-0.44069f,-0.0367029f,-0.13407f},{-0.471557f,-0.00396281f,-0.130108f},
{-0.481531f,0.0346569f,-0.12031f},{-0.468499f,0.0732766f,-0.105598f},{-0.435716f,0.106017f,-0.0886244f},
{-0.390041f,0.127893f,-0.0727466f},{-0.339539f,0.135575f,-0.0606899f},{-0.292198f,0.127893f,-0.0541963f},
{-0.255096f,0.106017f,-0.0541648f},{-0.232923f,0.0732764f,-0.0604336f},{-0.22704f,0.0346569f,-0.0718106f},
{-0.236654f,-0.00396281f,-0.0865268f},{-0.26078f,-0.0367029f,-0.102256f},{-0.298141f,-0.0585793f,-0.116287f},
{-0.336804f,-0.1131f,-0.0896059f},{-0.399229f,-0.103063f,-0.0934247f},{-0.453895f,-0.0744799f,-0.0923695f},
{-0.490081f,-0.0317029f,-0.0858416f},{-0.5f,0.0187562f,-0.0730349f},{-0.482199f,0.0692151f,-0.0551062f},
{-0.441819f,0.111992f,-0.0357056f},{-0.386863f,0.140575f,-0.0186269f},{-0.32513f,0.150612f,-0.00569723f},
{-0.265008f,0.140575f,0.00175248f},{-0.216493f,0.111992f,0.00131805f},{-0.188031f,0.0692151f,-0.0082449f},
{-0.182283f,0.018756f,-0.0249265f},{-0.196942f,-0.0317029f,-0.045005f},{-0.229284f,-0.0744799f,-0.0646411f},
{-0.277356f,-0.103063f,-0.080166f},{-0.329818f,-0.14272f,-0.0368107f},{-0.392866f,-0.131856f,-0.0388037f},
{-0.445457f,-0.100918f,-0.0362398f},{-0.477976f,-0.0546165f,-0.0288117f},{-0.484459f,0.0f,-0.0157477f},
{-0.465204f,0.0546165f,0.00161825f},{-0.425725f,0.100918f,0.0193463f},{-0.372221f,0.131856f,0.034428f},
{-0.309484f,0.14272f,0.0470423f},{-0.244464f,0.131856f,0.0565813f},{-0.189292f,0.100918f,0.0583469f},
{-0.156703f,0.0546165f,0.048326f},{-0.152152f,0.0f,0.0288029f},{-0.172617f,-0.0546165f,0.00608634f},
{-0.212389f,-0.100918f,-0.0143389f},{-0.266725f,-0.131856f,-0.0290232f},{0.35492f,0.0490122f,-0.136664f},
{0.352441f,-0.00933507f,-0.143152f},{0.38041f,-0.00517772f,-0.148025f},{0.405069f,0.00666169f,-0.149782f},
{0.421938f,0.0243805f,-0.147992f},{0.427713f,0.0452814f,-0.142654f},{0.421216f,0.0661823f,-0.134438f},
{0.403749f,0.0839011f,-0.124699f},{0.378666f,0.0957405f,-0.115177f},{0.35044f,0.0998979f,-0.107521f},
{0.323665f,0.0957405f,-0.102911f},{0.302226f,0.0839011f,-0.101906f},{0.288762f,0.0661823f,-0.104479f},
{0.284557f,0.0452814f,-0.110146f},{0.289822f,0.0243805f,-0.118063f},{0.304004f,0.00666169f,-0.127075f},
{0.32572f,-0.00517772f,-0.13585f},{0.345275f,-0.0662611f,-0.126649f},{0.395652f,-0.0585793f,-0.132679f},
{0.44069f,-0.0367029f,-0.13407f},{0.471557f,-0.00396281f,-0.130108f},{0.481531f,0.0346569f,-0.12031f},
{0.468499f,0.0732766f,-0.105598f},{0.435716f,0.106017f,-0.0886244f},{0.390041f,0.127893f,-0.0727466f},
{0.339539f,0.135575f,-0.0606899f},{0.292198f,0.127893f,-0.0541963f},{0.255096f,0.106017f,-0.0541648f},
{0.232923f,0.0732764f,-0.0604336f},{0.22704f,0.0346569f,-0.0718106f},{0.236655f,-0.00396281f,-0.0865268f},
{0.26078f,-0.0367029f,-0.102256f},{0.298142f,-0.0585793f,-0.116287f},{0.336804f,-0.1131f,-0.0896059f},
{0.399229f,-0.103063f,-0.0934246f},{0.453895f,-0.0744799f,-0.0923695f},{0.490081f,-0.0317029f,-0.0858416f},
{0.5f,0.0187562f,-0.0730349f},{0.482199f,0.0692151f,-0.0551062f},{0.441819f,0.111992f,-0.0357056f},
{0.386863f,0.140575f,-0.018627f},{0.32513f,0.150612f,-0.00569723f},{0.265008f,0.140575f,0.00175248f},
{0.216493f,0.111992f,0.00131805f},{0.188031f,0.0692151f,-0.0082449f},{0.182283f,0.018756f,-0.0249265f},
{0.196942f,-0.0317029f,-0.045005f},{0.229284f,-0.0744799f,-0.0646411f},{0.277356f,-0.103063f,-0.0801659f},
{0.329818f,-0.14272f,-0.0368107f},{0.392866f,-0.131856f,-0.0388037f},{0.445457f,-0.100918f,-0.0362398f},
{0.477976f,-0.0546165f,-0.0288117f},{0.484459f,0.0f,-0.0157477f},{0.465204f,0.0546165f,0.00161825f},
{0.425725f,0.100918f,0.0193463f},{0.372221f,0.131856f,0.034428f},{0.309485f,0.14272f,0.0470423f},
{0.244464f,0.131856f,0.0565813f},{0.189292f,0.100918f,0.0583469f},{0.156704f,0.0546165f,0.048326f},
{0.152152f,0.0f,0.0288029f},{0.172617f,-0.0546165f,0.00608634f},{0.212389f,-0.100918f,-0.0143389f},
{0.266725f,-0.131856f,-0.0290232f},{-0.277716f,0.00836844f,0.14043f},{-0.280742f,0.0653898f,0.122636f},
{-0.304826f,0.0610009f,0.117201f},{-0.324257f,0.0485021f,0.114166f},{-0.336986f,0.0297963f,0.11374f},
{-0.341972f,0.00773147f,0.11596f},{-0.338904f,-0.0143335f,0.120679f},{-0.328031f,-0.0330392f,0.127263f},
{-0.310188f,-0.0455381f,0.134519f},{-0.287054f,-0.0499271f,0.141103f},{-0.26152f,-0.0455381f,0.146069f},
{-0.23771f,-0.0330392f,0.149017f},{-0.220253f,-0.0143335f,0.149782f},{-0.21295f,0.00773147f,0.148127f},
{-0.217451f,0.0297963f,0.143878f},{-0.232678f,0.0485021f,0.137394f},{-0.255266f,0.0610009f,0.129799f},
{-0.293369f,0.112456f,0.0912079f},{-0.336341f,0.104346f,0.0834187f},{-0.369703f,0.0812518f,0.0796233f},
{-0.390712f,0.0466881f,0.0791105f},{-0.398299f,0.00591745f,0.0819687f},{-0.392462f,-0.0348534f,0.0889353f},
{-0.373867f,-0.0694169f,0.09953f},{-0.343481f,-0.0925117f,0.111166f},{-0.303004f,-0.100622f,0.120699f},
{-0.256454f,-0.0925117f,0.126708f},{-0.211359f,-0.0694169f,0.129889f},{-0.177502f,-0.0348532f,0.131224f},
{-0.163381f,0.00591745f,0.13016f},{-0.172658f,0.0466881f,0.125f},{-0.202749f,0.0812518f,0.115147f},
{-0.24612f,0.104346f,0.102663f},{-0.309223f,0.142402f,0.0478398f},{-0.365947f,0.131806f,0.0395624f},
{-0.410513f,0.101631f,0.0358015f},{-0.438152f,0.0564719f,0.0354415f},{-0.446767f,0.00320249f,0.0385313f},
{-0.436696f,-0.0500671f,0.0461625f},{-0.409985f,-0.0952267f,0.0578119f},{-0.369058f,-0.125401f,0.0700902f},
{-0.316548f,-0.135997f,0.0790487f},{-0.257432f,-0.125401f,0.0834509f},{-0.201015f,-0.0952267f,0.0851812f},
{-0.159359f,-0.0500669f,0.0863865f},{-0.142616f,0.00320249f,0.0865623f},{-0.154858f,0.0564719f,0.0828629f},
{-0.192921f,0.101632f,0.0734676f},{-0.248087f,0.131806f,0.0602875f},{-0.324881f,0.150669f,-0.00479203f},
{-0.39012f,0.1392f,-0.0144446f},{-0.443458f,0.106539f,-0.0197515f},{-0.476273f,0.0576585f,-0.0201944f},
{-0.484459f,0.0f,-0.0157477f},{-0.468884f,-0.0576585f,-0.00684364f},{-0.433719f,-0.106539f,0.00467625f},
{-0.38391f,-0.1392f,0.0154431f},{-0.32438f,-0.150669f,0.0225054f},{-0.261719f,-0.1392f,0.0255482f},
{-0.205523f,-0.106539f,0.0267245f},{-0.166441f,-0.0576583f,0.0280126f},{-0.152152f,0.0f,0.0288029f},
{-0.165015f,0.0576585f,0.0263835f},{-0.202543f,0.106539f,0.0188847f},{-0.258754f,0.1392f,0.00739763f},
{0.277716f,0.00836844f,0.14043f},{0.280742f,0.0653898f,0.122636f},{0.304826f,0.0610009f,0.117201f},
{0.324257f,0.0485021f,0.114166f},{0.336986f,0.0297963f,0.11374f},{0.341972f,0.00773147f,0.11596f},
{0.338904f,-0.0143335f,0.120679f},{0.328031f,-0.0330392f,0.127263f},{0.310188f,-0.0455381f,0.134519f},
{0.287054f,-0.0499271f,0.141103f},{0.26152f,-0.0455381f,0.146069f},{0.23771f,-0.0330392f,0.149017f},
{0.220253f,-0.0143335f,0.149782f},{0.21295f,0.00773147f,0.148127f},{0.217451f,0.0297963f,0.143878f},
{0.232678f,0.0485021f,0.137394f},{0.255266f,0.0610009f,0.129799f},{0.293369f,0.112456f,0.0912079f},
{0.336341f,0.104346f,0.0834187f},{0.369703f,0.0812518f,0.0796233f},{0.390712f,0.0466881f,0.0791105f},
{0.398299f,0.00591745f,0.0819687f},{0.392462f,-0.0348534f,0.0889353f},{0.373867f,-0.0694169f,0.09953f},
{0.343481f,-0.0925117f,0.111166f},{0.303004f,-0.100622f,0.120699f},{0.256454f,-0.0925117f,0.126708f},
{0.211359f,-0.0694169f,0.129889f},{0.177502f,-0.0348532f,0.131224f},{0.163381f,0.00591745f,0.13016f},
{0.172658f,0.0466881f,0.125f},{0.202749f,0.0812518f,0.115147f},{0.24612f,0.104346f,0.102663f},
{0.309223f,0.142402f,0.0478398f},{0.365947f,0.131806f,0.0395624f},{0.410513f,0.101631f,0.0358015f},
{0.438152f,0.0564719f,0.0354415f},{0.446767f,0.00320249f,0.0385313f},{0.436696f,-0.0500671f,0.0461625f},
{0.409985f,-0.0952267f,0.0578119f},{0.369058f,-0.125401f,0.0700902f},{0.316548f,-0.135997f,0.0790487f},
{0.257432f,-0.125401f,0.0834509f},{0.201015f,-0.0952267f,0.0851812f},{0.159359f,-0.0500669f,0.0863865f},
{0.142616f,0.00320249f,0.0865623f},{0.154858f,0.0564719f,0.082863f},{0.192921f,0.101632f,0.0734676f},
{0.248087f,0.131806f,0.0602875f},{0.324881f,0.150669f,-0.00479203f},{0.39012f,0.1392f,-0.0144446f},
{0.443458f,0.106539f,-0.0197515f},{0.476273f,0.0576585f,-0.0201944f},{0.468884f,-0.0576585f,-0.00684364f},
{0.433719f,-0.106539f,0.00467625f},{0.38391f,-0.1392f,0.0154431f},{0.32438f,-0.150669f,0.0225054f},
{0.261719f,-0.1392f,0.0255482f},{0.205523f,-0.106539f,0.0267245f},{0.166441f,-0.0576583f,0.0280126f},
{0.165015f,0.0576585f,0.0263835f},{0.202543f,0.106539f,0.0188847f},{0.258754f,0.1392f,0.00739763f}
},

//lid 1
{
{-0.353951f,0.019129f,-0.142995f},{-0.348688f,-0.0395605f,-0.13725f},{-0.37644f,-0.0352039f,-0.142413f},
{-0.401426f,-0.0227972f,-0.146432f},{-0.419356f,-0.00422938f,-0.148674f},{-0.426804f,0.0176729f,-0.148449f},
{-0.422104f,0.0395752f,-0.145383f},{-0.405972f,0.058143f,-0.139773f},{-0.38145f,0.0705497f,-0.132638f},
{-0.353099f,0.0749063f,-0.125394f},{-0.325786f,0.0705497f,-0.119389f},{-0.303578f,0.058143f,-0.115579f},
{-0.289167f,0.0395752f,-0.114452f},{-0.283899f,0.0176729f,-0.116049f},{-0.288135f,-0.00422939f,-0.119964f},
{-0.301449f,-0.0227972f,-0.125397f},{-0.322478f,-0.0352039f,-0.13141f},{-0.340315f,-0.0922273f,-0.10959f},
{-0.389728f,-0.0841773f,-0.115854f},{-0.434689f,-0.0612528f,-0.121228f},{-0.467406f,-0.0269439f,-0.124791f},
{-0.481165f,0.0135262f,-0.124789f},{-0.472339f,0.0539964f,-0.119913f},{-0.442178f,0.0883053f,-0.110465f},
{-0.396778f,0.11123f,-0.0984804f},{-0.345153f,0.11928f,-0.0867588f},{-0.296599f,0.11123f,-0.0776884f},
{-0.258429f,0.0883053f,-0.0726898f},{-0.234746f,0.0539964f,-0.0723075f},{-0.226799f,0.0135262f,-0.076421f},
{-0.234523f,-0.0269439f,-0.0840859f},{-0.257485f,-0.0612528f,-0.0933808f},{-0.294094f,-0.0841773f,-0.102202f},
{-0.332059f,-0.130853f,-0.0636959f},{-0.392836f,-0.120335f,-0.0686586f},{-0.446727f,-0.0903832f,-0.0732333f},
{-0.484947f,-0.0455564f,-0.0763222f},{-0.5f,0.00732036f,-0.0756228f},{-0.488046f,0.0601971f,-0.0697015f},
{-0.450962f,0.105024f,-0.0593253f},{-0.395754f,0.134976f,-0.0468043f},{-0.332196f,0.145494f,-0.0345443f},
{-0.270886f,0.134976f,-0.02476f},{-0.221613f,0.105024f,-0.0196705f},{-0.191182f,0.0601971f,-0.0206756f},
{-0.182158f,0.00732032f,-0.0273943f},{-0.194127f,-0.0455565f,-0.0377315f},{-0.225565f,-0.0903832f,-0.0486242f},
{-0.273503f,-0.120335f,-0.0574568f},{-0.325519f,-0.149558f,-0.00603217f},{-0.386779f,-0.138174f,-0.0106294f},
{-0.438138f,-0.105754f,-0.0150412f},{-0.472319f,-0.0572334f,-0.0176549f},{-0.483755f,3.0617e-008f,-0.0160775f},
{-0.470309f,0.0572334f,-0.0097539f},{-0.434281f,0.105754f,-0.000563411f},{-0.381004f,0.138174f,0.00963235f},
{-0.317226f,0.149558f,0.0205644f},{-0.251709f,0.138174f,0.031268f},{-0.195747f,0.105754f,0.0380775f},
{-0.160203f,0.0572334f,0.0373458f},{-0.151073f,-4.4012e-008f,0.0293253f},{-0.16826f,-0.0572335f,0.0178688f},
{-0.207633f,-0.105754f,0.00716789f},{-0.262789f,-0.138174f,-0.000655924f},{0.353951f,0.019129f,-0.142995f},
{0.348688f,-0.0395605f,-0.13725f},{0.37644f,-0.0352039f,-0.142413f},{0.401426f,-0.0227972f,-0.146432f},
{0.419356f,-0.00422938f,-0.148674f},{0.426804f,0.0176729f,-0.148449f},{0.422103f,0.0395752f,-0.145383f},
{0.405972f,0.058143f,-0.139773f},{0.381449f,0.0705497f,-0.132638f},{0.353099f,0.0749063f,-0.125394f},
{0.325786f,0.0705497f,-0.119389f},{0.303578f,0.058143f,-0.115579f},{0.289167f,0.0395752f,-0.114452f},
{0.283899f,0.0176729f,-0.116049f},{0.288135f,-0.00422939f,-0.119964f},{0.301449f,-0.0227972f,-0.125397f},
{0.322478f,-0.0352039f,-0.13141f},{0.340315f,-0.0922273f,-0.10959f},{0.389728f,-0.0841773f,-0.115854f},
{0.434689f,-0.0612528f,-0.121228f},{0.467405f,-0.0269439f,-0.124791f},{0.481165f,0.0135262f,-0.124789f},
{0.472339f,0.0539964f,-0.119913f},{0.442178f,0.0883053f,-0.110465f},{0.396778f,0.11123f,-0.0984804f},
{0.345153f,0.11928f,-0.0867588f},{0.296598f,0.11123f,-0.0776884f},{0.258429f,0.0883053f,-0.0726898f},
{0.234746f,0.0539964f,-0.0723075f},{0.226799f,0.0135262f,-0.076421f},{0.234523f,-0.0269439f,-0.0840859f},
{0.257485f,-0.0612528f,-0.0933808f},{0.294094f,-0.0841773f,-0.102202f},{0.332059f,-0.130853f,-0.0636959f},
{0.392836f,-0.120335f,-0.0686586f},{0.446727f,-0.0903832f,-0.0732333f},{0.484947f,-0.0455564f,-0.0763222f},
{0.5f,0.00732036f,-0.0756228f},{0.488046f,0.0601971f,-0.0697015f},{0.450962f,0.105024f,-0.0593253f},
{0.395754f,0.134976f,-0.0468043f},{0.332195f,0.145494f,-0.0345443f},{0.270886f,0.134976f,-0.02476f},
{0.221613f,0.105024f,-0.0196705f},{0.191182f,0.0601971f,-0.0206756f},{0.182158f,0.00732032f,-0.0273943f},
{0.194127f,-0.0455565f,-0.0377315f},{0.225565f,-0.0903832f,-0.0486242f},{0.273503f,-0.120335f,-0.0574568f},
{0.325519f,-0.149558f,-0.00603217f},{0.386779f,-0.138174f,-0.0106294f},{0.438138f,-0.105754f,-0.0150412f},
{0.472319f,-0.0572334f,-0.0176549f},{0.483755f,3.0617e-008f,-0.0160775f},{0.470309f,0.0572334f,-0.0097539f},
{0.434281f,0.105754f,-0.000563411f},{0.381004f,0.138174f,0.00963235f},{0.317226f,0.149558f,0.0205644f},
{0.251709f,0.138174f,0.031268f},{0.195747f,0.105754f,0.0380775f},{0.160203f,0.0572334f,0.0373458f},
{0.151073f,-4.4012e-008f,0.0293253f},{0.16826f,-0.0572335f,0.0178688f},{0.207633f,-0.105754f,0.00716789f},
{0.262789f,-0.138174f,-0.000655924f},{-0.278685f,-0.0184455f,0.142104f},{-0.276782f,0.0402249f,0.131836f},
{-0.301275f,0.0358657f,0.125528f},{-0.32166f,0.023452f,0.120724f},{-0.335761f,0.00487346f,0.117933f},
{-0.342327f,-0.0170414f,0.117442f},{-0.340777f,-0.0389562f,0.119308f},{-0.331139f,-0.0575348f,0.123149f},
{-0.314161f,-0.0699485f,0.128161f},{-0.291535f,-0.0743076f,0.133481f},{-0.266105f,-0.0699485f,0.138543f},
{-0.241813f,-0.0575347f,0.143068f},{-0.223134f,-0.0389562f,0.146692f},{-0.213979f,-0.0170414f,0.148674f},
{-0.216437f,0.00487348f,0.148103f},{-0.22997f,0.023452f,0.144568f},{-0.251555f,0.0358657f,0.138674f},
{-0.286428f,0.0927713f,0.106668f},{-0.329876f,0.0847167f,0.0969867f},{-0.364411f,0.0617791f,0.0897744f},
{-0.387562f,0.0274504f,0.0847431f},{-0.397904f,-0.0130429f,0.0824777f},{-0.394525f,-0.0535363f,0.0840476f},
{-0.377363f,-0.0878649f,0.089252f},{-0.347459f,-0.110803f,0.096282f},{-0.307253f,-0.118857f,0.103236f},
{-0.261203f,-0.110803f,0.1096f},{-0.216225f,-0.0878649f,0.116136f},{-0.180992f,-0.0535363f,0.123303f},
{-0.163781f,-0.0130429f,0.129625f},{-0.169441f,0.0274504f,0.131883f},{-0.196926f,0.0617791f,0.127674f},
{-0.239231f,0.0847167f,0.117999f},{-0.30165f,0.131194f,0.068821f},{-0.357946f,0.12067f,0.0586132f},
{-0.402983f,0.0907009f,0.0504722f},{-0.433219f,0.0458484f,0.0433801f},{-0.445856f,-0.00705878f,0.0384981f},
{-0.439138f,-0.0599659f,0.0380252f},{-0.413572f,-0.104818f,0.0420112f},{-0.371905f,-0.134788f,0.0480844f},
{-0.318578f,-0.145312f,0.0540119f},{-0.259936f,-0.134788f,0.0596851f},{-0.204491f,-0.104818f,0.0666849f},
{-0.162112f,-0.0599659f,0.0760798f},{-0.142086f,-0.00705876f,0.0861686f},{-0.150271f,0.0458484f,0.0923222f},
{-0.18592f,0.0907008f,0.0903491f},{-0.24061f,0.12067f,0.0808271f},{-0.317406f,0.149644f,0.0199458f},
{-0.381217f,0.138253f,0.00904715f},{-0.434494f,0.105814f,-0.00103264f},{-0.470442f,0.0572662f,-0.0100155f},
{-0.483755f,3.82713e-009f,-0.0160775f},{-0.472208f,-0.0572662f,-0.0173934f},{-0.437995f,-0.105814f,-0.0145555f},
{-0.386668f,-0.138253f,-0.00998602f},{-0.325449f,-0.149644f,-0.00532854f},{-0.262724f,-0.138253f,-8.28803e-006f},
{-0.207546f,-0.105814f,0.00765557f},{-0.168184f,-0.0572662f,0.0181296f},{-0.151073f,3.82713e-009f,0.0293253f},
{-0.160302f,0.0572663f,0.0370842f},{-0.195903f,0.105814f,0.0376073f},{-0.251874f,0.138253f,0.030682f},
{0.278685f,-0.0184455f,0.142104f},{0.276782f,0.0402249f,0.131836f},{0.301275f,0.0358657f,0.125528f},
{0.32166f,0.023452f,0.120724f},{0.335761f,0.00487346f,0.117933f},{0.342327f,-0.0170414f,0.117442f},
{0.340777f,-0.0389562f,0.119308f},{0.331139f,-0.0575348f,0.123149f},{0.314161f,-0.0699485f,0.128161f},
{0.291535f,-0.0743076f,0.133481f},{0.266105f,-0.0699485f,0.138543f},{0.241813f,-0.0575347f,0.143068f},
{0.223134f,-0.0389562f,0.146692f},{0.213978f,-0.0170414f,0.148674f},{0.216437f,0.00487348f,0.148103f},
{0.229969f,0.023452f,0.144568f},{0.251555f,0.0358657f,0.138674f},{0.286428f,0.0927713f,0.106668f},
{0.329876f,0.0847167f,0.0969866f},{0.364411f,0.0617791f,0.0897744f},{0.387562f,0.0274504f,0.084743f},
{0.397904f,-0.0130429f,0.0824776f},{0.394525f,-0.0535363f,0.0840476f},{0.377363f,-0.0878649f,0.089252f},
{0.347459f,-0.110803f,0.0962819f},{0.307253f,-0.118857f,0.103236f},{0.261203f,-0.110802f,0.1096f},
{0.216225f,-0.0878649f,0.116136f},{0.180992f,-0.0535363f,0.123303f},{0.163781f,-0.0130429f,0.129625f},
{0.169441f,0.0274504f,0.131883f},{0.196926f,0.0617791f,0.127674f},{0.239231f,0.0847167f,0.117999f},
{0.30165f,0.131194f,0.068821f},{0.357946f,0.12067f,0.0586132f},{0.402983f,0.0907009f,0.0504722f},
{0.433218f,0.0458484f,0.0433801f},{0.445856f,-0.00705878f,0.0384981f},{0.439138f,-0.0599659f,0.0380252f},
{0.413572f,-0.104818f,0.0420112f},{0.371905f,-0.134788f,0.0480844f},{0.318578f,-0.145312f,0.0540119f},
{0.259936f,-0.134788f,0.0596851f},{0.204491f,-0.104818f,0.0666849f},{0.162111f,-0.0599659f,0.0760797f},
{0.142086f,-0.00705875f,0.0861686f},{0.150271f,0.0458484f,0.0923222f},{0.18592f,0.0907008f,0.0903491f},
{0.24061f,0.12067f,0.0808271f},{0.317406f,0.149644f,0.0199458f},{0.381217f,0.138253f,0.00904715f},
{0.434494f,0.105814f,-0.00103264f},{0.470442f,0.0572662f,-0.0100155f},{0.483755f,3.82713e-009f,-0.0160775f},
{0.472208f,-0.0572662f,-0.0173934f},{0.437995f,-0.105814f,-0.0145555f},{0.386668f,-0.138253f,-0.00998602f},
{0.325449f,-0.149644f,-0.00532854f},{0.262724f,-0.138253f,-8.28803e-006f},{0.207546f,-0.105814f,0.00765557f},
{0.168184f,-0.0572662f,0.0181296f},{0.151073f,3.82713e-009f,0.0293253f},{0.160302f,0.0572663f,0.0370842f},
{0.195903f,0.105814f,0.0376073f},{0.251874f,0.138253f,0.030682f}
}

};

static GLfloat normals [NUM_LIDS][344][3] = {

//lid 10
{
{0.14128f,0.678859f,-0.720549f},{0.141183f,0.470342f,-0.871117f},{0.0436259f,0.538027f,-0.841798f},
{0.0679973f,0.716579f,-0.694184f},{-0.119311f,0.639257f,-0.759681f},{-0.00235058f,0.772214f,-0.635358f},
{-0.255136f,0.759046f,-0.598962f},{-0.0474012f,0.827055f,-0.560118f},{-0.314039f,0.853304f,-0.416235f},
{-0.0600024f,0.866637f,-0.495318f},{-0.292773f,0.915841f,-0.274809f},{-0.049072f,0.891986f,-0.449392f},
{-0.212481f,0.95807f,-0.192231f},{-0.0178326f,0.908456f,-0.417599f},{-0.0920599f,0.982527f,-0.161757f},
{0.0370726f,0.914058f,-0.403886f},{0.0521203f,0.982077f,-0.18113f},{0.108309f,0.902514f,-0.416819f},
{0.201428f,0.946854f,-0.250789f},{0.179027f,0.872331f,-0.45496f},{0.331459f,0.872109f,-0.359945f},
{0.23599f,0.827361f,-0.509688f},{0.418216f,0.768374f,-0.484455f},{0.271011f,0.775009f,-0.570888f},
{0.450676f,0.660369f,-0.60067f},{0.28066f,0.726565f,-0.627163f},{0.433824f,0.571637f,-0.69644f},
{0.269128f,0.691375f,-0.670501f},{0.379646f,0.512038f,-0.77051f},{0.242614f,0.670979f,-0.70066f},
{0.296688f,0.482442f,-0.824152f},{0.20092f,0.665188f,-0.719135f},{0.111321f,0.0838976f,-0.990237f},
{-0.029379f,0.177399f,-0.983701f},{-0.36291f,0.315654f,-0.876732f},{-0.636533f,0.537885f,-0.552726f},
{-0.692297f,0.698565f,-0.180919f},{-0.609692f,0.790176f,0.0624294f},{-0.463645f,0.864983f,0.191929f},
{-0.266794f,0.932768f,0.242413f},{-0.0294763f,0.976851f,0.211879f},{0.23276f,0.968844f,0.0846355f},
{0.473096f,0.871906f,-0.126332f},{0.622688f,0.697126f,-0.355352f},{0.663374f,0.512375f,-0.54535f},
{0.624155f,0.368076f,-0.689167f},{0.531327f,0.266649f,-0.804108f},{0.396108f,0.19478f,-0.897307f},
{0.301284f,0.331535f,-0.894043f},{0.293635f,0.335978f,-0.894929f},{0.0262531f,-0.314782f,-0.948801f},
{-0.145065f,-0.279238f,-0.949201f},{-0.600169f,-0.204803f,-0.773209f},{-0.94784f,0.0687263f,-0.311249f},
{-0.931339f,0.326478f,0.161309f},{-0.775903f,0.471621f,0.418986f},{-0.595717f,0.581008f,0.554573f},
{-0.378996f,0.685218f,0.621963f},{-0.1154f,0.782225f,0.612215f},{0.228237f,0.846899f,0.480282f},
{0.608238f,0.775101f,0.17107f},{0.820052f,0.537806f,-0.19565f},{0.837034f,0.294875f,-0.460893f},
{0.762505f,0.126921f,-0.634411f},{0.630338f,0.00231725f,-0.776317f},{0.436413f,-0.113109f,-0.892609f},
{0.320267f,0.0147375f,-0.947213f},{0.348327f,-0.00790562f,-0.93734f},{-0.0276759f,-0.417145f,-0.908418f},
{-0.141207f,-0.463983f,-0.874517f},{-0.573196f,-0.464631f,-0.674955f},{-0.943646f,-0.249543f,-0.217397f},
{-0.961507f,0.0693531f,0.265886f},{-0.808033f,0.269491f,0.523886f},{-0.636184f,0.393708f,0.663524f},
{-0.43775f,0.497816f,0.748702f},{-0.202579f,0.60248f,0.771997f},{0.122768f,0.708696f,0.694751f},
{0.564416f,0.712283f,0.417239f},{0.875302f,0.482711f,-0.0289185f},{0.906907f,0.205191f,-0.367988f},
{0.825239f,0.0254238f,-0.564212f},{0.68962f,-0.103674f,-0.716712f},{0.478163f,-0.232147f,-0.847035f},
{0.283993f,-0.306895f,-0.908385f},{0.330854f,-0.348141f,-0.877117f},{-0.141183f,0.470342f,-0.871117f},
{-0.14128f,0.678859f,-0.720549f},{-0.043626f,0.538027f,-0.841798f},{-0.0679977f,0.716579f,-0.694184f},
{0.119311f,0.639257f,-0.759681f},{0.00235085f,0.772214f,-0.635358f},{0.255136f,0.759046f,-0.598961f},
{0.0474012f,0.827055f,-0.560118f},{0.314038f,0.853304f,-0.416236f},{0.0600023f,0.866637f,-0.495318f},
{0.292773f,0.915841f,-0.274809f},{0.0490718f,0.891986f,-0.449392f},{0.212481f,0.95807f,-0.192231f},
{0.0178326f,0.908456f,-0.417599f},{0.0920599f,0.982527f,-0.161757f},{-0.0370725f,0.914058f,-0.403886f},
{-0.0521203f,0.982077f,-0.18113f},{-0.108309f,0.902514f,-0.416819f},{-0.201428f,0.946854f,-0.250789f},
{-0.179027f,0.872331f,-0.45496f},{-0.331459f,0.872109f,-0.359945f},{-0.235989f,0.827361f,-0.509688f},
{-0.418216f,0.768374f,-0.484455f},{-0.271012f,0.775009f,-0.570889f},{-0.450676f,0.660369f,-0.60067f},
{-0.28066f,0.726565f,-0.627163f},{-0.433824f,0.571637f,-0.696439f},{-0.269128f,0.691375f,-0.670501f},
{-0.379647f,0.512038f,-0.77051f},{-0.242614f,0.67098f,-0.70066f},{-0.296688f,0.482442f,-0.824152f},
{-0.20092f,0.665189f,-0.719135f},{-0.111321f,0.0838977f,-0.990237f},{0.029379f,0.177399f,-0.983701f},
{0.36291f,0.315654f,-0.876732f},{0.636533f,0.537885f,-0.552726f},{0.692297f,0.698565f,-0.18092f},
{0.609692f,0.790176f,0.0624292f},{0.463645f,0.864984f,0.191929f},{0.266794f,0.932768f,0.242413f},
{0.0294763f,0.976851f,0.211879f},{-0.23276f,0.968844f,0.0846357f},{-0.473096f,0.871906f,-0.126332f},
{-0.622688f,0.697126f,-0.355352f},{-0.663374f,0.512375f,-0.54535f},{-0.624155f,0.368076f,-0.689167f},
{-0.531328f,0.266649f,-0.804108f},{-0.396108f,0.19478f,-0.897307f},{-0.301284f,0.331535f,-0.894043f},
{-0.293635f,0.335978f,-0.894929f},{-0.0262532f,-0.314781f,-0.948801f},{0.145065f,-0.279238f,-0.949201f},
{0.600169f,-0.204803f,-0.773209f},{0.94784f,0.0687262f,-0.311249f},{0.931339f,0.326478f,0.161309f},
{0.775903f,0.471621f,0.418986f},{0.595716f,0.581008f,0.554573f},{0.378996f,0.685218f,0.621963f},
{0.1154f,0.782225f,0.612215f},{-0.228237f,0.846899f,0.480282f},{-0.608238f,0.775101f,0.17107f},
{-0.820052f,0.537806f,-0.19565f},{-0.837034f,0.294875f,-0.460893f},{-0.762505f,0.126921f,-0.634411f},
{-0.630338f,0.00231719f,-0.776317f},{-0.436413f,-0.113109f,-0.892609f},{-0.320267f,0.0147371f,-0.947213f},
{-0.348327f,-0.0079059f,-0.93734f},{0.027676f,-0.417145f,-0.908418f},{0.141207f,-0.463983f,-0.874517f},
{0.573197f,-0.46463f,-0.674955f},{0.943646f,-0.249543f,-0.217397f},{0.961506f,0.0693526f,0.265886f},
{0.808033f,0.269491f,0.523887f},{0.636184f,0.393708f,0.663524f},{0.43775f,0.497816f,0.748702f},
{0.202579f,0.60248f,0.771997f},{-0.122768f,0.708696f,0.694751f},{-0.564416f,0.712283f,0.417239f},
{-0.875302f,0.482711f,-0.0289183f},{-0.906908f,0.205191f,-0.367988f},{-0.825239f,0.0254234f,-0.564211f},
{-0.68962f,-0.103674f,-0.716712f},{-0.478163f,-0.232147f,-0.847035f},{-0.283994f,-0.306895f,-0.908385f},
{-0.330854f,-0.34814f,-0.877117f},{-0.101791f,0.89554f,0.433181f},{-0.10134f,0.982935f,0.153519f},
{-0.198237f,0.947331f,0.251529f},{-0.164187f,0.866134f,0.472075f},{-0.328502f,0.861858f,0.386377f},
{-0.22236f,0.81515f,0.534871f},{-0.407264f,0.738985f,0.53669f},{-0.261475f,0.745438f,0.61315f},
{-0.423584f,0.613071f,0.666874f},{-0.268118f,0.677242f,0.685169f},{-0.392497f,0.519335f,0.759103f},
{-0.24919f,0.634149f,0.731956f},{-0.338078f,0.471162f,0.814684f},{-0.22364f,0.617892f,0.753787f},
{-0.270615f,0.460525f,0.84539f},{-0.194833f,0.616506f,0.762863f},{-0.183681f,0.479089f,0.858333f},
{-0.149814f,0.630977f,0.761199f},{-0.0646262f,0.532383f,0.844033f},{-0.0833697f,0.671555f,0.736249f},
{0.0858598f,0.628864f,0.77276f},{-0.0110594f,0.735267f,0.677687f},{0.225661f,0.746376f,0.626099f},
{0.0402802f,0.800838f,0.597525f},{0.297614f,0.844032f,0.446135f},{0.0578062f,0.850871f,0.522185f},
{0.287181f,0.911623f,0.294058f},{0.0462129f,0.884f,0.465197f},{0.212292f,0.957645f,0.194545f},
{0.0112676f,0.903058f,0.429371f},{0.0946535f,0.984007f,0.1509f},{-0.0411956f,0.907323f,0.418412f},
{-0.0768357f,0.963819f,-0.255243f},{-0.231191f,0.968651f,-0.0909206f},{-0.478011f,0.865024f,0.152442f},
{-0.613761f,0.668302f,0.420321f},{-0.621661f,0.468695f,0.627584f},{-0.555999f,0.333983f,0.761131f},
{-0.465216f,0.269773f,0.843087f},{-0.358395f,0.248428f,0.899909f},{-0.215945f,0.246155f,0.944868f},
{-0.00160027f,0.275933f,0.961176f},{0.307449f,0.391756f,0.867181f},{0.57879f,0.576987f,0.57627f},
{0.658558f,0.716536f,0.229952f},{0.597679f,0.801598f,-0.0148259f},{0.460401f,0.872625f,-0.162965f},
{0.266984f,0.934523f,-0.235344f},{0.103983f,0.993374f,-0.048947f},{0.105796f,0.993123f,-0.0501399f},
{-0.0197862f,0.790362f,-0.61232f},{-0.242279f,0.852503f,-0.463184f},{-0.632416f,0.763443f,-0.131166f},
{-0.817379f,0.505342f,0.276625f},{-0.788174f,0.265216f,0.555375f},{-0.687043f,0.131972f,0.714531f},
{-0.56985f,0.0751975f,0.818301f},{-0.421735f,0.0372272f,0.905954f},{-0.203784f,-0.0289837f,0.978587f},
{0.124815f,-0.104369f,0.986675f},{0.577569f,-0.0689256f,0.813427f},{0.917184f,0.152931f,0.367949f},
{0.924202f,0.373489f,-0.0797226f},{0.792991f,0.508953f,-0.334863f},{0.620113f,0.617825f,-0.483478f},
{0.394039f,0.719565f,-0.571804f},{0.224221f,0.865854f,-0.447239f},{0.212217f,0.873358f,-0.438418f},
{0.0136589f,0.693472f,-0.720354f},{-0.145306f,0.729801f,-0.668039f},{-0.601517f,0.69868f,-0.387329f},
{-0.891335f,0.442876f,0.0968627f},{-0.872552f,0.175056f,0.45608f},{-0.763231f,0.0371769f,0.645055f},
{-0.642575f,-0.0180662f,0.76601f},{-0.48495f,-0.0563598f,0.872724f},{-0.238167f,-0.142315f,0.960741f},
{0.123424f,-0.279803f,0.952091f},{0.574493f,-0.347868f,0.740908f},{0.939284f,-0.188771f,0.28655f},
{0.979786f,0.0995065f,-0.173547f},{0.850407f,0.302179f,-0.430692f},{0.68788f,0.4362f,-0.580131f},
{0.478047f,0.550419f,-0.684478f},{0.3163f,0.607377f,-0.72873f},{0.292721f,0.633415f,-0.71631f},
{0.10134f,0.982936f,0.153519f},{0.101791f,0.895541f,0.433181f},{0.198237f,0.947331f,0.251529f},
{0.164188f,0.866134f,0.472075f},{0.328502f,0.861858f,0.386377f},{0.22236f,0.81515f,0.534871f},
{0.407264f,0.738986f,0.53669f},{0.261475f,0.745438f,0.61315f},{0.423584f,0.613071f,0.666874f},
{0.268118f,0.677242f,0.685168f},{0.392497f,0.519336f,0.759103f},{0.24919f,0.634149f,0.731956f},
{0.338078f,0.471162f,0.814684f},{0.22364f,0.617892f,0.753787f},{0.270615f,0.460525f,0.84539f},
{0.194833f,0.616506f,0.762863f},{0.183681f,0.479089f,0.858333f},{0.149814f,0.630977f,0.761199f},
{0.0646263f,0.532382f,0.844033f},{0.0833696f,0.671555f,0.736249f},{-0.0858598f,0.628864f,0.77276f},
{0.0110594f,0.735267f,0.677687f},{-0.225661f,0.746376f,0.626099f},{-0.0402801f,0.800838f,0.597525f},
{-0.297614f,0.844032f,0.446135f},{-0.0578062f,0.850871f,0.522185f},{-0.287181f,0.911623f,0.294058f},
{-0.0462129f,0.884f,0.465198f},{-0.212292f,0.957645f,0.194545f},{-0.0112675f,0.903058f,0.429371f},
{-0.0946533f,0.984007f,0.1509f},{0.041196f,0.907323f,0.418412f},{0.0768359f,0.963819f,-0.255243f},
{0.231191f,0.968651f,-0.0909207f},{0.478011f,0.865024f,0.152442f},{0.613761f,0.668302f,0.420321f},
{0.621661f,0.468695f,0.627584f},{0.555999f,0.333984f,0.761131f},{0.465216f,0.269773f,0.843087f},
{0.358395f,0.248428f,0.899909f},{0.215945f,0.246155f,0.944868f},{0.00160026f,0.275933f,0.961176f},
{-0.307449f,0.391756f,0.867181f},{-0.57879f,0.576987f,0.57627f},{-0.658558f,0.716536f,0.229952f},
{-0.597679f,0.801598f,-0.014826f},{-0.460401f,0.872625f,-0.162965f},{-0.266984f,0.934523f,-0.235344f},
{-0.103983f,0.993374f,-0.0489471f},{-0.105795f,0.993123f,-0.0501397f},{0.0197862f,0.790362f,-0.61232f},
{0.242279f,0.852503f,-0.463184f},{0.632416f,0.763443f,-0.131166f},{0.817379f,0.505342f,0.276625f},
{0.788174f,0.265216f,0.555375f},{0.687043f,0.131972f,0.714531f},{0.56985f,0.0751974f,0.818301f},
{0.421735f,0.0372273f,0.905954f},{0.203784f,-0.0289837f,0.978587f},{-0.124815f,-0.104369f,0.986675f},
{-0.577568f,-0.0689258f,0.813427f},{-0.917184f,0.152931f,0.367949f},{-0.924202f,0.373489f,-0.0797229f},
{-0.792991f,0.508952f,-0.334863f},{-0.620113f,0.617825f,-0.483478f},{-0.394039f,0.719565f,-0.571804f},
{-0.224221f,0.865854f,-0.447239f},{-0.212217f,0.873358f,-0.438418f},{-0.0136587f,0.693472f,-0.720354f},
{0.145306f,0.729801f,-0.668039f},{0.601517f,0.69868f,-0.387329f},{0.891335f,0.442876f,0.0968627f},
{0.872552f,0.175056f,0.45608f},{0.763232f,0.0371764f,0.645055f},{0.642575f,-0.0180665f,0.76601f},
{0.48495f,-0.0563598f,0.872724f},{0.238168f,-0.142315f,0.960741f},{-0.123424f,-0.279803f,0.952091f},
{-0.574493f,-0.347868f,0.740909f},{-0.939284f,-0.188771f,0.28655f},{-0.979786f,0.0995065f,-0.173547f},
{-0.850407f,0.302179f,-0.430692f},{-0.68788f,0.4362f,-0.580131f},{-0.478047f,0.550419f,-0.684478f},
{-0.3163f,0.607377f,-0.72873f},{-0.292721f,0.633415f,-0.71631f}
},

//lid 9
{
{0.170541f,0.555718f,-0.813691f},{0.159436f,0.323043f,-0.932857f},{0.0675904f,0.387311f,-0.919468f},
{0.101067f,0.59512f,-0.797256f},{-0.092135f,0.494669f,-0.864184f},{0.0336952f,0.658639f,-0.751704f},
{-0.229373f,0.644702f,-0.72921f},{-0.0108063f,0.727029f,-0.686522f},{-0.288707f,0.777821f,-0.55825f},
{-0.0233612f,0.779424f,-0.626062f},{-0.263651f,0.867508f,-0.421803f},{-0.012134f,0.812561f,-0.58275f},
{-0.179349f,0.921161f,-0.345394f},{0.0175103f,0.832714f,-0.553427f},{-0.0584333f,0.945729f,-0.319658f},
{0.0683393f,0.839411f,-0.539184f},{0.0823237f,0.938165f,-0.336258f},{0.135725f,0.826017f,-0.54706f},
{0.225929f,0.891127f,-0.393507f},{0.204819f,0.79023f,-0.577569f},{0.350601f,0.801826f,-0.483894f},
{0.261618f,0.736218f,-0.62413f},{0.433427f,0.683162f,-0.587734f},{0.296097f,0.673774f,-0.677019f},
{0.463621f,0.562726f,-0.684394f},{0.304738f,0.617548f,-0.725099f},{0.446703f,0.464193f,-0.764841f},
{0.293235f,0.577481f,-0.761924f},{0.394005f,0.394726f,-0.830031f},{0.267887f,0.553192f,-0.788806f},
{0.313145f,0.353344f,-0.881526f},{0.227697f,0.543901f,-0.807667f},{0.103488f,-0.0756736f,-0.991748f},
{-0.0254071f,0.00398757f,-0.999669f},{-0.349912f,0.130467f,-0.927653f},{-0.638155f,0.398665f,-0.658654f},
{-0.703033f,0.642145f,-0.305605f},{-0.609007f,0.79022f,-0.068285f},{-0.449166f,0.892346f,0.04437f},
{-0.241132f,0.967482f,0.0763763f},{0.00191164f,0.99924f,0.0389275f},{0.257914f,0.963174f,-0.0759974f},
{0.484125f,0.836707f,-0.256014f},{0.624151f,0.639931f,-0.448246f},{0.662818f,0.438996f,-0.606593f},
{0.625793f,0.279749f,-0.728096f},{0.534464f,0.160511f,-0.82981f},{0.397089f,0.067222f,-0.915315f},
{0.305679f,0.19791f,-0.931339f},{0.308629f,0.196352f,-0.930696f},{0.0010928f,-0.457257f,-0.889334f},
{-0.16025f,-0.427096f,-0.889892f},{-0.589829f,-0.355518f,-0.725057f},{-0.94399f,-0.0546976f,-0.325408f},
{-0.95306f,0.282341f,0.109367f},{-0.796299f,0.492715f,0.350912f},{-0.606733f,0.645652f,0.46369f},
{-0.372043f,0.777756f,0.506636f},{-0.086674f,0.876457f,0.473614f},{0.257346f,0.909395f,0.326763f},
{0.607804f,0.79297f,0.0421005f},{0.806237f,0.525687f,-0.271357f},{0.829843f,0.255751f,-0.495936f},
{0.762498f,0.0578159f,-0.644402f},{0.631312f,-0.0985713f,-0.769239f},{0.42819f,-0.241367f,-0.870859f},
{0.306199f,-0.119536f,-0.944433f},{0.342896f,-0.146123f,-0.927939f},{-0.0528956f,-0.553316f,-0.83129f},
{-0.163834f,-0.590968f,-0.789883f},{-0.573892f,-0.568852f,-0.589114f},{-0.928504f,-0.32689f,-0.176134f},
{-0.965442f,0.0371366f,0.25796f},{-0.823071f,0.286223f,0.490542f},{-0.651703f,0.453096f,0.608265f},
{-0.440343f,0.593015f,0.674115f},{-0.181412f,0.713338f,0.676933f},{0.152749f,0.80595f,0.571937f},
{0.566841f,0.771152f,0.289856f},{0.85507f,0.507622f,-0.105715f},{0.89627f,0.194243f,-0.398711f},
{0.82294f,-0.0268582f,-0.567493f},{0.68957f,-0.19749f,-0.696772f},{0.470535f,-0.360343f,-0.80545f},
{0.266767f,-0.44909f,-0.852733f},{0.309762f,-0.481723f,-0.81975f},{-0.159438f,0.323043f,-0.932857f},
{-0.170543f,0.555717f,-0.813691f},{-0.0675907f,0.387311f,-0.919468f},{-0.101065f,0.595122f,-0.797255f},
{0.0921356f,0.49467f,-0.864183f},{-0.0336954f,0.658639f,-0.751704f},{0.229373f,0.644702f,-0.72921f},
{0.0108064f,0.72703f,-0.686521f},{0.288706f,0.777821f,-0.558249f},{0.0233612f,0.779424f,-0.626062f},
{0.263651f,0.867508f,-0.421803f},{0.012134f,0.812561f,-0.58275f},{0.179349f,0.921161f,-0.345394f},
{-0.0175103f,0.832714f,-0.553427f},{0.0584332f,0.945729f,-0.319658f},{-0.0683394f,0.83941f,-0.539184f},
{-0.0823238f,0.938165f,-0.336259f},{-0.135725f,0.826017f,-0.54706f},{-0.225929f,0.891127f,-0.393507f},
{-0.204819f,0.79023f,-0.577569f},{-0.350601f,0.801826f,-0.483894f},{-0.261618f,0.736219f,-0.62413f},
{-0.433427f,0.683162f,-0.587733f},{-0.296097f,0.673776f,-0.677018f},{-0.463621f,0.562727f,-0.684393f},
{-0.304738f,0.617549f,-0.725099f},{-0.446703f,0.464193f,-0.764841f},{-0.293235f,0.577482f,-0.761924f},
{-0.394004f,0.394726f,-0.830031f},{-0.267886f,0.553192f,-0.788807f},{-0.313145f,0.353344f,-0.881526f},
{-0.227697f,0.543901f,-0.807667f},{-0.103488f,-0.0756737f,-0.991748f},{0.0254069f,0.00398732f,-0.999669f},
{0.349912f,0.130467f,-0.927653f},{0.638155f,0.398665f,-0.658654f},{0.703033f,0.642145f,-0.305605f},
{0.609007f,0.79022f,-0.0682853f},{0.449166f,0.892346f,0.0443696f},{0.241132f,0.967482f,0.0763763f},
{-0.0019117f,0.99924f,0.0389275f},{-0.257914f,0.963174f,-0.0759975f},{-0.484125f,0.836707f,-0.256014f},
{-0.624151f,0.639931f,-0.448246f},{-0.662818f,0.438997f,-0.606592f},{-0.625793f,0.279749f,-0.728096f},
{-0.534464f,0.160511f,-0.82981f},{-0.397088f,0.0672218f,-0.915315f},{-0.305679f,0.19791f,-0.931339f},
{-0.308629f,0.196352f,-0.930696f},{-0.00109355f,-0.457257f,-0.889334f},{0.16025f,-0.427096f,-0.889893f},
{0.589829f,-0.355518f,-0.725057f},{0.94399f,-0.0546977f,-0.325408f},{0.95306f,0.282341f,0.109367f},
{0.796299f,0.492715f,0.350912f},{0.606732f,0.645652f,0.46369f},{0.372042f,0.777756f,0.506636f},
{0.0866739f,0.876457f,0.473614f},{-0.257346f,0.909395f,0.326763f},{-0.607805f,0.79297f,0.0421001f},
{-0.806237f,0.525687f,-0.271357f},{-0.829843f,0.255751f,-0.495936f},{-0.762498f,0.0578159f,-0.644402f},
{-0.631312f,-0.0985713f,-0.769239f},{-0.42819f,-0.241367f,-0.870859f},{-0.306198f,-0.119536f,-0.944433f},
{-0.342896f,-0.146124f,-0.927939f},{0.0528946f,-0.553315f,-0.831291f},{0.163834f,-0.590967f,-0.789884f},
{0.573892f,-0.568851f,-0.589114f},{0.928504f,-0.32689f,-0.176134f},{0.965442f,0.0371366f,0.257959f},
{0.823071f,0.286223f,0.490542f},{0.651704f,0.453095f,0.608266f},{0.440343f,0.593015f,0.674116f},
{0.181412f,0.713338f,0.676933f},{-0.152749f,0.80595f,0.571937f},{-0.566841f,0.771152f,0.289855f},
{-0.85507f,0.507622f,-0.105715f},{-0.89627f,0.194243f,-0.398711f},{-0.82294f,-0.026858f,-0.567493f},
{-0.68957f,-0.19749f,-0.696772f},{-0.470535f,-0.360343f,-0.80545f},{-0.266767f,-0.44909f,-0.852733f},
{-0.309761f,-0.481723f,-0.819751f},{-0.11464f,0.854504f,0.506637f},{-0.114874f,0.966279f,0.230455f},
{-0.210589f,0.921522f,0.326266f},{-0.174897f,0.822321f,0.541478f},{-0.337297f,0.824425f,0.454483f},
{-0.232515f,0.765838f,0.599525f},{-0.411322f,0.691063f,0.594345f},{-0.270972f,0.689156f,0.67204f},
{-0.424194f,0.559147f,0.71233f},{-0.276544f,0.616478f,0.73721f},{-0.393218f,0.46414f,0.793696f},
{-0.258301f,0.57317f,0.777661f},{-0.342514f,0.416759f,0.842019f},{-0.23626f,0.558058f,0.795457f},
{-0.280672f,0.405896f,0.869754f},{-0.211881f,0.556491f,0.803383f},{-0.200032f,0.422183f,0.884166f},
{-0.170563f,0.570243f,0.803574f},{-0.0874915f,0.472863f,0.876781f},{-0.107036f,0.611665f,0.783842f},
{0.0581153f,0.571308f,0.818676f},{-0.036373f,0.679483f,0.732789f},{0.197933f,0.699796f,0.686373f},
{0.0148238f,0.751729f,0.659306f},{0.273319f,0.812315f,0.51521f},{0.03261f,0.807523f,0.588934f},
{0.266335f,0.891038f,0.367583f},{0.0218574f,0.843568f,0.536578f},{0.194206f,0.942733f,0.271181f},
{-0.0102549f,0.863372f,0.504464f},{0.078806f,0.970194f,0.229157f},{-0.0581579f,0.867363f,0.494266f},
{-0.0914466f,0.978258f,-0.186143f},{-0.244068f,0.969568f,-0.0192072f},{-0.48466f,0.847182f,0.217684f},
{-0.612357f,0.635581f,0.470165f},{-0.615785f,0.428517f,0.661198f},{-0.550439f,0.291383f,0.782377f},
{-0.463909f,0.226398f,0.856465f},{-0.362763f,0.202436f,0.909628f},{-0.225975f,0.194219f,0.954575f},
{-0.0183055f,0.216191f,0.976179f},{0.286186f,0.330996f,0.899188f},{0.562947f,0.537093f,0.628189f},
{0.648012f,0.704916f,0.288398f},{0.587764f,0.807722f,0.0460294f},{0.450024f,0.887599f,-0.0982117f},
{0.255516f,0.952228f,-0.167251f},{0.0906943f,0.995508f,0.0271607f},{0.0933649f,0.995308f,0.0253784f},
{-0.0355931f,0.831294f,-0.554693f},{-0.254659f,0.881814f,-0.396929f},{-0.632414f,0.771627f,-0.0681498f},
{-0.809248f,0.494993f,0.316386f},{-0.781041f,0.242949f,0.575283f},{-0.682456f,0.101224f,0.723883f},
{-0.568426f,0.0370607f,0.821899f},{-0.423234f,-0.0101017f,0.905964f},{-0.206764f,-0.0865563f,0.974555f},
{0.118895f,-0.168938f,0.978429f},{0.568569f,-0.131554f,0.812049f},{0.916179f,0.11474f,0.383994f},
{0.927836f,0.368796f,-0.0557681f},{0.794685f,0.525236f,-0.304306f},{0.618087f,0.648299f,-0.444608f},
{0.385917f,0.758658f,-0.524887f},{0.210919f,0.897809f,-0.38659f},{0.203377f,0.902055f,-0.380702f},
{-0.00079517f,0.742438f,-0.669914f},{-0.157844f,0.77598f,-0.610689f},{-0.602335f,0.730097f,-0.322724f},
{-0.880543f,0.453024f,0.13933f},{-0.864745f,0.167017f,0.473626f},{-0.759086f,0.014962f,0.650818f},
{-0.640551f,-0.0522314f,0.766137f},{-0.484416f,-0.104116f,0.86862f},{-0.23751f,-0.203911f,0.949742f},
{0.123602f,-0.346612f,0.929829f},{0.570647f,-0.405671f,0.713998f},{0.936051f,-0.22429f,0.271114f},
{0.980428f,0.0927185f,-0.173679f},{0.852254f,0.314963f,-0.417685f},{0.688798f,0.464589f,-0.55652f},
{0.47305f,0.592612f,-0.651946f},{0.30497f,0.65594f,-0.690461f},{0.282411f,0.679895f,-0.676747f},
{0.114874f,0.966279f,0.230455f},{0.11464f,0.854504f,0.506637f},{0.210589f,0.921522f,0.326266f},
{0.174897f,0.822321f,0.541478f},{0.337297f,0.824425f,0.454483f},{0.232515f,0.765837f,0.599525f},
{0.411322f,0.691063f,0.594346f},{0.270972f,0.689156f,0.67204f},{0.424194f,0.559147f,0.71233f},
{0.276544f,0.616478f,0.73721f},{0.393218f,0.46414f,0.793696f},{0.258301f,0.57317f,0.777661f},
{0.342514f,0.416759f,0.842019f},{0.236261f,0.558058f,0.795457f},{0.280672f,0.405896f,0.869754f},
{0.211882f,0.556491f,0.803383f},{0.200032f,0.422183f,0.884166f},{0.170563f,0.570243f,0.803574f},
{0.0874913f,0.472863f,0.876781f},{0.107037f,0.611665f,0.783842f},{-0.0581153f,0.571308f,0.818676f},
{0.036373f,0.679483f,0.732789f},{-0.197933f,0.699796f,0.686373f},{-0.0148238f,0.751729f,0.659306f},
{-0.273319f,0.812315f,0.515211f},{-0.03261f,0.807523f,0.588934f},{-0.266335f,0.891038f,0.367583f},
{-0.0218573f,0.843568f,0.536577f},{-0.194206f,0.942733f,0.271181f},{0.0102549f,0.863372f,0.504464f},
{-0.078806f,0.970194f,0.229156f},{0.058158f,0.867363f,0.494266f},{0.0914466f,0.978258f,-0.186143f},
{0.244068f,0.969568f,-0.0192073f},{0.48466f,0.847182f,0.217684f},{0.612358f,0.635581f,0.470165f},
{0.615785f,0.428517f,0.661198f},{0.550439f,0.291383f,0.782377f},{0.463909f,0.226398f,0.856465f},
{0.362763f,0.202436f,0.909628f},{0.225975f,0.19422f,0.954575f},{0.0183055f,0.216191f,0.976179f},
{-0.286186f,0.330996f,0.899188f},{-0.562947f,0.537093f,0.628189f},{-0.648012f,0.704916f,0.288399f},
{-0.587764f,0.807722f,0.0460294f},{-0.450024f,0.887599f,-0.0982118f},{-0.255516f,0.952228f,-0.167251f},
{-0.0906943f,0.995508f,0.0271607f},{-0.093365f,0.995308f,0.0253784f},{0.0355932f,0.831294f,-0.554693f},
{0.254659f,0.881814f,-0.396929f},{0.632414f,0.771627f,-0.0681498f},{0.809248f,0.494993f,0.316386f},
{0.781041f,0.242949f,0.575283f},{0.682456f,0.101224f,0.723883f},{0.568426f,0.0370607f,0.821899f},
{0.423234f,-0.0101017f,0.905964f},{0.206764f,-0.0865562f,0.974555f},{-0.118895f,-0.168938f,0.978429f},
{-0.568569f,-0.131554f,0.812049f},{-0.916179f,0.11474f,0.383994f},{-0.927836f,0.368796f,-0.0557682f},
{-0.794686f,0.525236f,-0.304306f},{-0.618087f,0.648299f,-0.444608f},{-0.385917f,0.758658f,-0.524887f},
{-0.210919f,0.897809f,-0.38659f},{-0.203377f,0.902055f,-0.380702f},{0.000795401f,0.742438f,-0.669914f},
{0.157843f,0.77598f,-0.610689f},{0.602334f,0.730098f,-0.322724f},{0.880543f,0.453024f,0.13933f},
{0.864745f,0.167017f,0.473626f},{0.759086f,0.014962f,0.650819f},{0.640551f,-0.0522313f,0.766137f},
{0.484416f,-0.104115f,0.86862f},{0.23751f,-0.203911f,0.949742f},{-0.123602f,-0.346612f,0.92983f},
{-0.570647f,-0.405671f,0.713998f},{-0.936051f,-0.22429f,0.271113f},{-0.980428f,0.0927184f,-0.173679f},
{-0.852254f,0.314963f,-0.417685f},{-0.688798f,0.46459f,-0.55652f},{-0.47305f,0.592612f,-0.651947f},
{-0.30497f,0.65594f,-0.690461f},{-0.282411f,0.679895f,-0.676747f}
},

//lid 8
{
{0.183219f,0.515603f,-0.837009f},{0.168233f,0.276577f,-0.946151f},{0.0789236f,0.33771f,-0.937936f},
{0.115197f,0.55477f,-0.82399f},{-0.0788423f,0.444272f,-0.892416f},{0.0493115f,0.619585f,-0.783379f},
{-0.215796f,0.602783f,-0.76817f},{0.00509343f,0.691651f,-0.722214f},{-0.275265f,0.749386f,-0.602205f},
{-0.00771255f,0.748436f,-0.663162f},{-0.249493f,0.848683f,-0.466358f},{0.00346534f,0.784383f,-0.620267f},
{-0.165042f,0.90581f,-0.390218f},{0.0322572f,0.805564f,-0.591631f},{-0.0456364f,0.929892f,-0.364991f},
{0.080755f,0.81256f,-0.577256f},{0.0928438f,0.920014f,-0.380728f},{0.146091f,0.799024f,-0.583282f},
{0.23474f,0.86947f,-0.434649f},{0.215159f,0.761573f,-0.611321f},{0.358561f,0.775663f,-0.519404f},
{0.272868f,0.704116f,-0.655564f},{0.440662f,0.653013f,-0.615948f},{0.307414f,0.638509f,-0.705551f},
{0.470318f,0.530909f,-0.704937f},{0.315767f,0.581186f,-0.75001f},{0.453707f,0.431995f,-0.779443f},
{0.304783f,0.540878f,-0.783938f},{0.401809f,0.360715f,-0.841685f},{0.280105f,0.515498f,-0.809816f},
{0.321717f,0.314999f,-0.892902f},{0.23998f,0.50473f,-0.829251f},{0.10177f,-0.124175f,-0.987028f},
{-0.0213474f,-0.0510002f,-0.99847f},{-0.339633f,0.0669536f,-0.938172f},{-0.632029f,0.346039f,-0.693395f},
{-0.701873f,0.620211f,-0.350303f},{-0.603308f,0.789452f,-0.113069f},{-0.43881f,0.898572f,-0.00368722f},
{-0.229713f,0.972972f,0.023611f},{0.0125592f,0.999809f,-0.0149582f},{0.266795f,0.955612f,-0.125002f},
{0.490219f,0.820159f,-0.294998f},{0.62726f,0.617606f,-0.474456f},{0.664848f,0.416024f,-0.620404f},
{0.629087f,0.257234f,-0.73354f},{0.538512f,0.134383f,-0.831833f},{0.399787f,0.0328209f,-0.916021f},
{0.30886f,0.159902f,-0.93757f},{0.317338f,0.155631f,-0.935455f},{-0.00782778f,-0.499674f,-0.866178f},
{-0.163187f,-0.471999f,-0.866364f},{-0.57959f,-0.404497f,-0.70743f},{-0.937032f,-0.10026f,-0.334542f},
{-0.960051f,0.266588f,0.0850474f},{-0.800902f,0.504502f,0.322543f},{-0.605592f,0.671753f,0.426623f},
{-0.365098f,0.809509f,0.459781f},{-0.0727785f,0.904433f,0.420363f},{0.27279f,0.922361f,0.27356f},
{0.614661f,0.788789f,0.00173532f},{0.8065f,0.514327f,-0.291591f},{0.830963f,0.243768f,-0.500077f},
{0.767385f,0.0433333f,-0.639721f},{0.636351f,-0.121862f,-0.761714f},{0.42732f,-0.276056f,-0.860925f},
{0.301003f,-0.155958f,-0.940784f},{0.343504f,-0.185537f,-0.920642f},{-0.0626903f,-0.592958f,-0.802789f},
{-0.170517f,-0.628368f,-0.758997f},{-0.568461f,-0.601158f,-0.56166f},{-0.918823f,-0.356076f,-0.170216f},
{-0.968663f,0.0240955f,0.247208f},{-0.829274f,0.296802f,0.473512f},{-0.65542f,0.48147f,0.581903f},
{-0.438276f,0.633814f,0.637334f},{-0.16793f,0.756496f,0.632071f},{0.173844f,0.835371f,0.521472f},
{0.578754f,0.777582f,0.245785f},{0.854862f,0.503223f,-0.126398f},{0.896856f,0.188576f,-0.40011f},
{0.828344f,-0.0368846f,-0.559005f},{0.696091f,-0.218808f,-0.683798f},{0.470358f,-0.395467f,-0.788904f},
{0.259101f,-0.490013f,-0.832318f},{0.302875f,-0.521613f,-0.797613f},{-0.168233f,0.276577f,-0.946152f},
{-0.183218f,0.515603f,-0.837009f},{-0.0789234f,0.33771f,-0.937936f},{-0.115196f,0.55477f,-0.82399f},
{0.0788423f,0.444272f,-0.892416f},{-0.0493115f,0.619585f,-0.783379f},{0.215796f,0.602783f,-0.76817f},
{-0.00509343f,0.691651f,-0.722214f},{0.275265f,0.749386f,-0.602205f},{0.00771252f,0.748436f,-0.663162f},
{0.249494f,0.848683f,-0.466358f},{-0.00346547f,0.784383f,-0.620267f},{0.165042f,0.90581f,-0.390218f},
{-0.032257f,0.805564f,-0.591631f},{0.0456365f,0.929892f,-0.364991f},{-0.080755f,0.81256f,-0.577256f},
{-0.0928437f,0.920014f,-0.380728f},{-0.146091f,0.799024f,-0.583282f},{-0.23474f,0.86947f,-0.434649f},
{-0.215159f,0.761573f,-0.611321f},{-0.358561f,0.775663f,-0.519404f},{-0.272868f,0.704116f,-0.655563f},
{-0.440662f,0.653013f,-0.615948f},{-0.307414f,0.638509f,-0.705551f},{-0.470318f,0.530909f,-0.704937f},
{-0.315767f,0.581186f,-0.75001f},{-0.453707f,0.431995f,-0.779442f},{-0.304784f,0.540878f,-0.783938f},
{-0.401809f,0.360715f,-0.841685f},{-0.280105f,0.515498f,-0.809816f},{-0.321718f,0.314999f,-0.892902f},
{-0.23998f,0.50473f,-0.829251f},{-0.10177f,-0.124175f,-0.987028f},{0.0213474f,-0.0510003f,-0.99847f},
{0.339633f,0.0669536f,-0.938172f},{0.632029f,0.346039f,-0.693395f},{0.701873f,0.620211f,-0.350303f},
{0.603308f,0.789452f,-0.11307f},{0.43881f,0.898572f,-0.0036873f},{0.229713f,0.972972f,0.023611f},
{-0.0125591f,0.999809f,-0.0149581f},{-0.266795f,0.955612f,-0.125002f},{-0.490219f,0.820159f,-0.294999f},
{-0.62726f,0.617606f,-0.474456f},{-0.664848f,0.416024f,-0.620404f},{-0.629087f,0.257234f,-0.73354f},
{-0.538512f,0.134383f,-0.831833f},{-0.399786f,0.0328209f,-0.916021f},{-0.30886f,0.159902f,-0.93757f},
{-0.317339f,0.155631f,-0.935454f},{0.00782779f,-0.499674f,-0.866178f},{0.163186f,-0.471999f,-0.866364f},
{0.57959f,-0.404497f,-0.707431f},{0.937032f,-0.10026f,-0.334542f},{0.960051f,0.266587f,0.0850475f},
{0.800902f,0.504502f,0.322543f},{0.605592f,0.671753f,0.426623f},{0.365098f,0.809509f,0.459781f},
{0.0727785f,0.904433f,0.420363f},{-0.27279f,0.922361f,0.27356f},{-0.614661f,0.788789f,0.00173559f},
{-0.8065f,0.514327f,-0.291591f},{-0.830963f,0.243767f,-0.500077f},{-0.767385f,0.0433335f,-0.639721f},
{-0.636351f,-0.121862f,-0.761713f},{-0.42732f,-0.276056f,-0.860925f},{-0.301003f,-0.155958f,-0.940784f},
{-0.343504f,-0.185537f,-0.920642f},{0.0626903f,-0.592958f,-0.802789f},{0.170517f,-0.628368f,-0.758997f},
{0.568461f,-0.601158f,-0.56166f},{0.918823f,-0.356076f,-0.170216f},{0.968663f,0.0240956f,0.247208f},
{0.829274f,0.296802f,0.473512f},{0.65542f,0.48147f,0.581904f},{0.438276f,0.633814f,0.637334f},
{0.16793f,0.756496f,0.632071f},{-0.173844f,0.835371f,0.521472f},{-0.578754f,0.777582f,0.245785f},
{-0.854863f,0.503223f,-0.126398f},{-0.896856f,0.188576f,-0.40011f},{-0.828343f,-0.0368841f,-0.559005f},
{-0.696091f,-0.218808f,-0.683798f},{-0.470358f,-0.395467f,-0.788904f},{-0.259101f,-0.490013f,-0.832318f},
{-0.302875f,-0.521613f,-0.797613f},{-0.136628f,0.763066f,0.631715f},{-0.139911f,0.91351f,0.382f},
{-0.230294f,0.853362f,0.467694f},{-0.193796f,0.727236f,0.658461f},{-0.346303f,0.741592f,0.574556f},
{-0.248184f,0.665563f,0.703868f},{-0.410724f,0.601945f,0.684812f},{-0.282328f,0.587202f,0.758607f},
{-0.420812f,0.474512f,0.773147f},{-0.286105f,0.519799f,0.804955f},{-0.394192f,0.388462f,0.832893f},
{-0.271441f,0.48297f,0.832502f},{-0.348961f,0.345726f,0.871034f},{-0.253473f,0.469114f,0.845981f},
{-0.288397f,0.331318f,0.898363f},{-0.227904f,0.465937f,0.854963f},{-0.205609f,0.337301f,0.918669f},
{-0.183354f,0.479034f,0.858434f},{-0.0927383f,0.374538f,0.922562f},{-0.122056f,0.518721f,0.846186f},
{0.0476515f,0.463623f,0.88475f},{-0.0593579f,0.58286f,0.810401f},{0.180078f,0.598609f,0.780538f},
{-0.0151815f,0.654338f,0.75605f},{0.249804f,0.732175f,0.633654f},{-0.000536045f,0.713225f,0.700935f},
{0.238979f,0.831312f,0.501806f},{-0.0116876f,0.752305f,0.658711f},{0.164828f,0.894338f,0.415923f},
{-0.0414348f,0.773339f,0.632638f},{0.0495883f,0.923567f,0.380217f},{-0.0846693f,0.777271f,0.623443f},
{-0.119615f,0.992173f,-0.0358517f},{-0.26578f,0.955061f,0.131223f},{-0.488134f,0.802358f,0.343433f},
{-0.600233f,0.576302f,0.554613f},{-0.602773f,0.370741f,0.706552f},{-0.548009f,0.239525f,0.801444f},
{-0.470781f,0.173944f,0.864933f},{-0.366503f,0.136982f,0.920278f},{-0.215389f,0.104768f,0.970892f},
{0.00346038f,0.0981433f,0.995166f},{0.301978f,0.191861f,0.933809f},{0.572361f,0.418812f,0.704982f},
{0.653782f,0.645133f,0.39544f},{0.583085f,0.795283f,0.165941f},{0.434465f,0.90003f,0.0344497f},
{0.232282f,0.972393f,-0.0223025f},{0.0629826f,0.980353f,0.186928f},{0.0646f,0.980455f,0.185836f},
{-0.0658798f,0.902312f,-0.426021f},{-0.275788f,0.926084f,-0.257505f},{-0.625976f,0.778258f,0.0496934f},
{-0.790611f,0.479302f,0.381055f},{-0.772137f,0.214951f,0.597997f},{-0.688996f,0.0606832f,0.72222f},
{-0.585024f,-0.0246281f,0.810642f},{-0.429108f,-0.106703f,0.896929f},{-0.181204f,-0.217596f,0.959071f},
{0.160618f,-0.312677f,0.936181f},{0.582391f,-0.272557f,0.765855f},{0.918424f,-0.000439342f,0.395597f},
{0.945892f,0.324477f,-0.00184092f},{0.807139f,0.541361f,-0.235489f},{0.61697f,0.701103f,-0.357495f},
{0.370398f,0.829668f,-0.417679f},{0.185885f,0.94934f,-0.253379f},{0.183324f,0.950425f,-0.251168f},
{-0.0297826f,0.831883f,-0.554151f},{-0.180719f,0.855135f,-0.485886f},{-0.598032f,0.776013f,-0.200401f},
{-0.857929f,0.470815f,0.20565f},{-0.856175f,0.160369f,0.491168f},{-0.765669f,-0.0168231f,0.643014f},
{-0.656838f,-0.115393f,0.74515f},{-0.492626f,-0.214217f,0.843463f},{-0.212263f,-0.358894f,0.908922f},
{0.169484f,-0.501572f,0.848352f},{0.583877f,-0.521011f,0.622604f},{0.92203f,-0.305082f,0.238299f},
{0.986224f,0.0586274f,-0.154675f},{0.863745f,0.332515f,-0.378654f},{0.693047f,0.521436f,-0.497785f},
{0.463554f,0.677117f,-0.571516f},{0.283588f,0.75075f,-0.596617f},{0.2633f,0.769891f,-0.581327f},
{0.13991f,0.91351f,0.382f},{0.136627f,0.763066f,0.631715f},{0.230294f,0.853362f,0.467694f},
{0.193795f,0.727236f,0.658461f},{0.346303f,0.741592f,0.574556f},{0.248184f,0.665563f,0.703868f},
{0.410724f,0.601945f,0.684812f},{0.282327f,0.587202f,0.758607f},{0.420812f,0.474512f,0.773147f},
{0.286105f,0.519799f,0.804955f},{0.394192f,0.388462f,0.832892f},{0.271441f,0.482971f,0.832501f},
{0.348961f,0.345727f,0.871034f},{0.253473f,0.469115f,0.845981f},{0.288397f,0.331318f,0.898363f},
{0.227904f,0.465937f,0.854963f},{0.205609f,0.337301f,0.918669f},{0.183354f,0.479033f,0.858434f},
{0.0927382f,0.374539f,0.922562f},{0.122055f,0.518722f,0.846186f},{-0.0476519f,0.463624f,0.88475f},
{0.0593579f,0.58286f,0.810401f},{-0.180078f,0.598609f,0.780538f},{0.0151815f,0.654338f,0.75605f},
{-0.249804f,0.732175f,0.633655f},{0.000536048f,0.713225f,0.700935f},{-0.238979f,0.831312f,0.501806f},
{0.0116876f,0.752305f,0.658711f},{-0.164827f,0.894338f,0.415923f},{0.0414349f,0.773338f,0.632638f},
{-0.0495883f,0.923567f,0.380217f},{0.0846698f,0.777271f,0.623443f},{0.119615f,0.992173f,-0.035852f},
{0.26578f,0.955061f,0.131222f},{0.488134f,0.802358f,0.343433f},{0.600233f,0.576303f,0.554613f},
{0.602773f,0.370741f,0.706552f},{0.548009f,0.239525f,0.801444f},{0.470781f,0.173944f,0.864933f},
{0.366503f,0.136982f,0.920278f},{0.215389f,0.104768f,0.970892f},{-0.00346019f,0.0981433f,0.995166f},
{-0.301978f,0.191862f,0.933809f},{-0.572361f,0.418812f,0.704982f},{-0.653782f,0.645133f,0.39544f},
{-0.583085f,0.795283f,0.165942f},{-0.434465f,0.90003f,0.0344495f},{-0.232282f,0.972393f,-0.0223026f},
{-0.0629828f,0.980353f,0.186927f},{-0.0646003f,0.980455f,0.185836f},{0.0658797f,0.902312f,-0.426021f},
{0.275788f,0.926084f,-0.257506f},{0.625976f,0.778258f,0.0496934f},{0.790612f,0.479302f,0.381054f},
{0.772137f,0.214951f,0.597996f},{0.688996f,0.0606832f,0.72222f},{0.585024f,-0.0246278f,0.810642f},
{0.429108f,-0.106702f,0.896929f},{0.181204f,-0.217596f,0.959071f},{-0.160618f,-0.312677f,0.936181f},
{-0.582391f,-0.272557f,0.765855f},{-0.918424f,-0.000439169f,0.395597f},{-0.945892f,0.324477f,-0.00184075f},
{-0.807139f,0.541361f,-0.235489f},{-0.61697f,0.701103f,-0.357495f},{-0.370398f,0.829668f,-0.41768f},
{-0.185885f,0.94934f,-0.253379f},{-0.183324f,0.950425f,-0.251168f},{0.0297826f,0.831883f,-0.554151f},
{0.180719f,0.855135f,-0.485886f},{0.598032f,0.776013f,-0.200402f},{0.857929f,0.470815f,0.20565f},
{0.856175f,0.16037f,0.491167f},{0.765669f,-0.0168233f,0.643014f},{0.656839f,-0.115393f,0.745149f},
{0.492626f,-0.214217f,0.843463f},{0.212263f,-0.358894f,0.908922f},{-0.169484f,-0.501571f,0.848352f},
{-0.583876f,-0.521011f,0.622604f},{-0.92203f,-0.305082f,0.238299f},{-0.986224f,0.0586269f,-0.154675f},
{-0.863745f,0.332514f,-0.378654f},{-0.693047f,0.521436f,-0.497785f},{-0.463554f,0.677117f,-0.571516f},
{-0.283588f,0.75075f,-0.596617f},{-0.2633f,0.769891f,-0.581327f}
},

//lid 6
{
{0.18588f,0.467699f,-0.864122f},{0.164569f,0.222549f,-0.960931f},{0.0776709f,0.28004f,-0.956841f},
{0.119855f,0.505696f,-0.854345f},{-0.077628f,0.383854f,-0.920125f},{0.0565274f,0.570373f,-0.819439f},
{-0.212757f,0.548379f,-0.808712f},{0.0137009f,0.645146f,-0.763937f},{-0.270868f,0.708583f,-0.651568f},
{0.00144722f,0.706519f,-0.707693f},{-0.242624f,0.819741f,-0.518804f},{0.0133808f,0.74627f,-0.665509f},
{-0.155487f,0.88262f,-0.443629f},{0.0427661f,0.769529f,-0.637179f},{-0.0347823f,0.907459f,-0.418699f},
{0.0908849f,0.777336f,-0.622486f},{0.103208f,0.895443f,-0.433047f},{0.155223f,0.763664f,-0.626677f},
{0.243236f,0.841282f,-0.482785f},{0.223441f,0.724979f,-0.651521f},{0.36442f,0.743646f,-0.560525f},
{0.280273f,0.665542f,-0.691738f},{0.443866f,0.618457f,-0.648454f},{0.313675f,0.598365f,-0.73727f},
{0.471772f,0.49537f,-0.729411f},{0.321239f,0.540099f,-0.777881f},{0.454403f,0.395144f,-0.79836f},
{0.309857f,0.498331f,-0.809725f},{0.401749f,0.320453f,-0.85785f},{0.284175f,0.47071f,-0.83527f},
{0.320433f,0.269367f,-0.908165f},{0.242663f,0.45807f,-0.855153f},{0.0869607f,-0.178282f,-0.980129f},
{-0.0317048f,-0.109602f,-0.99347f},{-0.342502f,0.000655748f,-0.939517f},{-0.633753f,0.283601f,-0.719671f},
{-0.708418f,0.584765f,-0.395213f},{-0.606138f,0.778497f,-0.162908f},{-0.434607f,0.898751f,-0.0579898f},
{-0.220487f,0.974733f,-0.0357786f},{0.0234381f,0.996835f,-0.0759604f},{0.27529f,0.944113f,-0.181291f},
{0.493509f,0.800437f,-0.340221f},{0.626126f,0.593557f,-0.505625f},{0.662475f,0.390644f,-0.639159f},
{0.627328f,0.22911f,-0.744291f},{0.535737f,0.0995679f,-0.838494f},{0.392946f,-0.0108421f,-0.919498f},
{0.300356f,0.11447f,-0.946933f},{0.315126f,0.107501f,-0.942942f},{-0.0254372f,-0.545227f,-0.837903f},
{-0.178221f,-0.515778f,-0.83798f},{-0.581813f,-0.444985f,-0.680795f},{-0.932889f,-0.139635f,-0.331996f},
{-0.967129f,0.24585f,0.0649586f},{-0.809593f,0.507989f,0.294119f},{-0.609129f,0.691194f,0.38886f},
{-0.361291f,0.836961f,0.411052f},{-0.0620213f,0.929727f,0.362989f},{0.282972f,0.934857f,0.214405f},
{0.615301f,0.786983f,-0.0454198f},{0.801931f,0.50525f,-0.318792f},{0.828411f,0.229084f,-0.511132f},
{0.767789f,0.0192651f,-0.640413f},{0.635529f,-0.158819f,-0.755566f},{0.419196f,-0.323113f,-0.848453f},
{0.287092f,-0.204083f,-0.93591f},{0.332725f,-0.234094f,-0.913506f},{-0.0777156f,-0.636227f,-0.767578f},
{-0.185381f,-0.665275f,-0.723217f},{-0.574317f,-0.624742f,-0.529015f},{-0.915037f,-0.372036f,-0.155874f},
{-0.970312f,0.0155884f,0.241355f},{-0.835734f,0.302763f,0.458131f},{-0.661248f,0.502507f,0.55699f},
{-0.4389f,0.667767f,0.60121f},{-0.159616f,0.794844f,0.585445f},{0.18591f,0.864414f,0.467146f},
{0.581437f,0.789583f,0.196187f},{0.849235f,0.504775f,-0.154925f},{0.893859f,0.18134f,-0.410039f},
{0.828751f,-0.0575603f,-0.556649f},{0.696171f,-0.255841f,-0.67074f},{0.464342f,-0.444749f,-0.765888f},
{0.24798f,-0.5422f,-0.802823f},{0.288333f,-0.569201f,-0.769983f},{-0.164569f,0.222549f,-0.960931f},
{-0.18588f,0.467699f,-0.864122f},{-0.0776708f,0.28004f,-0.956841f},{-0.119855f,0.505696f,-0.854346f},
{0.0776279f,0.383854f,-0.920125f},{-0.0565274f,0.570373f,-0.819439f},{0.212757f,0.548378f,-0.808713f},
{-0.0137025f,0.645143f,-0.763939f},{0.270868f,0.708582f,-0.651568f},{-0.00144792f,0.706521f,-0.707691f},
{0.242623f,0.819742f,-0.518803f},{-0.0133807f,0.74627f,-0.665509f},{0.155487f,0.88262f,-0.443629f},
{-0.042766f,0.769529f,-0.637179f},{0.0347824f,0.907459f,-0.418699f},{-0.0908848f,0.777336f,-0.622486f},
{-0.103208f,0.895443f,-0.433047f},{-0.155223f,0.763664f,-0.626676f},{-0.243236f,0.841282f,-0.482785f},
{-0.223441f,0.724979f,-0.651521f},{-0.36442f,0.743646f,-0.560525f},{-0.280274f,0.665541f,-0.691738f},
{-0.443867f,0.618457f,-0.648455f},{-0.313675f,0.598365f,-0.73727f},{-0.471772f,0.49537f,-0.729411f},
{-0.32124f,0.540099f,-0.777881f},{-0.454403f,0.395144f,-0.79836f},{-0.309857f,0.49833f,-0.809726f},
{-0.401749f,0.320453f,-0.85785f},{-0.284176f,0.47071f,-0.83527f},{-0.320433f,0.269367f,-0.908165f},
{-0.242663f,0.45807f,-0.855153f},{-0.0869606f,-0.178282f,-0.980129f},{0.031705f,-0.109602f,-0.99347f},
{0.342502f,0.000655692f,-0.939517f},{0.633753f,0.283601f,-0.719671f},{0.708419f,0.584765f,-0.395213f},
{0.606138f,0.778498f,-0.162908f},{0.434606f,0.898752f,-0.0579898f},{0.220487f,0.974733f,-0.0357785f},
{-0.0234378f,0.996835f,-0.0759606f},{-0.275291f,0.944112f,-0.181292f},{-0.493509f,0.800437f,-0.340221f},
{-0.626126f,0.593557f,-0.505625f},{-0.662475f,0.390645f,-0.639158f},{-0.627328f,0.22911f,-0.744291f},
{-0.535737f,0.099568f,-0.838494f},{-0.392946f,-0.0108418f,-0.919498f},{-0.300357f,0.11447f,-0.946933f},
{-0.315126f,0.107502f,-0.942942f},{0.0254373f,-0.545227f,-0.837903f},{0.178221f,-0.515778f,-0.83798f},
{0.581813f,-0.444985f,-0.680795f},{0.932888f,-0.139635f,-0.331996f},{0.967129f,0.24585f,0.0649582f},
{0.809593f,0.507989f,0.294119f},{0.609129f,0.691194f,0.38886f},{0.361291f,0.836962f,0.411052f},
{0.0620221f,0.929727f,0.36299f},{-0.282972f,0.934857f,0.214405f},{-0.615301f,0.786982f,-0.0454205f},
{-0.801931f,0.50525f,-0.318792f},{-0.828411f,0.229084f,-0.511132f},{-0.767789f,0.0192654f,-0.640413f},
{-0.635529f,-0.158819f,-0.755566f},{-0.419196f,-0.323113f,-0.848453f},{-0.287092f,-0.204083f,-0.935911f},
{-0.332725f,-0.234094f,-0.913506f},{0.0777156f,-0.636227f,-0.767578f},{0.185381f,-0.665275f,-0.723217f},
{0.574317f,-0.624742f,-0.529015f},{0.915037f,-0.372037f,-0.155874f},{0.970312f,0.0155882f,0.241355f},
{0.835734f,0.302764f,0.45813f},{0.661248f,0.502507f,0.55699f},{0.4389f,0.667767f,0.60121f},
{0.159616f,0.794844f,0.585445f},{-0.185909f,0.864414f,0.467147f},{-0.581437f,0.789583f,0.196187f},
{-0.849235f,0.504775f,-0.154925f},{-0.893859f,0.18134f,-0.410039f},{-0.828751f,-0.0575601f,-0.556649f},
{-0.696171f,-0.255841f,-0.67074f},{-0.464342f,-0.44475f,-0.765888f},{-0.24798f,-0.5422f,-0.802823f},
{-0.288333f,-0.569202f,-0.769983f},{-0.164231f,0.647208f,0.744413f},{-0.168401f,0.825722f,0.538354f},
{-0.252556f,0.752327f,0.608457f},{-0.218923f,0.609165f,0.762228f},{-0.356681f,0.632058f,0.687955f},
{-0.270207f,0.544858f,0.7938f},{-0.412454f,0.495243f,0.764602f},{-0.299424f,0.470627f,0.829973f},
{-0.422015f,0.380859f,0.822709f},{-0.301851f,0.415248f,0.858169f},{-0.401892f,0.308829f,0.862037f},
{-0.292041f,0.388966f,0.873738f},{-0.363526f,0.271835f,0.891041f},{-0.278694f,0.377274f,0.883173f},
{-0.304694f,0.252246f,0.918441f},{-0.251401f,0.371711f,0.89366f},{-0.21953f,0.245247f,0.944278f},
{-0.203426f,0.38298f,0.901079f},{-0.106344f,0.266344f,0.957994f},{-0.14537f,0.419089f,0.896232f},
{0.027634f,0.342629f,0.939064f},{-0.0921043f,0.475795f,0.87472f},{0.150223f,0.478986f,0.864873f},
{-0.0560432f,0.540989f,0.83916f},{0.212316f,0.629316f,0.747585f},{-0.0446826f,0.598166f,0.800126f},
{0.197281f,0.745623f,0.636495f},{-0.0554218f,0.637032f,0.768843f},{0.122751f,0.816344f,0.56437f},
{-0.0810959f,0.657415f,0.749152f},{0.0109646f,0.843844f,0.536477f},{-0.11762f,0.661328f,0.740818f},
{-0.150429f,0.979508f,0.133919f},{-0.290601f,0.909681f,0.2967f},{-0.492893f,0.728683f,0.475477f},
{-0.588316f,0.49644f,0.638304f},{-0.591448f,0.302121f,0.747604f},{-0.550134f,0.182488f,0.814893f},
{-0.484732f,0.115851f,0.866957f},{-0.378527f,0.0607272f,0.923596f},{-0.212839f,-0.000689027f,0.977087f},
{0.015943f,-0.0365482f,0.999205f},{0.305805f,0.0359447f,0.951415f},{0.57072f,0.278041f,0.77264f},
{0.651417f,0.564719f,0.506703f},{0.56895f,0.766234f,0.298632f},{0.409059f,0.893493f,0.185313f},
{0.201877f,0.968758f,0.144064f},{0.0304928f,0.931217f,0.363189f},{0.0245996f,0.929896f,0.366999f},
{-0.10373f,0.955245f,-0.277031f},{-0.304298f,0.947159f,-0.101449f},{-0.625893f,0.75942f,0.177593f},
{-0.773097f,0.445834f,0.451168f},{-0.7627f,0.179062f,0.62147f},{-0.697411f,0.0163115f,0.716486f},
{-0.606449f,-0.0938258f,0.789567f},{-0.441344f,-0.218556f,0.870316f},{-0.163703f,-0.363292f,0.917181f},
{0.189081f,-0.461406f,0.866806f},{0.58293f,-0.414287f,0.69897f},{0.912069f,-0.125103f,0.390487f},
{0.962139f,0.268252f,0.0482682f},{0.817556f,0.55344f,-0.159083f},{0.610798f,0.750085f,-0.25357f},
{0.349988f,0.891328f,-0.288173f},{0.158433f,0.982699f,-0.0959295f},{0.160262f,0.982234f,-0.0976385f},
{-0.0706087f,0.906588f,-0.416067f},{-0.213969f,0.914498f,-0.343382f},{-0.603053f,0.79487f,-0.0671517f},
{-0.837519f,0.469329f,0.279806f},{-0.845853f,0.147687f,0.512563f},{-0.772128f,-0.0502244f,0.633479f},
{-0.675299f,-0.184114f,0.714194f},{-0.504383f,-0.337547f,0.79477f},{-0.192974f,-0.522644f,0.830424f},
{0.200919f,-0.646592f,0.735901f},{0.584482f,-0.62365f,0.519077f},{0.903386f,-0.383047f,0.19279f},
{0.989227f,0.0196845f,-0.145061f},{0.873732f,0.349006f,-0.338803f},{0.693124f,0.580565f,-0.427228f},
{0.447705f,0.760557f,-0.470226f},{0.253468f,0.841137f,-0.477748f},{0.241386f,0.850733f,-0.46689f},
{0.168401f,0.825722f,0.538354f},{0.164232f,0.647208f,0.744413f},{0.252556f,0.752327f,0.608457f},
{0.218923f,0.609165f,0.762227f},{0.35668f,0.632058f,0.687954f},{0.270207f,0.544859f,0.793799f},
{0.412454f,0.495243f,0.764602f},{0.299424f,0.470627f,0.829973f},{0.422015f,0.380859f,0.822709f},
{0.301851f,0.415248f,0.85817f},{0.401892f,0.308829f,0.862037f},{0.292041f,0.388965f,0.873738f},
{0.363526f,0.271835f,0.891041f},{0.278694f,0.377274f,0.883173f},{0.304695f,0.252246f,0.918441f},
{0.251401f,0.371711f,0.89366f},{0.21953f,0.245247f,0.944278f},{0.203426f,0.38298f,0.901079f},
{0.106344f,0.266344f,0.957994f},{0.14537f,0.419089f,0.896232f},{-0.0276341f,0.342629f,0.939064f},
{0.0921045f,0.475795f,0.874721f},{-0.150223f,0.478986f,0.864873f},{0.0560429f,0.540989f,0.83916f},
{-0.212316f,0.629316f,0.747585f},{0.0446824f,0.598166f,0.800126f},{-0.197281f,0.745623f,0.636495f},
{0.0554217f,0.637032f,0.768842f},{-0.122751f,0.816344f,0.56437f},{0.0810955f,0.657415f,0.749152f},
{-0.0109649f,0.843844f,0.536477f},{0.11762f,0.661328f,0.740818f},{0.150429f,0.979508f,0.133919f},
{0.290601f,0.909681f,0.2967f},{0.492893f,0.728683f,0.475477f},{0.588316f,0.49644f,0.638304f},
{0.591449f,0.30212f,0.747604f},{0.550134f,0.182488f,0.814893f},{0.484732f,0.115851f,0.866957f},
{0.378527f,0.0607272f,0.923596f},{0.212839f,-0.000689037f,0.977087f},{-0.015943f,-0.0365482f,0.999205f},
{-0.305805f,0.0359448f,0.951415f},{-0.57072f,0.278041f,0.77264f},{-0.651417f,0.564719f,0.506703f},
{-0.56895f,0.766234f,0.298632f},{-0.409059f,0.893493f,0.185313f},{-0.201877f,0.968758f,0.144064f},
{-0.0304928f,0.931217f,0.363188f},{-0.0245995f,0.929896f,0.366999f},{0.103731f,0.955245f,-0.277031f},
{0.304298f,0.947159f,-0.101449f},{0.625893f,0.75942f,0.177593f},{0.773097f,0.445834f,0.451168f},
{0.7627f,0.179062f,0.621471f},{0.697411f,0.0163118f,0.716486f},{0.606449f,-0.0938259f,0.789567f},
{0.441344f,-0.218556f,0.870316f},{0.163703f,-0.363292f,0.917181f},{-0.189081f,-0.461406f,0.866806f},
{-0.58293f,-0.414287f,0.69897f},{-0.912069f,-0.125103f,0.390487f},{-0.962139f,0.268252f,0.0482685f},
{-0.817556f,0.55344f,-0.159082f},{-0.610798f,0.750085f,-0.25357f},{-0.349988f,0.891328f,-0.288172f},
{-0.158433f,0.982699f,-0.0959295f},{-0.160262f,0.982234f,-0.0976387f},{0.0706102f,0.906589f,-0.416066f},
{0.213969f,0.914498f,-0.343382f},{0.603053f,0.79487f,-0.0671515f},{0.837519f,0.469329f,0.279806f},
{0.845853f,0.147687f,0.512564f},{0.772128f,-0.0502239f,0.633479f},{0.675299f,-0.184114f,0.714195f},
{0.504383f,-0.337547f,0.79477f},{0.192974f,-0.522644f,0.830424f},{-0.200919f,-0.646592f,0.735901f},
{-0.584483f,-0.62365f,0.519077f},{-0.903386f,-0.383047f,0.19279f},{-0.989227f,0.0196847f,-0.145061f},
{-0.873732f,0.349006f,-0.338802f},{-0.693124f,0.580565f,-0.427228f},{-0.447705f,0.760557f,-0.470226f},
{-0.253469f,0.841136f,-0.477748f},{-0.241386f,0.850734f,-0.466889f}
},

//lid 5
{
{0.193444f,0.407529f,-0.892468f},{0.165525f,0.155217f,-0.973914f},{0.0817702f,0.2083f,-0.974641f},
{0.130027f,0.443981f,-0.886552f},{-0.0700469f,0.308246f,-0.948724f},{0.0698369f,0.508184f,-0.858413f},
{-0.202986f,0.479244f,-0.853887f},{0.0285804f,0.58596f,-0.809836f},{-0.259965f,0.655945f,-0.708629f},
{0.0167872f,0.652994f,-0.757177f},{-0.22937f,0.781713f,-0.579925f},{0.0293912f,0.697471f,-0.71601f},
{-0.13996f,0.851318f,-0.505638f},{0.0589978f,0.723127f,-0.688191f},{-0.0190551f,0.876732f,-0.480602f},
{0.105824f,0.731903f,-0.673142f},{0.117151f,0.862225f,-0.492791f},{0.168272f,0.71841f,-0.674961f},
{0.254554f,0.804206f,-0.53708f},{0.23545f,0.678528f,-0.695818f},{0.373057f,0.702449f,-0.60613f},
{0.29162f,0.616637f,-0.731243f},{0.450121f,0.574444f,-0.683671f},{0.323966f,0.547484f,-0.771562f},
{0.476569f,0.450249f,-0.755088f},{0.330806f,0.488291f,-0.807552f},{0.458733f,0.348468f,-0.817395f},
{0.31924f,0.444994f,-0.8367f},{0.405583f,0.269649f,-0.87338f},{0.29274f,0.414652f,-0.861608f},
{0.32327f,0.212095f,-0.922232f},{0.24994f,0.399549f,-0.881981f},{0.0759488f,-0.244867f,-0.966577f},
{-0.0372175f,-0.181635f,-0.982661f},{-0.339106f,-0.0810756f,-0.937248f},{-0.630476f,0.204915f,-0.748672f},
{-0.71242f,0.539226f,-0.449103f},{-0.6053f,0.763821f,-0.224031f},{-0.425226f,0.896448f,-0.124756f},
{-0.206691f,0.972417f,-0.108088f},{0.0371f,0.98819f,-0.148678f},{0.285431f,0.926163f,-0.246478f},
{0.498493f,0.773669f,-0.391077f},{0.627033f,0.56197f,-0.539462f},{0.662497f,0.357666f,-0.658159f},
{0.628481f,0.192969f,-0.753508f},{0.53626f,0.0552887f,-0.84224f},{0.389472f,-0.0657248f,-0.91869f},
{0.295455f,0.056842f,-0.953664f},{0.316848f,0.0475216f,-0.947285f},{-0.0397306f,-0.599632f,-0.799289f},
{-0.189195f,-0.569456f,-0.799953f},{-0.578897f,-0.49671f,-0.64665f},{-0.925553f,-0.191261f,-0.326758f},
{-0.975049f,0.218034f,0.0417236f},{-0.819003f,0.512483f,0.258062f},{-0.611015f,0.715488f,0.338728f},
{-0.354073f,0.868841f,0.346045f},{-0.0474662f,0.956162f,0.288965f},{0.295731f,0.944569f,0.142591f},
{0.617105f,0.780581f,-0.0993728f},{0.798058f,0.491737f,-0.348278f},{0.826967f,0.210536f,-0.521345f},
{0.770201f,-0.00938286f,-0.637732f},{0.637273f,-0.202705f,-0.743501f},{0.413738f,-0.379248f,-0.827642f},
{0.2762f,-0.263919f,-0.924154f},{0.324592f,-0.293701f,-0.899099f},{-0.089634f,-0.686727f,-0.721368f},
{-0.196968f,-0.709494f,-0.676625f},{-0.57606f,-0.656331f,-0.487222f},{-0.907761f,-0.396805f,-0.13607f},
{-0.97175f,0.00107842f,0.236008f},{-0.843724f,0.309278f,0.438722f},{-0.667858f,0.529876f,0.522683f},
{-0.437969f,0.71117f,0.549927f},{-0.146691f,0.841099f,0.520609f},{0.20301f,0.895177f,0.396793f},
{0.586122f,0.798484f,0.137423f},{0.843686f,0.503519f,-0.186178f},{0.891329f,0.172679f,-0.419183f},
{0.830646f,-0.0802118f,-0.550994f},{0.698204f,-0.297244f,-0.651273f},{0.46035f,-0.500613f,-0.733119f},
{0.239202f,-0.60152f,-0.762205f},{0.275863f,-0.623816f,-0.731268f},{-0.165525f,0.155217f,-0.973914f},
{-0.193444f,0.407529f,-0.892468f},{-0.0817703f,0.2083f,-0.974641f},{-0.130028f,0.443981f,-0.886552f},
{0.070047f,0.308246f,-0.948724f},{-0.0698366f,0.508184f,-0.858412f},{0.202986f,0.479244f,-0.853886f},
{-0.0285805f,0.58596f,-0.809836f},{0.259965f,0.655945f,-0.708629f},{-0.0167873f,0.652994f,-0.757177f},
{0.22937f,0.781714f,-0.579925f},{-0.0293914f,0.697471f,-0.71601f},{0.13996f,0.851318f,-0.505638f},
{-0.0589978f,0.723127f,-0.688191f},{0.0190551f,0.876732f,-0.480602f},{-0.105824f,0.731903f,-0.673142f},
{-0.117152f,0.862225f,-0.492791f},{-0.168272f,0.71841f,-0.674961f},{-0.254554f,0.804206f,-0.53708f},
{-0.23545f,0.678528f,-0.695818f},{-0.373057f,0.702449f,-0.60613f},{-0.29162f,0.616637f,-0.731243f},
{-0.450121f,0.574444f,-0.683671f},{-0.323966f,0.547484f,-0.771561f},{-0.476569f,0.450249f,-0.755088f},
{-0.330806f,0.488291f,-0.807552f},{-0.458733f,0.348468f,-0.817394f},{-0.319241f,0.444994f,-0.836699f},
{-0.405583f,0.269649f,-0.87338f},{-0.29274f,0.414652f,-0.861608f},{-0.32327f,0.212094f,-0.922232f},
{-0.249939f,0.399549f,-0.881981f},{-0.0759488f,-0.244867f,-0.966577f},{0.0372174f,-0.181635f,-0.982661f},
{0.339106f,-0.0810758f,-0.937248f},{0.630476f,0.204915f,-0.748672f},{0.71242f,0.539226f,-0.449103f},
{0.6053f,0.763821f,-0.224031f},{0.425226f,0.896448f,-0.124756f},{0.206691f,0.972417f,-0.108088f},
{-0.0370999f,0.98819f,-0.148678f},{-0.285431f,0.926163f,-0.246478f},{-0.498494f,0.773669f,-0.391077f},
{-0.627033f,0.56197f,-0.539462f},{-0.662496f,0.357666f,-0.658159f},{-0.62848f,0.192969f,-0.753509f},
{-0.53626f,0.0552887f,-0.84224f},{-0.389472f,-0.0657248f,-0.91869f},{-0.295455f,0.0568416f,-0.953664f},
{-0.316847f,0.0475212f,-0.947285f},{0.0397307f,-0.599632f,-0.799289f},{0.189195f,-0.569456f,-0.799953f},
{0.578897f,-0.496711f,-0.64665f},{0.925553f,-0.191262f,-0.326758f},{0.975049f,0.218034f,0.0417234f},
{0.819003f,0.512483f,0.258062f},{0.611015f,0.715488f,0.338728f},{0.354073f,0.868841f,0.346045f},
{0.0474661f,0.956162f,0.288965f},{-0.295731f,0.944569f,0.142591f},{-0.617106f,0.78058f,-0.0993727f},
{-0.798058f,0.491737f,-0.348278f},{-0.826967f,0.210536f,-0.521344f},{-0.770201f,-0.00938315f,-0.637733f},
{-0.637273f,-0.202705f,-0.743501f},{-0.413738f,-0.379248f,-0.827642f},{-0.2762f,-0.263918f,-0.924154f},
{-0.324592f,-0.293701f,-0.8991f},{0.0896339f,-0.686727f,-0.721368f},{0.196968f,-0.709494f,-0.676625f},
{0.57606f,-0.656331f,-0.487222f},{0.907761f,-0.396806f,-0.136069f},{0.971751f,0.001078f,0.236008f},
{0.843724f,0.309278f,0.438722f},{0.667858f,0.529876f,0.522683f},{0.437969f,0.71117f,0.549927f},
{0.146691f,0.841099f,0.520609f},{-0.203011f,0.895177f,0.396793f},{-0.586122f,0.798484f,0.137422f},
{-0.843686f,0.503519f,-0.186178f},{-0.89133f,0.172678f,-0.419182f},{-0.830646f,-0.0802122f,-0.550993f},
{-0.698204f,-0.297244f,-0.651273f},{-0.46035f,-0.500613f,-0.733119f},{-0.239203f,-0.601519f,-0.762205f},
{-0.275863f,-0.623816f,-0.731268f},{-0.180068f,0.577236f,0.796476f},{-0.184464f,0.761676f,0.621147f},
{-0.263986f,0.684387f,0.679651f},{-0.233173f,0.53943f,0.809102f},{-0.360888f,0.565359f,0.741707f},
{-0.281882f,0.476613f,0.832696f},{-0.413008f,0.435886f,0.799642f},{-0.307999f,0.408132f,0.859398f},
{-0.423679f,0.331379f,0.843021f},{-0.309908f,0.360869f,0.87962f},{-0.407224f,0.266101f,0.873704f},
{-0.302213f,0.339523f,0.890725f},{-0.371172f,0.229158f,0.899843f},{-0.289523f,0.327562f,0.899378f},
{-0.31079f,0.203294f,0.928483f},{-0.259276f,0.319654f,0.911371f},{-0.221476f,0.186725f,0.957122f},
{-0.208676f,0.329032f,0.920974f},{-0.105951f,0.197938f,0.974472f},{-0.152893f,0.361911f,0.919589f},
{0.0247945f,0.266447f,0.963531f},{-0.105696f,0.412464f,0.904821f},{0.139783f,0.401472f,0.905141f},
{-0.0747584f,0.471703f,0.878582f},{0.194322f,0.559025f,0.806058f},{-0.065496f,0.526649f,0.847556f},
{0.173984f,0.683979f,0.708451f},{-0.0765603f,0.565675f,0.821066f},{0.0973667f,0.758329f,0.64456f},
{-0.101272f,0.586349f,0.803703f},{-0.0128182f,0.784094f,0.620509f},{-0.13559f,0.590702f,0.795416f},
{-0.167613f,0.95658f,0.238456f},{-0.302976f,0.868131f,0.393134f},{-0.492446f,0.677089f,0.546852f},
{-0.580527f,0.448426f,0.679634f},{-0.58693f,0.263618f,0.765519f},{-0.554051f,0.148408f,0.819147f},
{-0.493685f,0.0752757f,0.866377f},{-0.383034f,0.00329912f,0.923728f},{-0.205087f,-0.0772348f,0.975691f},
{0.0313089f,-0.126159f,0.991516f},{0.314577f,-0.0622055f,0.947191f},{0.572765f,0.183372f,0.798947f},
{0.652539f,0.501707f,0.567876f},{0.561476f,0.73558f,0.379034f},{0.392032f,0.876671f,0.278852f},
{0.180957f,0.951871f,0.247377f},{0.0093866f,0.885281f,0.464963f},{-0.00263635f,0.88147f,0.472233f},
{-0.124483f,0.975732f,-0.180142f},{-0.318931f,0.947771f,-0.00348479f},{-0.623523f,0.739693f,0.253129f},
{-0.76216f,0.422483f,0.49053f},{-0.758436f,0.156186f,0.632756f},{-0.704104f,-0.0146938f,0.709945f},
{-0.618543f,-0.14637f,0.771998f},{-0.444527f,-0.300675f,0.843795f},{-0.148418f,-0.459723f,0.875572f},
{0.208804f,-0.548394f,0.809731f},{0.584935f,-0.489972f,0.646358f},{0.905722f,-0.196085f,0.37579f},
{0.97087f,0.227395f,0.0755174f},{0.825811f,0.553351f,-0.10881f},{0.607682f,0.772688f,-0.183509f},
{0.337269f,0.919679f,-0.201098f},{0.141443f,0.989923f,0.00676962f},{0.143487f,0.989641f,0.00480806f},
{-0.0933005f,0.94115f,-0.324855f},{-0.231626f,0.939611f,-0.251951f},{-0.604057f,0.796837f,0.0128559f},
{-0.825195f,0.463072f,0.323448f},{-0.840198f,0.136845f,0.524729f},{-0.776581f,-0.0757791f,0.625444f},
{-0.684572f,-0.236751f,0.689427f},{-0.505898f,-0.425245f,0.750489f},{-0.17675f,-0.62361f,0.761492f},
{0.21899f,-0.722456f,0.65582f},{0.585977f,-0.671017f,0.454276f},{0.893638f,-0.418293f,0.162611f},
{0.990147f,-0.00181478f,-0.140023f},{0.881177f,0.355667f,-0.311494f},{0.694655f,0.61195f,-0.378116f},
{0.438808f,0.804679f,-0.399924f},{0.236289f,0.887341f,-0.39597f},{0.228909f,0.892442f,-0.388777f},
{0.184464f,0.761676f,0.621147f},{0.180068f,0.577236f,0.796476f},{0.263986f,0.684387f,0.679651f},
{0.233173f,0.53943f,0.809102f},{0.360888f,0.565359f,0.741707f},{0.281881f,0.476613f,0.832696f},
{0.413008f,0.435886f,0.799643f},{0.307998f,0.408132f,0.859398f},{0.423679f,0.331378f,0.843021f},
{0.309908f,0.360868f,0.87962f},{0.407224f,0.266101f,0.873704f},{0.302213f,0.339523f,0.890725f},
{0.371172f,0.229158f,0.899843f},{0.289523f,0.327562f,0.899377f},{0.310791f,0.203294f,0.928483f},
{0.259276f,0.319654f,0.911371f},{0.221476f,0.186725f,0.957122f},{0.208676f,0.329032f,0.920974f},
{0.105951f,0.197938f,0.974472f},{0.152893f,0.361911f,0.919589f},{-0.0247946f,0.266447f,0.96353f},
{0.105696f,0.412464f,0.904821f},{-0.139783f,0.401473f,0.905141f},{0.0747584f,0.471704f,0.878582f},
{-0.194321f,0.559026f,0.806058f},{0.065496f,0.526648f,0.847556f},{-0.173984f,0.683979f,0.708451f},
{0.0765603f,0.565675f,0.821066f},{-0.0973666f,0.758329f,0.64456f},{0.101272f,0.586349f,0.803703f},
{0.0128182f,0.784094f,0.620509f},{0.13559f,0.590702f,0.795416f},{0.167613f,0.95658f,0.238456f},
{0.302976f,0.868131f,0.393134f},{0.492446f,0.677089f,0.546852f},{0.580527f,0.448426f,0.679635f},
{0.58693f,0.263618f,0.765518f},{0.554051f,0.148408f,0.819147f},{0.493685f,0.0752757f,0.866377f},
{0.383034f,0.00329909f,0.923728f},{0.205088f,-0.0772348f,0.975691f},{-0.0313088f,-0.126159f,0.991516f},
{-0.314577f,-0.0622053f,0.947191f},{-0.572765f,0.183371f,0.798946f},{-0.65254f,0.501707f,0.567876f},
{-0.561476f,0.73558f,0.379034f},{-0.392032f,0.876671f,0.278852f},{-0.180957f,0.951871f,0.247377f},
{-0.00938683f,0.885281f,0.464963f},{0.0026364f,0.88147f,0.472233f},{0.124484f,0.975732f,-0.180142f},
{0.318931f,0.947771f,-0.00348472f},{0.623523f,0.739693f,0.253129f},{0.76216f,0.422484f,0.49053f},
{0.758436f,0.156185f,0.632756f},{0.704104f,-0.0146936f,0.709945f},{0.618543f,-0.14637f,0.771998f},
{0.444527f,-0.300675f,0.843795f},{0.148418f,-0.459723f,0.875572f},{-0.208804f,-0.548394f,0.809732f},
{-0.584935f,-0.489972f,0.646358f},{-0.905722f,-0.196085f,0.37579f},{-0.97087f,0.227394f,0.0755171f},
{-0.825811f,0.55335f,-0.10881f},{-0.607682f,0.772688f,-0.183509f},{-0.337269f,0.919679f,-0.201098f},
{-0.141444f,0.989923f,0.0067696f},{-0.143487f,0.989641f,0.00480797f},{0.0933005f,0.94115f,-0.324856f},
{0.231626f,0.939611f,-0.251951f},{0.604057f,0.796837f,0.012856f},{0.825195f,0.463072f,0.323448f},
{0.840198f,0.136845f,0.524729f},{0.77658f,-0.0757789f,0.625444f},{0.684572f,-0.236751f,0.689427f},
{0.505898f,-0.425245f,0.750489f},{0.17675f,-0.62361f,0.761492f},{-0.21899f,-0.722456f,0.65582f},
{-0.585977f,-0.671017f,0.454276f},{-0.893638f,-0.418292f,0.162611f},{-0.990147f,-0.00181415f,-0.140023f},
{-0.881177f,0.355667f,-0.311494f},{-0.694655f,0.61195f,-0.378116f},{-0.438808f,0.804679f,-0.399924f},
{-0.236289f,0.887341f,-0.39597f},{-0.228909f,0.892442f,-0.388777f}
},

//lid 4
{
{0.197806f,0.252423f,-0.947183f},{0.152974f,-0.0131419f,-0.988143f},{0.076402f,0.0291397f,-0.996651f},
{0.141586f,0.282977f,-0.948619f},{-0.0651858f,0.114567f,-0.991275f},{0.0907763f,0.340981f,-0.935677f},
{-0.188783f,0.288503f,-0.938684f},{0.0551476f,0.4203f,-0.905708f},{-0.240493f,0.497493f,-0.833465f},
{0.0456548f,0.499267f,-0.865244f},{-0.202638f,0.66064f,-0.722836f},{0.0611606f,0.557154f,-0.828154f},
{-0.105771f,0.750916f,-0.651872f},{0.0934525f,0.590793f,-0.801393f},{0.0175425f,0.780671f,-0.624695f},
{0.139504f,0.603068f,-0.785397f},{0.15047f,0.76202f,-0.629829f},{0.198294f,0.591171f,-0.781791f},
{0.281108f,0.697071f,-0.659599f},{0.261657f,0.550939f,-0.792465f},{0.391376f,0.589919f,-0.706272f},
{0.313791f,0.487662f,-0.814691f},{0.461111f,0.461151f,-0.758101f},{0.342101f,0.418757f,-0.841195f},
{0.483411f,0.338155f,-0.807443f},{0.346951f,0.359543f,-0.86623f},{0.463587f,0.232429f,-0.855022f},
{0.33397f,0.311178f,-0.889737f},{0.407038f,0.141258f,-0.902422f},{0.302905f,0.271678f,-0.913477f},
{0.318994f,0.0666247f,-0.945412f},{0.25442f,0.249147f,-0.93445f},{0.0393542f,-0.403638f,-0.914072f},
{-0.0633284f,-0.348984f,-0.934987f},{-0.341741f,-0.268004f,-0.90077f},{-0.622255f,0.00424061f,-0.782803f},
{-0.723034f,0.396393f,-0.565769f},{-0.608206f,0.699392f,-0.375414f},{-0.40421f,0.8671f,-0.291121f},
{-0.172562f,0.943235f,-0.283777f},{0.0704847f,0.944233f,-0.321646f},{0.30922f,0.863119f,-0.39926f},
{0.508772f,0.695251f,-0.507717f},{0.627113f,0.478984f,-0.61425f},{0.661072f,0.274946f,-0.698133f},
{0.629603f,0.100423f,-0.7704f},{0.533618f,-0.0611259f,-0.843514f},{0.373406f,-0.207599f,-0.904141f},
{0.272005f,-0.0903327f,-0.958047f},{0.308413f,-0.102804f,-0.945681f},{-0.0753382f,-0.721378f,-0.688431f},
{-0.221636f,-0.685687f,-0.693333f},{-0.580906f,-0.600102f,-0.549932f},{-0.906914f,-0.30141f,-0.294379f},
{-0.990017f,0.14083f,-0.00574827f},{-0.844923f,0.508554f,0.165766f},{-0.615889f,0.760283f,0.206519f},
{-0.333857f,0.926152f,0.175449f},{-0.012656f,0.99492f,0.0998718f},{0.322707f,0.945914f,-0.0332746f},
{0.619119f,0.751467f,-0.22801f},{0.787733f,0.452378f,-0.418129f},{0.823064f,0.161486f,-0.544508f},
{0.775054f,-0.0856956f,-0.626057f},{0.638683f,-0.318141f,-0.700622f},{0.397172f,-0.52005f,-0.756176f},
{0.246139f,-0.418283f,-0.874331f},{0.294987f,-0.443073f,-0.846563f},{-0.116264f,-0.796737f,-0.593036f},
{-0.226117f,-0.802769f,-0.551755f},{-0.586943f,-0.715357f,-0.379158f},{-0.89438f,-0.440125f,-0.0798445f},
{-0.973234f,-0.0311641f,0.227692f},{-0.864269f,0.318505f,0.389351f},{-0.684692f,0.588076f,0.430538f},
{-0.433616f,0.80353f,0.40782f},{-0.11501f,0.932725f,0.341755f},{0.240096f,0.946978f,0.213511f},
{0.593785f,0.804597f,-0.00656442f},{0.829619f,0.49272f,-0.262602f},{0.884967f,0.146821f,-0.441901f},
{0.834044f,-0.142061f,-0.533093f},{0.699282f,-0.404508f,-0.589388f},{0.447792f,-0.634866f,-0.629625f},
{0.219984f,-0.737571f,-0.638433f},{0.244461f,-0.748524f,-0.616401f},{-0.152973f,-0.0131418f,-0.988143f},
{-0.197805f,0.252424f,-0.947183f},{-0.0764017f,0.0291398f,-0.996651f},{-0.141586f,0.282977f,-0.948619f},
{0.0651859f,0.114567f,-0.991275f},{-0.0907765f,0.340981f,-0.935677f},{0.188783f,0.288503f,-0.938684f},
{-0.0551476f,0.4203f,-0.905708f},{0.240493f,0.497493f,-0.833465f},{-0.0456548f,0.499267f,-0.865244f},
{0.202638f,0.66064f,-0.722836f},{-0.0611606f,0.557154f,-0.828154f},{0.105771f,0.750916f,-0.651872f},
{-0.0934527f,0.590793f,-0.801393f},{-0.0175423f,0.780672f,-0.624695f},{-0.139504f,0.603067f,-0.785397f},
{-0.15047f,0.76202f,-0.629829f},{-0.198294f,0.591171f,-0.781791f},{-0.281108f,0.697071f,-0.659599f},
{-0.261658f,0.550939f,-0.792466f},{-0.391376f,0.589919f,-0.706272f},{-0.313791f,0.487663f,-0.81469f},
{-0.46111f,0.46115f,-0.758101f},{-0.342102f,0.418756f,-0.841196f},{-0.483411f,0.338154f,-0.807443f},
{-0.346951f,0.359543f,-0.86623f},{-0.463587f,0.23243f,-0.855022f},{-0.333971f,0.311179f,-0.889737f},
{-0.407039f,0.141259f,-0.902422f},{-0.302905f,0.271678f,-0.913477f},{-0.318994f,0.0666247f,-0.945412f},
{-0.25442f,0.249147f,-0.93445f},{-0.0393541f,-0.403638f,-0.914072f},{0.0633285f,-0.348984f,-0.934987f},
{0.341741f,-0.268004f,-0.90077f},{0.622255f,0.00424059f,-0.782803f},{0.723034f,0.396392f,-0.565769f},
{0.608206f,0.699393f,-0.375414f},{0.40421f,0.8671f,-0.291121f},{0.172562f,0.943235f,-0.283777f},
{-0.0704845f,0.944233f,-0.321646f},{-0.30922f,0.863119f,-0.39926f},{-0.508772f,0.695251f,-0.507717f},
{-0.627113f,0.478984f,-0.61425f},{-0.661072f,0.274945f,-0.698133f},{-0.629603f,0.100424f,-0.7704f},
{-0.533618f,-0.0611257f,-0.843514f},{-0.373405f,-0.207599f,-0.904141f},{-0.272005f,-0.0903328f,-0.958047f},
{-0.308413f,-0.102804f,-0.945681f},{0.0753384f,-0.721378f,-0.688431f},{0.221636f,-0.685687f,-0.693333f},
{0.580906f,-0.600103f,-0.549932f},{0.906914f,-0.301409f,-0.294379f},{0.990017f,0.14083f,-0.00574841f},
{0.844923f,0.508554f,0.165766f},{0.615889f,0.760283f,0.206519f},{0.333857f,0.926152f,0.175449f},
{0.012656f,0.99492f,0.0998718f},{-0.322707f,0.945914f,-0.0332747f},{-0.619119f,0.751468f,-0.22801f},
{-0.787733f,0.452378f,-0.418128f},{-0.823064f,0.161485f,-0.544508f},{-0.775054f,-0.0856957f,-0.626057f},
{-0.638683f,-0.318141f,-0.700622f},{-0.397172f,-0.52005f,-0.756176f},{-0.246138f,-0.418282f,-0.874332f},
{-0.294987f,-0.443073f,-0.846563f},{0.116265f,-0.796737f,-0.593037f},{0.226117f,-0.802769f,-0.551755f},
{0.586943f,-0.715357f,-0.379159f},{0.89438f,-0.440125f,-0.0798443f},{0.973234f,-0.031164f,0.227692f},
{0.864269f,0.318505f,0.389351f},{0.684692f,0.588076f,0.430539f},{0.433616f,0.803529f,0.40782f},
{0.11501f,0.932725f,0.341755f},{-0.240096f,0.946978f,0.213511f},{-0.593785f,0.804597f,-0.00656453f},
{-0.829619f,0.49272f,-0.262602f},{-0.884968f,0.146821f,-0.4419f},{-0.834045f,-0.142061f,-0.533093f},
{-0.699282f,-0.404508f,-0.589388f},{-0.447792f,-0.634866f,-0.629625f},{-0.219984f,-0.737571f,-0.638433f},
{-0.24446f,-0.748524f,-0.616401f},{-0.208426f,0.467505f,0.859068f},{-0.21141f,0.645342f,0.734057f},
{-0.282958f,0.5677f,0.773079f},{-0.258987f,0.431703f,0.864036f},{-0.368601f,0.458411f,0.808698f},
{-0.303103f,0.374109f,0.876454f},{-0.416668f,0.346642f,0.840374f},{-0.324375f,0.31716f,0.891174f},
{-0.430617f,0.259782f,0.864339f},{-0.325747f,0.282993f,0.902111f},{-0.420251f,0.203556f,0.884282f},
{-0.320713f,0.268048f,0.908457f},{-0.386943f,0.162916f,0.907598f},{-0.307412f,0.253854f,0.917091f},
{-0.322163f,0.122735f,0.938695f},{-0.27108f,0.240458f,0.932038f},{-0.223762f,0.0878124f,0.97068f},
{-0.21604f,0.245468f,0.945025f},{-0.10262f,0.0825365f,0.991291f},{-0.16423f,0.272449f,0.948051f},
{0.0234933f,0.139016f,0.990011f},{-0.126689f,0.312363f,0.941477f},{0.125261f,0.270589f,0.954511f},
{-0.103528f,0.360547f,0.926978f},{0.165273f,0.437098f,0.884098f},{-0.0972457f,0.411136f,0.906372f},
{0.133677f,0.573686f,0.808093f},{-0.109202f,0.451287f,0.885672f},{0.0521017f,0.651921f,0.756495f},
{-0.133792f,0.473599f,0.870519f},{-0.0551972f,0.673656f,0.736981f},{-0.166331f,0.479272f,0.861761f},
{-0.194724f,0.892923f,0.40592f},{-0.321362f,0.778328f,0.539381f},{-0.489835f,0.58226f,0.648872f},
{-0.569077f,0.369664f,0.734506f},{-0.583491f,0.204904f,0.785845f},{-0.565193f,0.0957166f,0.819387f},
{-0.512484f,0.00638424f,0.858673f},{-0.392507f,-0.0996617f,0.914333f},{-0.192249f,-0.211968f,0.958181f},
{0.0562841f,-0.275946f,0.959524f},{0.32738f,-0.221716f,0.918512f},{0.573276f,0.0211426f,0.819089f},
{0.653155f,0.381962f,0.65383f},{0.546416f,0.668325f,0.504748f},{0.357923f,0.829639f,0.428475f},
{0.140622f,0.899867f,0.412874f},{-0.0284427f,0.788122f,0.614862f},{-0.0532601f,0.776915f,0.627349f},
{-0.157489f,0.987401f,-0.0154112f},{-0.342529f,0.926003f,0.158719f},{-0.619782f,0.690843f,0.372299f},
{-0.744927f,0.377356f,0.550169f},{-0.752895f,0.119041f,0.647285f},{-0.717327f,-0.0636677f,0.693822f},
{-0.639658f,-0.233703f,0.732271f},{-0.449197f,-0.43605f,0.779796f},{-0.124989f,-0.610088f,0.782413f},
{0.23555f,-0.675885f,0.698352f},{0.5842f,-0.598166f,0.54855f},{0.89061f,-0.305432f,0.336936f},
{0.982168f,0.152087f,0.110523f},{0.839266f,0.543118f,-0.0256032f},{0.599899f,0.797656f,-0.0621713f},
{0.313645f,0.948255f,-0.0493838f},{0.112243f,0.977134f,0.180584f},{0.109262f,0.976934f,0.183471f},
{-0.130507f,0.977203f,-0.167459f},{-0.261054f,0.960363f,-0.0977477f},{-0.60797f,0.781317f,0.141124f},
{-0.806985f,0.441576f,0.392157f},{-0.831542f,0.116681f,0.543069f},{-0.785144f,-0.11618f,0.608318f},
{-0.700039f,-0.321851f,0.637462f},{-0.505872f,-0.56167f,0.654691f},{-0.151627f,-0.765957f,0.624755f},
{0.241223f,-0.821394f,0.51684f},{0.585322f,-0.732453f,0.347723f},{0.87707f,-0.467825f,0.109029f},
{0.989822f,-0.0383588f,-0.137044f},{0.893267f,0.361677f,-0.266953f},{0.695714f,0.656377f,-0.291808f},
{0.422793f,0.86367f,-0.274445f},{0.208815f,0.94524f,-0.250834f},{0.208427f,0.945437f,-0.250415f},
{0.21141f,0.645342f,0.734057f},{0.208426f,0.467506f,0.859068f},{0.282958f,0.5677f,0.773079f},
{0.258987f,0.431703f,0.864036f},{0.368601f,0.458412f,0.808698f},{0.303103f,0.374109f,0.876454f},
{0.416668f,0.346641f,0.840374f},{0.324375f,0.317159f,0.891174f},{0.430617f,0.259782f,0.864339f},
{0.325748f,0.282993f,0.90211f},{0.420251f,0.203557f,0.884282f},{0.320713f,0.268048f,0.908457f},
{0.386943f,0.162916f,0.907598f},{0.307412f,0.253853f,0.917091f},{0.322162f,0.122735f,0.938695f},
{0.27108f,0.240458f,0.932038f},{0.223762f,0.0878123f,0.97068f},{0.21604f,0.245468f,0.945025f},
{0.10262f,0.0825365f,0.991291f},{0.16423f,0.272449f,0.948051f},{-0.0234933f,0.139016f,0.990011f},
{0.126689f,0.312363f,0.941477f},{-0.125261f,0.270589f,0.954511f},{0.103528f,0.360547f,0.926978f},
{-0.165273f,0.437098f,0.884099f},{0.0972457f,0.411136f,0.906372f},{-0.133677f,0.573686f,0.808093f},
{0.109202f,0.451287f,0.885672f},{-0.0521018f,0.651921f,0.756495f},{0.133792f,0.473599f,0.870519f},
{0.0551972f,0.673656f,0.736981f},{0.166331f,0.479272f,0.861761f},{0.194723f,0.892923f,0.40592f},
{0.321362f,0.778328f,0.539381f},{0.489835f,0.58226f,0.648872f},{0.569077f,0.369664f,0.734506f},
{0.583491f,0.204904f,0.785845f},{0.565193f,0.0957165f,0.819387f},{0.512484f,0.00638429f,0.858673f},
{0.392507f,-0.0996618f,0.914333f},{0.192249f,-0.211968f,0.95818f},{-0.0562842f,-0.275946f,0.959524f},
{-0.32738f,-0.221716f,0.918512f},{-0.573277f,0.0211428f,0.819089f},{-0.653155f,0.381962f,0.65383f},
{-0.546416f,0.668325f,0.504748f},{-0.357923f,0.829639f,0.428475f},{-0.140621f,0.899867f,0.412874f},
{0.0284431f,0.788121f,0.614862f},{0.0532601f,0.776915f,0.627349f},{0.157489f,0.987401f,-0.015411f},
{0.342529f,0.926003f,0.158719f},{0.619782f,0.690843f,0.372299f},{0.744927f,0.377355f,0.55017f},
{0.752895f,0.119041f,0.647285f},{0.717327f,-0.0636679f,0.693822f},{0.639658f,-0.233703f,0.732271f},
{0.449197f,-0.43605f,0.779796f},{0.124989f,-0.610088f,0.782413f},{-0.23555f,-0.675885f,0.698352f},
{-0.5842f,-0.598167f,0.54855f},{-0.89061f,-0.305431f,0.336936f},{-0.982168f,0.152087f,0.110523f},
{-0.839266f,0.543117f,-0.0256036f},{-0.5999f,0.797656f,-0.0621718f},{-0.313645f,0.948255f,-0.0493838f},
{-0.112243f,0.977134f,0.180583f},{-0.109261f,0.976934f,0.183472f},{0.130507f,0.977203f,-0.167459f},
{0.261054f,0.960363f,-0.0977474f},{0.607969f,0.781317f,0.141124f},{0.806984f,0.441576f,0.392157f},
{0.831542f,0.116681f,0.543069f},{0.785144f,-0.11618f,0.608318f},{0.700039f,-0.32185f,0.637462f},
{0.505872f,-0.56167f,0.654691f},{0.151627f,-0.765957f,0.624755f},{-0.241224f,-0.821394f,0.51684f},
{-0.585322f,-0.732453f,0.347722f},{-0.87707f,-0.467826f,0.109028f},{-0.989822f,-0.0383587f,-0.137044f},
{-0.893267f,0.361677f,-0.266952f},{-0.695714f,0.656377f,-0.291808f},{-0.422793f,0.86367f,-0.274445f},
{-0.208815f,0.94524f,-0.250834f},{-0.208427f,0.945437f,-0.250415f}
},

//lid 3
{
{0.19311f,0.19139f,-0.96233f},{0.142208f,-0.0774502f,-0.986802f},{0.0678547f,-0.0384938f,-0.996952f},
{0.13967f,0.219289f,-0.965611f},{-0.0696221f,0.0408271f,-0.996738f},{0.0926616f,0.273519f,-0.957393f},
{-0.188488f,0.211241f,-0.959088f},{0.0595677f,0.351221f,-0.934396f},{-0.237285f,0.427549f,-0.872294f},
{0.0513543f,0.433495f,-0.899691f},{-0.196157f,0.604068f,-0.772415f},{0.0685151f,0.496912f,-0.865092f},
{-0.0957246f,0.703615f,-0.704104f},{0.102755f,0.534448f,-0.838932f},{0.0293679f,0.736459f,-0.675844f},
{0.149571f,0.54853f,-0.822644f},{0.161603f,0.717349f,-0.677713f},{0.207462f,0.537636f,-0.817256f},
{0.289597f,0.651122f,-0.701551f},{0.268886f,0.498353f,-0.824224f},{0.3962f,0.544012f,-0.739646f},
{0.318634f,0.436497f,-0.841393f},{0.462795f,0.417077f,-0.782219f},{0.345075f,0.369444f,-0.862806f},
{0.483462f,0.295309f,-0.824049f},{0.349167f,0.310606f,-0.884085f},{0.462611f,0.187373f,-0.866535f},
{0.335206f,0.259551f,-0.905688f},{0.403961f,0.0904898f,-0.91029f},{0.301477f,0.215711f,-0.928752f},
{0.312545f,0.00928211f,-0.949858f},{0.250059f,0.189983f,-0.949409f},{0.0226189f,-0.461349f,-0.88693f},
{-0.0777483f,-0.407964f,-0.909682f},{-0.347637f,-0.331404f,-0.877109f},{-0.62028f,-0.0696448f,-0.781283f},
{-0.72716f,0.332372f,-0.600639f},{-0.61173f,0.662993f,-0.431541f},{-0.39808f,0.845991f,-0.354728f},
{-0.160319f,0.923082f,-0.349597f},{0.0827605f,0.919205f,-0.384985f},{0.317574f,0.832385f,-0.454183f},
{0.511501f,0.661363f,-0.548603f},{0.625966f,0.446074f,-0.639675f},{0.659684f,0.2427f,-0.711276f},
{0.629048f,0.0628337f,-0.774823f},{0.530845f,-0.10926f,-0.840396f},{0.36452f,-0.264439f,-0.892859f},
{0.259041f,-0.148767f,-0.954341f},{0.299861f,-0.161339f,-0.940241f},{-0.0884018f,-0.762538f,-0.640876f},
{-0.235609f,-0.723775f,-0.648566f},{-0.585528f,-0.630369f,-0.509698f},{-0.900905f,-0.335078f,-0.275848f},
{-0.993743f,0.110014f,-0.0192989f},{-0.855874f,0.50061f,0.129883f},{-0.618627f,0.770592f,0.15326f},
{-0.32579f,0.939296f,0.107627f},{0.000229109f,0.999641f,0.0267795f},{0.331651f,0.938181f,-0.09912f},
{0.618913f,0.735647f,-0.275264f},{0.783293f,0.435371f,-0.443738f},{0.821251f,0.141209f,-0.552817f},
{0.775996f,-0.117576f,-0.619682f},{0.637531f,-0.364574f,-0.678704f},{0.389838f,-0.573292f,-0.720668f},
{0.234329f,-0.478618f,-0.846177f},{0.280671f,-0.500188f,-0.819167f},{-0.125194f,-0.832553f,-0.539613f},
{-0.23729f,-0.832272f,-0.501016f},{-0.593865f,-0.730879f,-0.336364f},{-0.891521f,-0.44951f,-0.0559531f},
{-0.973153f,-0.0412239f,0.226436f},{-0.872411f,0.319219f,0.370133f},{-0.691725f,0.605878f,0.392973f},
{-0.431433f,0.831836f,0.349162f},{-0.103034f,0.957642f,0.268899f},{0.252442f,0.957152f,0.141888f},
{0.595298f,0.801204f,-0.0607619f},{0.823888f,0.48597f,-0.291617f},{0.882366f,0.135114f,-0.450749f},
{0.834461f,-0.168251f,-0.524753f},{0.697484f,-0.446476f,-0.560514f},{0.441864f,-0.682478f,-0.58222f},
{0.213859f,-0.783387f,-0.583584f},{0.2332f,-0.79081f,-0.565895f},{-0.142208f,-0.0774502f,-0.986802f},
{-0.19311f,0.19139f,-0.96233f},{-0.0678546f,-0.0384938f,-0.996952f},{-0.13967f,0.219289f,-0.965611f},
{0.0696222f,0.0408271f,-0.996738f},{-0.0926615f,0.273519f,-0.957393f},{0.188488f,0.211241f,-0.959088f},
{-0.0595678f,0.351221f,-0.934396f},{0.237285f,0.427549f,-0.872294f},{-0.0513544f,0.433495f,-0.899691f},
{0.196157f,0.604068f,-0.772415f},{-0.0685151f,0.496912f,-0.865092f},{0.0957247f,0.703616f,-0.704104f},
{-0.102755f,0.534448f,-0.838932f},{-0.029368f,0.73646f,-0.675844f},{-0.149571f,0.548531f,-0.822644f},
{-0.161603f,0.717349f,-0.677713f},{-0.207461f,0.537636f,-0.817256f},{-0.289597f,0.651122f,-0.701551f},
{-0.268886f,0.498353f,-0.824224f},{-0.396201f,0.544011f,-0.739646f},{-0.318635f,0.436497f,-0.841393f},
{-0.462795f,0.417077f,-0.782219f},{-0.345075f,0.369444f,-0.862806f},{-0.483462f,0.295309f,-0.824049f},
{-0.349167f,0.310605f,-0.884085f},{-0.462611f,0.187373f,-0.866535f},{-0.335206f,0.259552f,-0.905687f},
{-0.403961f,0.09049f,-0.910289f},{-0.301477f,0.215711f,-0.928752f},{-0.312545f,0.00928195f,-0.949857f},
{-0.250059f,0.189983f,-0.949409f},{-0.0226189f,-0.46135f,-0.88693f},{0.0777483f,-0.407964f,-0.909681f},
{0.347638f,-0.331404f,-0.877109f},{0.62028f,-0.0696447f,-0.781283f},{0.72716f,0.332372f,-0.600639f},
{0.61173f,0.662993f,-0.431541f},{0.39808f,0.845991f,-0.354728f},{0.160319f,0.923082f,-0.349597f},
{-0.0827604f,0.919205f,-0.384985f},{-0.317574f,0.832385f,-0.454183f},{-0.511501f,0.661363f,-0.548603f},
{-0.625966f,0.446074f,-0.639675f},{-0.659685f,0.242701f,-0.711275f},{-0.629047f,0.0628333f,-0.774824f},
{-0.530845f,-0.10926f,-0.840396f},{-0.36452f,-0.26444f,-0.892859f},{-0.259042f,-0.148767f,-0.954341f},
{-0.299861f,-0.161339f,-0.940241f},{0.0884017f,-0.762538f,-0.640876f},{0.235608f,-0.723775f,-0.648566f},
{0.585528f,-0.630369f,-0.509698f},{0.900905f,-0.335078f,-0.275848f},{0.993743f,0.110014f,-0.0192989f},
{0.855874f,0.50061f,0.129883f},{0.618627f,0.770592f,0.153259f},{0.325789f,0.939296f,0.107627f},
{-0.000229102f,0.999641f,0.0267794f},{-0.331651f,0.938181f,-0.0991201f},{-0.618913f,0.735647f,-0.275264f},
{-0.783293f,0.435371f,-0.443739f},{-0.821251f,0.141209f,-0.552817f},{-0.775996f,-0.117575f,-0.619682f},
{-0.637531f,-0.364574f,-0.678704f},{-0.389838f,-0.573292f,-0.720668f},{-0.234329f,-0.478618f,-0.846177f},
{-0.280672f,-0.500188f,-0.819167f},{0.125194f,-0.832552f,-0.539614f},{0.23729f,-0.832272f,-0.501016f},
{0.593865f,-0.730879f,-0.336363f},{0.891521f,-0.44951f,-0.0559528f},{0.973153f,-0.0412245f,0.226437f},
{0.872411f,0.319219f,0.370134f},{0.691726f,0.605878f,0.392973f},{0.431433f,0.831836f,0.349161f},
{0.103034f,0.957642f,0.268899f},{-0.252442f,0.957152f,0.141888f},{-0.595298f,0.801204f,-0.0607619f},
{-0.823888f,0.485971f,-0.291617f},{-0.882366f,0.135114f,-0.45075f},{-0.834461f,-0.168251f,-0.524753f},
{-0.697484f,-0.446475f,-0.560514f},{-0.441864f,-0.682478f,-0.58222f},{-0.213859f,-0.783387f,-0.583584f},
{-0.2332f,-0.79081f,-0.565895f},{-0.229669f,0.394981f,0.889518f},{-0.231123f,0.558736f,0.79649f},
{-0.296793f,0.48526f,0.822458f},{-0.27818f,0.361869f,0.889757f},{-0.375088f,0.387567f,0.842082f},
{-0.3186f,0.309805f,0.895832f},{-0.421505f,0.290791f,0.858938f},{-0.336716f,0.261486f,0.90457f},
{-0.438512f,0.215537f,0.872497f},{-0.337864f,0.234783f,0.911441f},{-0.432128f,0.162153f,0.887114f},
{-0.333658f,0.221571f,0.916285f},{-0.399382f,0.113997f,0.909669f},{-0.318071f,0.203324f,0.926008f},
{-0.329136f,0.0589227f,0.942442f},{-0.276121f,0.184141f,0.943318f},{-0.221544f,0.00826323f,0.975115f},
{-0.217713f,0.184842f,0.95835f},{-0.0944669f,-0.00852958f,0.995491f},{-0.168781f,0.207319f,0.963604f},
{0.0290205f,0.0408228f,0.998745f},{-0.137636f,0.239871f,0.960999f},{0.120965f,0.170167f,0.977962f},
{-0.119261f,0.280395f,0.952447f},{0.148983f,0.342616f,0.927587f},{-0.114791f,0.328866f,0.937374f},
{0.106802f,0.487704f,0.866452f},{-0.128197f,0.372061f,0.919313f},{0.0195776f,0.569159f,0.821994f},
{-0.154669f,0.397586f,0.904435f},{-0.0864364f,0.588895f,0.803574f},{-0.188131f,0.405089f,0.894712f},
{-0.213787f,0.826684f,0.520469f},{-0.33275f,0.699806f,0.632099f},{-0.486569f,0.510276f,0.709133f},
{-0.562541f,0.316054f,0.763975f},{-0.58474f,0.166721f,0.793903f},{-0.577003f,0.0581446f,0.81467f},
{-0.5284f,-0.0497126f,0.847539f},{-0.398676f,-0.186188f,0.897993f},{-0.17981f,-0.319832f,0.930256f},
{0.0771954f,-0.387706f,0.918545f},{0.338345f,-0.336226f,0.878906f},{0.573425f,-0.101638f,0.812929f},
{0.654623f,0.279956f,0.702206f},{0.53579f,0.60401f,0.590001f},{0.329575f,0.779685f,0.532421f},
{0.106662f,0.843401f,0.526591f},{-0.0582746f,0.705608f,0.706202f},{-0.0917435f,0.688008f,0.719881f},
{-0.18003f,0.977476f,0.110137f},{-0.357939f,0.891518f,0.277623f},{-0.615207f,0.644291f,0.454323f},
{-0.732591f,0.34145f,0.588832f},{-0.750623f,0.0927056f,0.654195f},{-0.728923f,-0.0996895f,0.677299f},
{-0.654723f,-0.300832f,0.693425f},{-0.44952f,-0.535469f,0.714986f},{-0.106872f,-0.711745f,0.69426f},
{0.252943f,-0.755576f,0.604256f},{0.582754f,-0.663256f,0.469562f},{0.876843f,-0.377081f,0.298256f},
{0.987578f,0.0908329f,0.128218f},{0.85011f,0.525354f,0.0362723f},{0.592618f,0.80484f,0.0321829f},
{0.293156f,0.953591f,0.0687309f},{0.0880785f,0.946859f,0.309353f},{0.0767341f,0.944294f,0.320033f},
{-0.156098f,0.986732f,-0.0446366f},{-0.281294f,0.959401f,0.0205867f},{-0.610051f,0.757103f,0.233735f},
{-0.794174f,0.419187f,0.439966f},{-0.826092f,0.100254f,0.554546f},{-0.792747f,-0.146156f,0.59177f},
{-0.710556f,-0.384711f,0.589158f},{-0.501651f,-0.653698f,0.566591f},{-0.133125f,-0.849606f,0.510341f},
{0.253964f,-0.875214f,0.411708f},{0.584528f,-0.765206f,0.269789f},{0.86544f,-0.496404f,0.0677977f},
{0.988373f,-0.0650512f,-0.13743f},{0.90281f,0.361254f,-0.2333f},{0.696363f,0.682041f,-0.223379f},
{0.410113f,0.895258f,-0.174126f},{0.189645f,0.972416f,-0.135803f},{0.191705f,0.971681f,-0.138152f},
{0.231123f,0.558736f,0.79649f},{0.229668f,0.394981f,0.889518f},{0.296793f,0.48526f,0.822458f},
{0.27818f,0.361869f,0.889757f},{0.375088f,0.387566f,0.842082f},{0.318601f,0.309804f,0.895832f},
{0.421505f,0.290791f,0.858938f},{0.336717f,0.261487f,0.90457f},{0.438512f,0.215537f,0.872497f},
{0.337864f,0.234783f,0.911441f},{0.432128f,0.162153f,0.887114f},{0.333659f,0.221571f,0.916285f},
{0.399382f,0.113997f,0.909669f},{0.318071f,0.203323f,0.926008f},{0.329136f,0.0589225f,0.942442f},
{0.27612f,0.184141f,0.943319f},{0.221544f,0.00826301f,0.975115f},{0.217714f,0.184842f,0.95835f},
{0.0944672f,-0.00852984f,0.995491f},{0.168781f,0.207319f,0.963604f},{-0.0290205f,0.0408228f,0.998745f},
{0.137636f,0.23987f,0.960999f},{-0.120965f,0.170168f,0.977962f},{0.119261f,0.280396f,0.952447f},
{-0.148983f,0.342615f,0.927587f},{0.114791f,0.328866f,0.937374f},{-0.106802f,0.487704f,0.866452f},
{0.128197f,0.372061f,0.919313f},{-0.0195775f,0.569159f,0.821994f},{0.154669f,0.397586f,0.904435f},
{0.0864366f,0.588895f,0.803574f},{0.188132f,0.405089f,0.894712f},{0.213787f,0.826684f,0.52047f},
{0.332749f,0.699806f,0.632099f},{0.486569f,0.510276f,0.709133f},{0.562541f,0.316053f,0.763975f},
{0.58474f,0.166722f,0.793903f},{0.577003f,0.0581448f,0.81467f},{0.5284f,-0.0497127f,0.847539f},
{0.398676f,-0.186189f,0.897993f},{0.17981f,-0.319832f,0.930256f},{-0.0771954f,-0.387706f,0.918545f},
{-0.338345f,-0.336226f,0.878906f},{-0.573425f,-0.101638f,0.812929f},{-0.654623f,0.279956f,0.702206f},
{-0.535791f,0.60401f,0.590001f},{-0.329575f,0.779685f,0.53242f},{-0.106662f,0.843401f,0.526591f},
{0.0582748f,0.705608f,0.706202f},{0.0917444f,0.688007f,0.719881f},{0.18003f,0.977476f,0.110137f},
{0.35794f,0.891518f,0.277623f},{0.615207f,0.644291f,0.454323f},{0.732591f,0.341449f,0.588832f},
{0.750623f,0.0927057f,0.654195f},{0.728923f,-0.0996895f,0.677299f},{0.654723f,-0.300832f,0.693425f},
{0.44952f,-0.535469f,0.714986f},{0.106872f,-0.711745f,0.69426f},{-0.252943f,-0.755576f,0.604256f},
{-0.582754f,-0.663256f,0.469562f},{-0.876843f,-0.377081f,0.298256f},{-0.987578f,0.0908331f,0.128219f},
{-0.85011f,0.525354f,0.0362722f},{-0.592618f,0.80484f,0.0321824f},{-0.293156f,0.953591f,0.0687308f},
{-0.0880785f,0.946859f,0.309353f},{-0.0767339f,0.944294f,0.320033f},{0.156098f,0.986732f,-0.0446371f},
{0.281294f,0.959401f,0.0205868f},{0.610051f,0.757103f,0.233736f},{0.794174f,0.419187f,0.439966f},
{0.826092f,0.100253f,0.554546f},{0.792747f,-0.146156f,0.591769f},{0.710556f,-0.384711f,0.589158f},
{0.501651f,-0.653698f,0.566591f},{0.133125f,-0.849606f,0.510341f},{-0.253964f,-0.875214f,0.411708f},
{-0.584528f,-0.765207f,0.269788f},{-0.86544f,-0.496404f,0.0677973f},{-0.988373f,-0.0650511f,-0.137429f},
{-0.90281f,0.361254f,-0.2333f},{-0.696363f,0.682041f,-0.223379f},{-0.410113f,0.895258f,-0.174126f},
{-0.189645f,0.972416f,-0.135803f},{-0.191705f,0.971681f,-0.138152f}
},

//lid 2
{
{0.187256f,0.116412f,-0.975389f},{0.129319f,-0.155775f,-0.979291f},{0.0579089f,-0.120735f,-0.990994f},
{0.137498f,0.140876f,-0.980433f},{-0.0738917f,-0.0492811f,-0.996048f},{0.0954745f,0.189637f,-0.977201f},
{-0.186073f,0.114379f,-0.975856f},{0.0656717f,0.26388f,-0.962317f},{-0.230893f,0.336505f,-0.912936f},
{0.0590603f,0.34927f,-0.935159f},{-0.185953f,0.52868f,-0.828202f},{0.0783567f,0.419768f,-0.904243f},
{-0.081558f,0.640475f,-0.763636f},{0.115249f,0.462736f,-0.878973f},{0.0452996f,0.67806f,-0.733609f},
{0.163262f,0.479446f,-0.862251f},{0.176397f,0.659123f,-0.731054f},{0.220148f,0.470118f,-0.854707f},
{0.301033f,0.59221f,-0.74744f},{0.279072f,0.432589f,-0.857313f},{0.403142f,0.486599f,-0.775047f},
{0.325609f,0.373537f,-0.86859f},{0.466056f,0.363663f,-0.806561f},{0.349637f,0.31003f,-0.884101f},
{0.484992f,0.244556f,-0.839628f},{0.352937f,0.25237f,-0.900969f},{0.462945f,0.13394f,-0.876209f},
{0.337758f,0.197705f,-0.920235f},{0.401344f,0.0292842f,-0.915459f},{0.300295f,0.147658f,-0.942348f},
{0.305224f,-0.0606399f,-0.950348f},{0.24473f,0.117415f,-0.962456f},{0.00340102f,-0.529962f,-0.848015f},
{-0.0938613f,-0.478074f,-0.87329f},{-0.352454f,-0.406562f,-0.842902f},{-0.61385f,-0.160057f,-0.773027f},
{-0.728006f,0.248101f,-0.639103f},{-0.613132f,0.611566f,-0.500057f},{-0.387794f,0.814176f,-0.432126f},
{-0.143534f,0.892502f,-0.427596f},{0.0984222f,0.883124f,-0.458699f},{0.328302f,0.790308f,-0.51733f},
{0.515789f,0.617037f,-0.594329f},{0.626024f,0.405388f,-0.666149f},{0.660135f,0.204925f,-0.722654f},
{0.630921f,0.0188943f,-0.775617f},{0.52944f,-0.167059f,-0.831736f},{0.354696f,-0.333342f,-0.873541f},
{0.243538f,-0.22025f,-0.944552f},{0.289875f,-0.232645f,-0.928358f},{-0.102856f,-0.809156f,-0.578522f},
{-0.250447f,-0.767445f,-0.590174f},{-0.588122f,-0.665757f,-0.459217f},{-0.891009f,-0.37675f,-0.253303f},
{-0.996878f,0.0697304f,-0.0370518f},{-0.868428f,0.488907f,0.0824813f},{-0.61914f,0.780765f,0.0840951f},
{-0.313284f,0.949395f,0.0224016f},{0.0164307f,0.997917f,-0.0623912f},{0.342913f,0.922407f,-0.177695f},
{0.620304f,0.711419f,-0.330312f},{0.779717f,0.412151f,-0.471353f},{0.821408f,0.11749f,-0.558109f},
{0.780344f,-0.153673f,-0.606174f},{0.638631f,-0.418378f,-0.645841f},{0.382109f,-0.635191f,-0.671212f},
{0.220792f,-0.550559f,-0.805069f},{0.263945f,-0.568498f,-0.779194f},{-0.135299f,-0.871634f,-0.471114f},
{-0.249238f,-0.864706f,-0.436078f},{-0.599387f,-0.748603f,-0.283423f},{-0.885957f,-0.462876f,-0.0287339f},
{-0.973386f,-0.055693f,0.222302f},{-0.882814f,0.320471f,0.343421f},{-0.69843f,0.628487f,0.342344f},
{-0.425676f,0.863021f,0.272019f},{-0.0871386f,0.980548f,0.175874f},{0.268067f,0.961922f,0.0533471f},
{0.599281f,0.790612f,-0.12568f},{0.819088f,0.473157f,-0.324372f},{0.881267f,0.120534f,-0.45699f},
{0.838241f,-0.197245f,-0.508376f},{0.698173f,-0.493499f,-0.518664f},{0.435853f,-0.735407f,-0.518853f},
{0.206757f,-0.833563f,-0.512273f},{0.22074f,-0.837852f,-0.499277f},{-0.129319f,-0.155775f,-0.979291f},
{-0.187257f,0.116412f,-0.975389f},{-0.0579092f,-0.120735f,-0.990994f},{-0.137498f,0.140876f,-0.980433f},
{0.0738916f,-0.0492814f,-0.996048f},{-0.0954751f,0.189636f,-0.977201f},{0.186073f,0.11438f,-0.975855f},
{-0.0656712f,0.263882f,-0.962317f},{0.230893f,0.336506f,-0.912936f},{-0.05906f,0.349268f,-0.93516f},
{0.185953f,0.528679f,-0.828203f},{-0.0783569f,0.419768f,-0.904243f},{0.0815577f,0.640475f,-0.763636f},
{-0.11525f,0.462736f,-0.878973f},{-0.0452998f,0.67806f,-0.733609f},{-0.163262f,0.479446f,-0.862251f},
{-0.176397f,0.659123f,-0.731054f},{-0.220148f,0.470118f,-0.854707f},{-0.301033f,0.592211f,-0.747439f},
{-0.279072f,0.432589f,-0.857313f},{-0.403142f,0.486599f,-0.775047f},{-0.32561f,0.373536f,-0.86859f},
{-0.466056f,0.363663f,-0.806561f},{-0.349637f,0.310031f,-0.884101f},{-0.484992f,0.244557f,-0.839628f},
{-0.352937f,0.25237f,-0.900969f},{-0.462945f,0.13394f,-0.876209f},{-0.337758f,0.197703f,-0.920235f},
{-0.401345f,0.0292838f,-0.915459f},{-0.300296f,0.147658f,-0.942348f},{-0.305224f,-0.0606397f,-0.950348f},
{-0.24473f,0.117415f,-0.962456f},{-0.00340093f,-0.529962f,-0.848015f},{0.0938612f,-0.478075f,-0.87329f},
{0.352454f,-0.406562f,-0.842902f},{0.61385f,-0.160057f,-0.773027f},{0.728006f,0.248101f,-0.639103f},
{0.613132f,0.611566f,-0.500057f},{0.387794f,0.814176f,-0.432126f},{0.143534f,0.892502f,-0.427596f},
{-0.0984221f,0.883124f,-0.458699f},{-0.328302f,0.790308f,-0.517331f},{-0.515789f,0.617037f,-0.594329f},
{-0.626024f,0.405389f,-0.666149f},{-0.660135f,0.204925f,-0.722653f},{-0.63092f,0.018894f,-0.775617f},
{-0.529439f,-0.167059f,-0.831736f},{-0.354696f,-0.333342f,-0.873541f},{-0.243538f,-0.22025f,-0.944552f},
{-0.289875f,-0.232645f,-0.928358f},{0.102856f,-0.809156f,-0.578522f},{0.250447f,-0.767445f,-0.590174f},
{0.588122f,-0.665757f,-0.459217f},{0.891009f,-0.37675f,-0.253303f},{0.996878f,0.0697302f,-0.0370519f},
{0.868427f,0.488908f,0.0824812f},{0.61914f,0.780765f,0.0840952f},{0.313285f,0.949395f,0.0224016f},
{-0.0164307f,0.997917f,-0.0623912f},{-0.342913f,0.922407f,-0.177696f},{-0.620304f,0.711419f,-0.330313f},
{-0.779717f,0.412152f,-0.471352f},{-0.821408f,0.11749f,-0.558108f},{-0.780344f,-0.153673f,-0.606175f},
{-0.638631f,-0.418378f,-0.645841f},{-0.38211f,-0.635191f,-0.671212f},{-0.220793f,-0.550559f,-0.805068f},
{-0.263945f,-0.568497f,-0.779194f},{0.135299f,-0.871634f,-0.471114f},{0.249238f,-0.864706f,-0.436078f},
{0.599387f,-0.748603f,-0.283424f},{0.885957f,-0.462876f,-0.0287343f},{0.973386f,-0.0556929f,0.222302f},
{0.882814f,0.32047f,0.343421f},{0.69843f,0.628487f,0.342344f},{0.425676f,0.863021f,0.272019f},
{0.0871387f,0.980548f,0.175874f},{-0.268067f,0.961922f,0.0533472f},{-0.599281f,0.790612f,-0.12568f},
{-0.819088f,0.473157f,-0.324372f},{-0.881267f,0.120534f,-0.45699f},{-0.838241f,-0.197244f,-0.508376f},
{-0.698173f,-0.4935f,-0.518664f},{-0.435853f,-0.735407f,-0.518853f},{-0.206757f,-0.833563f,-0.512274f},
{-0.220741f,-0.837852f,-0.499276f},{-0.25909f,0.275155f,0.925831f},{-0.260689f,0.411094f,0.873524f},
{-0.317162f,0.351731f,0.880735f},{-0.303933f,0.249266f,0.919506f},{-0.386375f,0.278498f,0.879291f},
{-0.337758f,0.208897f,0.917759f},{-0.432851f,0.205417f,0.877749f},{-0.352056f,0.172151f,0.920011f},
{-0.456366f,0.140033f,0.878704f},{-0.353222f,0.148434f,0.923689f},{-0.455199f,0.074466f,0.88727f},
{-0.346659f,0.125659f,0.929536f},{-0.417496f,-0.00714653f,0.908651f},{-0.320588f,0.0897104f,0.942961f},
{-0.327345f,-0.104932f,0.93906f},{-0.26398f,0.0534085f,0.963048f},{-0.192886f,-0.188203f,0.963003f},
{-0.19785f,0.0430034f,0.979288f},{-0.0492551f,-0.219339f,0.974405f},{-0.152308f,0.0574572f,0.986662f},
{0.0717795f,-0.1755f,0.981859f},{-0.129198f,0.08014f,0.988375f},{0.147879f,-0.0481031f,0.987835f},
{-0.116173f,0.112476f,0.98684f},{0.154069f,0.137754f,0.97841f},{-0.114789f,0.165197f,0.979558f},
{0.0873191f,0.307741f,0.947455f},{-0.135074f,0.224582f,0.965048f},{-0.0179641f,0.406632f,0.913415f},
{-0.172292f,0.265112f,0.9487f},{-0.128381f,0.433488f,0.891968f},{-0.214693f,0.280536f,0.935525f},
{-0.245676f,0.670307f,0.700237f},{-0.3474f,0.544072f,0.76374f},{-0.479751f,0.386625f,0.78763f},
{-0.557924f,0.231905f,0.796832f},{-0.598018f,0.101114f,0.795079f},{-0.607651f,-0.027379f,0.793732f},
{-0.558296f,-0.19439f,0.806547f},{-0.397246f,-0.396803f,0.827492f},{-0.137564f,-0.552716f,0.821937f},
{0.13254f,-0.603532f,0.786246f},{0.372904f,-0.543639f,0.751931f},{0.581714f,-0.336158f,0.74068f},
{0.668633f,0.0458593f,0.742177f},{0.534189f,0.433018f,0.726043f},{0.285923f,0.644991f,0.708685f},
{0.0453926f,0.700839f,0.711874f},{-0.108407f,0.543837f,0.832159f},{-0.14636f,0.521887f,0.840365f},
{-0.21819f,0.908956f,0.355236f},{-0.37833f,0.784453f,0.491427f},{-0.599202f,0.541926f,0.589299f},
{-0.711835f,0.275202f,0.646185f},{-0.754253f,0.0427209f,0.655192f},{-0.755977f,-0.18121f,0.629016f},
{-0.675388f,-0.448443f,0.585449f},{-0.432908f,-0.72345f,0.537783f},{-0.0651935f,-0.876173f,0.477568f},
{0.28624f,-0.870309f,0.400785f},{0.585434f,-0.749534f,0.308975f},{0.849956f,-0.483778f,0.208648f},
{0.988981f,-0.0370003f,0.143341f},{0.877374f,0.453848f,0.15568f},{0.581119f,0.781752f,0.226196f},
{0.246531f,0.919117f,0.307321f},{0.0350671f,0.839431f,0.542334f},{0.00382345f,0.823531f,0.567259f},
{-0.199301f,0.957252f,0.209638f},{-0.313378f,0.912873f,0.261643f},{-0.604842f,0.684644f,0.40673f},
{-0.768845f,0.368021f,0.522913f},{-0.820627f,0.0645513f,0.567806f},{-0.811706f,-0.213571f,0.543618f},
{-0.72293f,-0.512783f,0.463062f},{-0.476565f,-0.803756f,0.356177f},{-0.0965455f,-0.958156f,0.269474f},
{0.275182f,-0.938919f,0.206655f},{0.589036f,-0.798747f,0.122636f},{0.849483f,-0.527538f,-0.00910188f},
{0.984391f,-0.112052f,-0.135719f},{0.925676f,0.342887f,-0.159849f},{0.702208f,0.708021f,-0.0749055f},
{0.382441f,0.923041f,0.0416495f},{0.150729f,0.982769f,0.106983f},{0.147868f,0.982829f,0.110375f},
{0.260689f,0.411093f,0.873524f},{0.25909f,0.275155f,0.92583f},{0.317162f,0.351731f,0.880735f},
{0.303932f,0.249266f,0.919506f},{0.386375f,0.278498f,0.879291f},{0.337757f,0.208897f,0.917759f},
{0.432851f,0.205417f,0.877749f},{0.352056f,0.172151f,0.920011f},{0.456366f,0.140033f,0.878704f},
{0.353222f,0.148434f,0.923689f},{0.455199f,0.0744661f,0.88727f},{0.346659f,0.125659f,0.929536f},
{0.417496f,-0.00714663f,0.908651f},{0.320588f,0.0897105f,0.942961f},{0.327345f,-0.104932f,0.93906f},
{0.26398f,0.0534084f,0.963048f},{0.192886f,-0.188203f,0.963003f},{0.197851f,0.0430034f,0.979288f},
{0.0492551f,-0.219339f,0.974405f},{0.152308f,0.0574573f,0.986662f},{-0.0717796f,-0.1755f,0.981859f},
{0.129198f,0.0801399f,0.988375f},{-0.147879f,-0.048103f,0.987835f},{0.116173f,0.112476f,0.98684f},
{-0.154069f,0.137754f,0.97841f},{0.114789f,0.165197f,0.979558f},{-0.0873192f,0.307741f,0.947455f},
{0.135074f,0.224582f,0.965048f},{0.0179641f,0.406632f,0.913415f},{0.172292f,0.265112f,0.9487f},
{0.128382f,0.433487f,0.891968f},{0.214693f,0.280536f,0.935525f},{0.245676f,0.670307f,0.700237f},
{0.3474f,0.544072f,0.76374f},{0.479751f,0.386625f,0.78763f},{0.557924f,0.231905f,0.796832f},
{0.598018f,0.101113f,0.795079f},{0.607651f,-0.0273789f,0.793732f},{0.558296f,-0.19439f,0.806547f},
{0.397246f,-0.396803f,0.827492f},{0.137564f,-0.552716f,0.821937f},{-0.13254f,-0.603532f,0.786246f},
{-0.372904f,-0.543639f,0.751931f},{-0.581714f,-0.336158f,0.740679f},{-0.668633f,0.0458594f,0.742177f},
{-0.534188f,0.433018f,0.726043f},{-0.285924f,0.644991f,0.708685f},{-0.0453924f,0.700838f,0.711874f},
{0.108408f,0.543836f,0.83216f},{0.14636f,0.521887f,0.840365f},{0.21819f,0.908956f,0.355237f},
{0.37833f,0.784453f,0.491427f},{0.599202f,0.541926f,0.589299f},{0.711835f,0.275203f,0.646185f},
{0.754253f,0.0427209f,0.655192f},{0.755977f,-0.18121f,0.629017f},{0.675388f,-0.448443f,0.585449f},
{0.432908f,-0.72345f,0.537783f},{0.0651936f,-0.876173f,0.477568f},{-0.28624f,-0.870309f,0.400785f},
{-0.585434f,-0.749534f,0.308976f},{-0.849956f,-0.483778f,0.208648f},{-0.988981f,-0.0370008f,0.14334f},
{-0.877374f,0.453849f,0.15568f},{-0.581118f,0.781752f,0.226197f},{-0.246531f,0.919117f,0.307321f},
{-0.0350672f,0.839431f,0.542333f},{-0.0038228f,0.823531f,0.567259f},{0.199301f,0.957252f,0.209638f},
{0.313378f,0.912873f,0.261644f},{0.604842f,0.684644f,0.40673f},{0.768845f,0.368021f,0.522914f},
{0.820627f,0.0645516f,0.567806f},{0.811706f,-0.213571f,0.543618f},{0.722929f,-0.512783f,0.463062f},
{0.476565f,-0.803756f,0.356177f},{0.0965456f,-0.958156f,0.269474f},{-0.275182f,-0.938919f,0.206655f},
{-0.589036f,-0.798747f,0.122636f},{-0.849483f,-0.527538f,-0.00910149f},{-0.984391f,-0.112052f,-0.135719f},
{-0.925676f,0.342887f,-0.159849f},{-0.702208f,0.708021f,-0.0749052f},{-0.382441f,0.923041f,0.0416498f},
{-0.150728f,0.982769f,0.106983f},{-0.147869f,0.982829f,0.110375f}
},

//lid 1
{
{0.170033f,-0.0808841f,-0.982113f},{0.0991637f,-0.351643f,-0.930867f},{0.0327961f,-0.322779f,-0.945906f},
{0.127706f,-0.063447f,-0.989781f},{-0.086217f,-0.267487f,-0.959696f},{0.0961476f,-0.0272848f,-0.994993f},
{-0.181751f,-0.127272f,-0.975074f},{0.0739063f,0.0353914f,-0.996637f},{-0.215664f,0.0915415f,-0.972167f},
{0.0716391f,0.12319f,-0.989794f},{-0.16116f,0.311979f,-0.936321f},{0.0969912f,0.209661f,-0.972952f},
{-0.046894f,0.454896f,-0.889309f},{0.141817f,0.267782f,-0.952985f},{0.0844277f,0.508821f,-0.856722f},
{0.194301f,0.292492f,-0.93632f},{0.212463f,0.495016f,-0.842507f},{0.24922f,0.287968f,-0.924643f},
{0.328265f,0.43128f,-0.840381f},{0.300985f,0.256755f,-0.918415f},{0.419234f,0.333799f,-0.844287f},
{0.338886f,0.207317f,-0.917701f},{0.473826f,0.221963f,-0.852186f},{0.35754f,0.153168f,-0.921252f},
{0.489045f,0.106572f,-0.865724f},{0.359076f,0.0964688f,-0.928309f},{0.463733f,-0.0144368f,-0.885857f},
{0.339982f,0.0312277f,-0.939913f},{0.394368f,-0.138702f,-0.908425f},{0.293215f,-0.0338574f,-0.955447f},
{0.28677f,-0.245835f,-0.92592f},{0.228639f,-0.0745071f,-0.970656f},{-0.0325453f,-0.68793f,-0.725047f},
{-0.127355f,-0.639044f,-0.758554f},{-0.364076f,-0.573592f,-0.733786f},{-0.596709f,-0.366853f,-0.713692f},
{-0.722067f,0.0228584f,-0.691446f},{-0.613531f,0.44611f,-0.651587f},{-0.35934f,0.699754f,-0.61743f},
{-0.0981476f,0.785488f,-0.611045f},{0.139556f,0.766936f,-0.626366f},{0.355613f,0.66565f,-0.656087f},
{0.527228f,0.494736f,-0.690845f},{0.628305f,0.295939f,-0.719481f},{0.663179f,0.0997115f,-0.741789f},
{0.635683f,-0.105603f,-0.764693f},{0.52601f,-0.323037f,-0.78674f},{0.334451f,-0.507225f,-0.79427f},
{0.212833f,-0.406554f,-0.888491f},{0.263052f,-0.41547f,-0.87074f},{-0.128016f,-0.904378f,-0.407079f},
{-0.279766f,-0.859132f,-0.428513f},{-0.595541f,-0.737597f,-0.318249f},{-0.867722f,-0.465516f,-0.174224f},
{-0.997693f,-0.0361903f,-0.0574295f},{-0.89954f,0.435753f,-0.03076f},{-0.618557f,0.779961f,-0.0951219f},
{-0.277132f,0.94154f,-0.191575f},{0.0567628f,0.959392f,-0.276306f},{0.367868f,0.857611f,-0.359411f},
{0.623082f,0.636977f,-0.453903f},{0.771953f,0.34731f,-0.532415f},{0.820825f,0.0532505f,-0.568692f},
{0.786007f,-0.245625f,-0.567328f},{0.636046f,-0.542784f,-0.548481f},{0.366481f,-0.767941f,-0.525317f},
{0.19982f,-0.715118f,-0.669835f},{0.230048f,-0.72379f,-0.650543f},{-0.153901f,-0.944866f,-0.289037f},
{-0.27318f,-0.925861f,-0.261063f},{-0.612847f,-0.778574f,-0.135058f},{-0.871441f,-0.486954f,0.0588787f},
{-0.968914f,-0.0944346f,0.228664f},{-0.908279f,0.309565f,0.281424f},{-0.714681f,0.667427f,0.209219f},
{-0.406015f,0.911098f,0.0710771f},{-0.0481226f,0.997305f,-0.0553851f},{0.299353f,0.941114f,-0.15714f},
{0.604763f,0.747553f,-0.274638f},{0.80719f,0.435193f,-0.398812f},{0.877878f,0.0840118f,-0.471458f},
{0.843833f,-0.263295f,-0.46757f},{0.69423f,-0.590936f,-0.4109f},{0.421959f,-0.834474f,-0.354407f},
{0.195816f,-0.924426f,-0.327249f},{0.200539f,-0.924982f,-0.322788f},{-0.0991637f,-0.351643f,-0.930867f},
{-0.170033f,-0.080884f,-0.982113f},{-0.0327961f,-0.322779f,-0.945906f},{-0.127706f,-0.0634469f,-0.989781f},
{0.0862171f,-0.267487f,-0.959696f},{-0.0961476f,-0.0272849f,-0.994993f},{0.181751f,-0.127272f,-0.975074f},
{-0.0739063f,0.0353914f,-0.996637f},{0.215664f,0.0915414f,-0.972167f},{-0.0716392f,0.12319f,-0.989794f},
{0.16116f,0.311979f,-0.936321f},{-0.0969912f,0.209661f,-0.972952f},{0.0468939f,0.454896f,-0.889309f},
{-0.141817f,0.267782f,-0.952985f},{-0.0844277f,0.508821f,-0.856722f},{-0.194301f,0.292492f,-0.93632f},
{-0.212463f,0.495016f,-0.842507f},{-0.24922f,0.287968f,-0.924643f},{-0.328265f,0.43128f,-0.840381f},
{-0.300984f,0.256755f,-0.918415f},{-0.419234f,0.333799f,-0.844287f},{-0.338886f,0.207317f,-0.917701f},
{-0.473826f,0.221963f,-0.852186f},{-0.35754f,0.153168f,-0.921252f},{-0.489045f,0.106571f,-0.865724f},
{-0.359076f,0.0964685f,-0.928309f},{-0.463733f,-0.014437f,-0.885857f},{-0.339982f,0.0312277f,-0.939913f},
{-0.394368f,-0.138702f,-0.908425f},{-0.293215f,-0.0338572f,-0.955447f},{-0.28677f,-0.245835f,-0.92592f},
{-0.228639f,-0.0745069f,-0.970656f},{0.0325452f,-0.68793f,-0.725047f},{0.127355f,-0.639044f,-0.758554f},
{0.364076f,-0.573592f,-0.733786f},{0.596709f,-0.366853f,-0.713692f},{0.722066f,0.0228584f,-0.691446f},
{0.613531f,0.446109f,-0.651587f},{0.35934f,0.699754f,-0.61743f},{0.0981477f,0.785488f,-0.611045f},
{-0.139556f,0.766936f,-0.626366f},{-0.355613f,0.66565f,-0.656087f},{-0.527228f,0.494736f,-0.690845f},
{-0.628305f,0.295939f,-0.719481f},{-0.663179f,0.0997115f,-0.741789f},{-0.635683f,-0.105603f,-0.764693f},
{-0.52601f,-0.323037f,-0.78674f},{-0.334451f,-0.507225f,-0.79427f},{-0.212833f,-0.406554f,-0.888491f},
{-0.263052f,-0.41547f,-0.87074f},{0.128016f,-0.904378f,-0.407079f},{0.279766f,-0.859132f,-0.428513f},
{0.595541f,-0.737597f,-0.318249f},{0.867721f,-0.465516f,-0.174224f},{0.997693f,-0.0361901f,-0.0574301f},
{0.89954f,0.435753f,-0.0307605f},{0.618557f,0.779961f,-0.0951221f},{0.277132f,0.94154f,-0.191575f},
{-0.0567628f,0.959392f,-0.276306f},{-0.367868f,0.857611f,-0.359411f},{-0.623082f,0.636978f,-0.453903f},
{-0.771953f,0.34731f,-0.532415f},{-0.820825f,0.0532507f,-0.568692f},{-0.786007f,-0.245625f,-0.567328f},
{-0.636046f,-0.542784f,-0.548481f},{-0.366481f,-0.767941f,-0.525317f},{-0.199821f,-0.715118f,-0.669835f},
{-0.230048f,-0.723789f,-0.650544f},{0.153902f,-0.944866f,-0.289038f},{0.27318f,-0.925861f,-0.261063f},
{0.612847f,-0.778574f,-0.135058f},{0.871441f,-0.486954f,0.058879f},{0.968914f,-0.0944348f,0.228664f},
{0.908278f,0.309565f,0.281425f},{0.714681f,0.667427f,0.209219f},{0.406015f,0.911098f,0.0710772f},
{0.0481226f,0.997305f,-0.0553851f},{-0.299353f,0.941114f,-0.157141f},{-0.604763f,0.747553f,-0.274638f},
{-0.80719f,0.435193f,-0.398812f},{-0.877878f,0.084012f,-0.471458f},{-0.843833f,-0.263295f,-0.46757f},
{-0.69423f,-0.590936f,-0.410901f},{-0.421959f,-0.834474f,-0.354407f},{-0.195816f,-0.924426f,-0.327249f},
{-0.200539f,-0.924982f,-0.322788f},{-0.274592f,0.174388f,0.945615f},{-0.279076f,0.301266f,0.911787f},
{-0.329298f,0.2523f,0.909894f},{-0.314928f,0.1548f,0.936406f},{-0.393562f,0.19355f,0.898692f},
{-0.344531f,0.121609f,0.930865f},{-0.440573f,0.129756f,0.88829f},{-0.358316f,0.0865385f,0.929581f},
{-0.468003f,0.0598531f,0.881698f},{-0.359773f,0.0538913f,0.931482f},{-0.468217f,-0.0283813f,0.883158f},
{-0.348396f,0.0130349f,0.937257f},{-0.422712f,-0.146026f,0.894422f},{-0.311357f,-0.0425276f,0.949341f},
{-0.314744f,-0.27671f,0.907947f},{-0.244768f,-0.0926729f,0.965143f},{-0.162371f,-0.373759f,0.913203f},
{-0.175774f,-0.11056f,0.978202f},{-0.0114407f,-0.403112f,0.915079f},{-0.132327f,-0.100493f,0.986099f},
{0.105896f,-0.3578f,0.927774f},{-0.111692f,-0.0809213f,0.990443f},{0.173376f,-0.234368f,0.956563f},
{-0.0998722f,-0.0481502f,0.993835f},{0.168055f,-0.0433064f,0.984826f},{-0.101326f,0.0145724f,0.994747f},
{0.0843648f,0.148394f,0.985323f},{-0.130019f,0.0931257f,0.987129f},{-0.0359753f,0.269135f,0.96243f},
{-0.178792f,0.15071f,0.972276f},{-0.151761f,0.310221f,0.938473f},{-0.229283f,0.174998f,0.957499f},
{-0.2678f,0.5358f,0.800751f},{-0.35637f,0.423467f,0.832872f},{-0.476561f,0.294623f,0.828304f},
{-0.558104f,0.164185f,0.813365f},{-0.609262f,0.0354151f,0.792178f},{-0.62625f,-0.121961f,0.770023f},
{-0.567602f,-0.338786f,0.750368f},{-0.380861f,-0.573083f,0.725617f},{-0.102764f,-0.720569f,0.685726f},
{0.167181f,-0.746836f,0.643651f},{0.393748f,-0.676346f,0.62251f},{0.583979f,-0.49102f,0.646427f},
{0.672544f,-0.139115f,0.726865f},{0.53245f,0.270395f,0.802112f},{0.252808f,0.510165f,0.822083f},
{-0.000430566f,0.567174f,0.823598f},{-0.144443f,0.416356f,0.897655f},{-0.17502f,0.398991f,0.900097f},
{-0.244077f,0.810462f,0.532521f},{-0.388554f,0.67049f,0.632036f},{-0.585245f,0.450842f,0.673966f},
{-0.698492f,0.217713f,0.681697f},{-0.757717f,-0.00531936f,0.652561f},{-0.770035f,-0.256798f,0.584039f},
{-0.673661f,-0.561197f,0.480873f},{-0.405964f,-0.834516f,0.372525f},{-0.037435f,-0.955912f,0.291259f},
{0.30449f,-0.923199f,0.234498f},{0.590489f,-0.787303f,0.177417f},{0.834721f,-0.536296f,0.125006f},
{0.983082f,-0.12496f,0.133923f},{0.894006f,0.377014f,0.242101f},{0.565197f,0.73007f,0.384122f},
{0.199286f,0.847592f,0.491806f},{-0.012911f,0.718485f,0.695423f},{-0.0557474f,0.689361f,0.722269f},
{-0.227453f,0.884551f,0.407227f},{-0.333236f,0.830407f,0.446518f},{-0.595902f,0.602506f,0.530931f},
{-0.750001f,0.315665f,0.581252f},{-0.817264f,0.0288773f,0.575539f},{-0.822818f,-0.269884f,0.500134f},
{-0.71988f,-0.598072f,0.352255f},{-0.447652f,-0.874512f,0.186644f},{-0.0739497f,-0.993583f,0.0855858f},
{0.287303f,-0.956873f,0.0430333f},{0.596468f,-0.802625f,-0.0044153f},{0.842439f,-0.531975f,-0.0854336f},
{0.979279f,-0.138682f,-0.147577f},{0.942167f,0.319173f,-0.102225f},{0.704603f,0.707437f,0.0553817f},
{0.351449f,0.908373f,0.226586f},{0.114208f,0.945229f,0.305776f},{0.0986314f,0.941089f,0.323454f},
{0.279076f,0.301266f,0.911787f},{0.274592f,0.174388f,0.945615f},{0.329298f,0.2523f,0.909894f},
{0.314929f,0.1548f,0.936406f},{0.393563f,0.19355f,0.898692f},{0.344531f,0.121608f,0.930865f},
{0.440574f,0.129756f,0.88829f},{0.358316f,0.0865388f,0.929581f},{0.468003f,0.0598537f,0.881698f},
{0.359773f,0.0538922f,0.931482f},{0.468217f,-0.0283817f,0.883158f},{0.348396f,0.0130332f,0.937257f},
{0.422711f,-0.146026f,0.894422f},{0.311357f,-0.0425282f,0.949341f},{0.314744f,-0.27671f,0.907947f},
{0.244769f,-0.0926728f,0.965142f},{0.162371f,-0.373759f,0.913203f},{0.175773f,-0.11056f,0.978203f},
{0.0114408f,-0.403112f,0.915079f},{0.132328f,-0.100494f,0.986099f},{-0.105896f,-0.3578f,0.927774f},
{0.111692f,-0.0809209f,0.990443f},{-0.173376f,-0.234368f,0.956563f},{0.0998722f,-0.0481507f,0.993835f},
{-0.168055f,-0.0433065f,0.984826f},{0.101326f,0.0145723f,0.994747f},{-0.0843647f,0.148394f,0.985323f},
{0.130019f,0.0931262f,0.987128f},{0.0359753f,0.269135f,0.96243f},{0.178792f,0.150709f,0.972276f},
{0.151761f,0.310221f,0.938473f},{0.229284f,0.174998f,0.957499f},{0.2678f,0.5358f,0.800751f},
{0.35637f,0.423467f,0.832872f},{0.476561f,0.294623f,0.828304f},{0.558104f,0.164184f,0.813365f},
{0.609262f,0.0354153f,0.792177f},{0.626251f,-0.121961f,0.770023f},{0.567602f,-0.338786f,0.750368f},
{0.380861f,-0.573083f,0.725617f},{0.102764f,-0.720569f,0.685726f},{-0.167181f,-0.746836f,0.643651f},
{-0.393747f,-0.676347f,0.622509f},{-0.583979f,-0.49102f,0.646427f},{-0.672543f,-0.139115f,0.726865f},
{-0.53245f,0.270395f,0.802112f},{-0.252808f,0.510165f,0.822083f},{0.000430498f,0.567174f,0.823598f},
{0.144443f,0.416356f,0.897655f},{0.17502f,0.398991f,0.900097f},{0.244077f,0.810462f,0.532521f},
{0.388554f,0.67049f,0.632036f},{0.585245f,0.450842f,0.673966f},{0.698492f,0.217713f,0.681697f},
{0.757717f,-0.00531963f,0.652562f},{0.770035f,-0.256798f,0.584039f},{0.673661f,-0.561197f,0.480873f},
{0.405965f,-0.834516f,0.372525f},{0.0374351f,-0.955912f,0.291259f},{-0.30449f,-0.923199f,0.234498f},
{-0.590489f,-0.787303f,0.177417f},{-0.834721f,-0.536297f,0.125006f},{-0.983082f,-0.12496f,0.133923f},
{-0.894006f,0.377014f,0.242101f},{-0.565197f,0.73007f,0.384122f},{-0.199286f,0.847592f,0.491806f},
{0.012911f,0.718485f,0.695423f},{0.0557474f,0.689362f,0.722269f},{0.227453f,0.884551f,0.407227f},
{0.333236f,0.830407f,0.446518f},{0.595902f,0.602506f,0.53093f},{0.750001f,0.315666f,0.581252f},
{0.817264f,0.0288774f,0.575539f},{0.822817f,-0.269884f,0.500134f},{0.71988f,-0.598072f,0.352255f},
{0.447652f,-0.874512f,0.186644f},{0.0739498f,-0.993583f,0.0855857f},{-0.287303f,-0.956873f,0.0430335f},
{-0.596468f,-0.802625f,-0.00441504f},{-0.842439f,-0.531975f,-0.0854334f},{-0.979279f,-0.138682f,-0.147577f},
{-0.942167f,0.319173f,-0.102225f},{-0.704604f,0.707437f,0.0553818f},{-0.351449f,0.908373f,0.226586f},
{-0.114207f,0.945229f,0.305777f},{-0.0986314f,0.941089f,0.323454f}
}

};

static GLfloat textures [84][2] = {
//lid 1
{0.0f,1.0f},{0.0f,0.875f},{0.0625f,0.875f},
{0.0625f,1.0f},{0.125f,0.875f},{0.125f,1.0f},
{0.1875f,0.875f},{0.1875f,1.0f},{0.25f,0.875f},
{0.25f,1.0f},{0.3125f,0.875f},{0.3125f,1.0f},
{0.375f,0.875f},{0.375f,1.0f},{0.4375f,0.875f},
{0.4375f,1.0f},{0.5f,0.875f},{0.5f,1.0f},
{0.5625f,0.875f},{0.5625f,1.0f},{0.625f,0.875f},
{0.625f,1.0f},{0.6875f,0.875f},{0.6875f,1.0f},
{0.75f,0.875f},{0.75f,1.0f},{0.8125f,0.875f},
{0.8125f,1.0f},{0.875f,0.875f},{0.875f,1.0f},
{0.9375f,0.875f},{0.9375f,1.0f},{1.0f,0.875f},
{0.0f,0.75f},{0.0625f,0.75f},{0.125f,0.75f},
{0.1875f,0.75f},{0.25f,0.75f},{0.3125f,0.75f},
{0.375f,0.75f},{0.4375f,0.75f},{0.5f,0.75f},
{0.5625f,0.75f},{0.625f,0.75f},{0.6875f,0.75f},
{0.75f,0.75f},{0.8125f,0.75f},{0.875f,0.75f},
{0.9375f,0.75f},{1.0f,0.75f},{0.0f,0.625f},
{0.0625f,0.625f},{0.125f,0.625f},{0.1875f,0.625f},
{0.25f,0.625f},{0.3125f,0.625f},{0.375f,0.625f},
{0.4375f,0.625f},{0.5f,0.625f},{0.5625f,0.625f},
{0.625f,0.625f},{0.6875f,0.625f},{0.75f,0.625f},
{0.8125f,0.625f},{0.875f,0.625f},{0.9375f,0.625f},
{1.0f,0.625f},{0.0f,0.5f},{0.0625f,0.5f},
{0.125f,0.5f},{0.1875f,0.5f},{0.25f,0.5f},
{0.3125f,0.5f},{0.375f,0.5f},{0.4375f,0.5f},
{0.5f,0.5f},{0.5625f,0.5f},{0.625f,0.5f},
{0.6875f,0.5f},{0.75f,0.5f},{0.8125f,0.5f},
{0.875f,0.5f},{0.9375f,0.5f},{1.0f,0.5f}
};

static int material_ref [1][2] = {
{0,448}
};

static void MyMaterial(GLenum mode,GLfloat *f,GLfloat alpha)
{
 GLfloat d[4];
 d[0]=f[0];
 d[1]=f[1];
 d[2]=f[2];
 d[3]=alpha;
 glMaterialfv (GL_FRONT_AND_BACK,mode,d);
};


static void SelectMaterial(int i)
{
  //
  // Define the reflective properties of the 3D Object faces.
  //
  glEnd();
  GLfloat alpha=materials[i].alpha;
  MyMaterial (GL_AMBIENT, materials[i].ambient,alpha);
  MyMaterial (GL_DIFFUSE, materials[i].diffuse,alpha);
  MyMaterial (GL_SPECULAR, materials[i].specular,alpha);
  MyMaterial (GL_EMISSION, materials[i].emission,alpha);
  glMaterialf (GL_FRONT_AND_BACK,GL_SHININESS,materials[i].phExp);
  glBegin(GL_TRIANGLES);

};

static GLint Gen3DObjectList(int numlid)
{
 int i;
 int j;

 GLint lid=glGenLists(1);
	int mcount=0;
	int mindex=0;
   glNewList(lid, GL_COMPILE);

    glBegin (GL_TRIANGLES);
      for(i=0;i<sizeof(face_indicies[numlid])/sizeof(face_indicies[numlid][0]);i++)
       {
      if(!mcount)
       {
        SelectMaterial(material_ref[mindex][0]);
        mcount=material_ref[mindex][1];
        mindex++;
       }
       mcount--;
       for(j=0;j<3;j++)
        {
          int vi=face_indicies[numlid][i][j];
          int ni=face_indicies[numlid][i][j+3];//Normal index
          int ti=face_indicies[numlid][i][j+6];//Texture index
           glNormal3f (normals[numlid][ni][0],normals[numlid][ni][1],normals[numlid][ni][2]);
           glTexCoord2f(textures[ti][0],textures[ti][1]);
           glVertex3f (vertices[numlid][vi][0],vertices[numlid][vi][1],vertices[numlid][vi][2]);
        }
       }
    glEnd ();

   glEndList();
   return lid;
};

void initLids(){
	GLint test;
	int i;
	for(i=0;i<NUM_LIDS;i++){
		lidLists[i]=Gen3DObjectList(i);
	}
};

void drawLids(int num) {
	glCallList(lidLists[num]);
}
