/* USE_HILDON is (or is not) defined here */
#include <config.h>

#ifdef USE_HILDON

#include <gdk/gdkkeysyms.h>
#include "hildon-hacks.h"
#include "gtkblist.h"
#include "gtkutils.h"

/*
 * The following is a hack. It attempts to convince a dialog to become as large
 * as possible so as to display as many of the widgets inside a GtkScrolledWindow
 * as possible (hopefully without causing scrollbars to appear). It works like this:
 *
 * 1. When wrapping a container with _pidgin_make_container_scrollable(), ask for the
 *    toplevel widget that will contain it, and, if given, hook up to its "show"
 *    signal. If not, simply wrap into a GtkScrolledWindow and mark the scrolled
 *    window as "special".
 *    If the widget to be wrapped already contains a marked scrolled window, then
 *    don't wrap the requested widget anymore. Instead, if you have a toplevel, use it
 *    in conjunction with the existing scrolled window.
 * 2. Until the dialog shows up, use the scrolled window's size-request message to 
 *    request enough room for all the widgets plus the scrollbars.
 * 3. When the dialog shows up, unhook the scrolled window's size-request handler,
 *    because it is assumed that we know the maximum size we'll want. Unfortunately,
 *    this also means that on subsequent size-request events, the scrolled window will
 *    ask for very little, possibly causing the dialog to shrink. Thus, at "show", we
 *    attach a size-request handler to the dialog, forcing it to ask for the amount of
 *    space its allocation had during the "show" event.
 *
 * This likely only works on Maemo, because the dialogs there seem to be constrained to
 * displaying themselves entirely on the screen. Without such a constraint, there is
 * nothing to prevent a dialog from granting whatever size request is made here, rendering
 * the GtkScrolledWindow useless.
 */

static void
force_max_size_request(GtkWidget *dialog, GtkRequisition *rq, GtkRequisition *rq_from_now_on)
{
	rq->width = MAX(rq->width, rq_from_now_on->width);
	rq->height = MAX(rq->height, rq_from_now_on->height);
}

static void
dialog_plus_sw_show (GtkWidget *dialog, GtkWidget *scrolled_window)
{
	GtkRequisition *rq_from_now_on = NULL;
	guint size_request_handler_id = 0;

	g_object_set_data(G_OBJECT(scrolled_window), "rq-wanted", NULL);
	if ((size_request_handler_id = (guint)g_object_get_data(G_OBJECT(scrolled_window), "size-request-handler-id")) != 0) {
		g_signal_handler_disconnect(G_OBJECT(scrolled_window), size_request_handler_id);
		g_object_set_data(G_OBJECT(scrolled_window), "size-request-handler-id", (gpointer)0);
	}
	if ((rq_from_now_on = g_malloc0(sizeof(GtkRequisition))) != NULL) {
		rq_from_now_on->width = dialog->allocation.width;
		rq_from_now_on->height = dialog->allocation.height;
		g_object_set_data_full(G_OBJECT(dialog), "rq-wanted", rq_from_now_on, (GDestroyNotify)g_free);
		g_signal_connect(G_OBJECT(dialog), "size-request", (GCallback)force_max_size_request, rq_from_now_on);
	}
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
}

typedef struct
{
	GtkWidget *hscrollbar;
	GtkWidget *vscrollbar;
} HAndVScrollbars ;

static void
dialog_plus_sw_find_scrollbars (GtkWidget *widget, HAndVScrollbars *scrollbars)
{
	if (GTK_IS_HSCROLLBAR(widget)) scrollbars->hscrollbar = widget;
	else if (GTK_IS_VSCROLLBAR(widget)) scrollbars->vscrollbar = widget;
}

/*
 * During the first size-request, save the calculated request to the data item set by the
 * top-level function. Then, use the same size request on subsequent calls.
 */
static void
dialog_plus_sw_size_request(GtkWidget *sw, GtkRequisition *rq, gpointer data)
{
	GtkRequisition *rq_wanted = g_object_get_data(G_OBJECT(sw), "rq-wanted");
	GtkRequisition rq_hs = {0, 0}, rq_vs = {0, 0};
	guint scrollbar_spacing = 0;
	HAndVScrollbars scrollbars = {NULL, NULL};

	if (NULL == rq_wanted || (0 == rq_wanted->width && 0 == rq_wanted->height)) {
		gtk_container_forall(GTK_CONTAINER (sw), (GtkCallback)dialog_plus_sw_find_scrollbars, &scrollbars);
		if (NULL != scrollbars.hscrollbar)
			gtk_widget_size_request(scrollbars.hscrollbar, &rq_hs);
		if (NULL != scrollbars.vscrollbar)
			gtk_widget_size_request(scrollbars.vscrollbar, &rq_vs);
		gtk_widget_style_get(sw, "scrollbar-spacing", &scrollbar_spacing, NULL);

		rq->width  += scrollbar_spacing + rq_vs.width;
		rq->height += scrollbar_spacing + rq_hs.height;

		if (NULL != rq_wanted)
			*rq_wanted = *rq;
	}

	if (NULL != rq_wanted)
		*rq = *rq_wanted;
}

static void
get_pidgin_scrollable_widget(GtkWidget *widget, GtkWidget **scrollable_widget)
{
	if (*scrollable_widget) return;

	if ((gboolean)g_object_get_data(G_OBJECT(widget), "pidgin-scrollable-flag")) {
		(*scrollable_widget) = widget;
		return;
	}

	if (GTK_IS_CONTAINER(widget))
		gtk_container_foreach(GTK_CONTAINER(widget), (GtkCallback)get_pidgin_scrollable_widget, scrollable_widget);
}

GtkWidget *
_pidgin_make_container_scrollable(GtkWidget *container, GtkWidget *toplevel)
{
	GtkPolicyType policy = (toplevel ? GTK_POLICY_NEVER : GTK_POLICY_AUTOMATIC);
	GtkWidget *sw = NULL;
	GtkWidget *scrollable_widget = NULL;
	GtkWidget *ret = container;

	get_pidgin_scrollable_widget(container, &scrollable_widget);

	if (!scrollable_widget) {
		ret =
		sw = gtk_scrolled_window_new(NULL, NULL);
		g_object_set_data(G_OBJECT(sw), "pidgin-scrollable-flag", (gpointer)TRUE);
		gtk_widget_show(sw);
		gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(sw), GTK_SHADOW_NONE);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw), policy, policy);
		gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(sw), container);
	} else {
		sw = scrollable_widget;
		if (toplevel) {
			gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw), GTK_POLICY_NEVER, GTK_POLICY_NEVER);
		}
	}

	gtk_widget_show(container);

	if (toplevel) {
  	/* Create a place where the size-request handler might store its intended requisition */
		g_object_set_data_full(G_OBJECT(sw), "rq-wanted", g_malloc0 (sizeof (GtkRequisition)), (GDestroyNotify)g_free);
		g_object_set_data(G_OBJECT(sw), "size-request-handler-id",
			(gpointer)g_signal_connect(G_OBJECT(sw), "size-request", (GCallback)dialog_plus_sw_size_request, NULL));
		g_signal_connect(G_OBJECT(toplevel), "show", (GCallback)dialog_plus_sw_show, sw);
	}

	return ret;
}

static gboolean
fullscreen_window_key_pressed_cb(GtkWindow *window, GdkEventKey *event, gpointer null)
{
	/* Hardware fullscreen button */
	if (GDK_F6 != event->keyval) return FALSE;
	if (NULL == (GTK_WIDGET(window)->window)) return FALSE;

	if (gdk_window_get_state(GTK_WIDGET(window)->window) & GDK_WINDOW_STATE_FULLSCREEN)
		gtk_window_unfullscreen(window);
	else
		gtk_window_fullscreen(window);
	return TRUE ;
}

void
_pidgin_window_set_allow_fullscreen(GtkWidget *window, gboolean can_fullscreen)
{
	g_signal_handlers_disconnect_by_func(G_OBJECT(window), fullscreen_window_key_pressed_cb, NULL);

	if (can_fullscreen) {
		gtk_widget_add_events(GTK_WIDGET(window), GDK_KEY_PRESS_MASK);
		g_signal_connect(G_OBJECT(window), "key-press-event", (GCallback)fullscreen_window_key_pressed_cb, NULL);
	}
}

static void (*orig_gtk_window_show)(GtkWidget *widget) = NULL;

static void
my_gtk_window_show(GtkWidget *widget)
{
	if (orig_gtk_window_show)
		orig_gtk_window_show(widget);

	if (!widget)
		return;

	if (GTK_IS_WINDOW(widget)) {
		PidginBuddyList *blist = NULL;
		GtkWindow *wnd = GTK_WINDOW(widget);

		if (gtk_window_get_type_hint(wnd) == GDK_WINDOW_TYPE_HINT_DIALOG)
			if (gtk_window_get_transient_for(wnd) == NULL)
				if (!pidgin_auto_parent_window(widget))
					if ((blist = pidgin_blist_get_default_gtk_blist()) != NULL)
						if (blist->window)
							gtk_window_set_transient_for(wnd, GTK_WINDOW(blist->window));
	}
}

void _hildon_hacks_init(void)
{
	GtkWidgetClass *gtk_widget_class = NULL;

	g_type_class_ref(GTK_TYPE_WINDOW);
	if ((gtk_widget_class = g_type_class_peek(GTK_TYPE_WINDOW)) != NULL) {
		orig_gtk_window_show = gtk_widget_class->show;
		gtk_widget_class->show = my_gtk_window_show;
	}
}

void _hildon_hacks_uninit(void)
{
	GtkWidgetClass *gtk_widget_class = NULL;

	if ((gtk_widget_class = g_type_class_peek(GTK_TYPE_WINDOW)) != NULL) {
		gtk_widget_class->show = orig_gtk_window_show;
		g_type_class_unref(gtk_widget_class);
	}
}
#endif /* USE_HILDON */
