/*
 * GStreamer
 * Copyright 2007 Danilo Freire <danilo@embedded.ufcg.edu.br>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include "gstradiobin.h"

/*******************************************************************************/
#define _(String) gettext(String)
#define	FREQUENCY_MIN	87500
#define	FREQUENCY_MAX	108000
#define	FREQUENCY_STEP	5
#define FORMAT		"%06.2f"
#define FREQ_FRAC	16     /* For Nokia 800 only */
#define STATION_NAME_MAX_LENGTH	15
#define STATION_FREQ_MAX_LENGTH	6
#define SAMPLEDELAY     15000
#define THRESHOLD 65535.0   /* maximum acceptable signal %    */
#define ACCEPTLEVEL 0.5
/*******************************************************************************/

#ifndef __RADIO_CALLS_H__
#define __RADIO_CALLS_H__

gint   gst_radio_open(GstRadioBin *radiobin);

void   gst_radio_close(GstRadioBin *radiobin);

gint   gst_radio_setfreq(GstRadioBin *radiobin, guint freq);

guint gst_radio_getfreq(GstRadioBin *radiobin);

void   gst_radio_mute(GstRadioBin *radiobin);

void   gst_radio_unmute(GstRadioBin *radiobin);

void   gst_radio_setvolume(GstRadioBin *radiobin, guint vol);

guint  gst_radio_getvolume(GstRadioBin *radiobin);

void   gst_radio_get_capabilities(void);

gint   gst_radio_get_signal_strength(GstRadioBin *radiobin);

void   gst_radio_set_mixer(char* soundmixer);

#endif /*__RADIO_CALLS_H__*/
