/*
    CSV (Comma Separated Values) file handler for Qt
    Copyright (C) 2010 Heikki Holstila

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _CSVFILE_H_
#define _CSVFILE_H_

#include <QtCore>

class CCSVFile
{
	public:
	CCSVFile(QString fileName_, bool load_=false);
	~CCSVFile();
	
	// 
	// row and column numbering start from 0 in the memory structure
	// 
	
	// loads a disk file to the memory structure
	bool load();
	
	// saves the memory structure to a disk file
	bool save() const;
	
	// sets/changes the file name
	void setFileName(QString fileName_);
	
	// clears the memory structure	
	void clear();
	
	// appends a new row to the end of the memory structure
	void appendRow(QStringList row_);
	
	// returns the specified row of the memory structure or null if nonexistent
	QStringList* rowAt(int row_);
	
	// returns the specified cell of the memory structure or null if nonexistent
	QString* cellAt(int row_, int col_);
	
	// returns the data at the specified cell or an empty string if nonexistent
	QString dataAt(int row_, int col_) const;

	// sets the data at the specified cell to 'contents', if the table is smaller
	// than requested then the missing rows/cols are created as empty
	void setDataAt(int row_, int col_, QString cellData_);
	
	// is the memory structure empty?
	bool isEmpty() const;
	
	// the number of rows (height) currently in the memory structure
	int rows() const;
	
	// the number of columns (width) currently in the memory structure
	int columns() const;
	
	private:
	QString fileName;
	QList<QStringList> data;
};

#endif
