/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.midp.examples.simpledemo;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import org.microemu.midp.examples.simpledemo.BaseExamplesForm;
import org.microemu.midp.examples.simpledemo.SimpleDemoMIDlet;

public class HTTPPanel
extends BaseExamplesForm {
    static final Command goCommand = new Command("Go", 4, 1);
    static String demoLocation;
    TextField url;
    StringItem message;
    StringItem status;
    Thread requestThread = null;

    public HTTPPanel() {
        super("HTTP Connection");
        String host = SimpleDemoMIDlet.instance.getAppProperty("microemu.accessible.host");
        demoLocation = host == null ? "http://www.microemu.org/test/" : "http://" + host + "/test/";
        this.url = new TextField("URL:", demoLocation, 128, 4);
        this.append((Item)this.url);
        this.message = new StringItem("Message:", null);
        this.append((Item)this.message);
        this.status = new StringItem("Status:", null);
        this.append((Item)this.status);
        this.addCommand(goCommand);
    }

    private void makeConnection() {
        if (this.requestThread == null) {
            this.requestThread = new Thread(new ConnectionRun());
            this.requestThread.start();
        } else {
            this.message.setText("Request still running");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryConnect() {
        Connection c = null;
        InputStream is = null;
        try {
            this.status.setText("Connecting...");
            c = Connector.open((String)this.url.getString(), (int)1, (boolean)true);
            HttpConnection hcon = (HttpConnection)c;
            this.status.setText("http:" + String.valueOf(hcon.getResponseCode()) + " len:" + String.valueOf(hcon.getLength()));
            int length = (int)hcon.getLength();
            byte[] data = null;
            if (length != -1) {
                data = new byte[length];
                is = new DataInputStream(hcon.openInputStream());
                ((DataInputStream)is).readFully(data);
            } else {
                int onebyte;
                int chunkSize = 512;
                is = hcon.openInputStream();
                byte[] readData = new byte[chunkSize];
                int index = 0;
                while ((onebyte = is.read()) != -1) {
                    readData[index] = (byte)onebyte;
                    if (readData.length <= ++index) {
                        byte[] newData = new byte[index + chunkSize];
                        System.arraycopy(readData, 0, newData, 0, readData.length);
                        readData = newData;
                    }
                    if (index < 1000) continue;
                }
                data = new byte[index];
                System.arraycopy(readData, 0, data, 0, index);
            }
            this.message.setText(new String(data));
        }
        catch (Throwable e) {
            System.out.println(e.toString());
            e.printStackTrace();
            this.status.setText(e.toString());
            this.message.setText("");
            Alert alert = new Alert("Error", e.getMessage() + " " + e.toString(), null, AlertType.ERROR);
            alert.setTimeout(-2);
            SimpleDemoMIDlet.setCurrentDisplayable((Displayable)alert);
        }
        finally {
            this.requestThread = null;
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (c != null) {
                try {
                    c.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == goCommand) {
            this.makeConnection();
        }
        super.commandAction(c, d);
    }

    class ConnectionRun
    implements Runnable {
        ConnectionRun() {
        }

        public void run() {
            HTTPPanel.this.tryConnect();
        }
    }
}

