/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Hashtable;
import org.microemu.device.DeviceFactory;

public final class Font {
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    public static final int SIZE_SMALL = 8;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_LARGE = 16;
    public static final int FACE_SYSTEM = 0;
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;
    public static final int FONT_STATIC_TEXT = 0;
    public static final int FONT_INPUT_TEXT = 1;
    private static final Font a = new Font(0, 0, 0);
    private static Font[] b = new Font[]{a, a};
    private static Hashtable c = new Hashtable();
    private int d;
    private int e;
    private int f;
    private int g = -1;
    private int h = -1;

    private Font(int n2, int n3, int n4) {
        if (n2 != 0 && n2 != 32 && n2 != 64) {
            throw new IllegalArgumentException();
        }
        if (!(this.isPlain() || this.isBold() || this.isItalic() || this.isUnderlined())) {
            throw new IllegalArgumentException();
        }
        if (n4 != 8 && n4 != 0 && n4 != 16) {
            throw new IllegalArgumentException();
        }
        this.d = n2;
        this.e = n3;
        this.f = n4;
    }

    public static Font getDefaultFont() {
        return a;
    }

    public static Font getFont(int n2) {
        if (n2 != 1 && n2 != 0) {
            throw new IllegalArgumentException("Bad specifier");
        }
        return b[n2];
    }

    public static Font getFont(int n2, int n3, int n4) {
        Integer n5 = new Integer(n3 + n4 + n2);
        Font font = (Font)c.get(n5);
        if (font == null) {
            font = new Font(n2, n3, n4);
            c.put(n5, font);
        }
        return font;
    }

    public final int getStyle() {
        return this.e;
    }

    public final int getSize() {
        return this.f;
    }

    public final int getFace() {
        return this.d;
    }

    public final boolean isPlain() {
        return this.e == 0;
    }

    public final boolean isBold() {
        return (this.e & 1) != 0;
    }

    public final boolean isItalic() {
        return (this.e & 2) != 0;
    }

    public final boolean isUnderlined() {
        return (this.e & 4) != 0;
    }

    public final int getHeight() {
        if (this.h == -1) {
            this.h = DeviceFactory.getDevice().getFontManager().getHeight(this);
        }
        return this.h;
    }

    public final int getBaselinePosition() {
        if (this.g == -1) {
            this.g = DeviceFactory.getDevice().getFontManager().getBaselinePosition(this);
        }
        return this.g;
    }

    public final int charWidth(char c2) {
        return DeviceFactory.getDevice().getFontManager().charWidth(this, c2);
    }

    public final int charsWidth(char[] cArray, int n2, int n3) {
        return DeviceFactory.getDevice().getFontManager().charsWidth(this, cArray, n2, n3);
    }

    public final int stringWidth(String string) {
        return DeviceFactory.getDevice().getFontManager().stringWidth(this, string);
    }

    public final int substringWidth(String string, int n2, int n3) {
        return this.stringWidth(string.substring(n2, n2 + n3));
    }

    public final int hashCode() {
        return this.e + this.f + this.d;
    }
}

