/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TIMELINECTRL_H
#define TIMELINECTRL_H

#include <QtGui/QGraphicsScene>

#include "twitterapi/entry.h"
#include "imagedownload.h"
#include "timelineview.h"
#include "backend.h"

#include "applicationItems/dialog.h"
#include "applicationItems/tweet.h"

#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
    #include <QAbstractKineticScroller>
#endif

/*! \class TimelineCtrl
 *
 * \brief TimelineCtrl class is the controller to %TimelineView.
 */
class TimelineCtrl : public QObject
{
    Q_OBJECT

public:
    TimelineCtrl(QGraphicsScene *scene);
    ~TimelineCtrl();
    void showView();

signals:
    void done(void);
    void lockRotation(bool);

private slots:
    void _postNewUpdate(void);
    void _genericError(QString);
    void _handleFavorite(QString,bool);
    void _handleDeleteTweet(quint64);
    void _handleFriendship(QString, bool);
    void _updateWarning(QString);
    void _refreshWarning(QString);
    void _updateProfileImage(QString);
    void _dialogLocation(void);
    void _handleGPSLocation(void);
    void _populateHome(void);
    void _populateMentions(void);
    void _refreshHome(void);
    void _moreHomeTweets(void);
    void _refreshMentions(void);
    void _moreMentions(void);
    void _updatePosted(void);
    void _deletedTweet(quint64);

private:
    QGraphicsScene *_scene;
    TimelineView *_timelineView;
    QPropertyAnimation *_animInfo;
    QPropertyAnimation *_animLogoutButton;
    QPropertyAnimation *_animBackButton;
    bool atTimeline;
    bool isFollowing;
    bool updateTimeline;
    bool isGPS;
    QString gpsLatitude;
    QString gpsLongitude;
    int pageToDownload;
    int mentionsPageToDownload;
    bool addHome;
    bool addMentions;
    QGraphicsScene *m_scene;
    DialogView *dialog;
    Tweet *_deleteTweet;
};

#endif // TIMELINECTRL_H

