/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef MAEMO5GPS_H
#define MAEMO5GPS_H

#ifdef Q_WS_MAEMO_5

#include <QObject>

extern "C" {
#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>
}

/*!
 * \class Maemo5GPS
 *
 * \brief Maemo5GPS class handles all operations related to obtaining geographical coordinates from the GPS.
 */
class Maemo5GPS : public QObject {
    Q_OBJECT

public:
    Maemo5GPS(QObject *parent = 0);
    ~Maemo5GPS();
    double getLat() { return latitude; }
    double getLon() { return longitude; }
    double getAcc() { return accuracy; }
    void stop();
    void restart();
    friend void Maemo5GPS_changed(LocationGPSDevice *device, Maemo5GPS *gps);

signals:
    void getOK();
    void getOK_acwp();
    void getOK_agnss();

public slots:
    void get_acwp();
    void get_agnss();

private:
    double latitude;
    double longitude;
    double accuracy;

    int usegps;

    GMainLoop *loop;
    LocationGPSDControl *control;
    LocationGPSDevice *device;

};

void Maemo5GPS_changed(LocationGPSDevice *device, Maemo5GPS *gps);

#endif
#endif // MAEMO5GPS_H
