/*
 *
 *  Copyright (c) 2010 Zagaia (INdT - Instituto Nokia de Tecnologia/
 *       FUCAPI - Fundação Centro de Análise, Pesquisa e Inovação Tecnológica)
 *
 *  This file is part of TweeGo.
 *
 *  TweeGo is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  TweeGo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with TweeGo. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef TWITTERBUTTON_H
#define TWITTERBUTTON_H

#include <QtGui/QStyleOptionGraphicsItem>
#include <QtGui/QGraphicsSceneMouseEvent>
#include <QtGui/QPainter>

#include "twitterapplicationitem.h"
#include "loader.h"

/*! \class TwitterButton
 * \brief TwitterButton class
 * Handles all operations related to buttons.
 */
class TwitterButton : public TwitterApplicationItem
{
    Q_OBJECT

public:
    enum ButtonType { Expose, Logout, Generic, Retweet, Reply, Refresh,
                      Favorite, NoFavorite, GoUrl, Delete, Back,
                      Close, More, LoginSettings, GenericDownLeft,
                      GenericDownRight, NewAccount, Url, TwitterImage };

    TwitterButton(ButtonType buttonType, QString buttonLabel, QGraphicsWidget *parent);
    QRectF boundingRect() const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *);
    void setTypeButton(int);
    void setLabel(QString);
    void setMessage(QString);

signals:
    void imageUrl(QString);
    void released(void);

public slots:
    void enable(bool);

private slots:
    void _emitExposeSignal(void);
    void _emitImageUrl(void);
    void _openUrl(void);
    QString _shortUrl(QString);
    void _changeOrientation(void);

protected:
    virtual void mousePressEvent(QGraphicsSceneMouseEvent *);
    virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent *);
    virtual void mouseMoveEvent(QGraphicsSceneMouseEvent *event);

private:
    QPixmap _buttonSelectedImage;
    QPixmap _buttonImage;
    QString _buttonLabel;
    Loader *_loader;
    int _buttonType;
    bool _isPressed;
    QString _url;
    QFont font;
    QPen _pen;
};	

#endif // TWITTERBUTTON_H
