# -*- coding: utf-8 -*-
import time
try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui

from config import Config
from message import Message

from ui_message import Ui_Message
from ui_list import Ui_List, Ui_ListWidget
from ui_messageview import Ui_MessageView


class Ui_Stream(QtGui.QWidget):
    def __init__(self, style = "stream"):
        QtGui.QWidget.__init__(self)
        self.setObjectName("Ui_Stream")
        
        self.layout = QtGui.QVBoxLayout(self)
        
        self.listMessages = None
        self.sortList = []
        self.style = style

        self.listMessages = Ui_List(self)
        self.layout.addWidget(self.listMessages)

        #self.connect(self.taskListWidget, QtCore.SIGNAL("itemClicked(QListWidgetItem*)"), self.openTaskView)
        #self.updateStream()

        
    def updateStream(self):
        self.listMessages.clear()
        self.sortList = []
        if self.style != "stream" and Config().currentChannel == None:
            return
        #if self.style == "tasks" and Config().currentChannel == None:
            #return

        
        # Fetch messages
        if self.style == "stream":
            channel = None
        else:
            channel = Config().currentChannel.id
            
        if self.style == "channel":
            Config().menubar.channelAction.setText("#"+str(Config().currentChannel.getName()))

        if self.style == "tasks":
            print "channel",channel
            messages = Message.messageGetAll(channel, istask = 1)
            print "messages",len(messages)
        else:
            messages = Message.messageGetAll(channel, Config().configGetInt("default/stream/messages"), Config().configGetInt("default/stream/messagesall"))
            
        for message in messages:
            self.addMessage(message)


    #def removeTask(self, index):
        #item = self.taskListWidget.itemFromIndex(index)
        #self.taskListWidget.removeItemWidget(item)


    def addMessage(self, message):
        if self.style == "channel": # or self.style == "tasks":
            if Config().currentChannel == None:
                return
            if Config().currentChannel.id != message.channelid:
                return

        for item in self.sortList:
            if item.id == message.id:
                return

        insertAt = len(self.sortList)
        for index,item in enumerate(self.sortList):
            if item.created < message.created:
                insertAt = index
                break
        self.sortList.insert(insertAt, message)
        
        ui_message = Ui_Message(message, callback = self.viewMessage)
        ui_message.enableExtra()
        self.listMessages.addWidget(ui_message, insertAt)

        if len(self.sortList) > Config().configGetInt("default/stream/messages"):
            if self.listMessages.count() != len(self.sortList):
                print "**** ",self.listMessages.count(),len(self.sortList)
            index = len(self.sortList) - 1
            self.sortList.pop(index)
            self.listMessages.pop(index)


    def insertMessage(self, message):
        ui_message = Ui_Message(message, callback = self.viewMessage)
        ui_message.enableExtra()
        self.listMessages.addWidget(ui_message, 0)


    #def openTaskView(self, item):
        #self.workstreamer.current_task = item.task
        #self.taskView = C_TaskView(self.workstreamer, self, self.workstreamer.current_task)
        #self.taskView.show()            


    def viewMessage(self, ui_message, data):
        messageview = Ui_MessageView(ui_message)
        messageview.show()

        
