# -*- coding: utf-8 -*-
try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui


from config import Config
from qaikuconnection import QaikuConnection
from channel import Channel

class Ui_Channels(QtGui.QDialog):
    def __init__(self):
        QtGui.QDialog.__init__(self)

        self.setObjectName("Ui_Channels")
        if Config.mode_workstreamer:
            self.setWindowTitle(self.tr("Select project"))
        else:
            self.setWindowTitle(self.tr("Select channel"))

        self.setFixedHeight(400)
        self.layout = QtGui.QHBoxLayout(self)
        self.channelList = QtGui.QListWidget()
        self.layout.addWidget(self.channelList)
        button = QtGui.QPushButton("Select")
        self.layout.addWidget(button)
        QtCore.QObject.connect(button, QtCore.SIGNAL("clicked()"), self.selectChannel)

        channels = Channel.channelGetAll()
        for channel in channels:
            self.addChannel(channel)
       
        
    def selectChannel(self):
        name = self.channelList.currentItem().text()
        load = False
        if Config().currentChannel == None:
            load = True
        elif name != Config().currentChannel.getName():
            load = True

        if load == True:
            Config().currentChannel = Channel.channelCreate(name)
            if Config.mode_workstreamer:
                Config().tasklist.updateStream()
            Config().channelview.updateStream()
        Config.configSet("default/channel", name)
        Config().windowMain.showWidget(Config.configGetString("view"))
        self.hide()

    def addChannel(self, channel):
        item = QtGui.QListWidgetItem(QtGui.QIcon(channel.getLogo()), channel.getName())
        self.channelList.addItem(item)
        if Config().currentChannel == None:
            return
        if (channel.getName() == Config().currentChannel.getName()):
            self.channelList.setCurrentItem(item)


