# -*- coding: utf-8 -*-
try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui

from ui_list import Ui_List, Ui_ListWidget


class Ui_ButtonMenu(QtGui.QDialog):
    def __init__(self):
        QtGui.QDialog.__init__(self)

        self.setObjectName("Ui_ButtonMenu")
        #self.setFixedHeight(400)
        self.layout = QtGui.QHBoxLayout(self)
        self.menu = Ui_List()
        self.menu.setSpacing(2)
        self.layout.addWidget(self.menu)

        self.result = None
        #palette = self.palette()
        #palette.setColor(QtGui.QPalette.ButtonText, QtGui.QColor(0, 140, 255))
        #palette.setColor(QtGui.QPalette.WindowText, QtGui.QColor(0, 140, 255))
        #self.setPalette(palette)


    def addItem(self, text, iconfile = None, info = None):
        item = Ui_PushButton()
        item.setText(text)
        item.setSelectCallback(self.selected)
        
        if info != None:
            item.setInfo(info)
        
        if iconfile != None:
            item.setIcon(QtGui.QPixmap(iconfile))

        self.menu.addWidget(item)


    def selected(self, widget, data):
        self.result = widget
        self.done(1)
        

class Ui_PushButton(QtGui.QPushButton):
    def __init__(self, parent = None):
        QtGui.QPushButton.__init__(self, parent)
        
        self.layout = QtGui.QGridLayout()
        self.setLayout(self.layout)
        
        self.text = None
        self.info = None
        self.icon = None
        self.menu = None
        self.selectCallback = None

        QtCore.QObject.connect(self, QtCore.SIGNAL("clicked()"), self.pushed)


    def setText(self, text):
        if self.text == None:
            self.text = QtGui.QLabel()
            self.layout.addWidget(self.text, 0, 1)
        self.text.setText(text)


    def setInfo(self, text):
        if self.info == None:
            self.info = QtGui.QLabel()
            font = self.info.font()
            font.setPointSize(font.pointSize() - 4)
            self.info.setFont(font)
            palette = self.info.palette()
            palette.setColor(QtGui.QPalette.ButtonText, QtGui.QColor(00, 140, 255))
            self.info.setPalette(palette)
            self.layout.addWidget(self.info, 1, 1)
        self.info.setText(text)


    def setSelectCallback(self, callback):
        self.selectCallback = callback

        
    def createMenu(self, title):
        if self.menu == None:
            self.menu = Ui_ButtonMenu()
        self.menu.setWindowTitle(title)


    def addMenuItem(self, text, iconfile = None):
        if self.menu == None:
            return False
        self.menu.addItem(text, iconfile = iconfile)
        return True


    def pushed(self):
        if self.menu != None:
            self.menu.result = None
            if self.menu.exec_() == 1:
                value = self.menu.result.text.text()
                self.setInfo(value)
                if self.selectCallback != None:
                    self.selectCallback(value, self.menu.result)
        else:
            if self.selectCallback != None:
                self.selectCallback(self, None)

