# -*- coding: utf-8 -*-
try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui

class Config():
    # Borg singleton object
    __singleton = {}
    
    def __init__(self):
        self.__dict__ = self.__singleton
        if self.__singleton.has_key(str("config")) != True:
            self.__singleton["config"] = QtCore.QSettings("Rohea Oy", "Qaiku Client")

    # Overloaded getter function to handle direct request of variables
    def __getattr__(self, name):
        return self.__singleton[name]

    # Overloaded setter function to handle direct setting of variables
    def __setattr__(self, name, value):
        self.__singleton[name] = value


    @staticmethod
    def configSet(key, value):
        v = QtCore.QVariant(value)
        Config().config.setValue(key, v)
        #print "set",key,value,v


    @staticmethod
    def configGetInt(key):
        return Config().config.value(key).toInt()[0]


    @staticmethod
    def configGetString(key):
        return Config().config.value(key).toString()


    @staticmethod
    def configIs(key, value):
        if isinstance(value, int):
            cvalue = Config().config.value(key).toInt()[0]
        else:
            cvalue = Config().config.value(key).toString()

        if cvalue == value:
            return True
        return False

