#!/bin/bash
set -a

PACKAGE_ROOT=$PWD
PACKAGE_DIR="$PACKAGE_SOURCE-$PACKAGE_VERSION"
PACKAGE_FILE="$PACKAGE_ROOT/$PACKAGE_NAME-$PACKAGE_VERSION-$PACKAGE_ARCH.deb"

DEB_FILES="copyright preinst postinst postrm prerm changelog control md5sums"

rm -f "$PACKAGE_ROOT/$PACKAGE_NAME-*.deb"
rm -rf "$PACKAGE_DIR"
mkdir -p "$PACKAGE_DIR/DEBIAN"

for suffix in $DEB_FILES; do
	if [ -e "$PACKAGE_ROOT/DEBIAN/$suffix.sh" ]; then
		bash "$PACKAGE_ROOT/DEBIAN/$suffix.sh" > "$PACKAGE_DIR/DEBIAN/$suffix"
	fi
done

for suffix in $DEB_FILES; do
	if [ -e "$PACKAGE_ROOT/DEBIAN/$suffix" ]; then
		cp "$PACKAGE_ROOT/DEBIAN/$suffix" "$PACKAGE_DIR/DEBIAN/"
	fi
done

for suffix in $PACKAGE_CONFFILES; do
	echo $suffix >> "$PACKAGE_DIR/DEBIAN/conffiles"
done

cp -r $PACKAGE_SOURCE/* "$PACKAGE_DIR/."
cp -r $PACKAGE_ROOT/pysrc/* "$PACKAGE_DIR/opt/qaikuclient/"
find $PACKAGE_DIR -name ".svn" -exec rm -rf {} \;

cd $PACKAGE_ROOT
if dpkg-deb -b "$PACKAGE_DIR" "$PACKAGE_FILE"; then
	echo "** Successfully finished building package."
else
	echo "** Error while building package!"
	exit 1
fi

let "PACKAGE_BUILD += 1"
echo $PACKAGE_BUILD > build

if [ "$1" == "copy" ]; then
	ssh contrib "rm -f /var/www/software/debs/$PACKAGE_NAME*"
	scp $PACKAGE_FILE contrib:/var/www/software/debs
	ssh contrib "cd /var/www/software/&&./update-packages.sh"
	svn commit -m "$PACKAGE_NAME build"
fi

#rm -rf "$PACKAGE_DIR"
