#ifndef  PROXIMITYD_H
#define	 PROXIMITYD_H

#include <iostream>
#include <unistd.h>
#include <dbus/dbus.h>
#include <vector>
#include <cstring>
#include <cmath>
#include <dirent.h>

#define INTERVAL_IDLE 1000000
#define INTERVAL_ACTIVE 100000

class Client
{
	public:
		int pid;
	       	int interval;

		Client(int pid_, int interval_);	





};


class ProximityDaemon
{

	private:
		int intervalUsec;
		int active;
		char currentState;
		FILE* fp;

		void readProx(); //looped reading
		void readSensor(); //single read

		const char* file;

		void emitState(char newState_);

		void connectToDbusSignal();

		DBusMessage* msgSig;
		DBusMessageIter argsSig;
		DBusConnection* connSig;
		DBusError errSig;
		int retSig;
		dbus_uint32_t serialSig;
	
		void handleMethodCall();
		void listen();
		void turnOff();
		void turnOn();
		void connectToDbusMethod();		
		
		DBusMessage* msgMth;
		DBusMessage* replyMth;
		DBusMessageIter argsMth;
		DBusConnection* connMth;
		DBusError errMth;
		int retMth;
		char* paramMth;
		int paramMthPid;
		int intervalMth;
		int connectedMth;
				  
		void changeInterval(int mInterval_, int pid_);
		
		std::vector<Client*> pids;
		int checkProcess();
		int counterCheck;
		std::vector<Client*> toKeep;
		void setInterval();

		
		int debugFlag;
	public:
		ProximityDaemon(int debugFlag_);
		~ProximityDaemon();
		
		void debug(const char* message);





};






#endif
