/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.cldc.file;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.file.ConnectionClosedException;
import javax.microedition.io.file.FileConnection;
import org.microemu.cldc.file.FileSystemConnectorImpl;

public class FileSystemFileConnection
implements FileConnection {
    private String fsRootConfig;
    private File fsRoot;
    private String host;
    private String fullPath;
    private File file;
    private boolean isRoot;
    private boolean isDirectory;
    private Throwable locationClosedFrom = null;
    private FileSystemConnectorImpl notifyClosed;
    private InputStream opendInputStream;
    private OutputStream opendOutputStream;
    private static final char DIR_SEP = '/';
    private static final String DIR_SEP_STR = "/";
    private AccessControlContext acc;
    private static boolean java15 = false;

    FileSystemFileConnection(String fsRootConfig, String name, FileSystemConnectorImpl notifyClosed) throws IOException {
        int hostEnd = name.indexOf(47);
        if (hostEnd == -1) {
            throw new IOException("Invalid path " + name);
        }
        this.fsRootConfig = fsRootConfig;
        this.notifyClosed = notifyClosed;
        this.host = name.substring(0, hostEnd);
        this.fullPath = name.substring(hostEnd + 1);
        if (this.fullPath.length() == 0) {
            throw new IOException("Invalid path " + name);
        }
        int rootEnd = this.fullPath.indexOf(47);
        boolean bl = this.isRoot = rootEnd == -1 || rootEnd == this.fullPath.length() - 1;
        if (this.fullPath.charAt(this.fullPath.length() - 1) == '/') {
            this.fullPath = this.fullPath.substring(0, this.fullPath.length() - 1);
        }
        this.acc = AccessController.getContext();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FileSystemFileConnection.this.fsRoot = FileSystemFileConnection.getRoot(FileSystemFileConnection.this.fsRootConfig);
                FileSystemFileConnection.this.file = new File(FileSystemFileConnection.this.fsRoot, FileSystemFileConnection.this.fullPath);
                FileSystemFileConnection.this.isDirectory = FileSystemFileConnection.this.file.isDirectory();
                return null;
            }
        }, this.acc);
    }

    private Object doPrivilegedIO(PrivilegedExceptionAction action) throws IOException {
        return FileSystemConnectorImpl.doPrivilegedIO(action, this.acc);
    }

    private boolean doPrivilegedBoolean(PrivilegedBooleanAction action) {
        return (Boolean)AccessController.doPrivileged(action);
    }

    public static File getRoot(String fsRootConfig) {
        try {
            if (fsRootConfig == null) {
                File fsRoot = new File(System.getProperty("user.home") + "/.microemulator/filesystem");
                if (!fsRoot.exists()) {
                    File rootE;
                    if (!fsRoot.mkdirs()) {
                        throw new RuntimeException("Can't create filesystem root " + fsRoot.getAbsolutePath());
                    }
                    File rootC = new File(fsRoot, "c");
                    if (!rootC.exists()) {
                        rootC.mkdirs();
                    }
                    if (!(rootE = new File(fsRoot, "e")).exists()) {
                        rootE.mkdirs();
                    }
                }
                return fsRoot;
            }
            File fsRoot = new File(fsRootConfig);
            if (!fsRoot.isDirectory()) {
                throw new RuntimeException("Can't find filesystem root " + fsRoot.getAbsolutePath());
            }
            return fsRoot;
        }
        catch (SecurityException e) {
            System.out.println("Cannot access user.home " + e);
            return null;
        }
    }

    static Enumeration listRoots(String fsRootConfig, String fsSingleConfig) {
        File[] files;
        if (fsSingleConfig != null) {
            files = new File[]{FileSystemFileConnection.getRoot(fsRootConfig + fsSingleConfig)};
        } else {
            files = FileSystemFileConnection.getRoot(fsRootConfig).listFiles();
            if (files == null) {
                return new Vector().elements();
            }
        }
        Vector<String> list = new Vector<String>();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isHidden() || !file.isDirectory()) continue;
            list.add(file.getName() + '/');
        }
        return list.elements();
    }

    public long availableSize() {
        this.throwClosed();
        if (this.fsRoot == null) {
            return -1L;
        }
        return this.getFileValueJava6("getFreeSpace");
    }

    public long totalSize() {
        this.throwClosed();
        if (this.fsRoot == null) {
            return -1L;
        }
        return this.getFileValueJava6("getTotalSpace");
    }

    public boolean canRead() {
        this.throwClosed();
        return this.doPrivilegedBoolean(new PrivilegedBooleanAction(){

            public boolean getBoolean() {
                return FileSystemFileConnection.this.file.canRead();
            }
        });
    }

    public boolean canWrite() {
        this.throwClosed();
        return this.doPrivilegedBoolean(new PrivilegedBooleanAction(){

            public boolean getBoolean() {
                return FileSystemFileConnection.this.file.canWrite();
            }
        });
    }

    public void create() throws IOException {
        this.throwClosed();
        this.doPrivilegedIO(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                if (!FileSystemFileConnection.this.file.createNewFile()) {
                    throw new IOException("File already exists  " + FileSystemFileConnection.this.file.getAbsolutePath());
                }
                return null;
            }
        });
    }

    public void delete() throws IOException {
        this.throwClosed();
        this.doPrivilegedIO(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                if (!FileSystemFileConnection.this.file.delete()) {
                    throw new IOException("Unable to delete " + FileSystemFileConnection.this.file.getAbsolutePath());
                }
                return null;
            }
        });
    }

    public long directorySize(final boolean includeSubDirs) throws IOException {
        this.throwClosed();
        return (Long)this.doPrivilegedIO(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                if (!FileSystemFileConnection.this.file.isDirectory()) {
                    throw new IOException("Not a directory " + FileSystemFileConnection.this.file.getAbsolutePath());
                }
                return new Long(FileSystemFileConnection.directorySize(FileSystemFileConnection.this.file, includeSubDirs));
            }
        });
    }

    private static long directorySize(File dir, boolean includeSubDirs) throws IOException {
        long size = 0L;
        File[] files = dir.listFiles();
        if (files == null) {
            return 0L;
        }
        for (int i = 0; i < files.length; ++i) {
            File child = files[i];
            if (includeSubDirs && child.isDirectory()) {
                size += FileSystemFileConnection.directorySize(child, true);
                continue;
            }
            size += child.length();
        }
        return size;
    }

    public boolean exists() {
        this.throwClosed();
        return this.doPrivilegedBoolean(new PrivilegedBooleanAction(){

            public boolean getBoolean() {
                return FileSystemFileConnection.this.file.exists();
            }
        });
    }

    public long fileSize() throws IOException {
        this.throwClosed();
        return (Long)this.doPrivilegedIO(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                return new Long(FileSystemFileConnection.this.file.length());
            }
        });
    }

    public String getName() {
        this.throwClosed();
        if (this.isRoot) {
            return "";
        }
        if (this.isDirectory) {
            return this.file.getName() + '/';
        }
        return this.file.getName();
    }

    public String getPath() {
        this.throwClosed();
        if (this.isRoot) {
            return '/' + this.fullPath + '/';
        }
        int pathEnd = this.fullPath.lastIndexOf(47);
        if (pathEnd == -1) {
            return DIR_SEP_STR;
        }
        return '/' + this.fullPath.substring(0, pathEnd + 1);
    }

    public String getURL() {
        this.throwClosed();
        return "file://" + this.host + '/' + this.fullPath + (this.isDirectory ? DIR_SEP_STR : "");
    }

    public boolean isDirectory() {
        this.throwClosed();
        return this.isDirectory;
    }

    public boolean isHidden() {
        this.throwClosed();
        return this.doPrivilegedBoolean(new PrivilegedBooleanAction(){

            public boolean getBoolean() {
                return FileSystemFileConnection.this.file.isHidden();
            }
        });
    }

    public long lastModified() {
        this.throwClosed();
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Long(FileSystemFileConnection.this.file.lastModified());
            }
        }, this.acc);
    }

    public void mkdir() throws IOException {
        this.throwClosed();
        this.doPrivilegedIO(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                if (!FileSystemFileConnection.this.file.mkdir()) {
                    throw new IOException("Can't create directory " + FileSystemFileConnection.this.file.getAbsolutePath());
                }
                return null;
            }
        });
    }

    public Enumeration list() throws IOException {
        return this.list(null, false);
    }

    public Enumeration list(final String filter, final boolean includeHidden) throws IOException {
        this.throwClosed();
        return (Enumeration)this.doPrivilegedIO(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                return FileSystemFileConnection.this.listPrivileged(filter, includeHidden);
            }
        });
    }

    private Enumeration listPrivileged(String filter, boolean includeHidden) throws IOException {
        if (!this.file.isDirectory()) {
            throw new IOException("Not a directory " + this.file.getAbsolutePath());
        }
        FilenameFilter filenameFilter = null;
        File[] files = this.file.listFiles(filenameFilter);
        if (files == null) {
            return new Vector().elements();
        }
        Vector<String> list = new Vector<String>();
        for (int i = 0; i < files.length; ++i) {
            File child = files[i];
            if (!includeHidden && child.isHidden()) continue;
            if (child.isDirectory()) {
                list.add(child.getName() + '/');
                continue;
            }
            list.add(child.getName());
        }
        return list.elements();
    }

    public boolean isOpen() {
        return this.file != null;
    }

    private void throwOpenDirectory() throws IOException {
        if (this.isDirectory) {
            throw new IOException("Unable to open Stream on directory");
        }
    }

    public InputStream openInputStream() throws IOException {
        this.throwClosed();
        this.throwOpenDirectory();
        if (this.opendInputStream != null) {
            throw new IOException("InputStream already opened");
        }
        this.opendInputStream = (InputStream)this.doPrivilegedIO(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                return new FileInputStream(FileSystemFileConnection.this.file){

                    public void close() throws IOException {
                        FileSystemFileConnection.this.opendInputStream = null;
                        super.close();
                    }
                };
            }
        });
        return this.opendInputStream;
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public OutputStream openOutputStream() throws IOException {
        return this.openOutputStream(false);
    }

    private OutputStream openOutputStream(final boolean append) throws IOException {
        this.throwClosed();
        this.throwOpenDirectory();
        if (this.opendOutputStream != null) {
            throw new IOException("OutputStream already opened");
        }
        this.opendOutputStream = (OutputStream)this.doPrivilegedIO(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                return new FileOutputStream(FileSystemFileConnection.this.file, append){

                    public void close() throws IOException {
                        FileSystemFileConnection.this.opendOutputStream = null;
                        super.close();
                    }
                };
            }
        });
        return this.opendOutputStream;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public OutputStream openOutputStream(long byteOffset) throws IOException {
        this.throwClosed();
        this.throwOpenDirectory();
        if (this.opendOutputStream != null) {
            throw new IOException("OutputStream already opened");
        }
        this.truncate(byteOffset);
        return this.openOutputStream(true);
    }

    public void rename(final String newName) throws IOException {
        this.throwClosed();
        if (newName.indexOf(47) != -1) {
            throw new IllegalArgumentException("Name contains path specification " + newName);
        }
        this.doPrivilegedIO(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                File newFile = new File(FileSystemFileConnection.this.file.getParentFile(), newName);
                if (!FileSystemFileConnection.this.file.renameTo(newFile)) {
                    throw new IOException("Unable to rename " + FileSystemFileConnection.this.file.getAbsolutePath() + " to " + newFile.getAbsolutePath());
                }
                return null;
            }
        });
        this.fullPath = this.getPath() + newName;
    }

    public void setFileConnection(String s) throws IOException {
        this.throwClosed();
    }

    public void setHidden(boolean hidden) throws IOException {
        this.throwClosed();
    }

    private void fileSetJava16(String mehtodName, final Boolean param) throws IOException {
        if (java15) {
            throw new IOException("Not supported on Java version < 6");
        }
        try {
            final Method setWritable = this.file.getClass().getMethod(mehtodName, Boolean.TYPE);
            this.doPrivilegedIO(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    try {
                        setWritable.invoke((Object)FileSystemFileConnection.this.file, param);
                    }
                    catch (Exception e) {
                        throw new IOException(e.getCause().getMessage());
                    }
                    FileSystemFileConnection.this.file.setReadOnly();
                    return null;
                }
            });
        }
        catch (NoSuchMethodException e) {
            java15 = true;
            throw new IOException("Not supported on Java version < 6");
        }
    }

    private long getFileValueJava6(String mehtodName) throws SecurityException {
        if (java15) {
            throw new SecurityException("Not supported on Java version < 6");
        }
        try {
            final Method getter = this.file.getClass().getMethod(mehtodName, new Class[0]);
            Long rc = (Long)this.doPrivilegedIO(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    try {
                        return getter.invoke((Object)FileSystemFileConnection.this.file, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IOException(e.getCause().getMessage());
                    }
                }
            });
            return rc;
        }
        catch (IOException e) {
            throw new SecurityException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            java15 = true;
            throw new SecurityException("Not supported on Java version < 6");
        }
    }

    public void setReadable(boolean readable) throws IOException {
        this.throwClosed();
        this.fileSetJava16("setReadable", new Boolean(readable));
    }

    public void setWritable(boolean writable) throws IOException {
        this.throwClosed();
        if (!writable) {
            this.doPrivilegedIO(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    FileSystemFileConnection.this.file.setReadOnly();
                    return null;
                }
            });
        } else {
            this.fileSetJava16("setWritable", new Boolean(writable));
        }
    }

    public void truncate(final long byteOffset) throws IOException {
        this.throwClosed();
        this.doPrivilegedIO(new PrivilegedExceptionAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() throws IOException {
                RandomAccessFile raf = new RandomAccessFile(FileSystemFileConnection.this.file, "rw");
                try {
                    raf.setLength(byteOffset);
                }
                finally {
                    raf.close();
                }
                return null;
            }
        });
    }

    public long usedSize() {
        try {
            return this.fileSize();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public void close() throws IOException {
        if (this.file != null) {
            if (this.notifyClosed != null) {
                this.notifyClosed.notifyClosed(this);
            }
            this.locationClosedFrom = new Throwable();
            this.locationClosedFrom.fillInStackTrace();
            this.file = null;
        }
    }

    private void throwClosed() throws ConnectionClosedException {
        if (this.file == null) {
            if (this.locationClosedFrom != null) {
                this.locationClosedFrom.printStackTrace();
            }
            throw new ConnectionClosedException("Connection already closed");
        }
    }

    private abstract class PrivilegedBooleanAction
    implements PrivilegedAction {
        private PrivilegedBooleanAction() {
        }

        public Object run() {
            return new Boolean(this.getBoolean());
        }

        abstract boolean getBoolean();
    }
}

