'''
Advanced Power Abstract Device Mode Wrapper
2008-2010(c) Kirill Plyashkevich <ru.spirit@gmail.com>
'''

from wrappers.AbstractWrappers import AbstractWrapper

class AbstractDeviceMode(AbstractWrapper):

  def __init__(self, bus, check = False):
    self.device_mode = 'unknown'
    self.system_inactive = False
    AbstractWrapper.__init__(self, bus, check)

  def post_init(self):
    pass

  def device_mode_handler(self, *args):
    raise NotImplementedError("AbstractDeviceMode.device_mode_handler(*args) must be implemented")

  def get_device_mode(self):
    raise NotImplementedError("AbstractDeviceMode.get_device_mode() must be implemented")

  def set_device_mode(self, mode):
    raise NotImplementedError("AbstractDeviceMode.set_device_mode(mode) must be implemented")

  def system_inactive_handler(self, *args):
    raise NotImplementedError("AbstractDeviceMode.system_inactive_handler(*args) must be implemented")

  def get_system_inactive(self):
    raise NotImplementedError("AbstractDeviceMode.get_system_inactive() must be implemented")

  def set_system_inactive(self, mode):
    raise NotImplementedError("AbstractDeviceMode.set_system_inactive(mode) must be implemented")

  def tklock(self):
    raise NotImplementedError("AbstractDeviceMode.tklock() must be implemented")

  def reboot(self):
    raise NotImplementedError("AbstractDeviceMode.reboot() must be implemented")

  def shutdown(self):
    raise NotImplementedError("AbstractDeviceMode.shutdown() must be implemented")
