#ifndef QVERNOTE_H
#define QVERNOTE_H

#include <QtGui/QMainWindow>
#include "ui_QvernoteView.h"
#include "QvernoteWindow.h"
#include "QvernoteAPI.h"
#include "QNotesView.h"
#include "QNotebookListItemWidget.h"

using namespace qvernote::api;

class QvernoteView : public QvernoteWindow
{
    Q_OBJECT

public:
    QvernoteView(shared_ptr<QvernoteAPI> hEvernote, QWidget *parent = 0);
    ~QvernoteView();

    shared_ptr<QvernoteAPI> getHandle() { return m_hEvernote; }

public slots:
	void initView();
	void loadNotebook(QListWidgetItem* p_notebookListItem);
    void createNewNotebook();
    void reloadNotebookList();
    void loadNotebookList();
    void deleteSelectedNotebook(QNotebookListItemWidget*);
    void configureSslProtocol(bool checked);
    void accountConfig();
    void openSearchDialog();
    void searchNote(QString searchString);
    void openDeleteNotebookWindow();

    void setPortraitOrientation(bool) { setDisplayOrientation(QvernoteSettings::DO_PORTRAIT); }
    void setLandscapeOrientation(bool) { setDisplayOrientation(QvernoteSettings::DO_LANDSCAPE); }
    void setAutoOrientation(bool) { setDisplayOrientation(QvernoteSettings::DO_AUTO); }

    void orientationChanged();
    bool backgroundJobCallback() { return queryNotebooks(); }
    void jobDoneCallback() { loadNotebookList(); }
    void jobFailedCallback() { displayError("Unable to load notebook list", QString(m_hEvernote->getLastErrorString().c_str())); }

private:
	bool queryNotebooks();

private:
    Ui::QvernoteClass ui;
    shared_ptr<QvernoteAPI> m_hEvernote;
    QNotesView*		m_pNotesView;
};

#endif // QvernoteView_H
