/*
 * QvernoteSettings.h
 *
 *  Created on: May 12, 2010
 *      Author: alexr
 */

#ifndef QVERNOTESETTINGS_H_
#define QVERNOTESETTINGS_H_

#include <QSettings>


class QvernoteSettings {
public:

	enum DisplayOrientation {
		DO_PORTRAIT,
		DO_LANDSCAPE,
		DO_AUTO
	};

	static QvernoteSettings* Instance()
	{
		if(settings == NULL)
			settings = new QvernoteSettings();

		return settings;
	}

public:
	QString getUsername() { return m_qsUsername; }
	void setUsername(QString qsUsername) { m_qsUsername = qsUsername; }
	QString getPassword() { return m_qsPassword; }
	void setPassword(QString qsPassword) { m_qsPassword = qsPassword; }
	bool	getUseSsl() { return m_bSsl; }
	void 	setUseSsl(bool enabled) { m_bSsl = enabled; }

	DisplayOrientation	getDisplayOrientation() { return m_eDisplayOrientation; }
	void	setDisplayOrientation(DisplayOrientation o) { m_eDisplayOrientation = o; }
	void 	Store();
	void	Load();

private:
	static QvernoteSettings* settings;

	QvernoteSettings() { Load(); };
	//QvernoteSettings(const QvernoteSettings&);
	QvernoteSettings& operator=(const QvernoteSettings&);

	QString m_qsUsername;
	QString m_qsPassword;
	bool	m_bSsl;
	DisplayOrientation m_eDisplayOrientation;
};

//extern QvernoteSettings g_QvernoteSettings;

#endif /* QVERNOTESETTINGS_H_ */
