/*
 * QvernoteSettings.cpp
 *
 *  Created on: May 12, 2010
 *      Author: alexr
 */

#include "QvernoteSettings.h"

QvernoteSettings* QvernoteSettings::settings = NULL;

void QvernoteSettings::Load() {
	QSettings settings("qvernote");

	m_qsUsername = settings.value("qvernote/username", "").toString();
	m_qsPassword = settings.value("qvernote/password", "").toString();
	m_bSsl = settings.value("qvernote/ssl", false).toBool();
	m_eDisplayOrientation = (DisplayOrientation)settings.value("qvernote/display", DO_LANDSCAPE).toInt();
}

void QvernoteSettings::Store() {
	QSettings settings("qvernote");

	settings.setValue("qvernote/username", m_qsUsername);
	settings.setValue("qvernote/password", m_qsPassword);
	settings.setValue("qvernote/ssl", m_bSsl);
	settings.setValue("qvernote/display", m_eDisplayOrientation);
}


