/*
 * QvernoteAPI.h
 *
 *  Created on: May 12, 2010
 *      Author: alexr
 */

#ifndef QVERNOTEAPI_H_
#define QVERNOTEAPI_H_

#include <transport/THttpClient.h>
#include <UserStore.h>
#include <UserStore_constants.h>
#include <NoteStore.h>
#include <boost/shared_ptr.hpp>

using namespace std;
using namespace apache::thrift;
using namespace apache::thrift::protocol;
using namespace apache::thrift::transport;
using namespace evernote;
using namespace evernote::edam;
using namespace evernote::limits;
using namespace boost;

namespace qvernote { namespace api {

#define EDAM_CONSUMER_KEY "sharker76"
#define EDAM_CONSUMER_SECRET "e2cf4349a6e0b44e"
#define EVERNOTE_HOST	"www.evernote.com"
#define EDAM_USER_STORE_PATH "/edam/user"
#define EDAM_NOTE_STORE_PATH "/edam/note"
#define EDAM_CLIENT_NAME "Evernote QT/4.6;Linux;Nokia N900"


class QvernoteAPI {
public:
	QvernoteAPI();
	virtual ~QvernoteAPI();

	void initUserStore();
	void reInitUserStore();
	bool initNoteStore();
	bool reinitNoteStore();

	bool checkVersion();
	bool Authenticate(const string& userName, const string& password);

	bool	loadNotes(int maxNotes, const Notebook& notebook);
	bool	getFirstNote(Note& note);
	bool	getNextNote(Note& note);
	bool	createNewNote(Note& newNote);
	bool 	updateExistingNote(Note& existingNote);
	bool	deleteNote(Note& existingNote);
	bool 	searchNotes(const string& searchString, int maxResults);
	bool	searchNoteList(vector<Note>::iterator& pos, Guid noteGuid);

	bool loadNotebookList();
	string getDefaultNotebookName();
	bool getNotebookByName(Notebook& notebook, string notebookName);
	bool getFirstNotebook(Notebook& notebook);
	bool getNextNotebook(Notebook& notebook);
	bool createNewNotebook(const string& notebookName, bool isDefault, bool isPublished);
	bool deleteNotebook(Notebook& notebook);
	int	 getNotebookCount();
	int  getNotebookContentsCount(Notebook& notebook);
	int  getTrashCount();
	bool getFirstNotebookTag(const string& notebookName, Tag& tag);
	bool getNextNotebookTag(const string& notebookName, Tag& tag);


	bool addNewTag(const string& newTagName, Tag& result);
	bool loadTagList();
	bool getFirstTag(Tag& tag);
	bool getNextTag(Tag& tag);
	bool addExistingTag(const Tag& tag, Note& note);
	bool removeExistingTag(const Tag& tag, Note& note);

	string getAuthenticationToken() { return m_AuthenticationResult->authenticationToken; }
	string getShardId() { return m_AuthenticationResult->user.shardId; }

	string	getLastErrorString() { return m_sLastError; }
	int		getLastErrorCode() { return m_nLastError; }

private:
	void	setError(string errorString, int errorCode) {
		m_sLastError = errorString;
		m_nLastError = errorCode;
	}

	void clearError() { m_sLastError.clear(); m_nLastError = 0; }

private:
	vector<Notebook>	m_NotebookList;
	vector<Notebook>::iterator m_NotebookIterator;
	map<string, vector<Tag> > m_TagsPerNotebook;
	vector<Tag>::iterator	m_TagsPerNotebookIterator;
	vector<Tag>	m_TagList;
	vector<Tag>::iterator m_TagIterator;
	shared_ptr<UserStoreClient> m_UserStoreClient;
	shared_ptr<NoteStoreClient> m_NoteStoreClient;
	shared_ptr<AuthenticationResult> m_AuthenticationResult;
	NoteList	m_NoteList;
	NoteCollectionCounts m_NoteCounts;
	vector<Note>::iterator m_NoteIterator;
	string	m_sLastError;
	int		m_nLastError;

	shared_ptr<THttpClient> userStoreHttpClient;
	shared_ptr<TTransport> noteStoreHttpClient;
};
}}
#endif /* QVERNOTEAPI_H_ */
