/*
 * Qvernote.cpp
 *
 *  Created on: May 12, 2010
 *      Author: alex
 */

#include "Qvernote.h"
#include "qvernotelogindialog.h"
#include <QDebug>
#include <QDialog>
#include <QMessageBox>

#ifdef Q_WS_MAEMO_5
#include <QMaemo5InformationBox>
#endif

using namespace qvernote;

void InitThread::run()
{
	qDebug() << m_pQvernote->settings->getUsername() << ": " << m_pQvernote->settings->getUsername().length();


	if(m_pQvernote->m_hEvernote->checkVersion() == true) {
		if(m_pQvernote->m_hEvernote->Authenticate(
				m_pQvernote->settings->getUsername().toStdString(),
				m_pQvernote->settings->getPassword().toStdString()))
		{
			if(m_pQvernote->m_hEvernote->initNoteStore() == true)
			{
				emit m_pQvernote->noteStoreInitialized();
				return;
			}
		}
	}

	emit m_pQvernote->noteStoreFailed(QString(m_pQvernote->m_hEvernote->getLastErrorString().c_str()));
}

Qvernote::Qvernote()
{
	settings = QvernoteSettings::Instance();
	try {
		m_hEvernote = shared_ptr<QvernoteAPI>(new QvernoteAPI());
	} catch(TException& e) {
#ifdef Q_WS_MAEMO_5
		QMaemo5InformationBox::information(0, QString("Network error:  ") + QString(e.what()));
#else
		QMessageBox::critical(0, "Login error", e.what());
#endif
		exit(121);
	}
	m_pWnd = new QvernoteView(m_hEvernote);
	m_pWnd->show();
	QObject::connect(this, SIGNAL(noteStoreInitialized()), m_pWnd, SLOT(initView()));
	QObject::connect(this, SIGNAL(noteStoreFailed(QString)), this, SLOT(qvernoteShutdown(QString)));

}

Qvernote::~Qvernote() {
	QvernoteSettings::Instance()->Store();
}


void Qvernote::Init() {
	QvernoteLoginDialog ld;

	if(settings->getUsername().length() == 0) {
		if(ld.exec() == QDialog::Rejected)
			return;
	}

	InitThread* t = new InitThread(this);
	t->start();
}

void Qvernote::qvernoteShutdown(QString error)
{
#ifdef Q_WS_MAEMO_5
	QMaemo5InformationBox::information(0, QString("Login error:  ")+ QString(error));
#else
	QMessageBox::critical(0, "Login error", error);
#endif
	//m_hEvernote->reInitUserStore();
	settings->setUsername("");
	settings->setPassword("");
	Init();
	//exit(1);
}
