#ifndef QTAGSELECTORDIALOG_H
#define QTAGSELECTORDIALOG_H

#include <QtGui/QDialog>
#include "ui_QTagSelectorDialog.h"
#include "QvernoteAPI.h"
#include <QGridLayout>

using namespace qvernote::api;

class QTagSelectorDialog : public QDialog
{
    Q_OBJECT

public:
    QTagSelectorDialog(shared_ptr<QvernoteAPI> hEvernote, const vector<string> tagNames, QWidget *parent = 0);
    ~QTagSelectorDialog();

    void loadTagsIntoView();
    void addTag(Tag& tag);

public slots:
	void addNewTag();

private:
    Ui::QTagSelectorDialogClass ui;
    vector<string> m_vTagNames;
    vector<string> tagGuids;
    shared_ptr<QvernoteAPI> m_hEvernote;
    QWidget* m_parent;
    QRect geom;
};

#endif // QTAGSELECTORDIALOG_H
