#include "QTagSelectorDialog.h"
#include "QClickableLabel.h"
#include <QMessageBox>
#include <QDebug>
#include "QTagButton.h"
#include "QvernoteWindow.h"
#ifdef Q_WS_MAEMO_5
#include <QMaemo5InformationBox>
#include <QDesktopWidget>
#endif

QTagSelectorDialog::QTagSelectorDialog(shared_ptr<QvernoteAPI> hEvernote, const vector<string> tagNames, QWidget *parent)
    : QDialog(parent), m_vTagNames(tagNames), m_hEvernote(hEvernote), m_parent(parent)
{
	ui.setupUi(this);

	this->setWindowTitle("Tags for " + m_parent->windowTitle());

	QObject::connect(ui.pbNewTag, SIGNAL(clicked()), this, SLOT(addNewTag()));

	if(m_hEvernote->loadTagList() == false)
	{
#ifdef Q_WS_MAEMO_5
		QMaemo5InformationBox::information(this, "Error loading tag list: " + QString(m_hEvernote->getLastErrorString().c_str()), QMaemo5InformationBox::DefaultTimeout);
#else
		QMessageBox::critical(this, "Error loading tag list", QString(m_hEvernote->getLastErrorString().c_str()));
#endif
	}

	loadTagsIntoView();
}

QTagSelectorDialog::~QTagSelectorDialog()
{

}

void QTagSelectorDialog::addTag(Tag& tag)
{
	QTagButton* tagLabel;

	tagLabel = new QTagButton(tag, ui.saTagArea->widget());
	tagLabel->adjustGeometry(geom);

	if(std::find(m_vTagNames.begin(), m_vTagNames.end(), tag.name) != m_vTagNames.end())
	{
		tagLabel->setChecked(true);
	}
	connect(tagLabel, SIGNAL(tagToggled(bool, Tag)), m_parent, SLOT(setTag(bool, Tag)));
}

void QTagSelectorDialog::loadTagsIntoView()
{
	bool hasMoreItems;
	QTagButton* tagLabel;
	Tag tag;

	for(hasMoreItems = m_hEvernote->getFirstTag(tag); hasMoreItems; hasMoreItems = m_hEvernote->getNextTag(tag))
	{
		addTag(tag);
	}
}

void QTagSelectorDialog::addNewTag()
{
	Tag newTag;

#ifdef Q_WS_MAEMO_5
	setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
	if(m_hEvernote->addNewTag(ui.lNewTag->text().toStdString(), newTag) == true)
	{
		addTag(newTag);
	}
	else
	{
#ifdef Q_WS_MAEMO_5
		QMaemo5InformationBox::information(this, "Failed to add new tag: " + QString(m_hEvernote->getLastErrorString().c_str()), QMaemo5InformationBox::DefaultTimeout);
#else
		QMessageBox::critical(this, "Failed to add new tag", QString(m_hEvernote->getLastErrorString().c_str()));
#endif
	}
#ifdef Q_WS_MAEMO_5
	setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}
