#ifndef QNOTESVIEW_H
#define QNOTESVIEW_H

#include <QtGui/QMainWindow>
#include "QvernoteWindow.h"
#include <QGraphicsWidget>
#include <QGraphicsGridLayout>
#include "ui_QNotesView.h"
#include "QvernoteAPI.h"
#include "QNoteWidget.h"
#include "QNotesViewGraphicsWidget.h"
#include "QNoteListItemWidget.h"
#include <QThread>
using namespace qvernote::api;

class QNotesView : public QvernoteWindow
{
    Q_OBJECT

public:

    QNotesView(shared_ptr<QvernoteAPI> hEvernote, const Notebook& notebook, QWidget *parent = 0);
    QNotesView(shared_ptr<QvernoteAPI> hEvernote, QString windowTitle, QWidget *parent = 0);
    ~QNotesView();

    shared_ptr<QvernoteAPI> getHandle() { return m_hEvernote; }

public slots:
	void reloadNotes();
	void loadNotesIntoView();
	void openNewNoteWindow();
	void openNoteEditor(QListWidgetItem *item);
	void openNoteEditor(QNoteListItemWidget *item);
	void loadDeleteNotesView();
	void notesViewShutdown();

	bool backgroundJobCallback() { return queryNotes(); }
    void jobDoneCallback() { loadNotesIntoView(); }
    void jobFailedCallback() { notesViewShutdown(); }

private:
	bool queryNotes();

private:
    Ui::QNotesViewClass ui;
    shared_ptr<QvernoteAPI> m_hEvernote;
    vector<QNoteWidget*>	m_vNoteWidgets;
    Notebook	m_Notebook;
};

#endif // QNOTESVIEW_H
