#include "QNotesView.h"
#include "QNoteEditWindow.h"
#include <QPropertyAnimation>
#include <QDebug>
#include <QGraphicsPixmapItem>
#include <QGraphicsView>
#include <QPixmap>
#include <QMessageBox>
#include <QGraphicsProxyWidget>
#include <QGraphicsGridLayout>
#include "QNoteListItemWidget.h"
#include "QNoteEditWindow.h"
#include "QDeleteNotesView.h"

using namespace qvernote;
using namespace qvernote::api;

QNotesView::QNotesView(shared_ptr<QvernoteAPI> hEvernote, const Notebook& notebook, QWidget *parent)
    : QvernoteWindow(parent), m_hEvernote(hEvernote), m_Notebook(notebook)
{
	ui.setupUi(this);

	this->setWindowTitle(QString(notebook.name.c_str()));
	ui.gridLayout_2->setAlignment(ui.lvNoteList, Qt::AlignTop);

	QObject::connect(ui.actionReload, SIGNAL(triggered(bool)), this, SLOT(reloadNotes()));
	QObject::connect(ui.pbNewNote, SIGNAL(clicked()), this, SLOT(openNewNoteWindow()));
	QObject::connect(ui.lvNoteList, SIGNAL(itemClicked(QListWidgetItem *)), this, SLOT(openNoteEditor(QListWidgetItem *)));
	QObject::connect(ui.actionDelete_notes, SIGNAL(triggered(bool)), this, SLOT(loadDeleteNotesView()));

	setProgressIndicator(true);
	m_pBackgroundJob->start();
	displayInformationBox("Loading notes. Please wait...");
}

QNotesView::QNotesView(shared_ptr<QvernoteAPI> hEvernote, QString windowTitle, QWidget *parent)
: QvernoteWindow(parent), m_hEvernote(hEvernote)
{
	ui.setupUi(this);

	this->setWindowTitle(windowTitle);
	ui.pbNewNote->setVisible(false);

	ui.gridLayout_2->setAlignment(ui.lvNoteList, Qt::AlignTop);
	QObject::connect(ui.lvNoteList, SIGNAL(itemClicked(QListWidgetItem *)), this, SLOT(openNoteEditor(QListWidgetItem *)));
	loadNotesIntoView();
}

QNotesView::~QNotesView()
{

}

void QNotesView::reloadNotes()
{
	m_pBackgroundJob->start();
}

void QNotesView::loadNotesIntoView()
{
	Note note;
	bool hasMoreNotes = true;
	//int maxColumns = (int)((int)this->geometry().width() / (int)225) - 1;
	//int columnCount = 0;
	//int rowIndex = 0;
	//int noteCount = 0;

	//qDebug() << "maxColumns" << maxColumns;
	ui.lvNoteList->clear();
	ui.lvNoteList->setVisible(false);
	ui.lvNoteList->setListItemHeight(70);

	for(hasMoreNotes = m_hEvernote->getFirstNote(note); hasMoreNotes; hasMoreNotes = m_hEvernote->getNextNote(note))
	{
		//QNoteWidget* w = new QNoteWidget(note, this);
		//w->setAttribute(Qt::WA_OpaquePaintEvent, true);
		//m_vNoteWidgets.push_back(w);
		//QGraphicsProxyWidget* gp = scene.addWidget(w);
		//gp->setGeometry(QRectF(columnCount*(w->width() + 20), rowIndex*(w->height() + 20), w->width(), w->height()));

		QListWidgetItem* iw = new QListWidgetItem(ui.lvNoteList);
		iw->setSizeHint(QSize(0, 70));
		ui.lvNoteList->setItemWidget(iw, new QNoteListItemWidget(note, false, this));

		/*if(columnCount >= maxColumns)
		{
			columnCount = 0;
			rowIndex++;
		}
		else
		{
			columnCount++;
		}*/

	}

	ui.lvNoteList->setVisible(true);
	setProgressIndicator(false);
}

void QNotesView::openNewNoteWindow()
{
	Note newNote;
	newNote.notebookGuid = m_Notebook.guid;
	QNoteEditWindow* pNoteEditWindow = new QNoteEditWindow(newNote, "", m_hEvernote, this);
	pNoteEditWindow->show();
}

void QNotesView::openNoteEditor(QListWidgetItem *item)
{
	QNoteListItemWidget* w = (QNoteListItemWidget*)ui.lvNoteList->itemWidget(item);

	//QNoteEditWindow* pNoteEditWindow = new QNoteEditWindow(w->getNote(), w->getHtml(), m_hEvernote, this);
	//pNoteEditWindow->show();
	openNoteEditor(w);
}

void QNotesView::openNoteEditor(QNoteListItemWidget *item)
{
	QNoteEditWindow* pNoteEditWindow = new QNoteEditWindow(item->getNote(), item->getHtml(), m_hEvernote, this);
	pNoteEditWindow->show();
}

void QNotesView::loadDeleteNotesView()
{
	QDeleteNotesView* p_Wnd = new QDeleteNotesView(m_hEvernote, QString(m_Notebook.name.c_str()), this);
	p_Wnd->show();
}

void QNotesView::notesViewShutdown()
{
	displayError("Error loading notebook", QString(m_hEvernote->getLastErrorString().c_str()));
	close();
}

bool QNotesView::queryNotes()
{
	return m_hEvernote->loadNotes(10000, m_Notebook);
}
