#ifndef QNOTEBOOKLISTITEMWIDGET_H
#define QNOTEBOOKLISTITEMWIDGET_H

#include <QtGui/QWidget>
#include "ui_QNotebookListItemWidget.h"
#include "QvernoteAPI.h"
#include <QGraphicsPixmapItem>

using namespace qvernote::api;

class QNotebookListItemWidget : public QWidget
{
    Q_OBJECT

public:
    QNotebookListItemWidget(Notebook& notebook, shared_ptr<QvernoteAPI> hEvernote, int noteCount, bool isDeleteMode, QWidget *parent = 0);
    ~QNotebookListItemWidget();

    Notebook& getNotebook() { return m_Notebook; }

    bool	isItemMarked() { return m_bItemMarked; }

    void mouseMoveEvent(QMouseEvent* event)
    {
    	//m_bMouseMoved = true;
    }

    void mousePressEvent ( QMouseEvent *event )
    {
    	m_bMouseMoved = false;
    	QWidget::mousePressEvent(event);
    }

    void mouseReleaseEvent( QMouseEvent *event )
    {
    	if(m_bDeleteMode && !m_bMouseMoved)
    	{
    		//qDebug() << "In delete mode";
    		if(m_bItemMarked == false)
    		{
    			m_bItemMarked = true;
    			ui.lDeleteMark->setPixmap(QPixmap(":/IconAdd/widgets_tickmark_list.png"));
    			emit notebookMarked();
    		}
    		else
    		{
    			m_bItemMarked = false;
    			ui.lDeleteMark->clear();
    			emit notebookUnmarked();
    		}
    	}
    	else
    	{
    		QWidget::mouseReleaseEvent(event);
    	}
    }

signals:
	void notebookMarked();
	void notebookUnmarked();

private:
    Ui::QNotebookListItemWidgetClass ui;
    Notebook m_Notebook;
    bool	m_bDeleteMode;
    bool    m_bItemMarked;
    bool	m_bMouseMoved;
};

#endif // QNOTEBOOKLISTITEMWIDGET_H
