#include "QNotebookListItemWidget.h"
#include "QvernoteView.h"
#include <QWidget>

QNotebookListItemWidget::QNotebookListItemWidget(Notebook& notebook, shared_ptr<QvernoteAPI> hEvernote, int noteCount, bool isDeleteMode, QWidget *parent)
    : QWidget(parent), m_Notebook(notebook), m_bDeleteMode(isDeleteMode), m_bItemMarked(false), m_bMouseMoved(false)
{
	ui.setupUi(this);

	if(isDeleteMode)
		ui.lDeleteMark->setVisible(true);
	else
		ui.lDeleteMark->setVisible(false);

	if(m_Notebook.defaultNotebook)
	{
		ui.lNotebookIcon->setPixmap(QPixmap(":/IconAdd/Star-48.png"));
	}

	ui.lNotebookName->setText(QString(m_Notebook.name.c_str()));

	ui.lNotesCount->setText(QString::number((noteCount == -1)? hEvernote->getNotebookContentsCount(notebook) : noteCount, 10) + " notes");

	Tag tag;
	bool hasNextTag;
	QString tagList;
	for(hasNextTag = hEvernote->getFirstNotebookTag(notebook.name, tag); hasNextTag; hasNextTag = hEvernote->getNextNotebookTag(notebook.name, tag))
	{
		tagList += QString(tag.name.c_str()) + " ";
	}

	if(tagList.size() == 0)
	{
		ui.lNotebookTags->setText("No tags");
	}
	else
	{
		ui.lNotebookTags->setText(tagList);
	}

	//QObject::connect(ui.lDeleteNotebook, SIGNAL(mousePressed()), this, SLOT(deleteNotebook()));
}

QNotebookListItemWidget::~QNotebookListItemWidget()
{

}
