#ifndef QNOTEEDITWINDOW_H
#define QNOTEEDITWINDOW_H

#include <QtGui/QMainWindow>
#include "QvernoteWindow.h"
#include "ui_QNoteEditWindow.h"
#include "QvernoteAPI.h"
#include "QEnmlWriter.h"

using namespace qvernote::api;
using namespace qvernote::xml;

class QNoteEditWindow : public QvernoteWindow
{
    Q_OBJECT

public:
    QNoteEditWindow(Note& note, const QString& htmlData, shared_ptr<QvernoteAPI> hEvernote, QWidget *parent = 0);
    ~QNoteEditWindow();

signals:
    void noteListUpdated();

public slots:
    void saveNote();
    void emailNote();
    void toggleBoldStyle();
    void toggleItalicStyle();
    void toggleUnderlineStyle();
    void attachFile();
    void resizeWebView();
    void openTagSelectorDialog();
    void setTag(bool, Tag);

    bool backgroundJobCallback() { return createNote(); }
    void jobDoneCallback() { setProgressIndicator(false); emit noteListUpdated(); }
    void jobFailedCallback() { noteSaveFailure(); }

private:
    bool createNote();
    void noteSaveFailure();

private:
    Ui::QNoteEditWindowClass ui;
    Note& m_Note;
    QString m_HtmlData;
    bool	isNewNote;
    shared_ptr<QvernoteAPI> m_hEvernote;
    QEnmlWriter* enmlWriter;
};

#endif // QNOTEEDITWINDOW_H
