#include "QNoteEditWindow.h"
#include "QEnmlWriter.h"
#include <QToolBar>
#include <QAction>
#include <QPushButton>
#include <QFileDialog>
#include <QMessageBox>
#include <QWebFrame>
#include <QDebug>
#include <QFile>
#include "QTagSelectorDialog.h"

#ifdef Q_WS_MAEMO_5
#include <QAbstractKineticScroller>
#include "QMaemoTextSelectionSupressor.h"
#include "modest_interface_p.h"
#endif

using namespace qvernote::xml;

QNoteEditWindow::QNoteEditWindow(Note& note, const QString& htmlData, shared_ptr<QvernoteAPI> hEvernote, QWidget *parent)
    : QvernoteWindow(parent), m_Note(note), m_HtmlData(htmlData), m_hEvernote(hEvernote)
{
	ui.setupUi(this);

	if(m_HtmlData.size() == 0)
	{
		isNewNote = true;
		this->setWindowTitle("Untitled");
	}
	else
	{
		isNewNote = false;
		this->setWindowTitle(QString(m_Note.title.c_str()));
	}

	QObject::connect(ui.wvNoteEdit, SIGNAL(loadFinished(bool)), this, SLOT(resizeWebView()));
	QObject::connect(ui.wvNoteEdit->page(), SIGNAL(contentsChanged()), this, SLOT(resizeWebView()));

	ui.wvNoteEdit->setHtml(m_HtmlData);
	ui.wvNoteEdit->page()->setContentEditable(true);


#ifdef Q_WS_MAEMO_5
	QMaemoTextSelectionSupressor* supressor = new QMaemoTextSelectionSupressor(ui.wvNoteEdit);
	supressor->enable();
	//ui.wvNoteEdit->property("kineticScroller").value<QAbstractKineticScroller *>()->setEnabled(true);
#endif

	ui.leNoteTitle->setText(QString(m_Note.title.c_str()));
	enmlWriter = new QEnmlWriter(m_Note);

	QToolBar* htmlEditToolbar = new QToolBar();
	QAction* actBold = new QAction(QIcon(":/IconAdd/general_bold.png"), "Bold", this);
	QAction* actItalic = new QAction(QIcon(":/IconAdd/general_italic.png"), "Italic", this);
	QAction* actUnderline = new QAction(QIcon(":/IconAdd/notes_underline.png"), "Underline", this);
	QAction* actAddTag = new QAction(QIcon(":/IconAdd/general_tag.png"), "Add tag", this);
	QAction* actAttachFile = new QAction(QIcon(":/IconAdd/email_attachment.png"), "Attach file", this);
	QAction* actEmailNote = new QAction(QIcon(":/IconAdd/general_email.png"), "Email note", this);
	QAction* actSaveNote = new QAction(QIcon(":/IconAdd/notes_save.png"), "Save note", this);

	actBold->setCheckable(true);
	actItalic->setCheckable(true);
	actUnderline->setCheckable(true);

	htmlEditToolbar->addAction(actBold);
	htmlEditToolbar->addAction(actItalic);
	htmlEditToolbar->addAction(actUnderline);
	htmlEditToolbar->addAction(actAttachFile);
	htmlEditToolbar->addAction(actAddTag);
	htmlEditToolbar->addAction(actEmailNote);
	htmlEditToolbar->addAction(actSaveNote);

	//ui.horizontalLayout->addWidget(htmlEditToolbar);

	//QPushButton* pbSaveButton = new QPushButton("Save note");
	//pbSaveButton->setIcon(QIcon(":/IconAdd/notes_save.png"));
	//QPushButton* pbEmailButton = new QPushButton("Email note");
	//pbEmailButton->setIcon(QIcon(":/IconAdd/general_email.png"));
	//htmlEditToolbar->addWidget(pbEmailButton);
	//htmlEditToolbar->addWidget(pbSaveButton);

	this->addToolBar(htmlEditToolbar);

	QObject::connect(actSaveNote, SIGNAL(triggered(bool)), this, SLOT(saveNote()));
	QObject::connect(actEmailNote, SIGNAL(triggered(bool)), this, SLOT(emailNote()));
	QObject::connect(actAddTag, SIGNAL(triggered(bool)), this, SLOT(openTagSelectorDialog()));
	QObject::connect(this, SIGNAL(noteListUpdated()), parent, SLOT(loadNotesIntoView()));

	QObject::connect(actBold, SIGNAL(toggled(bool)), this, SLOT(toggleBoldStyle()));
	QObject::connect(actItalic, SIGNAL(toggled(bool)), this, SLOT(toggleItalicStyle()));
	QObject::connect(actUnderline, SIGNAL(toggled(bool)), this, SLOT(toggleUnderlineStyle()));
	QObject::connect(actAttachFile, SIGNAL(triggered()), this, SLOT(attachFile()));

}

QNoteEditWindow::~QNoteEditWindow()
{
	delete enmlWriter;
}

void QNoteEditWindow::saveNote()
{
	setProgressIndicator(true);
	enmlWriter->setNoteTitle(ui.leNoteTitle->text());
	enmlWriter->createNote(ui.wvNoteEdit->page()->mainFrame()->toHtml());

	//qDebug() << enmlWriter->getEnmlDocument();

	//m_Note = enmlWriter.getNote();

	/*
	if(isNewNote)
	{
		if(m_hEvernote->createNewNote(enmlWriter->getNote()) == false)
		{
			displayError("Failed to save note", QString(m_hEvernote->getLastErrorString().c_str()));
		}
		else
		{
			emit noteListUpdated();
		}
	}
	else
	{
		if(m_hEvernote->updateExistingNote(enmlWriter->getNote()) == false)
		{
			displayError("Failed to update note", QString(m_hEvernote->getLastErrorString().c_str()));
		}
		else
		{
			emit noteListUpdated();
		}
	}
	*/
	m_pBackgroundJob->start();
}

bool QNoteEditWindow::createNote()
{
	if(isNewNote)
	{
		return m_hEvernote->createNewNote(enmlWriter->getNote());
	}
	else
	{
		return m_hEvernote->updateExistingNote(enmlWriter->getNote());
	}
}

void QNoteEditWindow::noteSaveFailure()
{
	if(isNewNote)
	{
		displayError("Failed to save note", QString(m_hEvernote->getLastErrorString().c_str()));
	}
	else
	{
		displayError("Failed to update note", QString(m_hEvernote->getLastErrorString().c_str()));
	}

	setProgressIndicator(false);
	close();
}

void QNoteEditWindow::toggleBoldStyle()
{
	ui.wvNoteEdit->triggerPageAction(QWebPage::ToggleBold);
}

void QNoteEditWindow::toggleItalicStyle()
{
	ui.wvNoteEdit->triggerPageAction(QWebPage::ToggleItalic);
}

void QNoteEditWindow::toggleUnderlineStyle()
{
	ui.wvNoteEdit->triggerPageAction(QWebPage::ToggleUnderline);
}

void QNoteEditWindow::attachFile()
{
	QStringList fileNames;
	QString mediaType;
	QFileDialog dlg(this, "Choose file");
	dlg.setNameFilter(tr("Images (*.png *.xpm *.jpg)"));
	dlg.setFileMode(QFileDialog::ExistingFiles);

	QFileDialog::Options options;
	QString selectedFilter;
	QString fileName = QFileDialog::getOpenFileName(this,
			tr("Choose file"),
			"/",
			tr("Images (*.png *.xpm *.jpg)"),
			&selectedFilter,
			options);

	QFile attachFile(fileName);
	attachFile.open(QIODevice::ReadOnly);

	if(attachFile.fileName().endsWith("png"))
	{
		mediaType = "image/png";
	}
	else if(attachFile.fileName().endsWith("jpg"))
	{
		mediaType = "image/jpg";
	}

	QString mediaTag = enmlWriter->addMedia(mediaType, attachFile.readAll());
	//qDebug() << mediaTag;

	ui.wvNoteEdit->setHtml(ui.wvNoteEdit->page()->mainFrame()->toHtml().append(mediaTag));
}

void QNoteEditWindow::emailNote()
{
	qDebug() << "Email note";

#ifdef Q_WS_MAEMO_5
	ModestInterface modestIf(ModestInterface::staticInterfaceName(), "/com/nokia/modest", QDBusConnection::sessionBus(), 0);

	/* Build the note */
	//enmlWriter->createNote(ui.wvNoteEdit->page()->mainFrame()->toHtml());

	modestIf.ComposeMail("", "", "", ui.leNoteTitle->text(), ui.wvNoteEdit->page()->mainFrame()->toHtml(), "");
#endif
}

void QNoteEditWindow::resizeWebView()
{
	QSize s = ui.wvNoteEdit->page()->mainFrame()->contentsSize();
	const QRect fr = ui.wvNoteEdit->frameGeometry();
	const QRect cr = ui.wvNoteEdit->contentsRect();

	//s.setHeight(s.height() + 1 * ui.wvNoteEdit->fontMetrics().lineSpacing());
	ui.wvNoteEdit->setMinimumHeight(qMax(70, s.height()  + (fr.height() - cr.height() - 1)));
}

void QNoteEditWindow::openTagSelectorDialog()
{
	QTagSelectorDialog* p_Dlg = new QTagSelectorDialog(m_hEvernote, enmlWriter->getNotePtr()->tagNames, this);
	p_Dlg->exec();
}

void QNoteEditWindow::setTag(bool state, Tag tag)
{
	if(state)
		m_hEvernote->addExistingTag(tag, *enmlWriter->getNotePtr());
	else
		m_hEvernote->removeExistingTag(tag, *enmlWriter->getNotePtr());
}
