#include "QNewNotebookDialog.h"
#include <QMessageBox>

QNewNotebookDialog::QNewNotebookDialog(shared_ptr<QvernoteAPI> hEvernote, QWidget *parent)
    : QDialog(parent), m_hEvernote(hEvernote)
{
	ui.setupUi(this);

	QObject::connect(ui.pbOk, SIGNAL(clicked()), this, SLOT(createNewNotebook()));
	QObject::connect(this, SIGNAL(reloadNotebookList()), parent, SLOT(reloadNotebookList()));
}

QNewNotebookDialog::~QNewNotebookDialog()
{

}

void QNewNotebookDialog::createNewNotebook()
{
#ifdef Q_WS_MAEMO_5
	setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

	if(m_hEvernote->createNewNotebook(
			ui.leNotebookName->text().toStdString(),
			ui.cbDefault->isChecked(),
			ui.cbPublic->isChecked()) == false)
	{
		QMessageBox::critical(this, "Error", "Unable to create notebook");
	}
	else
	{
		emit reloadNotebookList();
	}
	this->close();
}

