/*
 * QEnmlWriter.h
 *
 *  Created on: May 20, 2010
 *      Author: alexr
 */

#ifndef QENMLWRITER_H_
#define QENMLWRITER_H_

#include <QString>
#include "QvernoteAPI.h"

using namespace qvernote::api;

namespace qvernote { namespace xml {

class QEnmlWriter {
public:
	QEnmlWriter(Note note) : bDocTypeWritten(false), m_sEnmlDocument(""), m_Note(note) { };
	virtual ~QEnmlWriter() {};

	void createNote(QString sNoteHtml);
	void setNoteTitle(QString sTitle) { m_Note.title = sTitle.toStdString(); }
	QString addMedia(QString sMimeType, const QByteArray& baMediaContent);
	QString getEnmlDocument() { writeDoctype(); return  m_sEnmlDocument; }
	Note& getNote() {
		m_Note.content = getEnmlDocument().toStdString();
		return m_Note;
	}

	Note* getNotePtr() { return &m_Note; }
private:
	void writeDoctype();
	QString byteArrayToMd5String(const QByteArray& data);
	QByteArray	byteArrayToMd5Array(const QByteArray& data);

private:
	bool bDocTypeWritten;
	QString m_sEnmlDocument;
	Note	m_Note;
};

}}

#endif /* QENMLWRITER_H_ */
