/*
 * QEnmlWriter.cpp
 *
 *  Created on: May 20, 2010
 *      Author: alexr
 */

#include "QEnmlWriter.h"
#include <QRegExp>
#include "md5.h"
#include <QDebug>

namespace qvernote { namespace xml {

void QEnmlWriter::createNote(QString sNoteHtml)
{
	QRegExp rHtmlTag("(^.*<html>|</html>|</?head>)");
	QRegExp rBodyTag("(</?)(body)");
	QRegExp rBrTag("(<br>)");
	QRegExp rImgTag("<img");
	QRegExp rImgSrcTag("src=\"[^\"]+\"");
	sNoteHtml.replace(rHtmlTag, "");
	sNoteHtml.replace(rBodyTag, "\\1en-note");
	sNoteHtml.replace(rBrTag, "<br/>");
	sNoteHtml.replace(rImgTag, "<en-media");
	sNoteHtml.replace(rImgSrcTag, "/");

	m_sEnmlDocument = sNoteHtml;
}

QString QEnmlWriter::addMedia(QString sMimeType, const QByteArray& baMediaContent)
{
	QString mediaContentHash = byteArrayToMd5Array(baMediaContent).toHex();
	Resource* noteResource = new Resource;

	noteResource->mime = sMimeType.toStdString();
	noteResource->__isset.mime = true;

	string initialDataString((const char*)baMediaContent, baMediaContent.size());

	noteResource->data.body = string(initialDataString.begin(), initialDataString.begin() + baMediaContent.size());
	noteResource->data.__isset.body = true;


	//qDebug() << __FUNCTION__ << "Data size" << noteResource->data.body.size();

	QByteArray mediaHash = byteArrayToMd5Array(baMediaContent);
	string initialBodyHashString((const char*)mediaHash, mediaHash.size());
	noteResource->data.bodyHash = string(initialBodyHashString.begin(), initialBodyHashString.begin() + mediaHash.size());
	noteResource->data.__isset.bodyHash = true;

	//qDebug() << "Writing raw hash" << QString(byteArrayToMd5Array(baMediaContent).data());

	noteResource->data.size = baMediaContent.size();
	noteResource->data.__isset.size = true;

	noteResource->__isset.data = true;

	m_Note.resources.push_back(*noteResource);
	m_Note.__isset.resources = true;

	//return "<en-media type=\"" + sMimeType + "\" hash=\"" + mediaContentHash + "\" />";
	return "<img type=\"" + sMimeType + "\" hash=\"" + mediaContentHash + "\" src=\"data:"+sMimeType+";base64," + baMediaContent.toBase64() + "\">";
}

void QEnmlWriter::writeDoctype()
{
	if(bDocTypeWritten == false)
	{
		m_sEnmlDocument.prepend(
			"<?xml version=\"1.0\" encoding=\"UTF-8\"?>" \
			"<!DOCTYPE en-note SYSTEM \"http://xml.evernote.com/pub/enml2.dtd\">"
			);
		bDocTypeWritten = true;
	}
}

QString QEnmlWriter::byteArrayToMd5String(const QByteArray& data)
{
	md5_state_t	state;
	md5_byte_t	digest[16];
	QString sHexOutput;

	md5_init(&state);
	md5_append(&state, (const md5_byte_t*)(const void*)data, data.size());
	md5_finish(&state, digest);

	for (int di = 0; di < 16; ++di)
		sHexOutput += QString("%1").arg((ushort)digest[di], 0, 16);
	//sprintf(hex_output + di * 2, "%02x", digest[di]);

	return sHexOutput;
}

QByteArray	QEnmlWriter::byteArrayToMd5Array(const QByteArray& data)
{
	md5_state_t	state;
	md5_byte_t	digest[16];
	QByteArray sHexOutput;

	md5_init(&state);
	md5_append(&state, (const md5_byte_t*)(const char*)data, data.size());
	md5_finish(&state, digest);

	return QByteArray((const char*)digest, 16);
}
}}
