/*
 * QEnmlParser.h
 *
 *  Created on: May 17, 2010
 *      Author: alexr
 */

#ifndef QENMLREADER_H_
#define QENMLREADER_H_

#include <QXmlSimpleReader>
#include <QXmlInputSource>
#include <QXmlDefaultHandler>
#include <Limits_constants.h>
#include "QvernoteAPI.h"

using namespace qvernote::api;

namespace qvernote { namespace xml {

class QEnmlContentHandler : public QXmlDefaultHandler {
	enum EnmlElement {
		EN_NOTE,
		EN_MEDIA,
		EN_CRYPT,
		EN_TODO,
		EN_NONE
	};

	enum EnmlMediaType {
		MT_IMAGE = 0, /* 3 image types */
		MT_AUDIO = 3, /* 3 audio types */
		MT_APPLICATION = 6,
		MT_UNKNOWN = 100
	};

	enum EnmlContentType {
		CT_HTML,
		CT_MEDIA,
		CT_NONE
	};

public:
	QEnmlContentHandler(const Note& note)
	: m_Note(note),currentEnmlContentType(CT_NONE),isHtmlElementOpened(false) {};
	~QEnmlContentHandler() {};

	bool startElement( const QString & namespaceURI, const QString & localName, const QString & , const QXmlAttributes & atts );
	bool endElement ( const QString & namespaceURI, const QString & localName, const QString &  );
	bool characters ( const QString & ch );
	bool startDocument () { m_sOutputHtml = "<html><body>";  return true; }
	bool endDocument () { m_sOutputHtml += "</body></html>"; return true; }
	QString	getHtml() { return m_sOutputHtml; }

private:
	EnmlElement decodeEnmlElement(const QString& elemName);
	EnmlMediaType decodeEnmlMediaType(const QXmlAttributes & atts);
	int decodeResource(const QXmlAttributes & atts, QByteArray& bodyData);

	void openHtmlElement(const QString& elemName, const QXmlAttributes & atts);
	void closeHtmlElement(const QString& elemName);
	void addMedia(const QXmlAttributes & atts);

private:
	Note m_Note;
	QString m_sOutputHtml;
	EnmlElement	currentEnmlElement;
	EnmlContentType currentEnmlContentType;
	bool	isHtmlElementOpened;
};

class QEnmlReader : public QXmlSimpleReader {
public:
	QEnmlReader(const Note& note);
	virtual ~QEnmlReader();

	bool parse() { return QXmlSimpleReader::parse(&m_EnmlDocumentInputSource); }
	QString getHtml() { return ((QEnmlContentHandler*)contentHandler())->getHtml(); }

private:
	QXmlInputSource m_EnmlDocumentInputSource;
	shared_ptr<QEnmlContentHandler> m_EnmlContentHandler;
};

}}

#endif /* QENMLREADER_H_ */
