/*
 * QEnmlParser.cpp
 *
 *  Created on: May 17, 2010
 *      Author: alexr
 */

#include "QEnmlReader.h"
#include <QBuffer>
#include <QDebug>
#include <iostream>
using namespace std;

namespace qvernote { namespace xml {

static QString enmlElements[] = {
		"en-note", "en-media", "en-crypt", "en-todo", NULL
};

static QString enmlMediaTypes[] = {
		"image/gif",
		"image/jpeg",
		"image/png",
		"audio/wav",
		"audio/mpeg",
		"audio/amr",
		"application/vnd.evernote.ink",
		"application/pdf",
		"application/octet-stream",
		NULL
};

bool QEnmlContentHandler::startElement( const QString & namespaceURI, const QString & localName, const QString & , const QXmlAttributes & atts )
{
	//qDebug() << __FUNCTION__ << namespaceURI << localName << qName;

	switch(decodeEnmlElement(localName)) {
	case EN_TODO:
	case EN_NOTE:
		currentEnmlContentType = CT_HTML;
		break;
	case EN_MEDIA:
		currentEnmlContentType = CT_MEDIA;
		addMedia(atts);
		break;
	default:
		openHtmlElement(localName, atts);
	}

	return true;
}

bool QEnmlContentHandler::endElement ( const QString & namespaceURI, const QString & localName, const QString & )
{
	//qDebug() << __FUNCTION__ << localName;
	switch(decodeEnmlElement(localName)) {
	case EN_NONE:
		closeHtmlElement(localName);
		break;
	default:
		break;
	}

	currentEnmlContentType = CT_NONE;

	//qDebug() << "=============";
	//qDebug() << m_sOutputHtml;
	//qDebug() << "===============";
	return true;
}

bool QEnmlContentHandler::characters ( const QString & ch )
{
	//qDebug() << __FUNCTION__ << ch;

	m_sOutputHtml += ch;
	return true;
}

void QEnmlContentHandler::openHtmlElement(const QString& elemName, const QXmlAttributes & atts)
{
	QString attrList = "<" + elemName;

	for(int i = 0; i < atts.count(); i++)
	{
		attrList += " " + atts.localName(i) + "=\"" + atts.value(i) + "\"";
	}

	attrList += ">";
	m_sOutputHtml += attrList;
	//qDebug() << __FUNCTION__ << elemName;
}

void QEnmlContentHandler::closeHtmlElement(const QString& elemName)
{
	m_sOutputHtml += "</" + elemName + ">";
	//qDebug() << __FUNCTION__ << elemName;
}

void QEnmlContentHandler::addMedia(const QXmlAttributes & atts)
{
	int mediaSize;
	QByteArray mediaData;

	switch(decodeEnmlMediaType(atts)) {
	case MT_IMAGE:
		m_sOutputHtml += "<img type=\"" + atts.value("type") + "\" hash=\"" + atts.value("hash") + "\" src=\"data:" + atts.value("type") + ";base64,";
		mediaSize = decodeResource(atts, mediaData);
		if(mediaSize > 0)
		{
			m_sOutputHtml +=  mediaData + "\"/>";
			//qDebug() << m_sOutputHtml;
		}
		else
		{
			qDebug() << "Error retrieving media";
		}
		break;
	default:
		break;
	}
}

QEnmlContentHandler::EnmlElement QEnmlContentHandler::decodeEnmlElement(const QString& elemName)
{
	int cmpElemIdx = 0;

	while(enmlElements[cmpElemIdx] != NULL)
	{
		if(elemName == enmlElements[cmpElemIdx])
			return (EnmlElement)cmpElemIdx;

		cmpElemIdx++;
	}

	return EN_NONE;
}

QEnmlContentHandler::EnmlMediaType QEnmlContentHandler::decodeEnmlMediaType(const QXmlAttributes & atts)
{
	int cmpMediaIdx = 0;

	while(enmlMediaTypes[cmpMediaIdx] != NULL)
	{
		if(atts.value("type") == enmlMediaTypes[cmpMediaIdx])
		{
			if(cmpMediaIdx < MT_AUDIO) return MT_IMAGE;
			if(cmpMediaIdx < MT_APPLICATION) return MT_AUDIO;
			return MT_APPLICATION;
		}

		cmpMediaIdx++;
	}

	return MT_UNKNOWN;
}



int	QEnmlContentHandler::decodeResource(const QXmlAttributes & atts, QByteArray& bodyData)
{
	vector<Resource>::iterator resourceIterator = m_Note.resources.begin();
	LimitsConstants lc;
	QString resourceHash = atts.value("hash");
	//qDebug() << "resourceHash" << resourceHash;
	QString bodyHash;

	while(resourceIterator != m_Note.resources.end())
	{
		//cout << "std::string hash " << (*resourceIterator).data.bodyHash << endl;

		QByteArray b = QByteArray::fromRawData((*resourceIterator).data.bodyHash.c_str(), lc.EDAM_HASH_LEN);

		//qDebug() << "QByteArray: " << b.toHex();

		bodyHash = QString((*resourceIterator).data.bodyHash.c_str());
		//qDebug() << "bodyHash" << bodyHash;
		//qDebug() << "b.toHex()" << b.toHex();
		//qDebug() << "Data size:" << (*resourceIterator).data.size;
		if(b.toHex() == resourceHash)
		{
			bodyData = QByteArray::fromRawData((*resourceIterator).data.body.c_str(), (*resourceIterator).data.size).toBase64();
			return (*resourceIterator).data.size;
		}

		resourceIterator++;
	}

	return 0;
}

QEnmlReader::QEnmlReader(const Note& note) {
	//m_EnmlDocumentInputSource = shared_ptr<QXmlInputSource>(new QXmlInputSource());
	m_EnmlDocumentInputSource.setData(QString(note.content.c_str()));

	m_EnmlContentHandler = shared_ptr<QEnmlContentHandler>(new QEnmlContentHandler(note));
	setContentHandler(m_EnmlContentHandler.get());
	setErrorHandler(m_EnmlContentHandler.get());
}

QEnmlReader::~QEnmlReader() {

}


}}
