#ifndef QDELETENOTEBOOKVIEW_H
#define QDELETENOTEBOOKVIEW_H

#include <QtGui/QMainWindow>
#include "ui_QDeleteNotebookView.h"
#include "QvernoteWindow.h"
#include "QvernoteAPI.h"

using namespace qvernote::api;

class QDeleteNotebookView : public QvernoteWindow
{
    Q_OBJECT

public:
    QDeleteNotebookView(shared_ptr<QvernoteAPI> hEvernote, QWidget *parent = 0);
    ~QDeleteNotebookView();

    void loadNotebooksIntoView();

public slots:
   	void deleteSelectedNotebooks();
    void addSelectedCount() { m_lSelectedCount.setText(QString("%1 notebooks").arg(++m_iSelectedCount)); }
    void subSelectedCount() { m_lSelectedCount.setText(QString("%1 notebooks").arg(--m_iSelectedCount)); }

private:
    Ui::QDeleteNotebookViewClass ui;
    shared_ptr<QvernoteAPI> m_hEvernote;
    QLabel	m_lSelectedCount;
    QPushButton m_pbDeleteSelected;
    int		m_iSelectedCount;
    QWidget* m_parent;
};

#endif // QDELETENOTEBOOKVIEW_H
