#include <QtCore/QString>
#include <QtTest/QtTest>
#include <QDebug>
#include "../../src/coordinates.h"

class CoordinatesTest : public QObject
{
    Q_OBJECT

public:
    CoordinatesTest();

private Q_SLOTS:
    void testCase1();
    void fromWgs();
};

CoordinatesTest::CoordinatesTest()
{
}

void CoordinatesTest::testCase1()
{
//    Coordinates KKJxy_to_KKJlalo(FinnishCoordinates coords);
    FinnishCoordinates coords = makeFinnishCoordinates(2540385,6673704);
//    FinnishCoordinates coords = makeFinnishCoordinates(6673704,2540385);
    Coordinates wgs = toWgs84(coords);
    
    qDebug()<< wgs.first << wgs.second;
            
    QVERIFY2(true, "Failure");
}

void CoordinatesTest::fromWgs()
{
    Coordinates coords = makeCoordinates(24.72436,60.17297);
    FinnishCoordinates finn = fromWgs84(coords);
    
    qDebug()<< finn.first << finn.second;
            
    QVERIFY2(true, "Failure");
}

QTEST_APPLESS_MAIN(CoordinatesTest);

#include "ut_coordinatestest.moc"
