#ifndef YTVPRIVATE_H
#define YTVPRIVATE_H
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include "ytvparser.h"
#include "location.h"
#include "route.h"


class ytvPrivate : public QObject {

    Q_OBJECT

    QNetworkAccessManager *mNetwork;
    QNetworkRequest mRequest;
    QNetworkReply *mReply;
    ytvParser parser;
    bool busy;

public slots:
    void slotReadyRead();
    void slotError(QNetworkReply::NetworkError);

signals:
    void done();
    void error(int error);

public:
    ytvPrivate(QObject *parent = 0);

    ~ytvPrivate();

    bool search(const QString &what);

    bool route(FinnishCoordinates start, FinnishCoordinates dest, const QDateTime &datetime, int connectionTime);

    Location::List searchResults();

    Route::List routeResults();
private:
    QByteArray& encode(QByteArray &before);

};

#endif // YTVPRIVATE_H
