#ifndef YTVPARSER_H
#define YTVPARSER_H

#include <QXmlStreamReader>
#include <QTime>
#include <QDateTime>
#include <QString>

#include "location.h"
#include "route.h"




class ytvParser : public QXmlStreamReader
{
public:
    ytvParser();

    bool start();

private:
    void readUnknownElement();
    void readMTRXML();
    void readGeoCode();
    void readReverse();
    Route readRoute();
    void readLocation();
    int readLengthDistance();
    QTime readLengthTime();
    Stop readPoint();
    Stop readStop();
    Transport readWalk();
    Transport readLine();
    QString readName();
    QDateTime readArrival();
    QDateTime readDeparture();

public:
    Location::List locationList;
    Route::List routeList;

};

#endif // YTVPARSER_H
