#include "test.h"
#include <QDebug>


Test::Test(QObject *parent) :
        QObject(parent)
{
    state = 0;

    ytv = new Ytv(0);

    connect(ytv, SIGNAL(done()), this, SLOT(done()));
    connect(ytv, SIGNAL(error(int)), this, SLOT(error(int)));

}


Test::~Test() {

    delete ytv;

}

void Test::search(const QString &what) {

    state = 1;
    ytv->search(what);
}

void Test::reverseGeoCode(const float x, const float y) {

    state = 2;
    ytv->reverseGeoCode(x,y);

}

void Test::route(FinnishCoordinates start, FinnishCoordinates dest) {

    state = 3;
    ytv->route(start, dest);

}

void Test::done() {

    Location loc;
    Location::List list;

    Route route;
    Route::List routes;

    qDebug() << "done" << state;

    switch (state) {

    case 1:
        list = ytv->searchResults();

        foreach(loc, list) {
            loc.debug();
        }

        break;

    case 2:


        break;

    case 3:

        routes = ytv->routeResults();

        qDebug() << routes.count();

        foreach(route, routes) {
            route.debug();
        }
        break;

    default:
        qDebug() << "Unknown state!!" <<state ;
    }

}

void Test::error(int code) {

    Q_UNUSED(code);

    qDebug() << "Error: in state" << state;

}

void Test::initTest() {

    FinnishCoordinates start;
    FinnishCoordinates end;

    start.first = 2546445;
    start.second = 6675512;
    end.first = 2549445;
    end.second = 6675513;
    route(start, end);

}
