#ifndef STOP_H
#define STOP_H


#include <QString>
#include <QList>
#include <QDateTime>

#include "coordinates.h"

class QStandardItem;

/** Class to store the stops in a route.
  It can also store the address of start/end

  */
class Stop
{
public:
    /**
      List of Stops on a route
      */
    typedef QList<Stop> List;
    explicit Stop(const QString &name, const QDateTime &arrivalTime, 
                  const QDateTime &departureTime, int x, int y);

    explicit Stop();

    QString name()  const {return mName;}

    QDateTime arrivalTime()  const {return mArrivalTime;}
    
    QDateTime departureTime()  const {return mDepartureTime;}

    float longitude() const {return mLongitude;}

    float latitude() const {return mLatitude;}

    Coordinates coordinates() const;

    void debug() const;

    QStandardItem* model() const;
    

private:

    QString mName;      //Only the finnish name ;)
    QDateTime mArrivalTime;
    QDateTime mDepartureTime;
    float mLongitude;
    float mLatitude;
};

#endif // STOP_H
