#ifndef DISPLAYINFOWIDGET_H
#define DISPLAYINFOWIDGET_H

#include <QWidget>
#include "route.h"
#include "transport.h"
#include "coordinates.h"
#include "stop.h"

#include <QPixmap>
#include <QDateTime>
#include <QList>

class QPushButton;
class QGridLayout;
class QLabel;
class QMouseEvent;

class displayInfoWidget : public QWidget
{
    Q_OBJECT
public:
    explicit displayInfoWidget(QWidget *parent = 0);
    
    ~displayInfoWidget();

    void setRoute(const Route &ruta, int id);

    void displayTransport(const Transport &trans);
    
    void displayStop(const Stop &stop);

    void mouseReleaseEvent ( QMouseEvent * event );

    void setTitle(const QString &title);

    QSize sizeHint () const;

    QSizePolicy sizePolicy () const;

    void paintEvent(QPaintEvent *);

signals:

    void clicked(int);

public slots:

    void clear();
    
private slots:
    
    void displayStops();
    
    void setAlarm();

private:

    QGridLayout *mGrid;
    QLabel *mIconLabel;
    QLabel *mTitleLabel;
    QLabel *mDescriptionLabel;
    QLabel *mLineLabel;
    QPushButton *mMapButton;
    QPushButton *mAlarmButton;
    QPixmap mIcon;
    Stop::List mStops;
    QList<QWidget*>  mWidgets;
    int state;
    //For stops
    Coordinates mLocation;
    QDateTime mTime;
    int mId;


};

#endif // DISPLAYINFOWIDGET_H
