#include "ytvprivate.h"

#include <QUrl>
#include <QString>
#include <QDebug>
#include <QByteArray>

const QUrl gUrl( QString::fromLatin1("http://api.reittiopas.fi/public-ytv/fi/api/?user=sindemora&pass=ny0k81ur") );


void ytvPrivate::slotReadyRead() {
    qDebug() << "Ready to read";

    //DEBUG
    QByteArray data = mReply->readAll();
//    qDebug() << data;
    parser.addData(data );
    parser.start();
    emit done();

    busy = false;

    mReply->deleteLater();
}

void ytvPrivate::slotError(QNetworkReply::NetworkError) {
    qDebug() << "Error!!!!";
    
    busy = false;
    emit error(1);  //TODO pass what kind of error

}

ytvPrivate::ytvPrivate(QObject *parent) : QObject( parent ),
mNetwork(new QNetworkAccessManager(this)), busy(false) {

}

ytvPrivate::~ytvPrivate() {

}

bool ytvPrivate::search(const QString &what) {

    if (! what.isNull() && !busy ) {
        parser.locationList.clear();

        QUrl url(gUrl);
        
        //We cannot send it in UTF, so all this is for that ;)
        url.addEncodedQueryItem("key", what.toLatin1().toPercentEncoding() );
        
        QNetworkRequest request;
        
//        qDebug() << url << url.toEncoded();
        request.setUrl(url);

        mReply = mNetwork->get(request);
        connect(mReply, SIGNAL(readyRead()), this, SLOT(slotReadyRead()));
        connect(mReply, SIGNAL(error(QNetworkReply::NetworkError)),
                this, SLOT(slotError(QNetworkReply::NetworkError)));

        busy = true;

        return true;
    }

    return false;
}

Location::List ytvPrivate::searchResults() {

    return parser.locationList;
}


bool ytvPrivate::route(FinnishCoordinates start, FinnishCoordinates dest, const QDateTime &datetime) {


    if ( !busy ) {
        parser.routeList.clear();

        QNetworkRequest request;
        QUrl url(gUrl);
        QString orig = QString::number( start.first ) + ',' + QString::number( start.second );
        QString fin = QString::number( dest.first ) + ',' + QString::number( dest.second );

        QString time = datetime.time().toString("hhmm");
        QString date = datetime.date().toString("yyyyMMdd");
        url.addQueryItem("a",orig);
        url.addQueryItem("b", fin);
        url.addQueryItem("time", time);
        url.addQueryItem("date", date);

        qDebug() << url;
        request.setUrl(url);

        mReply = mNetwork->get(request);
        connect(mReply, SIGNAL(finished()), this, SLOT(slotReadyRead()));
        connect(mReply, SIGNAL(error(QNetworkReply::NetworkError)),
                this, SLOT(slotError(QNetworkReply::NetworkError)));
        busy = true;
        return true;
    } else
        return false;



}

Route::List ytvPrivate::routeResults() {

    return parser.routeList;
}

QByteArray& ytvPrivate::encode(QByteArray &before) {
    
//    int i;
//    for (i=0; i < before.count(); i++) {
//        if (before.at(i) > 128) { //we dont filter illegal chars
//            before.replace(i, 1, )
//        
//        }
//    }
//    
//    return before;
}
