#ifndef TRANSPORT_H
#define TRANSPORT_H

#include <QString>
#include <QList>
#include "stop.h"
#include "coordinates.h"


class QStandardItem;

/** Class to store the different transports
of a route calculated. It includes the walking
parts

  */
class Transport
{
public:
    /**
      List of transports
      */
    typedef QList<Transport> List;

    enum TransportType {
        Bus, //We dont care if it is regional, or whatever
        Tram,
        Metro,
        Ferry,
        Train,
        Night,  //Only exception to the buses
        Walk

    };

    explicit Transport(const QString &line, TransportType type);

    explicit Transport();

    void setLine(const QString &line);

    void setType( TransportType type);

    QString line() const { return mLine;}

    TransportType type() const {return mType;}

    void addStop( Stop newStop);

    QDateTime startTime() const;

    QDateTime endTime() const;

    QTime time() const;

    float distance() const;

    void setDistance(float distance);

    Coordinates startCoordinates() const;

    Coordinates endCoordinates() const;

    void debug() const;

    QStandardItem* model() const;

    bool isEmpty() const { return mEmpty; }

    Stop::List stops() const; 

private:
    QString mLine;
    TransportType mType;
    Stop::List mStops;
    float mDistance;
    bool mEmpty;

};

#endif // TRANSPORT_H
