#ifndef ROUTE_H
#define ROUTE_H

#include <QString>
#include <QList>
#include <QTime>

#include "transport.h"

class QStandardItem;

/** Class to store the routes calculated.

  */
class Route
{
public:
    /**
      List of routes
      */
    typedef QList<Route> List;
    explicit Route(const QTime &time);
    explicit Route();

    void setTime(const QTime &time);

    void addTransport(Transport newTransport);

    int numberTransports();

    QTime time() const;

    QDateTime startTime() const;

    QDateTime endTime() const;

    float walking() const;

    int realTransports() const;

    void debug() const;

    QString transportNames() const;

    QStandardItem* model();

    const Transport& next() const;      //FIXME Ugly

private:
    Transport::List mTransports;
    QTime mTime;
    mutable int mIndex;   //FIXME Hack, shouldn't be here
};

#endif // ROUTE_H
