#include "route.h"
#include <QDebug>
#include <QStandardItem>

Route::Route(const QTime &time) :
        mTime(time), mIndex(0)
{
}

Route::Route() :
        mTime(QTime()), mIndex(0)
{
}

void Route::setTime(const QTime &time) {

    mTime = time;
}

void Route::addTransport(Transport newTransport)
{
    mTransports.append(newTransport);
}

int Route::numberTransports()
{
    return mTransports.count();
}

QTime Route::time() const
{
    return mTime;
}

QDateTime Route::startTime() const
{
    if (mTransports.isEmpty()) {
        return QDateTime();
    } else {
        return mTransports.first().startTime();
    }
}

QDateTime Route::endTime() const
{
    if (mTransports.isEmpty()) {
        return QDateTime();
    } else {
        return mTransports.last().endTime();
    }
}

void Route::debug() const {

    Transport trans;

    qDebug() << "Route Length" << mTime;

    foreach(trans, mTransports) {
        trans.debug();
    }
}

QString Route::transportNames() const {

    QString names;

    foreach (const Transport &trans, mTransports) {
        if (trans.type() != Transport::Walk) {
            names += trans.line() + QString::fromLatin1(" ");
        }
    }
    return names;

}

QStandardItem* Route::model() {

    QStandardItem *temp;
    Transport trans;

    temp = new QStandardItem( QString::number(numberTransports()) + QString::fromLatin1(" ") +  time().toString());


    foreach(trans, mTransports) {
        temp->appendRow(trans.model());
    }

    return temp;

}

float Route::walking() const {

    float acumulate = 0;

    foreach (const Transport &trans, mTransports) {
        if (trans.type() == Transport::Walk) {
            //            acumulate.addSecs( trans.time().second() );
            acumulate += trans.distance();
        }
    }
    return acumulate / 1000 ; //To Km

}

int Route::realTransports() const {

    int acumulate = 0;

    foreach (const Transport &trans, mTransports) {
        if (trans.type() != Transport::Walk) {
            acumulate ++;
        }
    }
    return acumulate;

}

const Transport& Route::next() const {

    qDebug() << "next" << mIndex << mTransports.count();
    if (mIndex < mTransports.count())
        return (mTransports.at(mIndex++));
    return Transport();

}
