/*
 * jamendo_api.c
 *
 *  Created on: 2009-10-05
 *      Author: marcin
 */

#include "jamendo_api.h"
#include "http_utils.h"

static const gchar * const GET_API = "http://api.jamendo.com/get2/";

typedef gpointer (*NodeParseFunc)(xmlNode*);
static GList* xml_query(gchar* query, NodeParseFunc node_parse_func);

GList* jamendo_get_popular_albums_week() {
	return xml_query("id+name+image+rating+artist_name/album/xml/?n=25&order=ratingweek_desc", (NodeParseFunc)album_new_from_xml);
}

GList* jamendo_search_for_albums_by_tag(const gchar* tag) {
	gchar* query = g_strdup_printf("id+name+image+rating+artist_name/album/xml/?n=50&order=ratingweek_desc&tag_idstr=%s",tag);
	GList* album_list = xml_query(query, (NodeParseFunc)album_new_from_xml);
	g_free(query);
	return album_list;
}

GList* jamendo_search_for_albums_by_artist(const gchar* artist_name) {
	gchar* query = g_strdup_printf("id+name+image+rating+artist_name/album/xml/?n=50&order=ratingweek_desc&searchquery=%s",artist_name);
	GList* album_list = xml_query(query, (NodeParseFunc)album_new_from_xml);
	g_free(query);
	return album_list;
}

GList* jamendo_search_for_user_starred_albums(const gchar* user) {
	gchar* query = g_strdup_printf("id+name+image+rating+artist_name/album/xml/album_user_starred/?user_idstr=%s&n=all&order=rating_desc",user);
	GList* album_list = xml_query(query, (NodeParseFunc)album_new_from_xml);
	g_free(query);
	return album_list;
}

GList* jamendo_search_for_user_playlist(const gchar* user) {
	//TODO: implement playlists support
	return NULL;
}

GList* jamendo_get_album_tracks(Album* album) {
	gchar* query = g_strdup_printf("id+name+duration+rating+stream+artist_name/track/xml/track_album+album_artist/?album_id=%d",album->id);
	GList *track_list = xml_query(query, (NodeParseFunc)track_new_from_xml);
	g_free(query);
	return track_list;
}

GList* jamendo_get_top_100() {
	gchar* query = "id+name+duration+rating+stream+album_name+artist_name/track/xml/track_album+album_artist/?n=100&order=ratingweek_desc";
	GList *track_list = xml_query(query, (NodeParseFunc)track_new_from_xml);
	return track_list;
}

GList* jamendo_get_radios() {
	gchar* query = "id+idstr+image/radio/xml/?id=4+5+6+7+8+9";
	GList *radio_list = xml_query(query, (NodeParseFunc)radio_new_from_xml);
	return radio_list;
}

GList* jamendo_get_radio_playlist(Radio* radio) {
	gchar* query = g_strdup_printf("id+name+duration+rating+stream+artist_name/track/xml/radio_track_inradioplaylist+track_album+album_artist/?radio_id=%d&nshuffle=1&n=%d",radio->id,100);
	GList *track_list = xml_query(query, (NodeParseFunc)track_new_from_xml);
	g_free(query);
	return track_list;
}

/*
 * Helper function for XML query parsing
 */
static GList* xml_query(gchar* query, NodeParseFunc node_parse_func) {
	GList *parsed_list = NULL;

	gchar* uri = g_strdup_printf("%s%s", GET_API, query);
	xmlDocPtr doc = http_get_xml(uri);
	g_free(uri);
	if (doc) {
		xmlNode *root_node = xmlDocGetRootElement(doc);
		if (root_node->type == XML_ELEMENT_NODE && g_strcmp0((gchar*) root_node->name, "data") == 0) {
			xmlNode* child_node;
			for (child_node = root_node->children; child_node; child_node = child_node->next) {
				gpointer parsed_object = node_parse_func(child_node);
				if (parsed_object) {
					parsed_list = g_list_append(parsed_list, parsed_object);
				}
			}
		}
	}

	xmlFreeDoc(doc);
	return parsed_list;
}
