/*
 * Copyright (C) 2010 Kamilla Bremeraunet <kamilla@bremeraunet.com>
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef DESKTOPWIDGET_H
#define DESKTOPWIDGET_H

#include <QWidget>
#include <QModelIndex>

#include "fbconnectglobal.h"
namespace Ui {
    class DesktopWidget;
    class FBError;
}

class DesktopWidget : public QWidget
{
    Q_OBJECT

public:
    explicit DesktopWidget(QWidget *parent = 0);
    ~DesktopWidget();

protected:
    void changeEvent(QEvent *e);
    virtual void paintEvent(QPaintEvent *);

private slots:
    void onDownButtonClicked();
    void onUpButtonClicked();
    void onRefreshButtonClicked();
    void newsFeedRefreshError();
    void newsFeedLoaded();
    void newsFeedListClicked(QModelIndex index);
    void newsFeedLoading();

private:
    Ui::DesktopWidget *m_ui;

};

#endif // DESKTOPWIDGET_H
